package drr.regulation.techsprint.g20.mas.reports;

import cdm.event.common.BusinessEvent;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(PriorVersionRule.PriorVersionRuleDefault.class)
public abstract class PriorVersionRule implements ReportFunction<TransactionReportInstruction, List<? extends Trade>> {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends Trade> evaluate(TransactionReportInstruction input) {
		List<Trade.TradeBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends Trade> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(Trade::build).collect(Collectors.toList());
			objectValidator.validate(Trade.class, output);
		}
		
		return output;
	}

	protected abstract List<Trade.TradeBuilder> doEvaluate(TransactionReportInstruction input);

	public static class PriorVersionRuleDefault extends PriorVersionRule {
		@Override
		protected List<Trade.TradeBuilder> doEvaluate(TransactionReportInstruction input) {
			List<Trade.TradeBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<Trade.TradeBuilder> assignOutput(List<Trade.TradeBuilder> output, TransactionReportInstruction input) {
			output = toBuilder(MapperS.of(input)
				.mapSingleToList(item -> item.<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).<BusinessEvent>map("getBusinessEvent", workflowStep -> workflowStep.getBusinessEvent()).<TradeState>mapC("getAfter", businessEvent -> businessEvent.getAfter()).<Trade>map("getTrade", tradeState -> tradeState.getTrade())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
