package drr.standards.iosco.cde.reports;

import cdm.base.staticdata.identifier.Identifier;
import cdm.product.collateral.Collateral;
import cdm.product.collateral.metafields.ReferenceWithMetaCollateral;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.PositionForEvent;
import drr.regulation.common.functions.TradeForEvent;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CDECollateralPortfolioIndicatorRule.CDECollateralPortfolioIndicatorRuleDefault.class)
public abstract class CDECollateralPortfolioIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {
	
	// RosettaFunction dependencies
	//
	@Inject protected PositionForEvent positionForEvent;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class CDECollateralPortfolioIndicatorRuleDefault extends CDECollateralPortfolioIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> exists(MapperS.of(tradeForEvent.evaluate(item.get())).<Collateral>map("getCollateral", trade -> trade.getCollateral()).<Identifier>mapC("getPortfolioIdentifier", collateral -> collateral.getPortfolioIdentifier())).orNullSafe(exists(MapperS.of(positionForEvent.evaluate(item.get())).<ReferenceWithMetaCollateral>map("getCollateral", counterpartyPosition -> counterpartyPosition.getCollateral()).<Collateral>map("Type coercion", referenceWithMetaCollateral -> referenceWithMetaCollateral == null ? null : referenceWithMetaCollateral.getValue()).<Identifier>mapC("getPortfolioIdentifier", collateral -> collateral.getPortfolioIdentifier()))).asMapper()).get();
			
			return output;
		}
	}
}
