package drr.standards.iosco.cde.reports;

import cdm.event.workflow.EventTimestamp;
import cdm.event.workflow.EventTimestampQualificationEnum;
import cdm.event.workflow.WorkflowStep;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ConfirmationMethodEnum;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CDEConfirmedRule.CDEConfirmedRuleDefault.class)
public abstract class CDEConfirmedRule implements ReportFunction<TransactionReportInstruction, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class CDEConfirmedRuleDefault extends CDEConfirmedRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			if (notEqual(MapperS.of(input).<WorkflowStep>map("getOriginatingWorkflowStep", transactionReportInstruction -> transactionReportInstruction.getOriginatingWorkflowStep()).<EventTimestamp>mapC("getTimestamp", workflowStep -> workflowStep.getTimestamp()).<EventTimestampQualificationEnum>map("getQualification", eventTimestamp -> eventTimestamp.getQualification()), MapperS.of(EventTimestampQualificationEnum.CONFIRMATION_DATE_TIME), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(input).<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<ConfirmationMethodEnum>map("getConfirmationMethod", reportableInformation -> reportableInformation.getConfirmationMethod()), MapperS.of(ConfirmationMethodEnum.NOT_CONFIRMED), CardinalityOperator.All)).getOrDefault(false)) {
				output = "NCNF";
			} else {
				output = MapperS.of(input)
					.mapSingleToItem(item -> {
						if (areEqual(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<ConfirmationMethodEnum>map("getConfirmationMethod", reportableInformation -> reportableInformation.getConfirmationMethod()), MapperS.of(ConfirmationMethodEnum.ELECTRONIC), CardinalityOperator.All).getOrDefault(false)) {
							return MapperS.of("ECNF");
						}
						if (areEqual(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<ConfirmationMethodEnum>map("getConfirmationMethod", reportableInformation -> reportableInformation.getConfirmationMethod()), MapperS.of(ConfirmationMethodEnum.NON_ELECTRONIC), CardinalityOperator.All).getOrDefault(false)) {
							return MapperS.of("YCNF");
						}
						return MapperS.<String>ofNull();
					}).get();
			}
			
			return output;
		}
	}
}
