package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;


@ImplementedBy(CDENotionalQuantityScheduleEffectiveDateRule.CDENotionalQuantityScheduleEffectiveDateRuleDefault.class)
public abstract class CDENotionalQuantityScheduleEffectiveDateRule implements ReportFunction<QuantityReportablePeriod, Date> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(QuantityReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(QuantityReportablePeriod input);

	public static class CDENotionalQuantityScheduleEffectiveDateRuleDefault extends CDENotionalQuantityScheduleEffectiveDateRule {
		@Override
		protected Date doEvaluate(QuantityReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, QuantityReportablePeriod input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<Date>map("getPeriodEffectiveDate", quantityReportablePeriod -> quantityReportablePeriod.getPeriodEffectiveDate())).get();
			
			return output;
		}
	}
}
