package drr.standards.iosco.cde.reports;

import cdm.base.math.NonNegativeQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.Get_OptionPremiumOnEventDate;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(CDEOptionPremiumAmountRule.CDEOptionPremiumAmountRuleDefault.class)
public abstract class CDEOptionPremiumAmountRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected Get_OptionPremiumOnEventDate get_OptionPremiumOnEventDate;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class CDEOptionPremiumAmountRuleDefault extends CDEOptionPremiumAmountRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<BigDecimal> thenArg = MapperS.of(get_OptionPremiumOnEventDate.evaluate(input)).<NonNegativeQuantity>map("getQuantity", transfer -> transfer.getQuantity()).<BigDecimal>map("getValue", nonNegativeQuantity -> nonNegativeQuantity.getValue());
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
