package drr.standards.iosco.cde.reports;

import cdm.event.common.Trade;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.FloatingRateSpecification;
import cdm.product.asset.RateSpecification;
import cdm.product.asset.SpreadSchedule;
import cdm.product.common.settlement.CommodityPriceReturnTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg1;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.IsCommodityFloatingPriceForward;
import drr.regulation.common.functions.IsCommoditySwapFloatFloat;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.IsSingleCommodityPayoutProduct;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(CDESpreadLeg1Rule.CDESpreadLeg1RuleDefault.class)
public abstract class CDESpreadLeg1Rule implements ReportFunction<TransactionReportInstruction, PriceSchedule> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityLeg1 commodityLeg1;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsCommodityFloatingPriceForward isCommodityFloatingPriceForward;
	@Inject protected IsCommoditySwapFloatFloat isCommoditySwapFloatFloat;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected TradeForEvent tradeForEvent;
	@Inject protected UnderlierForProduct underlierForProduct;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceSchedule evaluate(TransactionReportInstruction input) {
		PriceSchedule.PriceScheduleBuilder outputBuilder = doEvaluate(input);
		
		final PriceSchedule output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(PriceSchedule.class, output);
		}
		
		return output;
	}

	protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction input);

	public static class CDESpreadLeg1RuleDefault extends CDESpreadLeg1Rule {
		@Override
		protected PriceSchedule.PriceScheduleBuilder doEvaluate(TransactionReportInstruction input) {
			PriceSchedule.PriceScheduleBuilder output = PriceSchedule.builder();
			return assignOutput(output, input);
		}
		
		protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(tradeForEvent.evaluate(input));
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForTrade.evaluate(item.get())));
			final MapperS<SpreadSchedule> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					final Boolean boolean0 = isCommoditySwapFloatFloat.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(commodityLeg1.evaluate(item.get())).<CommodityPriceReturnTerms>map("getCommodityPriceReturnTerms", commodityPayout -> commodityPayout.getCommodityPriceReturnTerms()).<SpreadSchedule>map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread());
					}
					final Boolean boolean1 = isSingleCommodityPayoutProduct.evaluate(item.get());
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<CommodityPriceReturnTerms>map("getCommodityPriceReturnTerms", commodityPayout -> commodityPayout.getCommodityPriceReturnTerms()).<SpreadSchedule>map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread());
					}
					final Boolean boolean2 = isCommodityFloatingPriceForward.evaluate(item.get());
					if ((boolean2 == null ? false : boolean2)) {
						return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get()).<CommodityPriceReturnTerms>map("getCommodityPriceReturnTerms", commodityPayout -> commodityPayout.getCommodityPriceReturnTerms()).<SpreadSchedule>map("getSpread", commodityPriceReturnTerms -> commodityPriceReturnTerms.getSpread());
					}
					if (ComparisonResult.ofNullSafe(MapperS.of(isIRSwaption.evaluate(item.get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCreditSwaption.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of(interestRateLeg1.evaluate(underlierForProduct.evaluate(item.get()))).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<SpreadSchedule>map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule());
					}
					return MapperS.of(interestRateLeg1.evaluate(item.get())).<RateSpecification>map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).<FloatingRateSpecification>map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).<SpreadSchedule>map("getSpreadSchedule", floatingRateSpecification -> floatingRateSpecification.getSpreadSchedule());
				});
			final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule = thenArg2
				.mapSingleToItem(item -> item.<ReferenceWithMetaPriceSchedule>map("getPrice", spreadSchedule -> spreadSchedule.getPrice())).get();
			if (referenceWithMetaPriceSchedule == null) {
				output = null;
			} else {
				output = toBuilder(referenceWithMetaPriceSchedule.getValue());
			}
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
