package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNotationString;
import javax.inject.Inject;


@ImplementedBy(CDESpreadLeg2NotationRule.CDESpreadLeg2NotationRuleDefault.class)
public abstract class CDESpreadLeg2NotationRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpreadLeg2NotationEnumRule cDESpreadLeg2NotationEnumRule;
	@Inject protected GetNotationString getNotationString;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class CDESpreadLeg2NotationRuleDefault extends CDESpreadLeg2NotationRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = getNotationString.evaluate(cDESpreadLeg2NotationEnumRule.evaluate(input));
			
			return output;
		}
	}
}
