package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(CDEStrikePriceScheduleAmountFormatDecimalRule.CDEStrikePriceScheduleAmountFormatDecimalRuleDefault.class)
public abstract class CDEStrikePriceScheduleAmountFormatDecimalRule implements ReportFunction<PriceReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected FormatToBaseOneRate formatToBaseOneRate;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(PriceReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(PriceReportablePeriod input);

	public static class CDEStrikePriceScheduleAmountFormatDecimalRuleDefault extends CDEStrikePriceScheduleAmountFormatDecimalRule {
		@Override
		protected BigDecimal doEvaluate(PriceReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, PriceReportablePeriod input) {
			final MapperS<PriceAndNotation> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> item.<PriceAndNotation>map("getPeriodValue", priceReportablePeriod -> priceReportablePeriod.getPeriodValue()));
			final MapperS<BigDecimal> ifThenElseResult;
			if (areEqual(thenArg.<PriceNotationEnum>map("getPriceNotation", priceAndNotation -> priceAndNotation.getPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = thenArg.<BigDecimal>map("getPricePercentage", priceAndNotation -> priceAndNotation.getPricePercentage());
			} else {
				ifThenElseResult = MapperS.<BigDecimal>ofNull();
			}
			output = MapperS.of(formatToBaseOneRate.evaluate(ifThenElseResult.get())).get();
			
			return output;
		}
	}
}
