package drr.standards.iosco.cde.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;


@ImplementedBy(CDEStrikePriceScheduleEndDateRule.CDEStrikePriceScheduleEndDateRuleDefault.class)
public abstract class CDEStrikePriceScheduleEndDateRule implements ReportFunction<PriceReportablePeriod, Date> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(PriceReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(PriceReportablePeriod input);

	public static class CDEStrikePriceScheduleEndDateRuleDefault extends CDEStrikePriceScheduleEndDateRule {
		@Override
		protected Date doEvaluate(PriceReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, PriceReportablePeriod input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> item.<Date>map("getPeriodEndDate", priceReportablePeriod -> priceReportablePeriod.getPeriodEndDate())).get();
			
			return output;
		}
	}
}
