package drr.standards.iosco.cde.reports;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.IsCallOption;
import drr.regulation.common.functions.IsCap;
import drr.regulation.common.functions.IsFloor;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.IsPutOption;
import javax.inject.Inject;


@ImplementedBy(UPIOptionTypeRule.UPIOptionTypeRuleDefault.class)
public abstract class UPIOptionTypeRule implements ReportFunction<Product, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsCallOption isCallOption;
	@Inject protected IsCap isCap;
	@Inject protected IsFloor isFloor;
	@Inject protected IsOption isOption;
	@Inject protected IsPutOption isPutOption;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(Product input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(Product input);

	public static class UPIOptionTypeRuleDefault extends UPIOptionTypeRule {
		@Override
		protected String doEvaluate(Product input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, Product input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					if (ComparisonResult.ofNullSafe(MapperS.of(isPutOption.evaluate(item.get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isFloor.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of("PUTO");
					}
					if (ComparisonResult.ofNullSafe(MapperS.of(isCallOption.evaluate(item.get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCap.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of("CALL");
					}
					final Boolean _boolean = isOption.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of("OTHR");
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
