package drr.standards.iso.upi.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.standards.iso.upi.AnnaDsbHeader;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class AnnaDsbHeaderTypeFormatValidator implements Validator<AnnaDsbHeader> {

	private List<ComparisonResult> getComparisonResults(AnnaDsbHeader o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, AnnaDsbHeader o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("AnnaDsbHeader", ValidationResult.ValidationType.TYPE_FORMAT, "AnnaDsbHeader", path, "", res.getError());
				}
				return success("AnnaDsbHeader", ValidationResult.ValidationType.TYPE_FORMAT, "AnnaDsbHeader", path, "");
			})
			.collect(toList());
	}

}
