package drr.standards.iso.upi.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.standards.iso.upi.AnnaDsbEmpty;
import drr.standards.iso.upi.AnnaDsbOtherUnderlierIDSourceEnum;
import drr.standards.iso.upi.AnnaDsbOtherUnderlying;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class AnnaDsbOtherUnderlyingOnlyExistsValidator implements ValidatorWithArg<AnnaDsbOtherUnderlying, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends AnnaDsbOtherUnderlying> ValidationResult<AnnaDsbOtherUnderlying> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("OtherUnderlierIDSource", ExistenceChecker.isSet((AnnaDsbOtherUnderlierIDSourceEnum) o.getOtherUnderlierIDSource()))
				.put("OtherUnderlierID", ExistenceChecker.isSet((String) o.getOtherUnderlierID()))
				.put("Basket", ExistenceChecker.isSet((AnnaDsbEmpty) o.getBasket()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("AnnaDsbOtherUnderlying", ValidationResult.ValidationType.ONLY_EXISTS, "AnnaDsbOtherUnderlying", path, "");
		}
		return failure("AnnaDsbOtherUnderlying", ValidationResult.ValidationType.ONLY_EXISTS, "AnnaDsbOtherUnderlying", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
