/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.array;

import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Messages;
import com.opengamma.strata.collect.array.DoubleArray;
import com.opengamma.strata.collect.array.Matrix;
import com.opengamma.strata.collect.function.IntIntDoubleConsumer;
import com.opengamma.strata.collect.function.IntIntDoubleToDoubleFunction;
import com.opengamma.strata.collect.function.IntIntToDoubleFunction;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntFunction;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class DoubleMatrix
implements Matrix,
Serializable,
ImmutableBean {
    public static final DoubleMatrix EMPTY = new DoubleMatrix(new double[0][0], 0, 0);
    private static final long serialVersionUID = 1L;
    @PropertyDefinition(validate="notNull", get="")
    private final double[][] array;
    private final transient int rows;
    private final transient int columns;
    private final transient int elements;

    public static DoubleMatrix of() {
        return EMPTY;
    }

    public static DoubleMatrix of(int rows, int columns, double ... values) {
        if (values.length != rows * columns) {
            throw new IllegalArgumentException("Values array not of length rows * columns");
        }
        if (rows == 0 || columns == 0) {
            return EMPTY;
        }
        double[][] array = new double[rows][columns];
        for (int i = 0; i < values.length; ++i) {
            array[i / columns][i % columns] = values[i];
        }
        return new DoubleMatrix(array, rows, columns);
    }

    public static DoubleMatrix of(int rows, int columns, IntIntToDoubleFunction valueFunction) {
        if (rows == 0 || columns == 0) {
            return EMPTY;
        }
        double[][] array = new double[rows][columns];
        for (int i = 0; i < array.length; ++i) {
            double[] inner = array[i];
            for (int j = 0; j < inner.length; ++j) {
                inner[j] = valueFunction.applyAsDouble(i, j);
            }
        }
        return new DoubleMatrix(array, rows, columns);
    }

    public static DoubleMatrix ofArrays(int rows, int columns, IntFunction<double[]> valuesFunction) {
        if (rows == 0 || columns == 0) {
            return EMPTY;
        }
        double[][] array = new double[rows][columns];
        for (int i = 0; i < array.length; ++i) {
            double[] values = valuesFunction.apply(i);
            if (values.length != columns) {
                throw new IllegalArgumentException(Messages.format("Function returned array of incorrect length {}, expected {}", values.length, columns));
            }
            array[i] = (double[])values.clone();
        }
        return new DoubleMatrix(array, rows, columns);
    }

    public static DoubleMatrix ofArrayObjects(int rows, int columns, IntFunction<DoubleArray> valuesFunction) {
        if (rows == 0 || columns == 0) {
            return EMPTY;
        }
        double[][] array = new double[rows][columns];
        for (int i = 0; i < array.length; ++i) {
            DoubleArray values = valuesFunction.apply(i);
            if (values.size() != columns) {
                throw new IllegalArgumentException(Messages.format("Function returned array of incorrect length {}, expected {}", values.size(), columns));
            }
            array[i] = values.toArrayUnsafe();
        }
        return new DoubleMatrix(array, rows, columns);
    }

    public static DoubleMatrix ofUnsafe(double[][] array) {
        int rows = array.length;
        if (rows == 0 || array[0].length == 0) {
            return EMPTY;
        }
        return new DoubleMatrix(array, rows, array[0].length);
    }

    public static DoubleMatrix copyOf(double[][] array) {
        int rows = array.length;
        if (rows == 0 || array[0].length == 0) {
            return EMPTY;
        }
        int columns = array[0].length;
        return new DoubleMatrix(DoubleMatrix.deepClone(array, rows, columns), rows, columns);
    }

    public static DoubleMatrix filled(int rows, int columns) {
        if (rows == 0 || columns == 0) {
            return EMPTY;
        }
        return new DoubleMatrix(new double[rows][columns], rows, columns);
    }

    public static DoubleMatrix filled(int rows, int columns, double value) {
        if (rows == 0 || columns == 0) {
            return EMPTY;
        }
        double[][] array = new double[rows][columns];
        for (int i = 0; i < array.length; ++i) {
            Arrays.fill(array[i], value);
        }
        return new DoubleMatrix(array, rows, columns);
    }

    public static DoubleMatrix identity(int size) {
        if (size == 0) {
            return EMPTY;
        }
        double[][] array = new double[size][size];
        for (int i = 0; i < size; ++i) {
            array[i][i] = 1.0;
        }
        return new DoubleMatrix(array, size, size);
    }

    public static DoubleMatrix diagonal(DoubleArray array) {
        int size = array.size();
        if (size == 0) {
            return EMPTY;
        }
        double[][] data = new double[size][size];
        for (int i = 0; i < size; ++i) {
            data[i][i] = array.get(i);
        }
        return new DoubleMatrix(data, size, size);
    }

    DoubleMatrix(double[][] data, int rows, int columns) {
        this.rows = rows;
        this.columns = columns;
        this.array = data;
        this.elements = rows * columns;
    }

    private DoubleMatrix(double[][] array) {
        ArgChecker.notNull(array, "array");
        if (array.length == 0) {
            this.array = DoubleMatrix.EMPTY.array;
            this.rows = 0;
            this.columns = 0;
        } else {
            this.array = array;
            this.rows = array.length;
            this.columns = array[0].length;
        }
        this.elements = this.rows * this.columns;
    }

    private static double[][] deepClone(double[][] input, int rows, int columns) {
        double[][] cloned = new double[rows][columns];
        for (int i = 0; i < rows; ++i) {
            cloned[i] = (double[])input[i].clone();
        }
        return cloned;
    }

    private Object readResolve() {
        return new DoubleMatrix(this.array);
    }

    @Override
    public int dimensions() {
        return 2;
    }

    @Override
    public int size() {
        return this.elements;
    }

    public int rowCount() {
        return this.rows;
    }

    public int columnCount() {
        return this.columns;
    }

    public boolean isSquare() {
        return this.rows == this.columns;
    }

    public boolean isEmpty() {
        return this.elements == 0;
    }

    public double get(int row, int column) {
        return this.array[row][column];
    }

    public DoubleArray row(int row) {
        return DoubleArray.ofUnsafe(this.array[row]);
    }

    public double[] rowArray(int row) {
        return (double[])this.array[row].clone();
    }

    public DoubleArray column(int column) {
        return DoubleArray.of(this.rows, i -> this.array[i][column]);
    }

    public double[] columnArray(int column) {
        return this.column(column).toArrayUnsafe();
    }

    public double[][] toArray() {
        return DoubleMatrix.deepClone(this.array, this.rows, this.columns);
    }

    public double[][] toArrayUnsafe() {
        return this.array;
    }

    public void forEach(IntIntDoubleConsumer action) {
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                action.accept(i, j, this.array[i][j]);
            }
        }
    }

    public DoubleMatrix with(int row, int column, double newValue) {
        if (Double.doubleToLongBits(this.array[row][column]) == Double.doubleToLongBits(newValue)) {
            return this;
        }
        double[][] result = (double[][])this.array.clone();
        result[row] = (double[])result[row].clone();
        result[row][column] = newValue;
        return new DoubleMatrix(result, this.rows, this.columns);
    }

    public DoubleMatrix multipliedBy(double factor) {
        if (factor == 1.0) {
            return this;
        }
        double[][] result = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result[i][j] = this.array[i][j] * factor;
            }
        }
        return new DoubleMatrix(result, this.rows, this.columns);
    }

    public DoubleMatrix map(DoubleUnaryOperator operator) {
        double[][] result = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result[i][j] = operator.applyAsDouble(this.array[i][j]);
            }
        }
        return new DoubleMatrix(result, this.rows, this.columns);
    }

    public DoubleMatrix mapWithIndex(IntIntDoubleToDoubleFunction function) {
        double[][] result = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result[i][j] = function.applyAsDouble(i, j, this.array[i][j]);
            }
        }
        return new DoubleMatrix(result, this.rows, this.columns);
    }

    public DoubleMatrix plus(DoubleMatrix other) {
        if (this.rows != other.rows || this.columns != other.columns) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        double[][] result = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result[i][j] = this.array[i][j] + other.array[i][j];
            }
        }
        return new DoubleMatrix(result, this.rows, this.columns);
    }

    public DoubleMatrix minus(DoubleMatrix other) {
        if (this.rows != other.rows || this.columns != other.columns) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        double[][] result = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result[i][j] = this.array[i][j] - other.array[i][j];
            }
        }
        return new DoubleMatrix(result, this.rows, this.columns);
    }

    public DoubleMatrix combine(DoubleMatrix other, DoubleBinaryOperator operator) {
        if (this.rows != other.rows || this.columns != other.columns) {
            throw new IllegalArgumentException("Arrays have different sizes");
        }
        double[][] result = new double[this.rows][this.columns];
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result[i][j] = operator.applyAsDouble(this.array[i][j], other.array[i][j]);
            }
        }
        return new DoubleMatrix(result, this.rows, this.columns);
    }

    public double total() {
        double total = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                total += this.array[i][j];
            }
        }
        return total;
    }

    public double reduce(double identity, DoubleBinaryOperator operator) {
        double result = identity;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                result = operator.applyAsDouble(result, this.array[i][j]);
            }
        }
        return result;
    }

    public DoubleMatrix transpose() {
        return DoubleMatrix.of(this.columns, this.rows, (i, j) -> this.array[j][i]);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DoubleMatrix) {
            DoubleMatrix other = (DoubleMatrix)obj;
            if (this.columns != other.columns || this.rows != other.rows) {
                return false;
            }
            for (int i = 0; i < this.rows; ++i) {
                for (int j = 0; j < this.columns; ++j) {
                    if (Double.doubleToLongBits(this.array[i][j]) == Double.doubleToLongBits(other.array[i][j])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        for (int i = 0; i < this.rows; ++i) {
            result = 31 * result + Arrays.hashCode(this.array[i]);
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (double[] d : this.array) {
            for (int i = 0; i < d.length; ++i) {
                buf.append(d[i]);
                buf.append(i == d.length - 1 ? "\n" : " ");
            }
        }
        return buf.toString();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<DoubleMatrix> {
        private double[][] array;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 93090393: {
                    return this.array;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 93090393: {
                    this.array = (double[][])newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public DoubleMatrix build() {
            return new DoubleMatrix(this.array);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("DoubleMatrix.Builder{");
            buf.append("array").append('=').append(JodaBeanUtils.toString((Object)this.array));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<double[][]> array = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"array", DoubleMatrix.class, double[][].class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"array"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 93090393: {
                    return this.array;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends DoubleMatrix> builder() {
            return new Builder();
        }

        public Class<? extends DoubleMatrix> beanType() {
            return DoubleMatrix.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<double[][]> array() {
            return this.array;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 93090393: {
                    return ((DoubleMatrix)bean).array;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

