/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.io;

import com.google.common.base.Charsets;
import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.Resources;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public final class CharSources {
    private CharSources() {
    }

    public static CharSource ofFileName(String fileName) {
        return Files.asCharSource((File)new File(fileName), (Charset)Charsets.UTF_8);
    }

    public static CharSource ofFileName(String fileName, Charset charset) {
        return Files.asCharSource((File)new File(fileName), (Charset)charset);
    }

    public static CharSource ofFile(File file) {
        return Files.asCharSource((File)file, (Charset)Charsets.UTF_8);
    }

    public static CharSource ofFile(File file, Charset charset) {
        return Files.asCharSource((File)file, (Charset)charset);
    }

    public static CharSource ofPath(Path path) {
        return MoreFiles.asCharSource((Path)path, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
    }

    public static CharSource ofPath(Path path, Charset charset) {
        return MoreFiles.asCharSource((Path)path, (Charset)charset, (OpenOption[])new OpenOption[0]);
    }

    public static CharSource ofUrl(URL url) {
        return Resources.asCharSource((URL)url, (Charset)Charsets.UTF_8);
    }

    public static CharSource ofUrl(URL url, Charset charset) {
        return Resources.asCharSource((URL)url, (Charset)charset);
    }

    public static CharSource ofContent(String content) {
        return CharSource.wrap((CharSequence)content);
    }

    public static CharSource ofContent(byte[] content) {
        return CharSource.wrap((CharSequence)new String(content, Charsets.UTF_8));
    }

    public static CharSource ofContent(byte[] content, Charset charset) {
        return CharSource.wrap((CharSequence)new String(content, charset));
    }
}

