/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.datetime;

import cdm.base.datetime.BusinessDayAdjustments;
import cdm.base.datetime.meta.AdjustableDatesMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AdjustableDates", builder=AdjustableDatesBuilderImpl.class, version="5.24.0")
@RuneDataType(value="AdjustableDates", model="cdm", builder=AdjustableDatesBuilderImpl.class, version="5.24.0")
public interface AdjustableDates
extends RosettaModelObject,
GlobalKey {
    public static final AdjustableDatesMeta metaData = new AdjustableDatesMeta();

    public List<Date> getUnadjustedDate();

    public BusinessDayAdjustments getDateAdjustments();

    public List<? extends FieldWithMetaDate> getAdjustedDate();

    public MetaFields getMeta();

    public AdjustableDates build();

    public AdjustableDatesBuilder toBuilder();

    public static AdjustableDatesBuilder builder() {
        return new AdjustableDatesBuilderImpl();
    }

    default public RosettaMetaData<? extends AdjustableDates> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AdjustableDates> getType() {
        return AdjustableDates.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("unadjustedDate"), Date.class, this.getUnadjustedDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.class, this.getDateAdjustments(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("adjustedDate"), processor, FieldWithMetaDate.class, this.getAdjustedDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class AdjustableDatesBuilderImpl
    implements AdjustableDatesBuilder {
        protected List<Date> unadjustedDate = new ArrayList<Date>();
        protected BusinessDayAdjustments.BusinessDayAdjustmentsBuilder dateAdjustments;
        protected List<FieldWithMetaDate.FieldWithMetaDateBuilder> adjustedDate = new ArrayList<FieldWithMetaDate.FieldWithMetaDateBuilder>();
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="unadjustedDate")
        @RuneAttribute(value="unadjustedDate")
        public List<Date> getUnadjustedDate() {
            return this.unadjustedDate;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments() {
            BusinessDayAdjustments.BusinessDayAdjustmentsBuilder result = this.dateAdjustments != null ? this.dateAdjustments : (this.dateAdjustments = BusinessDayAdjustments.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustedDate")
        @RuneAttribute(value="adjustedDate")
        public List<? extends FieldWithMetaDate.FieldWithMetaDateBuilder> getAdjustedDate() {
            return this.adjustedDate;
        }

        @Override
        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateAdjustedDate(int _index) {
            if (this.adjustedDate == null) {
                this.adjustedDate = new ArrayList<FieldWithMetaDate.FieldWithMetaDateBuilder>();
            }
            return (FieldWithMetaDate.FieldWithMetaDateBuilder)this.getIndex(this.adjustedDate, _index, () -> {
                FieldWithMetaDate.FieldWithMetaDateBuilder newAdjustedDate = FieldWithMetaDate.builder();
                return newAdjustedDate;
            });
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="unadjustedDate")
        @RuneAttribute(value="unadjustedDate")
        public AdjustableDatesBuilder addUnadjustedDate(Date _unadjustedDate) {
            if (_unadjustedDate != null) {
                this.unadjustedDate.add(_unadjustedDate);
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder addUnadjustedDate(Date _unadjustedDate, int _idx) {
            this.getIndex(this.unadjustedDate, _idx, () -> _unadjustedDate);
            return this;
        }

        @Override
        public AdjustableDatesBuilder addUnadjustedDate(List<Date> unadjustedDates) {
            if (unadjustedDates != null) {
                for (Date toAdd : unadjustedDates) {
                    this.unadjustedDate.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="unadjustedDate")
        public AdjustableDatesBuilder setUnadjustedDate(List<Date> unadjustedDates) {
            this.unadjustedDate = unadjustedDates == null ? new ArrayList<Date>() : (List)unadjustedDates.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public AdjustableDatesBuilder setDateAdjustments(BusinessDayAdjustments _dateAdjustments) {
            this.dateAdjustments = _dateAdjustments == null ? null : _dateAdjustments.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedDate")
        @RuneAttribute(value="adjustedDate")
        public AdjustableDatesBuilder addAdjustedDate(FieldWithMetaDate _adjustedDate) {
            if (_adjustedDate != null) {
                this.adjustedDate.add(_adjustedDate.toBuilder());
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDate(FieldWithMetaDate _adjustedDate, int _idx) {
            this.getIndex(this.adjustedDate, _idx, () -> _adjustedDate.toBuilder());
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDateValue(Date _adjustedDate) {
            this.getOrCreateAdjustedDate(-1).setValue(_adjustedDate);
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDateValue(Date _adjustedDate, int _idx) {
            this.getOrCreateAdjustedDate(_idx).setValue(_adjustedDate);
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDate(List<? extends FieldWithMetaDate> adjustedDates) {
            if (adjustedDates != null) {
                for (FieldWithMetaDate fieldWithMetaDate : adjustedDates) {
                    this.adjustedDate.add(fieldWithMetaDate.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="adjustedDate")
        public AdjustableDatesBuilder setAdjustedDate(List<? extends FieldWithMetaDate> adjustedDates) {
            this.adjustedDate = adjustedDates == null ? new ArrayList<FieldWithMetaDate.FieldWithMetaDateBuilder>() : (List)adjustedDates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public AdjustableDatesBuilder addAdjustedDateValue(List<? extends Date> adjustedDates) {
            if (adjustedDates != null) {
                for (Date date : adjustedDates) {
                    this.addAdjustedDateValue(date);
                }
            }
            return this;
        }

        @Override
        public AdjustableDatesBuilder setAdjustedDateValue(List<? extends Date> adjustedDates) {
            this.adjustedDate.clear();
            if (adjustedDates != null) {
                adjustedDates.forEach(this::addAdjustedDateValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public AdjustableDatesBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public AdjustableDates build() {
            return new AdjustableDatesImpl(this);
        }

        @Override
        public AdjustableDatesBuilder toBuilder() {
            return this;
        }

        @Override
        public AdjustableDatesBuilder prune() {
            if (this.dateAdjustments != null && !this.dateAdjustments.prune().hasData()) {
                this.dateAdjustments = null;
            }
            this.adjustedDate = this.adjustedDate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getUnadjustedDate() != null && !this.getUnadjustedDate().isEmpty()) {
                return true;
            }
            if (this.getDateAdjustments() != null && this.getDateAdjustments().hasData()) {
                return true;
            }
            return this.getAdjustedDate() != null && !this.getAdjustedDate().isEmpty();
        }

        public AdjustableDatesBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AdjustableDatesBuilder o = (AdjustableDatesBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDateAdjustments(), (RosettaModelObjectBuilder)o.getDateAdjustments(), this::setDateAdjustments);
            merger.mergeRosetta(this.getAdjustedDate(), o.getAdjustedDate(), this::getOrCreateAdjustedDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            merger.mergeBasic(this.getUnadjustedDate(), o.getUnadjustedDate(), this::addUnadjustedDate);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AdjustableDates _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.unadjustedDate, _that.getUnadjustedDate())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!ListEquals.listEquals(this.adjustedDate, _that.getAdjustedDate())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unadjustedDate != null ? this.unadjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.adjustedDate != null ? this.adjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustableDatesBuilder {unadjustedDate=" + this.unadjustedDate + ", dateAdjustments=" + this.dateAdjustments + ", adjustedDate=" + this.adjustedDate + ", meta=" + this.meta + '}';
        }
    }

    public static class AdjustableDatesImpl
    implements AdjustableDates {
        private final List<Date> unadjustedDate;
        private final BusinessDayAdjustments dateAdjustments;
        private final List<? extends FieldWithMetaDate> adjustedDate;
        private final MetaFields meta;

        protected AdjustableDatesImpl(AdjustableDatesBuilder builder) {
            this.unadjustedDate = Optional.ofNullable(builder.getUnadjustedDate()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.dateAdjustments = Optional.ofNullable(builder.getDateAdjustments()).map(f -> f.build()).orElse(null);
            this.adjustedDate = Optional.ofNullable(builder.getAdjustedDate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="unadjustedDate")
        @RuneAttribute(value="unadjustedDate")
        public List<Date> getUnadjustedDate() {
            return this.unadjustedDate;
        }

        @Override
        @RosettaAttribute(value="dateAdjustments")
        @RuneAttribute(value="dateAdjustments")
        public BusinessDayAdjustments getDateAdjustments() {
            return this.dateAdjustments;
        }

        @Override
        @RosettaAttribute(value="adjustedDate")
        @RuneAttribute(value="adjustedDate")
        public List<? extends FieldWithMetaDate> getAdjustedDate() {
            return this.adjustedDate;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public AdjustableDates build() {
            return this;
        }

        @Override
        public AdjustableDatesBuilder toBuilder() {
            AdjustableDatesBuilder builder = AdjustableDates.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AdjustableDatesBuilder builder) {
            Optional.ofNullable(this.getUnadjustedDate()).ifPresent(builder::setUnadjustedDate);
            Optional.ofNullable(this.getDateAdjustments()).ifPresent(builder::setDateAdjustments);
            Optional.ofNullable(this.getAdjustedDate()).ifPresent(builder::setAdjustedDate);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            AdjustableDates _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.unadjustedDate, _that.getUnadjustedDate())) {
                return false;
            }
            if (!Objects.equals(this.dateAdjustments, _that.getDateAdjustments())) {
                return false;
            }
            if (!ListEquals.listEquals(this.adjustedDate, _that.getAdjustedDate())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.unadjustedDate != null ? this.unadjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.dateAdjustments != null ? this.dateAdjustments.hashCode() : 0);
            _result = 31 * _result + (this.adjustedDate != null ? this.adjustedDate.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AdjustableDates {unadjustedDate=" + this.unadjustedDate + ", dateAdjustments=" + this.dateAdjustments + ", adjustedDate=" + this.adjustedDate + ", meta=" + this.meta + '}';
        }
    }

    public static interface AdjustableDatesBuilder
    extends AdjustableDates,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getOrCreateDateAdjustments();

        @Override
        public BusinessDayAdjustments.BusinessDayAdjustmentsBuilder getDateAdjustments();

        public FieldWithMetaDate.FieldWithMetaDateBuilder getOrCreateAdjustedDate(int var1);

        public List<? extends FieldWithMetaDate.FieldWithMetaDateBuilder> getAdjustedDate();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public AdjustableDatesBuilder addUnadjustedDate(Date var1);

        public AdjustableDatesBuilder addUnadjustedDate(Date var1, int var2);

        public AdjustableDatesBuilder addUnadjustedDate(List<Date> var1);

        public AdjustableDatesBuilder setUnadjustedDate(List<Date> var1);

        public AdjustableDatesBuilder setDateAdjustments(BusinessDayAdjustments var1);

        public AdjustableDatesBuilder addAdjustedDate(FieldWithMetaDate var1);

        public AdjustableDatesBuilder addAdjustedDate(FieldWithMetaDate var1, int var2);

        public AdjustableDatesBuilder addAdjustedDateValue(Date var1);

        public AdjustableDatesBuilder addAdjustedDateValue(Date var1, int var2);

        public AdjustableDatesBuilder addAdjustedDate(List<? extends FieldWithMetaDate> var1);

        public AdjustableDatesBuilder setAdjustedDate(List<? extends FieldWithMetaDate> var1);

        public AdjustableDatesBuilder addAdjustedDateValue(List<? extends Date> var1);

        public AdjustableDatesBuilder setAdjustedDateValue(List<? extends Date> var1);

        public AdjustableDatesBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("unadjustedDate"), Date.class, this.getUnadjustedDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dateAdjustments"), processor, BusinessDayAdjustments.BusinessDayAdjustmentsBuilder.class, this.getDateAdjustments(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("adjustedDate"), processor, FieldWithMetaDate.FieldWithMetaDateBuilder.class, this.getAdjustedDate(), new AttributeMeta[]{AttributeMeta.GLOBAL_KEY_FIELD});
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public AdjustableDatesBuilder prune();
    }
}

