/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math;

import cdm.base.math.UnitType;
import cdm.base.math.meta.MeasureBaseMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="MeasureBase", builder=MeasureBaseBuilderImpl.class, version="5.24.0")
@RuneDataType(value="MeasureBase", model="cdm", builder=MeasureBaseBuilderImpl.class, version="5.24.0")
public interface MeasureBase
extends RosettaModelObject {
    public static final MeasureBaseMeta metaData = new MeasureBaseMeta();

    public BigDecimal getValue();

    public UnitType getUnit();

    public MeasureBase build();

    public MeasureBaseBuilder toBuilder();

    public static MeasureBaseBuilder builder() {
        return new MeasureBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends MeasureBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MeasureBase> getType() {
        return MeasureBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unit"), processor, UnitType.class, this.getUnit(), new AttributeMeta[0]);
    }

    public static class MeasureBaseBuilderImpl
    implements MeasureBaseBuilder {
        protected BigDecimal value;
        protected UnitType.UnitTypeBuilder unit;

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="value")
        public BigDecimal getValue() {
            return this.value;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public UnitType.UnitTypeBuilder getUnit() {
            return this.unit;
        }

        @Override
        public UnitType.UnitTypeBuilder getOrCreateUnit() {
            UnitType.UnitTypeBuilder result = this.unit != null ? this.unit : (this.unit = UnitType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="value")
        public MeasureBaseBuilder setValue(BigDecimal _value) {
            this.value = _value == null ? null : _value;
            return this;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public MeasureBaseBuilder setUnit(UnitType _unit) {
            this.unit = _unit == null ? null : _unit.toBuilder();
            return this;
        }

        @Override
        public MeasureBase build() {
            return new MeasureBaseImpl(this);
        }

        @Override
        public MeasureBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public MeasureBaseBuilder prune() {
            if (this.unit != null && !this.unit.prune().hasData()) {
                this.unit = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getValue() != null) {
                return true;
            }
            return this.getUnit() != null && this.getUnit().hasData();
        }

        public MeasureBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            MeasureBaseBuilder o = (MeasureBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnit(), (RosettaModelObjectBuilder)o.getUnit(), this::setUnit);
            merger.mergeBasic((Object)this.getValue(), (Object)o.getValue(), this::setValue, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MeasureBase _that = this.getType().cast(o);
            if (!Objects.equals(this.value, _that.getValue())) {
                return false;
            }
            return Objects.equals(this.unit, _that.getUnit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MeasureBaseBuilder {value=" + this.value + ", unit=" + this.unit + '}';
        }
    }

    public static class MeasureBaseImpl
    implements MeasureBase {
        private final BigDecimal value;
        private final UnitType unit;

        protected MeasureBaseImpl(MeasureBaseBuilder builder) {
            this.value = builder.getValue();
            this.unit = Optional.ofNullable(builder.getUnit()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="value")
        public BigDecimal getValue() {
            return this.value;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public UnitType getUnit() {
            return this.unit;
        }

        @Override
        public MeasureBase build() {
            return this;
        }

        @Override
        public MeasureBaseBuilder toBuilder() {
            MeasureBaseBuilder builder = MeasureBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MeasureBaseBuilder builder) {
            Optional.ofNullable(this.getValue()).ifPresent(builder::setValue);
            Optional.ofNullable(this.getUnit()).ifPresent(builder::setUnit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            MeasureBase _that = this.getType().cast(o);
            if (!Objects.equals(this.value, _that.getValue())) {
                return false;
            }
            return Objects.equals(this.unit, _that.getUnit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            _result = 31 * _result + (this.unit != null ? this.unit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "MeasureBase {value=" + this.value + ", unit=" + this.unit + '}';
        }
    }

    public static interface MeasureBaseBuilder
    extends MeasureBase,
    RosettaModelObjectBuilder {
        public UnitType.UnitTypeBuilder getOrCreateUnit();

        @Override
        public UnitType.UnitTypeBuilder getUnit();

        public MeasureBaseBuilder setValue(BigDecimal var1);

        public MeasureBaseBuilder setUnit(UnitType var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unit"), processor, UnitType.UnitTypeBuilder.class, this.getUnit(), new AttributeMeta[0]);
        }

        public MeasureBaseBuilder prune();
    }
}

