/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common;

import cdm.base.staticdata.asset.common.DebtType;
import cdm.base.staticdata.asset.common.EquityTypeEnum;
import cdm.base.staticdata.asset.common.FundProductTypeEnum;
import cdm.base.staticdata.asset.common.Listing;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.ProductTaxonomy;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import cdm.base.staticdata.asset.common.meta.SecurityMeta;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.base.staticdata.party.LegalEntity;
import cdm.product.template.EconomicTerms;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Security", builder=SecurityBuilderImpl.class, version="5.24.0")
@RuneDataType(value="Security", model="cdm", builder=SecurityBuilderImpl.class, version="5.24.0")
public interface Security
extends Listing {
    public static final SecurityMeta metaData = new SecurityMeta();

    public SecurityTypeEnum getSecurityType();

    public DebtType getDebtType();

    public EquityTypeEnum getEquityType();

    public FundProductTypeEnum getFundType();

    public EconomicTerms getEconomicTerms();

    @Override
    public Security build();

    @Override
    public SecurityBuilder toBuilder();

    public static SecurityBuilder builder() {
        return new SecurityBuilderImpl();
    }

    default public RosettaMetaData<? extends Security> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Security> getType() {
        return Security.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productTaxonomy"), processor, ProductTaxonomy.class, this.getProductTaxonomy(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("productIdentifier"), processor, ReferenceWithMetaProductIdentifier.class, this.getProductIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.class, this.getExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.class, this.getRelatedExchange(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("securityType"), SecurityTypeEnum.class, (Object)this.getSecurityType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("debtType"), processor, DebtType.class, this.getDebtType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("equityType"), EquityTypeEnum.class, (Object)this.getEquityType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fundType"), FundProductTypeEnum.class, (Object)this.getFundType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("economicTerms"), processor, EconomicTerms.class, this.getEconomicTerms(), new AttributeMeta[0]);
    }

    public static class SecurityBuilderImpl
    extends Listing.ListingBuilderImpl
    implements SecurityBuilder {
        protected SecurityTypeEnum securityType;
        protected DebtType.DebtTypeBuilder debtType;
        protected EquityTypeEnum equityType;
        protected FundProductTypeEnum fundType;
        protected EconomicTerms.EconomicTermsBuilder economicTerms;

        @Override
        @RosettaAttribute(value="securityType")
        @RuneAttribute(value="securityType")
        public SecurityTypeEnum getSecurityType() {
            return this.securityType;
        }

        @Override
        @RosettaAttribute(value="debtType")
        @RuneAttribute(value="debtType")
        public DebtType.DebtTypeBuilder getDebtType() {
            return this.debtType;
        }

        @Override
        public DebtType.DebtTypeBuilder getOrCreateDebtType() {
            DebtType.DebtTypeBuilder result = this.debtType != null ? this.debtType : (this.debtType = DebtType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="equityType")
        @RuneAttribute(value="equityType")
        public EquityTypeEnum getEquityType() {
            return this.equityType;
        }

        @Override
        @RosettaAttribute(value="fundType")
        @RuneAttribute(value="fundType")
        public FundProductTypeEnum getFundType() {
            return this.fundType;
        }

        @Override
        @RosettaAttribute(value="economicTerms")
        @RuneAttribute(value="economicTerms")
        public EconomicTerms.EconomicTermsBuilder getEconomicTerms() {
            return this.economicTerms;
        }

        @Override
        public EconomicTerms.EconomicTermsBuilder getOrCreateEconomicTerms() {
            EconomicTerms.EconomicTermsBuilder result = this.economicTerms != null ? this.economicTerms : (this.economicTerms = EconomicTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productTaxonomy")
        @RuneAttribute(value="productTaxonomy")
        public SecurityBuilder addProductTaxonomy(ProductTaxonomy _productTaxonomy) {
            if (_productTaxonomy != null) {
                this.productTaxonomy.add(_productTaxonomy.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addProductTaxonomy(ProductTaxonomy _productTaxonomy, int _idx) {
            this.getIndex(this.productTaxonomy, _idx, () -> _productTaxonomy.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            if (productTaxonomys != null) {
                for (ProductTaxonomy productTaxonomy : productTaxonomys) {
                    this.productTaxonomy.add(productTaxonomy.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productTaxonomy")
        public SecurityBuilder setProductTaxonomy(List<? extends ProductTaxonomy> productTaxonomys) {
            this.productTaxonomy = productTaxonomys == null ? new ArrayList() : (List)productTaxonomys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="productIdentifier")
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public SecurityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier _productIdentifier) {
            if (_productIdentifier != null) {
                this.productIdentifier.add(_productIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier _productIdentifier, int _idx) {
            this.getIndex(this.productIdentifier, _idx, () -> _productIdentifier.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifierValue(ProductIdentifier _productIdentifier) {
            this.getOrCreateProductIdentifier(-1).setValue(_productIdentifier.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifierValue(ProductIdentifier _productIdentifier, int _idx) {
            this.getOrCreateProductIdentifier(_idx).setValue(_productIdentifier.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ReferenceWithMetaProductIdentifier referenceWithMetaProductIdentifier : productIdentifiers) {
                    this.productIdentifier.add(referenceWithMetaProductIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="productIdentifier")
        @RuneScopedAttributeReference
        public SecurityBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> productIdentifiers) {
            this.productIdentifier = productIdentifiers == null ? new ArrayList() : (List)productIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public SecurityBuilder addProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            if (productIdentifiers != null) {
                for (ProductIdentifier productIdentifier : productIdentifiers) {
                    this.addProductIdentifierValue(productIdentifier);
                }
            }
            return this;
        }

        @Override
        public SecurityBuilder setProductIdentifierValue(List<? extends ProductIdentifier> productIdentifiers) {
            this.productIdentifier.clear();
            if (productIdentifiers != null) {
                productIdentifiers.forEach(this::addProductIdentifierValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="exchange")
        @RuneAttribute(value="exchange")
        public SecurityBuilder setExchange(LegalEntity _exchange) {
            this.exchange = _exchange == null ? null : _exchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedExchange")
        @RuneAttribute(value="relatedExchange")
        public SecurityBuilder addRelatedExchange(LegalEntity _relatedExchange) {
            if (_relatedExchange != null) {
                this.relatedExchange.add(_relatedExchange.toBuilder());
            }
            return this;
        }

        @Override
        public SecurityBuilder addRelatedExchange(LegalEntity _relatedExchange, int _idx) {
            this.getIndex(this.relatedExchange, _idx, () -> _relatedExchange.toBuilder());
            return this;
        }

        @Override
        public SecurityBuilder addRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            if (relatedExchanges != null) {
                for (LegalEntity legalEntity : relatedExchanges) {
                    this.relatedExchange.add(legalEntity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedExchange")
        public SecurityBuilder setRelatedExchange(List<? extends LegalEntity> relatedExchanges) {
            this.relatedExchange = relatedExchanges == null ? new ArrayList() : (List)relatedExchanges.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="securityType")
        @RuneAttribute(value="securityType")
        public SecurityBuilder setSecurityType(SecurityTypeEnum _securityType) {
            this.securityType = _securityType == null ? null : _securityType;
            return this;
        }

        @Override
        @RosettaAttribute(value="debtType")
        @RuneAttribute(value="debtType")
        public SecurityBuilder setDebtType(DebtType _debtType) {
            this.debtType = _debtType == null ? null : _debtType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="equityType")
        @RuneAttribute(value="equityType")
        public SecurityBuilder setEquityType(EquityTypeEnum _equityType) {
            this.equityType = _equityType == null ? null : _equityType;
            return this;
        }

        @Override
        @RosettaAttribute(value="fundType")
        @RuneAttribute(value="fundType")
        public SecurityBuilder setFundType(FundProductTypeEnum _fundType) {
            this.fundType = _fundType == null ? null : _fundType;
            return this;
        }

        @Override
        @RosettaAttribute(value="economicTerms")
        @RuneAttribute(value="economicTerms")
        public SecurityBuilder setEconomicTerms(EconomicTerms _economicTerms) {
            this.economicTerms = _economicTerms == null ? null : _economicTerms.toBuilder();
            return this;
        }

        @Override
        public Security build() {
            return new SecurityImpl(this);
        }

        @Override
        public SecurityBuilder toBuilder() {
            return this;
        }

        @Override
        public SecurityBuilder prune() {
            super.prune();
            if (this.debtType != null && !this.debtType.prune().hasData()) {
                this.debtType = null;
            }
            if (this.economicTerms != null && !this.economicTerms.prune().hasData()) {
                this.economicTerms = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSecurityType() != null) {
                return true;
            }
            if (this.getDebtType() != null && this.getDebtType().hasData()) {
                return true;
            }
            if (this.getEquityType() != null) {
                return true;
            }
            if (this.getFundType() != null) {
                return true;
            }
            return this.getEconomicTerms() != null && this.getEconomicTerms().hasData();
        }

        @Override
        public SecurityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            SecurityBuilder o = (SecurityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getDebtType(), (RosettaModelObjectBuilder)o.getDebtType(), this::setDebtType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEconomicTerms(), (RosettaModelObjectBuilder)o.getEconomicTerms(), this::setEconomicTerms);
            merger.mergeBasic((Object)this.getSecurityType(), (Object)o.getSecurityType(), this::setSecurityType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEquityType(), (Object)o.getEquityType(), this::setEquityType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFundType(), (Object)o.getFundType(), this::setFundType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Security _that = (Security)this.getType().cast(o);
            if (!Objects.equals((Object)this.securityType, (Object)_that.getSecurityType())) {
                return false;
            }
            if (!Objects.equals(this.debtType, _that.getDebtType())) {
                return false;
            }
            if (!Objects.equals((Object)this.equityType, (Object)_that.getEquityType())) {
                return false;
            }
            if (!Objects.equals((Object)this.fundType, (Object)_that.getFundType())) {
                return false;
            }
            return Objects.equals(this.economicTerms, _that.getEconomicTerms());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.securityType != null ? ((Object)((Object)this.securityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.debtType != null ? this.debtType.hashCode() : 0);
            _result = 31 * _result + (this.equityType != null ? ((Object)((Object)this.equityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fundType != null ? ((Object)((Object)this.fundType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.economicTerms != null ? this.economicTerms.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "SecurityBuilder {securityType=" + (Object)((Object)this.securityType) + ", debtType=" + this.debtType + ", equityType=" + (Object)((Object)this.equityType) + ", fundType=" + (Object)((Object)this.fundType) + ", economicTerms=" + this.economicTerms + '}' + " " + super.toString();
        }
    }

    public static class SecurityImpl
    extends Listing.ListingImpl
    implements Security {
        private final SecurityTypeEnum securityType;
        private final DebtType debtType;
        private final EquityTypeEnum equityType;
        private final FundProductTypeEnum fundType;
        private final EconomicTerms economicTerms;

        protected SecurityImpl(SecurityBuilder builder) {
            super(builder);
            this.securityType = builder.getSecurityType();
            this.debtType = Optional.ofNullable(builder.getDebtType()).map(f -> f.build()).orElse(null);
            this.equityType = builder.getEquityType();
            this.fundType = builder.getFundType();
            this.economicTerms = Optional.ofNullable(builder.getEconomicTerms()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="securityType")
        @RuneAttribute(value="securityType")
        public SecurityTypeEnum getSecurityType() {
            return this.securityType;
        }

        @Override
        @RosettaAttribute(value="debtType")
        @RuneAttribute(value="debtType")
        public DebtType getDebtType() {
            return this.debtType;
        }

        @Override
        @RosettaAttribute(value="equityType")
        @RuneAttribute(value="equityType")
        public EquityTypeEnum getEquityType() {
            return this.equityType;
        }

        @Override
        @RosettaAttribute(value="fundType")
        @RuneAttribute(value="fundType")
        public FundProductTypeEnum getFundType() {
            return this.fundType;
        }

        @Override
        @RosettaAttribute(value="economicTerms")
        @RuneAttribute(value="economicTerms")
        public EconomicTerms getEconomicTerms() {
            return this.economicTerms;
        }

        @Override
        public Security build() {
            return this;
        }

        @Override
        public SecurityBuilder toBuilder() {
            SecurityBuilder builder = Security.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(SecurityBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSecurityType()).ifPresent(builder::setSecurityType);
            Optional.ofNullable(this.getDebtType()).ifPresent(builder::setDebtType);
            Optional.ofNullable(this.getEquityType()).ifPresent(builder::setEquityType);
            Optional.ofNullable(this.getFundType()).ifPresent(builder::setFundType);
            Optional.ofNullable(this.getEconomicTerms()).ifPresent(builder::setEconomicTerms);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Security _that = (Security)this.getType().cast(o);
            if (!Objects.equals((Object)this.securityType, (Object)_that.getSecurityType())) {
                return false;
            }
            if (!Objects.equals(this.debtType, _that.getDebtType())) {
                return false;
            }
            if (!Objects.equals((Object)this.equityType, (Object)_that.getEquityType())) {
                return false;
            }
            if (!Objects.equals((Object)this.fundType, (Object)_that.getFundType())) {
                return false;
            }
            return Objects.equals(this.economicTerms, _that.getEconomicTerms());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.securityType != null ? ((Object)((Object)this.securityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.debtType != null ? this.debtType.hashCode() : 0);
            _result = 31 * _result + (this.equityType != null ? ((Object)((Object)this.equityType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.fundType != null ? ((Object)((Object)this.fundType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.economicTerms != null ? this.economicTerms.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "Security {securityType=" + (Object)((Object)this.securityType) + ", debtType=" + this.debtType + ", equityType=" + (Object)((Object)this.equityType) + ", fundType=" + (Object)((Object)this.fundType) + ", economicTerms=" + this.economicTerms + '}' + " " + super.toString();
        }
    }

    public static interface SecurityBuilder
    extends Security,
    Listing.ListingBuilder {
        public DebtType.DebtTypeBuilder getOrCreateDebtType();

        @Override
        public DebtType.DebtTypeBuilder getDebtType();

        public EconomicTerms.EconomicTermsBuilder getOrCreateEconomicTerms();

        @Override
        public EconomicTerms.EconomicTermsBuilder getEconomicTerms();

        @Override
        public SecurityBuilder addProductTaxonomy(ProductTaxonomy var1);

        @Override
        public SecurityBuilder addProductTaxonomy(ProductTaxonomy var1, int var2);

        @Override
        public SecurityBuilder addProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public SecurityBuilder setProductTaxonomy(List<? extends ProductTaxonomy> var1);

        @Override
        public SecurityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1);

        @Override
        public SecurityBuilder addProductIdentifier(ReferenceWithMetaProductIdentifier var1, int var2);

        @Override
        public SecurityBuilder addProductIdentifierValue(ProductIdentifier var1);

        @Override
        public SecurityBuilder addProductIdentifierValue(ProductIdentifier var1, int var2);

        @Override
        public SecurityBuilder addProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public SecurityBuilder setProductIdentifier(List<? extends ReferenceWithMetaProductIdentifier> var1);

        @Override
        public SecurityBuilder addProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public SecurityBuilder setProductIdentifierValue(List<? extends ProductIdentifier> var1);

        @Override
        public SecurityBuilder setExchange(LegalEntity var1);

        @Override
        public SecurityBuilder addRelatedExchange(LegalEntity var1);

        @Override
        public SecurityBuilder addRelatedExchange(LegalEntity var1, int var2);

        @Override
        public SecurityBuilder addRelatedExchange(List<? extends LegalEntity> var1);

        @Override
        public SecurityBuilder setRelatedExchange(List<? extends LegalEntity> var1);

        public SecurityBuilder setSecurityType(SecurityTypeEnum var1);

        public SecurityBuilder setDebtType(DebtType var1);

        public SecurityBuilder setEquityType(EquityTypeEnum var1);

        public SecurityBuilder setFundType(FundProductTypeEnum var1);

        public SecurityBuilder setEconomicTerms(EconomicTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productTaxonomy"), processor, ProductTaxonomy.ProductTaxonomyBuilder.class, this.getProductTaxonomy(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("productIdentifier"), processor, ReferenceWithMetaProductIdentifier.ReferenceWithMetaProductIdentifierBuilder.class, this.getProductIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchange"), processor, LegalEntity.LegalEntityBuilder.class, (RosettaModelObjectBuilder)this.getExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedExchange"), processor, LegalEntity.LegalEntityBuilder.class, this.getRelatedExchange(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("securityType"), SecurityTypeEnum.class, (Object)this.getSecurityType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("debtType"), processor, DebtType.DebtTypeBuilder.class, this.getDebtType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("equityType"), EquityTypeEnum.class, (Object)this.getEquityType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fundType"), FundProductTypeEnum.class, (Object)this.getFundType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("economicTerms"), processor, EconomicTerms.EconomicTermsBuilder.class, this.getEconomicTerms(), new AttributeMeta[0]);
        }

        @Override
        public SecurityBuilder prune();
    }
}

