/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.identifier;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.meta.IdentifierMeta;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Identifier", builder=IdentifierBuilderImpl.class, version="5.24.0")
@RuneDataType(value="Identifier", model="cdm", builder=IdentifierBuilderImpl.class, version="5.24.0")
public interface Identifier
extends RosettaModelObject,
GlobalKey {
    public static final IdentifierMeta metaData = new IdentifierMeta();

    public ReferenceWithMetaParty getIssuerReference();

    public FieldWithMetaString getIssuer();

    public List<? extends AssignedIdentifier> getAssignedIdentifier();

    public MetaFields getMeta();

    public Identifier build();

    public IdentifierBuilder toBuilder();

    public static IdentifierBuilder builder() {
        return new IdentifierBuilderImpl();
    }

    default public RosettaMetaData<? extends Identifier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Identifier> getType() {
        return Identifier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("issuerReference"), processor, ReferenceWithMetaParty.class, this.getIssuerReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuer"), processor, FieldWithMetaString.class, this.getIssuer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assignedIdentifier"), processor, AssignedIdentifier.class, this.getAssignedIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class IdentifierBuilderImpl
    implements IdentifierBuilder {
        protected ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder issuerReference;
        protected FieldWithMetaString.FieldWithMetaStringBuilder issuer;
        protected List<AssignedIdentifier.AssignedIdentifierBuilder> assignedIdentifier = new ArrayList<AssignedIdentifier.AssignedIdentifierBuilder>();
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="issuerReference")
        @RuneAttribute(value="issuerReference")
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getIssuerReference() {
            return this.issuerReference;
        }

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateIssuerReference() {
            ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder result = this.issuerReference != null ? this.issuerReference : (this.issuerReference = ReferenceWithMetaParty.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuer")
        @RuneAttribute(value="issuer")
        public FieldWithMetaString.FieldWithMetaStringBuilder getIssuer() {
            return this.issuer;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateIssuer() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.issuer != null ? this.issuer : (this.issuer = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assignedIdentifier")
        @RuneAttribute(value="assignedIdentifier")
        public List<? extends AssignedIdentifier.AssignedIdentifierBuilder> getAssignedIdentifier() {
            return this.assignedIdentifier;
        }

        @Override
        public AssignedIdentifier.AssignedIdentifierBuilder getOrCreateAssignedIdentifier(int _index) {
            if (this.assignedIdentifier == null) {
                this.assignedIdentifier = new ArrayList<AssignedIdentifier.AssignedIdentifierBuilder>();
            }
            return (AssignedIdentifier.AssignedIdentifierBuilder)this.getIndex(this.assignedIdentifier, _index, () -> {
                AssignedIdentifier.AssignedIdentifierBuilder newAssignedIdentifier = AssignedIdentifier.builder();
                return newAssignedIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuerReference")
        @RuneAttribute(value="issuerReference")
        public IdentifierBuilder setIssuerReference(ReferenceWithMetaParty _issuerReference) {
            this.issuerReference = _issuerReference == null ? null : _issuerReference.toBuilder();
            return this;
        }

        @Override
        public IdentifierBuilder setIssuerReferenceValue(Party _issuerReference) {
            this.getOrCreateIssuerReference().setValue(_issuerReference);
            return this;
        }

        @Override
        @RosettaAttribute(value="issuer")
        @RuneAttribute(value="issuer")
        public IdentifierBuilder setIssuer(FieldWithMetaString _issuer) {
            this.issuer = _issuer == null ? null : _issuer.toBuilder();
            return this;
        }

        @Override
        public IdentifierBuilder setIssuerValue(String _issuer) {
            this.getOrCreateIssuer().setValue(_issuer);
            return this;
        }

        @Override
        @RosettaAttribute(value="assignedIdentifier")
        @RuneAttribute(value="assignedIdentifier")
        public IdentifierBuilder addAssignedIdentifier(AssignedIdentifier _assignedIdentifier) {
            if (_assignedIdentifier != null) {
                this.assignedIdentifier.add(_assignedIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public IdentifierBuilder addAssignedIdentifier(AssignedIdentifier _assignedIdentifier, int _idx) {
            this.getIndex(this.assignedIdentifier, _idx, () -> _assignedIdentifier.toBuilder());
            return this;
        }

        @Override
        public IdentifierBuilder addAssignedIdentifier(List<? extends AssignedIdentifier> assignedIdentifiers) {
            if (assignedIdentifiers != null) {
                for (AssignedIdentifier assignedIdentifier : assignedIdentifiers) {
                    this.assignedIdentifier.add(assignedIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="assignedIdentifier")
        public IdentifierBuilder setAssignedIdentifier(List<? extends AssignedIdentifier> assignedIdentifiers) {
            this.assignedIdentifier = assignedIdentifiers == null ? new ArrayList<AssignedIdentifier.AssignedIdentifierBuilder>() : (List)assignedIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public IdentifierBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public Identifier build() {
            return new IdentifierImpl(this);
        }

        @Override
        public IdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public IdentifierBuilder prune() {
            if (this.issuerReference != null && !this.issuerReference.prune().hasData()) {
                this.issuerReference = null;
            }
            if (this.issuer != null && !this.issuer.prune().hasData()) {
                this.issuer = null;
            }
            this.assignedIdentifier = this.assignedIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIssuerReference() != null && this.getIssuerReference().hasData()) {
                return true;
            }
            if (this.getIssuer() != null) {
                return true;
            }
            return this.getAssignedIdentifier() != null && this.getAssignedIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public IdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            IdentifierBuilder o = (IdentifierBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuerReference(), (RosettaModelObjectBuilder)o.getIssuerReference(), this::setIssuerReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuer(), (RosettaModelObjectBuilder)o.getIssuer(), this::setIssuer);
            merger.mergeRosetta(this.getAssignedIdentifier(), o.getAssignedIdentifier(), this::getOrCreateAssignedIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Identifier _that = this.getType().cast(o);
            if (!Objects.equals(this.issuerReference, _that.getIssuerReference())) {
                return false;
            }
            if (!Objects.equals(this.issuer, _that.getIssuer())) {
                return false;
            }
            if (!ListEquals.listEquals(this.assignedIdentifier, _that.getAssignedIdentifier())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuerReference != null ? this.issuerReference.hashCode() : 0);
            _result = 31 * _result + (this.issuer != null ? this.issuer.hashCode() : 0);
            _result = 31 * _result + (this.assignedIdentifier != null ? this.assignedIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "IdentifierBuilder {issuerReference=" + this.issuerReference + ", issuer=" + this.issuer + ", assignedIdentifier=" + this.assignedIdentifier + ", meta=" + this.meta + '}';
        }
    }

    public static class IdentifierImpl
    implements Identifier {
        private final ReferenceWithMetaParty issuerReference;
        private final FieldWithMetaString issuer;
        private final List<? extends AssignedIdentifier> assignedIdentifier;
        private final MetaFields meta;

        protected IdentifierImpl(IdentifierBuilder builder) {
            this.issuerReference = Optional.ofNullable(builder.getIssuerReference()).map(f -> f.build()).orElse(null);
            this.issuer = Optional.ofNullable(builder.getIssuer()).map(f -> f.build()).orElse(null);
            this.assignedIdentifier = Optional.ofNullable(builder.getAssignedIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="issuerReference")
        @RuneAttribute(value="issuerReference")
        public ReferenceWithMetaParty getIssuerReference() {
            return this.issuerReference;
        }

        @Override
        @RosettaAttribute(value="issuer")
        @RuneAttribute(value="issuer")
        public FieldWithMetaString getIssuer() {
            return this.issuer;
        }

        @Override
        @RosettaAttribute(value="assignedIdentifier")
        @RuneAttribute(value="assignedIdentifier")
        public List<? extends AssignedIdentifier> getAssignedIdentifier() {
            return this.assignedIdentifier;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Identifier build() {
            return this;
        }

        @Override
        public IdentifierBuilder toBuilder() {
            IdentifierBuilder builder = Identifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(IdentifierBuilder builder) {
            Optional.ofNullable(this.getIssuerReference()).ifPresent(builder::setIssuerReference);
            Optional.ofNullable(this.getIssuer()).ifPresent(builder::setIssuer);
            Optional.ofNullable(this.getAssignedIdentifier()).ifPresent(builder::setAssignedIdentifier);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Identifier _that = this.getType().cast(o);
            if (!Objects.equals(this.issuerReference, _that.getIssuerReference())) {
                return false;
            }
            if (!Objects.equals(this.issuer, _that.getIssuer())) {
                return false;
            }
            if (!ListEquals.listEquals(this.assignedIdentifier, _that.getAssignedIdentifier())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuerReference != null ? this.issuerReference.hashCode() : 0);
            _result = 31 * _result + (this.issuer != null ? this.issuer.hashCode() : 0);
            _result = 31 * _result + (this.assignedIdentifier != null ? this.assignedIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Identifier {issuerReference=" + this.issuerReference + ", issuer=" + this.issuer + ", assignedIdentifier=" + this.assignedIdentifier + ", meta=" + this.meta + '}';
        }
    }

    public static interface IdentifierBuilder
    extends Identifier,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getOrCreateIssuerReference();

        @Override
        public ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder getIssuerReference();

        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateIssuer();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getIssuer();

        public AssignedIdentifier.AssignedIdentifierBuilder getOrCreateAssignedIdentifier(int var1);

        public List<? extends AssignedIdentifier.AssignedIdentifierBuilder> getAssignedIdentifier();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public IdentifierBuilder setIssuerReference(ReferenceWithMetaParty var1);

        public IdentifierBuilder setIssuerReferenceValue(Party var1);

        public IdentifierBuilder setIssuer(FieldWithMetaString var1);

        public IdentifierBuilder setIssuerValue(String var1);

        public IdentifierBuilder addAssignedIdentifier(AssignedIdentifier var1);

        public IdentifierBuilder addAssignedIdentifier(AssignedIdentifier var1, int var2);

        public IdentifierBuilder addAssignedIdentifier(List<? extends AssignedIdentifier> var1);

        public IdentifierBuilder setAssignedIdentifier(List<? extends AssignedIdentifier> var1);

        public IdentifierBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("issuerReference"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getIssuerReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuer"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getIssuer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assignedIdentifier"), processor, AssignedIdentifier.AssignedIdentifierBuilder.class, this.getAssignedIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public IdentifierBuilder prune();
    }
}

