/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.party;

import cdm.base.staticdata.party.meta.AddressMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.FieldWithMetaString;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Address", builder=AddressBuilderImpl.class, version="5.24.0")
@RuneDataType(value="Address", model="cdm", builder=AddressBuilderImpl.class, version="5.24.0")
public interface Address
extends RosettaModelObject {
    public static final AddressMeta metaData = new AddressMeta();

    public List<String> getStreet();

    public String getCity();

    public String getState();

    public FieldWithMetaString getCountry();

    public String getPostalCode();

    public Address build();

    public AddressBuilder toBuilder();

    public static AddressBuilder builder() {
        return new AddressBuilderImpl();
    }

    default public RosettaMetaData<? extends Address> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Address> getType() {
        return Address.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("street"), String.class, this.getStreet(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("city"), String.class, (Object)this.getCity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("state"), String.class, (Object)this.getState(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("country"), processor, FieldWithMetaString.class, this.getCountry(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("postalCode"), String.class, (Object)this.getPostalCode(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AddressBuilderImpl
    implements AddressBuilder {
        protected List<String> street = new ArrayList<String>();
        protected String city;
        protected String state;
        protected FieldWithMetaString.FieldWithMetaStringBuilder country;
        protected String postalCode;

        @Override
        @RosettaAttribute(value="street")
        @RuneAttribute(value="street")
        public List<String> getStreet() {
            return this.street;
        }

        @Override
        @RosettaAttribute(value="city")
        @RuneAttribute(value="city")
        public String getCity() {
            return this.city;
        }

        @Override
        @RosettaAttribute(value="state")
        @RuneAttribute(value="state")
        public String getState() {
            return this.state;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public FieldWithMetaString.FieldWithMetaStringBuilder getCountry() {
            return this.country;
        }

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCountry() {
            FieldWithMetaString.FieldWithMetaStringBuilder result = this.country != null ? this.country : (this.country = FieldWithMetaString.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="postalCode")
        @RuneAttribute(value="postalCode")
        public String getPostalCode() {
            return this.postalCode;
        }

        @Override
        @RosettaAttribute(value="street")
        @RuneAttribute(value="street")
        public AddressBuilder addStreet(String _street) {
            if (_street != null) {
                this.street.add(_street);
            }
            return this;
        }

        @Override
        public AddressBuilder addStreet(String _street, int _idx) {
            this.getIndex(this.street, _idx, () -> _street);
            return this;
        }

        @Override
        public AddressBuilder addStreet(List<String> streets) {
            if (streets != null) {
                for (String toAdd : streets) {
                    this.street.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="street")
        public AddressBuilder setStreet(List<String> streets) {
            this.street = streets == null ? new ArrayList<String>() : (List)streets.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="city")
        @RuneAttribute(value="city")
        public AddressBuilder setCity(String _city) {
            this.city = _city == null ? null : _city;
            return this;
        }

        @Override
        @RosettaAttribute(value="state")
        @RuneAttribute(value="state")
        public AddressBuilder setState(String _state) {
            this.state = _state == null ? null : _state;
            return this;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public AddressBuilder setCountry(FieldWithMetaString _country) {
            this.country = _country == null ? null : _country.toBuilder();
            return this;
        }

        @Override
        public AddressBuilder setCountryValue(String _country) {
            this.getOrCreateCountry().setValue(_country);
            return this;
        }

        @Override
        @RosettaAttribute(value="postalCode")
        @RuneAttribute(value="postalCode")
        public AddressBuilder setPostalCode(String _postalCode) {
            this.postalCode = _postalCode == null ? null : _postalCode;
            return this;
        }

        @Override
        public Address build() {
            return new AddressImpl(this);
        }

        @Override
        public AddressBuilder toBuilder() {
            return this;
        }

        @Override
        public AddressBuilder prune() {
            if (this.country != null && !this.country.prune().hasData()) {
                this.country = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getStreet() != null && !this.getStreet().isEmpty()) {
                return true;
            }
            if (this.getCity() != null) {
                return true;
            }
            if (this.getState() != null) {
                return true;
            }
            if (this.getCountry() != null) {
                return true;
            }
            return this.getPostalCode() != null;
        }

        public AddressBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AddressBuilder o = (AddressBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCountry(), (RosettaModelObjectBuilder)o.getCountry(), this::setCountry);
            merger.mergeBasic(this.getStreet(), o.getStreet(), this::addStreet);
            merger.mergeBasic((Object)this.getCity(), (Object)o.getCity(), this::setCity, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getState(), (Object)o.getState(), this::setState, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPostalCode(), (Object)o.getPostalCode(), this::setPostalCode, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Address _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.street, _that.getStreet())) {
                return false;
            }
            if (!Objects.equals(this.city, _that.getCity())) {
                return false;
            }
            if (!Objects.equals(this.state, _that.getState())) {
                return false;
            }
            if (!Objects.equals(this.country, _that.getCountry())) {
                return false;
            }
            return Objects.equals(this.postalCode, _that.getPostalCode());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.street != null ? this.street.hashCode() : 0);
            _result = 31 * _result + (this.city != null ? this.city.hashCode() : 0);
            _result = 31 * _result + (this.state != null ? this.state.hashCode() : 0);
            _result = 31 * _result + (this.country != null ? this.country.hashCode() : 0);
            _result = 31 * _result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AddressBuilder {street=" + this.street + ", city=" + this.city + ", state=" + this.state + ", country=" + this.country + ", postalCode=" + this.postalCode + '}';
        }
    }

    public static class AddressImpl
    implements Address {
        private final List<String> street;
        private final String city;
        private final String state;
        private final FieldWithMetaString country;
        private final String postalCode;

        protected AddressImpl(AddressBuilder builder) {
            this.street = Optional.ofNullable(builder.getStreet()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.city = builder.getCity();
            this.state = builder.getState();
            this.country = Optional.ofNullable(builder.getCountry()).map(f -> f.build()).orElse(null);
            this.postalCode = builder.getPostalCode();
        }

        @Override
        @RosettaAttribute(value="street")
        @RuneAttribute(value="street")
        public List<String> getStreet() {
            return this.street;
        }

        @Override
        @RosettaAttribute(value="city")
        @RuneAttribute(value="city")
        public String getCity() {
            return this.city;
        }

        @Override
        @RosettaAttribute(value="state")
        @RuneAttribute(value="state")
        public String getState() {
            return this.state;
        }

        @Override
        @RosettaAttribute(value="country")
        @RuneAttribute(value="country")
        public FieldWithMetaString getCountry() {
            return this.country;
        }

        @Override
        @RosettaAttribute(value="postalCode")
        @RuneAttribute(value="postalCode")
        public String getPostalCode() {
            return this.postalCode;
        }

        @Override
        public Address build() {
            return this;
        }

        @Override
        public AddressBuilder toBuilder() {
            AddressBuilder builder = Address.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AddressBuilder builder) {
            Optional.ofNullable(this.getStreet()).ifPresent(builder::setStreet);
            Optional.ofNullable(this.getCity()).ifPresent(builder::setCity);
            Optional.ofNullable(this.getState()).ifPresent(builder::setState);
            Optional.ofNullable(this.getCountry()).ifPresent(builder::setCountry);
            Optional.ofNullable(this.getPostalCode()).ifPresent(builder::setPostalCode);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Address _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.street, _that.getStreet())) {
                return false;
            }
            if (!Objects.equals(this.city, _that.getCity())) {
                return false;
            }
            if (!Objects.equals(this.state, _that.getState())) {
                return false;
            }
            if (!Objects.equals(this.country, _that.getCountry())) {
                return false;
            }
            return Objects.equals(this.postalCode, _that.getPostalCode());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.street != null ? this.street.hashCode() : 0);
            _result = 31 * _result + (this.city != null ? this.city.hashCode() : 0);
            _result = 31 * _result + (this.state != null ? this.state.hashCode() : 0);
            _result = 31 * _result + (this.country != null ? this.country.hashCode() : 0);
            _result = 31 * _result + (this.postalCode != null ? this.postalCode.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Address {street=" + this.street + ", city=" + this.city + ", state=" + this.state + ", country=" + this.country + ", postalCode=" + this.postalCode + '}';
        }
    }

    public static interface AddressBuilder
    extends Address,
    RosettaModelObjectBuilder {
        public FieldWithMetaString.FieldWithMetaStringBuilder getOrCreateCountry();

        @Override
        public FieldWithMetaString.FieldWithMetaStringBuilder getCountry();

        public AddressBuilder addStreet(String var1);

        public AddressBuilder addStreet(String var1, int var2);

        public AddressBuilder addStreet(List<String> var1);

        public AddressBuilder setStreet(List<String> var1);

        public AddressBuilder setCity(String var1);

        public AddressBuilder setState(String var1);

        public AddressBuilder setCountry(FieldWithMetaString var1);

        public AddressBuilder setCountryValue(String var1);

        public AddressBuilder setPostalCode(String var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("street"), String.class, this.getStreet(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("city"), String.class, (Object)this.getCity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("state"), String.class, (Object)this.getState(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("country"), processor, FieldWithMetaString.FieldWithMetaStringBuilder.class, this.getCountry(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("postalCode"), String.class, (Object)this.getPostalCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AddressBuilder prune();
    }
}

