/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.IdentifiedList;
import cdm.event.common.CorporateActionTypeEnum;
import cdm.event.common.CounterpartyPositionState;
import cdm.event.common.PositionEventIntentEnum;
import cdm.event.common.meta.CounterpartyPositionBusinessEventMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CounterpartyPositionBusinessEvent", builder=CounterpartyPositionBusinessEventBuilderImpl.class, version="5.24.0")
@RuneDataType(value="CounterpartyPositionBusinessEvent", model="cdm", builder=CounterpartyPositionBusinessEventBuilderImpl.class, version="5.24.0")
public interface CounterpartyPositionBusinessEvent
extends RosettaModelObject {
    public static final CounterpartyPositionBusinessEventMeta metaData = new CounterpartyPositionBusinessEventMeta();

    public PositionEventIntentEnum getIntent();

    public CorporateActionTypeEnum getCorporateActionIntent();

    public Date getEventDate();

    public Date getEffectiveDate();

    public IdentifiedList getPackageInformation();

    public List<? extends CounterpartyPositionState> getAfter();

    public CounterpartyPositionBusinessEvent build();

    public CounterpartyPositionBusinessEventBuilder toBuilder();

    public static CounterpartyPositionBusinessEventBuilder builder() {
        return new CounterpartyPositionBusinessEventBuilderImpl();
    }

    default public RosettaMetaData<? extends CounterpartyPositionBusinessEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CounterpartyPositionBusinessEvent> getType() {
        return CounterpartyPositionBusinessEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("intent"), PositionEventIntentEnum.class, (Object)this.getIntent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateActionIntent"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionIntent(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageInformation"), processor, IdentifiedList.class, this.getPackageInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("after"), processor, CounterpartyPositionState.class, this.getAfter(), new AttributeMeta[0]);
    }

    public static class CounterpartyPositionBusinessEventBuilderImpl
    implements CounterpartyPositionBusinessEventBuilder {
        protected PositionEventIntentEnum intent;
        protected CorporateActionTypeEnum corporateActionIntent;
        protected Date eventDate;
        protected Date effectiveDate;
        protected IdentifiedList.IdentifiedListBuilder packageInformation;
        protected List<CounterpartyPositionState.CounterpartyPositionStateBuilder> after = new ArrayList<CounterpartyPositionState.CounterpartyPositionStateBuilder>();

        @Override
        @RosettaAttribute(value="intent")
        @RuneAttribute(value="intent")
        public PositionEventIntentEnum getIntent() {
            return this.intent;
        }

        @Override
        @RosettaAttribute(value="corporateActionIntent")
        @RuneAttribute(value="corporateActionIntent")
        public CorporateActionTypeEnum getCorporateActionIntent() {
            return this.corporateActionIntent;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        @RuneAttribute(value="packageInformation")
        public IdentifiedList.IdentifiedListBuilder getPackageInformation() {
            return this.packageInformation;
        }

        @Override
        public IdentifiedList.IdentifiedListBuilder getOrCreatePackageInformation() {
            IdentifiedList.IdentifiedListBuilder result = this.packageInformation != null ? this.packageInformation : (this.packageInformation = IdentifiedList.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="after")
        @RuneAttribute(value="after")
        public List<? extends CounterpartyPositionState.CounterpartyPositionStateBuilder> getAfter() {
            return this.after;
        }

        @Override
        public CounterpartyPositionState.CounterpartyPositionStateBuilder getOrCreateAfter(int _index) {
            if (this.after == null) {
                this.after = new ArrayList<CounterpartyPositionState.CounterpartyPositionStateBuilder>();
            }
            return (CounterpartyPositionState.CounterpartyPositionStateBuilder)this.getIndex(this.after, _index, () -> {
                CounterpartyPositionState.CounterpartyPositionStateBuilder newAfter = CounterpartyPositionState.builder();
                return newAfter;
            });
        }

        @Override
        @RosettaAttribute(value="intent")
        @RuneAttribute(value="intent")
        public CounterpartyPositionBusinessEventBuilder setIntent(PositionEventIntentEnum _intent) {
            this.intent = _intent == null ? null : _intent;
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateActionIntent")
        @RuneAttribute(value="corporateActionIntent")
        public CounterpartyPositionBusinessEventBuilder setCorporateActionIntent(CorporateActionTypeEnum _corporateActionIntent) {
            this.corporateActionIntent = _corporateActionIntent == null ? null : _corporateActionIntent;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public CounterpartyPositionBusinessEventBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public CounterpartyPositionBusinessEventBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        @RuneAttribute(value="packageInformation")
        public CounterpartyPositionBusinessEventBuilder setPackageInformation(IdentifiedList _packageInformation) {
            this.packageInformation = _packageInformation == null ? null : _packageInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="after")
        @RuneAttribute(value="after")
        public CounterpartyPositionBusinessEventBuilder addAfter(CounterpartyPositionState _after) {
            if (_after != null) {
                this.after.add(_after.toBuilder());
            }
            return this;
        }

        @Override
        public CounterpartyPositionBusinessEventBuilder addAfter(CounterpartyPositionState _after, int _idx) {
            this.getIndex(this.after, _idx, () -> _after.toBuilder());
            return this;
        }

        @Override
        public CounterpartyPositionBusinessEventBuilder addAfter(List<? extends CounterpartyPositionState> afters) {
            if (afters != null) {
                for (CounterpartyPositionState counterpartyPositionState : afters) {
                    this.after.add(counterpartyPositionState.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="after")
        public CounterpartyPositionBusinessEventBuilder setAfter(List<? extends CounterpartyPositionState> afters) {
            this.after = afters == null ? new ArrayList<CounterpartyPositionState.CounterpartyPositionStateBuilder>() : (List)afters.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CounterpartyPositionBusinessEvent build() {
            return new CounterpartyPositionBusinessEventImpl(this);
        }

        @Override
        public CounterpartyPositionBusinessEventBuilder toBuilder() {
            return this;
        }

        @Override
        public CounterpartyPositionBusinessEventBuilder prune() {
            if (this.packageInformation != null && !this.packageInformation.prune().hasData()) {
                this.packageInformation = null;
            }
            this.after = this.after.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getIntent() != null) {
                return true;
            }
            if (this.getCorporateActionIntent() != null) {
                return true;
            }
            if (this.getEventDate() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getPackageInformation() != null && this.getPackageInformation().hasData()) {
                return true;
            }
            return this.getAfter() != null && this.getAfter().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CounterpartyPositionBusinessEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CounterpartyPositionBusinessEventBuilder o = (CounterpartyPositionBusinessEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPackageInformation(), (RosettaModelObjectBuilder)o.getPackageInformation(), this::setPackageInformation);
            merger.mergeRosetta(this.getAfter(), o.getAfter(), this::getOrCreateAfter);
            merger.mergeBasic((Object)this.getIntent(), (Object)o.getIntent(), this::setIntent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCorporateActionIntent(), (Object)o.getCorporateActionIntent(), this::setCorporateActionIntent, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CounterpartyPositionBusinessEvent _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.intent, (Object)_that.getIntent())) {
                return false;
            }
            if (!Objects.equals((Object)this.corporateActionIntent, (Object)_that.getCorporateActionIntent())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.packageInformation, _that.getPackageInformation())) {
                return false;
            }
            return ListEquals.listEquals(this.after, _that.getAfter());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.intent != null ? ((Object)((Object)this.intent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.corporateActionIntent != null ? ((Object)((Object)this.corporateActionIntent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.packageInformation != null ? this.packageInformation.hashCode() : 0);
            _result = 31 * _result + (this.after != null ? this.after.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CounterpartyPositionBusinessEventBuilder {intent=" + (Object)((Object)this.intent) + ", corporateActionIntent=" + (Object)((Object)this.corporateActionIntent) + ", eventDate=" + this.eventDate + ", effectiveDate=" + this.effectiveDate + ", packageInformation=" + this.packageInformation + ", after=" + this.after + '}';
        }
    }

    public static class CounterpartyPositionBusinessEventImpl
    implements CounterpartyPositionBusinessEvent {
        private final PositionEventIntentEnum intent;
        private final CorporateActionTypeEnum corporateActionIntent;
        private final Date eventDate;
        private final Date effectiveDate;
        private final IdentifiedList packageInformation;
        private final List<? extends CounterpartyPositionState> after;

        protected CounterpartyPositionBusinessEventImpl(CounterpartyPositionBusinessEventBuilder builder) {
            this.intent = builder.getIntent();
            this.corporateActionIntent = builder.getCorporateActionIntent();
            this.eventDate = builder.getEventDate();
            this.effectiveDate = builder.getEffectiveDate();
            this.packageInformation = Optional.ofNullable(builder.getPackageInformation()).map(f -> f.build()).orElse(null);
            this.after = Optional.ofNullable(builder.getAfter()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="intent")
        @RuneAttribute(value="intent")
        public PositionEventIntentEnum getIntent() {
            return this.intent;
        }

        @Override
        @RosettaAttribute(value="corporateActionIntent")
        @RuneAttribute(value="corporateActionIntent")
        public CorporateActionTypeEnum getCorporateActionIntent() {
            return this.corporateActionIntent;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="packageInformation")
        @RuneAttribute(value="packageInformation")
        public IdentifiedList getPackageInformation() {
            return this.packageInformation;
        }

        @Override
        @RosettaAttribute(value="after")
        @RuneAttribute(value="after")
        public List<? extends CounterpartyPositionState> getAfter() {
            return this.after;
        }

        @Override
        public CounterpartyPositionBusinessEvent build() {
            return this;
        }

        @Override
        public CounterpartyPositionBusinessEventBuilder toBuilder() {
            CounterpartyPositionBusinessEventBuilder builder = CounterpartyPositionBusinessEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CounterpartyPositionBusinessEventBuilder builder) {
            Optional.ofNullable(this.getIntent()).ifPresent(builder::setIntent);
            Optional.ofNullable(this.getCorporateActionIntent()).ifPresent(builder::setCorporateActionIntent);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDate);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getPackageInformation()).ifPresent(builder::setPackageInformation);
            Optional.ofNullable(this.getAfter()).ifPresent(builder::setAfter);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CounterpartyPositionBusinessEvent _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.intent, (Object)_that.getIntent())) {
                return false;
            }
            if (!Objects.equals((Object)this.corporateActionIntent, (Object)_that.getCorporateActionIntent())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.packageInformation, _that.getPackageInformation())) {
                return false;
            }
            return ListEquals.listEquals(this.after, _that.getAfter());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.intent != null ? ((Object)((Object)this.intent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.corporateActionIntent != null ? ((Object)((Object)this.corporateActionIntent)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.packageInformation != null ? this.packageInformation.hashCode() : 0);
            _result = 31 * _result + (this.after != null ? this.after.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CounterpartyPositionBusinessEvent {intent=" + (Object)((Object)this.intent) + ", corporateActionIntent=" + (Object)((Object)this.corporateActionIntent) + ", eventDate=" + this.eventDate + ", effectiveDate=" + this.effectiveDate + ", packageInformation=" + this.packageInformation + ", after=" + this.after + '}';
        }
    }

    public static interface CounterpartyPositionBusinessEventBuilder
    extends CounterpartyPositionBusinessEvent,
    RosettaModelObjectBuilder {
        public IdentifiedList.IdentifiedListBuilder getOrCreatePackageInformation();

        @Override
        public IdentifiedList.IdentifiedListBuilder getPackageInformation();

        public CounterpartyPositionState.CounterpartyPositionStateBuilder getOrCreateAfter(int var1);

        public List<? extends CounterpartyPositionState.CounterpartyPositionStateBuilder> getAfter();

        public CounterpartyPositionBusinessEventBuilder setIntent(PositionEventIntentEnum var1);

        public CounterpartyPositionBusinessEventBuilder setCorporateActionIntent(CorporateActionTypeEnum var1);

        public CounterpartyPositionBusinessEventBuilder setEventDate(Date var1);

        public CounterpartyPositionBusinessEventBuilder setEffectiveDate(Date var1);

        public CounterpartyPositionBusinessEventBuilder setPackageInformation(IdentifiedList var1);

        public CounterpartyPositionBusinessEventBuilder addAfter(CounterpartyPositionState var1);

        public CounterpartyPositionBusinessEventBuilder addAfter(CounterpartyPositionState var1, int var2);

        public CounterpartyPositionBusinessEventBuilder addAfter(List<? extends CounterpartyPositionState> var1);

        public CounterpartyPositionBusinessEventBuilder setAfter(List<? extends CounterpartyPositionState> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("intent"), PositionEventIntentEnum.class, (Object)this.getIntent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateActionIntent"), CorporateActionTypeEnum.class, (Object)this.getCorporateActionIntent(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageInformation"), processor, IdentifiedList.IdentifiedListBuilder.class, this.getPackageInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("after"), processor, CounterpartyPositionState.CounterpartyPositionStateBuilder.class, this.getAfter(), new AttributeMeta[0]);
        }

        public CounterpartyPositionBusinessEventBuilder prune();
    }
}

