/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.Trade;
import cdm.event.common.meta.LineageMeta;
import cdm.event.common.metafields.ReferenceWithMetaTrade;
import cdm.event.position.PortfolioState;
import cdm.event.position.metafields.ReferenceWithMetaPortfolioState;
import cdm.event.workflow.WorkflowStep;
import cdm.event.workflow.metafields.ReferenceWithMetaWorkflowStep;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Lineage", builder=LineageBuilderImpl.class, version="5.24.0")
@RuneDataType(value="Lineage", model="cdm", builder=LineageBuilderImpl.class, version="5.24.0")
public interface Lineage
extends RosettaModelObject {
    public static final LineageMeta metaData = new LineageMeta();

    public List<? extends ReferenceWithMetaTrade> getTradeReference();

    public List<? extends ReferenceWithMetaWorkflowStep> getEventReference();

    public List<? extends ReferenceWithMetaPortfolioState> getPortfolioStateReference();

    public Lineage build();

    public LineageBuilder toBuilder();

    public static LineageBuilder builder() {
        return new LineageBuilderImpl();
    }

    default public RosettaMetaData<? extends Lineage> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Lineage> getType() {
        return Lineage.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTrade.class, this.getTradeReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventReference"), processor, ReferenceWithMetaWorkflowStep.class, this.getEventReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioStateReference"), processor, ReferenceWithMetaPortfolioState.class, this.getPortfolioStateReference(), new AttributeMeta[0]);
    }

    public static class LineageBuilderImpl
    implements LineageBuilder {
        protected List<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder> tradeReference = new ArrayList<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder>();
        protected List<ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder> eventReference = new ArrayList<ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder>();
        protected List<ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder> portfolioStateReference = new ArrayList<ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder>();

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public List<? extends ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder> getTradeReference() {
            return this.tradeReference;
        }

        @Override
        public ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder getOrCreateTradeReference(int _index) {
            if (this.tradeReference == null) {
                this.tradeReference = new ArrayList<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder>();
            }
            return (ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder)this.getIndex(this.tradeReference, _index, () -> {
                ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder newTradeReference = ReferenceWithMetaTrade.builder();
                return newTradeReference;
            });
        }

        @Override
        @RosettaAttribute(value="eventReference")
        @RuneAttribute(value="eventReference")
        public List<? extends ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder> getEventReference() {
            return this.eventReference;
        }

        @Override
        public ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder getOrCreateEventReference(int _index) {
            if (this.eventReference == null) {
                this.eventReference = new ArrayList<ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder>();
            }
            return (ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder)this.getIndex(this.eventReference, _index, () -> {
                ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder newEventReference = ReferenceWithMetaWorkflowStep.builder();
                return newEventReference;
            });
        }

        @Override
        @RosettaAttribute(value="portfolioStateReference")
        @RuneAttribute(value="portfolioStateReference")
        public List<? extends ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder> getPortfolioStateReference() {
            return this.portfolioStateReference;
        }

        @Override
        public ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder getOrCreatePortfolioStateReference(int _index) {
            if (this.portfolioStateReference == null) {
                this.portfolioStateReference = new ArrayList<ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder>();
            }
            return (ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder)this.getIndex(this.portfolioStateReference, _index, () -> {
                ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder newPortfolioStateReference = ReferenceWithMetaPortfolioState.builder();
                return newPortfolioStateReference;
            });
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public LineageBuilder addTradeReference(ReferenceWithMetaTrade _tradeReference) {
            if (_tradeReference != null) {
                this.tradeReference.add(_tradeReference.toBuilder());
            }
            return this;
        }

        @Override
        public LineageBuilder addTradeReference(ReferenceWithMetaTrade _tradeReference, int _idx) {
            this.getIndex(this.tradeReference, _idx, () -> _tradeReference.toBuilder());
            return this;
        }

        @Override
        public LineageBuilder addTradeReferenceValue(Trade _tradeReference) {
            this.getOrCreateTradeReference(-1).setValue(_tradeReference.toBuilder());
            return this;
        }

        @Override
        public LineageBuilder addTradeReferenceValue(Trade _tradeReference, int _idx) {
            this.getOrCreateTradeReference(_idx).setValue(_tradeReference.toBuilder());
            return this;
        }

        @Override
        public LineageBuilder addTradeReference(List<? extends ReferenceWithMetaTrade> tradeReferences) {
            if (tradeReferences != null) {
                for (ReferenceWithMetaTrade referenceWithMetaTrade : tradeReferences) {
                    this.tradeReference.add(referenceWithMetaTrade.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradeReference")
        public LineageBuilder setTradeReference(List<? extends ReferenceWithMetaTrade> tradeReferences) {
            this.tradeReference = tradeReferences == null ? new ArrayList<ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder>() : (List)tradeReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LineageBuilder addTradeReferenceValue(List<? extends Trade> tradeReferences) {
            if (tradeReferences != null) {
                for (Trade trade : tradeReferences) {
                    this.addTradeReferenceValue(trade);
                }
            }
            return this;
        }

        @Override
        public LineageBuilder setTradeReferenceValue(List<? extends Trade> tradeReferences) {
            this.tradeReference.clear();
            if (tradeReferences != null) {
                tradeReferences.forEach(this::addTradeReferenceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="eventReference")
        @RuneAttribute(value="eventReference")
        public LineageBuilder addEventReference(ReferenceWithMetaWorkflowStep _eventReference) {
            if (_eventReference != null) {
                this.eventReference.add(_eventReference.toBuilder());
            }
            return this;
        }

        @Override
        public LineageBuilder addEventReference(ReferenceWithMetaWorkflowStep _eventReference, int _idx) {
            this.getIndex(this.eventReference, _idx, () -> _eventReference.toBuilder());
            return this;
        }

        @Override
        public LineageBuilder addEventReferenceValue(WorkflowStep _eventReference) {
            this.getOrCreateEventReference(-1).setValue(_eventReference.toBuilder());
            return this;
        }

        @Override
        public LineageBuilder addEventReferenceValue(WorkflowStep _eventReference, int _idx) {
            this.getOrCreateEventReference(_idx).setValue(_eventReference.toBuilder());
            return this;
        }

        @Override
        public LineageBuilder addEventReference(List<? extends ReferenceWithMetaWorkflowStep> eventReferences) {
            if (eventReferences != null) {
                for (ReferenceWithMetaWorkflowStep referenceWithMetaWorkflowStep : eventReferences) {
                    this.eventReference.add(referenceWithMetaWorkflowStep.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventReference")
        public LineageBuilder setEventReference(List<? extends ReferenceWithMetaWorkflowStep> eventReferences) {
            this.eventReference = eventReferences == null ? new ArrayList<ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder>() : (List)eventReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LineageBuilder addEventReferenceValue(List<? extends WorkflowStep> eventReferences) {
            if (eventReferences != null) {
                for (WorkflowStep workflowStep : eventReferences) {
                    this.addEventReferenceValue(workflowStep);
                }
            }
            return this;
        }

        @Override
        public LineageBuilder setEventReferenceValue(List<? extends WorkflowStep> eventReferences) {
            this.eventReference.clear();
            if (eventReferences != null) {
                eventReferences.forEach(this::addEventReferenceValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioStateReference")
        @RuneAttribute(value="portfolioStateReference")
        public LineageBuilder addPortfolioStateReference(ReferenceWithMetaPortfolioState _portfolioStateReference) {
            if (_portfolioStateReference != null) {
                this.portfolioStateReference.add(_portfolioStateReference.toBuilder());
            }
            return this;
        }

        @Override
        public LineageBuilder addPortfolioStateReference(ReferenceWithMetaPortfolioState _portfolioStateReference, int _idx) {
            this.getIndex(this.portfolioStateReference, _idx, () -> _portfolioStateReference.toBuilder());
            return this;
        }

        @Override
        public LineageBuilder addPortfolioStateReferenceValue(PortfolioState _portfolioStateReference) {
            this.getOrCreatePortfolioStateReference(-1).setValue(_portfolioStateReference.toBuilder());
            return this;
        }

        @Override
        public LineageBuilder addPortfolioStateReferenceValue(PortfolioState _portfolioStateReference, int _idx) {
            this.getOrCreatePortfolioStateReference(_idx).setValue(_portfolioStateReference.toBuilder());
            return this;
        }

        @Override
        public LineageBuilder addPortfolioStateReference(List<? extends ReferenceWithMetaPortfolioState> portfolioStateReferences) {
            if (portfolioStateReferences != null) {
                for (ReferenceWithMetaPortfolioState referenceWithMetaPortfolioState : portfolioStateReferences) {
                    this.portfolioStateReference.add(referenceWithMetaPortfolioState.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="portfolioStateReference")
        public LineageBuilder setPortfolioStateReference(List<? extends ReferenceWithMetaPortfolioState> portfolioStateReferences) {
            this.portfolioStateReference = portfolioStateReferences == null ? new ArrayList<ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder>() : (List)portfolioStateReferences.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LineageBuilder addPortfolioStateReferenceValue(List<? extends PortfolioState> portfolioStateReferences) {
            if (portfolioStateReferences != null) {
                for (PortfolioState portfolioState : portfolioStateReferences) {
                    this.addPortfolioStateReferenceValue(portfolioState);
                }
            }
            return this;
        }

        @Override
        public LineageBuilder setPortfolioStateReferenceValue(List<? extends PortfolioState> portfolioStateReferences) {
            this.portfolioStateReference.clear();
            if (portfolioStateReferences != null) {
                portfolioStateReferences.forEach(this::addPortfolioStateReferenceValue);
            }
            return this;
        }

        @Override
        public Lineage build() {
            return new LineageImpl(this);
        }

        @Override
        public LineageBuilder toBuilder() {
            return this;
        }

        @Override
        public LineageBuilder prune() {
            this.tradeReference = this.tradeReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.eventReference = this.eventReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.portfolioStateReference = this.portfolioStateReference.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getTradeReference() != null && this.getTradeReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getEventReference() != null && this.getEventReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPortfolioStateReference() != null && this.getPortfolioStateReference().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public LineageBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LineageBuilder o = (LineageBuilder)other;
            merger.mergeRosetta(this.getTradeReference(), o.getTradeReference(), this::getOrCreateTradeReference);
            merger.mergeRosetta(this.getEventReference(), o.getEventReference(), this::getOrCreateEventReference);
            merger.mergeRosetta(this.getPortfolioStateReference(), o.getPortfolioStateReference(), this::getOrCreatePortfolioStateReference);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Lineage _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeReference, _that.getTradeReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eventReference, _that.getEventReference())) {
                return false;
            }
            return ListEquals.listEquals(this.portfolioStateReference, _that.getPortfolioStateReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            _result = 31 * _result + (this.eventReference != null ? this.eventReference.hashCode() : 0);
            _result = 31 * _result + (this.portfolioStateReference != null ? this.portfolioStateReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LineageBuilder {tradeReference=" + this.tradeReference + ", eventReference=" + this.eventReference + ", portfolioStateReference=" + this.portfolioStateReference + '}';
        }
    }

    public static class LineageImpl
    implements Lineage {
        private final List<? extends ReferenceWithMetaTrade> tradeReference;
        private final List<? extends ReferenceWithMetaWorkflowStep> eventReference;
        private final List<? extends ReferenceWithMetaPortfolioState> portfolioStateReference;

        protected LineageImpl(LineageBuilder builder) {
            this.tradeReference = Optional.ofNullable(builder.getTradeReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.eventReference = Optional.ofNullable(builder.getEventReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.portfolioStateReference = Optional.ofNullable(builder.getPortfolioStateReference()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeReference")
        @RuneAttribute(value="tradeReference")
        public List<? extends ReferenceWithMetaTrade> getTradeReference() {
            return this.tradeReference;
        }

        @Override
        @RosettaAttribute(value="eventReference")
        @RuneAttribute(value="eventReference")
        public List<? extends ReferenceWithMetaWorkflowStep> getEventReference() {
            return this.eventReference;
        }

        @Override
        @RosettaAttribute(value="portfolioStateReference")
        @RuneAttribute(value="portfolioStateReference")
        public List<? extends ReferenceWithMetaPortfolioState> getPortfolioStateReference() {
            return this.portfolioStateReference;
        }

        @Override
        public Lineage build() {
            return this;
        }

        @Override
        public LineageBuilder toBuilder() {
            LineageBuilder builder = Lineage.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LineageBuilder builder) {
            Optional.ofNullable(this.getTradeReference()).ifPresent(builder::setTradeReference);
            Optional.ofNullable(this.getEventReference()).ifPresent(builder::setEventReference);
            Optional.ofNullable(this.getPortfolioStateReference()).ifPresent(builder::setPortfolioStateReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Lineage _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.tradeReference, _that.getTradeReference())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eventReference, _that.getEventReference())) {
                return false;
            }
            return ListEquals.listEquals(this.portfolioStateReference, _that.getPortfolioStateReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeReference != null ? this.tradeReference.hashCode() : 0);
            _result = 31 * _result + (this.eventReference != null ? this.eventReference.hashCode() : 0);
            _result = 31 * _result + (this.portfolioStateReference != null ? this.portfolioStateReference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Lineage {tradeReference=" + this.tradeReference + ", eventReference=" + this.eventReference + ", portfolioStateReference=" + this.portfolioStateReference + '}';
        }
    }

    public static interface LineageBuilder
    extends Lineage,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder getOrCreateTradeReference(int var1);

        public List<? extends ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder> getTradeReference();

        public ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder getOrCreateEventReference(int var1);

        public List<? extends ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder> getEventReference();

        public ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder getOrCreatePortfolioStateReference(int var1);

        public List<? extends ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder> getPortfolioStateReference();

        public LineageBuilder addTradeReference(ReferenceWithMetaTrade var1);

        public LineageBuilder addTradeReference(ReferenceWithMetaTrade var1, int var2);

        public LineageBuilder addTradeReferenceValue(Trade var1);

        public LineageBuilder addTradeReferenceValue(Trade var1, int var2);

        public LineageBuilder addTradeReference(List<? extends ReferenceWithMetaTrade> var1);

        public LineageBuilder setTradeReference(List<? extends ReferenceWithMetaTrade> var1);

        public LineageBuilder addTradeReferenceValue(List<? extends Trade> var1);

        public LineageBuilder setTradeReferenceValue(List<? extends Trade> var1);

        public LineageBuilder addEventReference(ReferenceWithMetaWorkflowStep var1);

        public LineageBuilder addEventReference(ReferenceWithMetaWorkflowStep var1, int var2);

        public LineageBuilder addEventReferenceValue(WorkflowStep var1);

        public LineageBuilder addEventReferenceValue(WorkflowStep var1, int var2);

        public LineageBuilder addEventReference(List<? extends ReferenceWithMetaWorkflowStep> var1);

        public LineageBuilder setEventReference(List<? extends ReferenceWithMetaWorkflowStep> var1);

        public LineageBuilder addEventReferenceValue(List<? extends WorkflowStep> var1);

        public LineageBuilder setEventReferenceValue(List<? extends WorkflowStep> var1);

        public LineageBuilder addPortfolioStateReference(ReferenceWithMetaPortfolioState var1);

        public LineageBuilder addPortfolioStateReference(ReferenceWithMetaPortfolioState var1, int var2);

        public LineageBuilder addPortfolioStateReferenceValue(PortfolioState var1);

        public LineageBuilder addPortfolioStateReferenceValue(PortfolioState var1, int var2);

        public LineageBuilder addPortfolioStateReference(List<? extends ReferenceWithMetaPortfolioState> var1);

        public LineageBuilder setPortfolioStateReference(List<? extends ReferenceWithMetaPortfolioState> var1);

        public LineageBuilder addPortfolioStateReferenceValue(List<? extends PortfolioState> var1);

        public LineageBuilder setPortfolioStateReferenceValue(List<? extends PortfolioState> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeReference"), processor, ReferenceWithMetaTrade.ReferenceWithMetaTradeBuilder.class, this.getTradeReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventReference"), processor, ReferenceWithMetaWorkflowStep.ReferenceWithMetaWorkflowStepBuilder.class, this.getEventReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioStateReference"), processor, ReferenceWithMetaPortfolioState.ReferenceWithMetaPortfolioStateBuilder.class, this.getPortfolioStateReference(), new AttributeMeta[0]);
        }

        public LineageBuilder prune();
    }
}

