/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.math.Quantity;
import cdm.event.common.meta.ReturnInstructionMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ReturnInstruction", builder=ReturnInstructionBuilderImpl.class, version="5.24.0")
@RuneDataType(value="ReturnInstruction", model="cdm", builder=ReturnInstructionBuilderImpl.class, version="5.24.0")
public interface ReturnInstruction
extends RosettaModelObject {
    public static final ReturnInstructionMeta metaData = new ReturnInstructionMeta();

    public List<? extends Quantity> getQuantity();

    public ReturnInstruction build();

    public ReturnInstructionBuilder toBuilder();

    public static ReturnInstructionBuilder builder() {
        return new ReturnInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends ReturnInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReturnInstruction> getType() {
        return ReturnInstruction.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("quantity"), processor, Quantity.class, this.getQuantity(), new AttributeMeta[0]);
    }

    public static class ReturnInstructionBuilderImpl
    implements ReturnInstructionBuilder {
        protected List<Quantity.QuantityBuilder> quantity = new ArrayList<Quantity.QuantityBuilder>();

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public List<? extends Quantity.QuantityBuilder> getQuantity() {
            return this.quantity;
        }

        @Override
        public Quantity.QuantityBuilder getOrCreateQuantity(int _index) {
            if (this.quantity == null) {
                this.quantity = new ArrayList<Quantity.QuantityBuilder>();
            }
            return (Quantity.QuantityBuilder)this.getIndex(this.quantity, _index, () -> {
                Quantity.QuantityBuilder newQuantity = Quantity.builder();
                return newQuantity;
            });
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public ReturnInstructionBuilder addQuantity(Quantity _quantity) {
            if (_quantity != null) {
                this.quantity.add(_quantity.toBuilder());
            }
            return this;
        }

        @Override
        public ReturnInstructionBuilder addQuantity(Quantity _quantity, int _idx) {
            this.getIndex(this.quantity, _idx, () -> _quantity.toBuilder());
            return this;
        }

        @Override
        public ReturnInstructionBuilder addQuantity(List<? extends Quantity> quantitys) {
            if (quantitys != null) {
                for (Quantity quantity : quantitys) {
                    this.quantity.add(quantity.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="quantity")
        public ReturnInstructionBuilder setQuantity(List<? extends Quantity> quantitys) {
            this.quantity = quantitys == null ? new ArrayList<Quantity.QuantityBuilder>() : (List)quantitys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ReturnInstruction build() {
            return new ReturnInstructionImpl(this);
        }

        @Override
        public ReturnInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public ReturnInstructionBuilder prune() {
            this.quantity = this.quantity.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            return this.getQuantity() != null && this.getQuantity().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ReturnInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReturnInstructionBuilder o = (ReturnInstructionBuilder)other;
            merger.mergeRosetta(this.getQuantity(), o.getQuantity(), this::getOrCreateQuantity);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReturnInstruction _that = this.getType().cast(o);
            return ListEquals.listEquals(this.quantity, _that.getQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReturnInstructionBuilder {quantity=" + this.quantity + '}';
        }
    }

    public static class ReturnInstructionImpl
    implements ReturnInstruction {
        private final List<? extends Quantity> quantity;

        protected ReturnInstructionImpl(ReturnInstructionBuilder builder) {
            this.quantity = Optional.ofNullable(builder.getQuantity()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="quantity")
        @RuneAttribute(value="quantity")
        public List<? extends Quantity> getQuantity() {
            return this.quantity;
        }

        @Override
        public ReturnInstruction build() {
            return this;
        }

        @Override
        public ReturnInstructionBuilder toBuilder() {
            ReturnInstructionBuilder builder = ReturnInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReturnInstructionBuilder builder) {
            Optional.ofNullable(this.getQuantity()).ifPresent(builder::setQuantity);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReturnInstruction _that = this.getType().cast(o);
            return ListEquals.listEquals(this.quantity, _that.getQuantity());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.quantity != null ? this.quantity.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReturnInstruction {quantity=" + this.quantity + '}';
        }
    }

    public static interface ReturnInstructionBuilder
    extends ReturnInstruction,
    RosettaModelObjectBuilder {
        public Quantity.QuantityBuilder getOrCreateQuantity(int var1);

        public List<? extends Quantity.QuantityBuilder> getQuantity();

        public ReturnInstructionBuilder addQuantity(Quantity var1);

        public ReturnInstructionBuilder addQuantity(Quantity var1, int var2);

        public ReturnInstructionBuilder addQuantity(List<? extends Quantity> var1);

        public ReturnInstructionBuilder setQuantity(List<? extends Quantity> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("quantity"), processor, Quantity.QuantityBuilder.class, this.getQuantity(), new AttributeMeta[0]);
        }

        public ReturnInstructionBuilder prune();
    }
}

