/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.functions.ExtractCounterpartyByRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Reset;
import cdm.event.common.Trade;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.event.common.functions.EquityPerformance;
import cdm.event.common.functions.ResolveCashSettlementDate;
import cdm.observable.asset.Price;
import cdm.product.asset.functions.ResolveEquityInitialPrice;
import cdm.product.template.PerformancePayout;
import cdm.product.template.TradeLot;
import cdm.product.template.metafields.ReferenceWithMetaPerformancePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=EquityCashSettlementAmountDefault.class)
public abstract class EquityCashSettlementAmount
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;
    @Inject
    protected EquityPerformance equityPerformance0;
    @Inject
    protected ExtractCounterpartyByRole extractCounterpartyByRole;
    @Inject
    protected ResolveCashSettlementDate resolveCashSettlementDate;
    @Inject
    protected ResolveEquityInitialPrice resolveEquityInitialPrice;

    public Transfer evaluate(TradeState tradeState, Date date) {
        Transfer equityCashSettlementAmount;
        Transfer.TransferBuilder equityCashSettlementAmountBuilder = this.doEvaluate(tradeState, date);
        if (equityCashSettlementAmountBuilder == null) {
            equityCashSettlementAmount = null;
        } else {
            equityCashSettlementAmount = equityCashSettlementAmountBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)equityCashSettlementAmount);
        }
        return equityCashSettlementAmount;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(TradeState var1, Date var2);

    protected abstract MapperS<? extends PerformancePayout> equityPerformancePayout(TradeState var1, Date var2);

    protected abstract MapperS<BigDecimal> equityPerformance1(TradeState var1, Date var2);

    protected abstract MapperS<? extends ReferenceWithMetaParty> payer(TradeState var1, Date var2);

    protected abstract MapperS<? extends ReferenceWithMetaParty> receiver(TradeState var1, Date var2);

    public static class EquityCashSettlementAmountDefault
    extends EquityCashSettlementAmount {
        @Override
        protected Transfer.TransferBuilder doEvaluate(TradeState tradeState, Date date) {
            Transfer.TransferBuilder equityCashSettlementAmount = Transfer.builder();
            return this.assignOutput(equityCashSettlementAmount, tradeState, date);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder equityCashSettlementAmount, TradeState tradeState, Date date0) {
            equityCashSettlementAmount.getOrCreateQuantity().setValue(this.abs.evaluate((BigDecimal)this.equityPerformance1(tradeState, date0).get()));
            equityCashSettlementAmount.getOrCreateQuantity().getOrCreateUnit().setCurrency((FieldWithMetaString)MapperS.of((Object)this.resolveEquityInitialPrice.evaluate(MapperS.of((Object)((TradeLot)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti())).map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency()).get());
            ReferenceWithMetaParty ifThenElseResult0 = ExpressionOperators.greaterThanEquals(this.equityPerformance1(tradeState, date0), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)this.payer(tradeState, date0).get() : (ReferenceWithMetaParty)this.receiver(tradeState, date0).get();
            equityCashSettlementAmount.getOrCreatePayerReceiver().setPayerPartyReference(ifThenElseResult0);
            ReferenceWithMetaParty ifThenElseResult1 = ExpressionOperators.greaterThanEquals(this.equityPerformance1(tradeState, date0), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (ReferenceWithMetaParty)this.receiver(tradeState, date0).get() : (ReferenceWithMetaParty)this.payer(tradeState, date0).get();
            equityCashSettlementAmount.getOrCreatePayerReceiver().setReceiverPartyReference(ifThenElseResult1);
            Date date1 = this.resolveCashSettlementDate.evaluate(tradeState);
            equityCashSettlementAmount.getOrCreateSettlementDate().setAdjustedDate(date1 == null ? FieldWithMetaDate.builder().build() : FieldWithMetaDate.builder().setValue(date1).build());
            PerformancePayout equityCashSettlementAmountSettlementOriginPerformancePayout = (PerformancePayout)this.equityPerformancePayout(tradeState, date0).get();
            equityCashSettlementAmount.getOrCreateSettlementOrigin().setPerformancePayout(ReferenceWithMetaPerformancePayout.builder().setGlobalReference(Optional.ofNullable(equityCashSettlementAmountSettlementOriginPerformancePayout).map(r -> r.getMeta()).map(m -> m.getGlobalKey()).orElse(null)).setExternalReference(Optional.ofNullable(equityCashSettlementAmountSettlementOriginPerformancePayout).map(r -> r.getMeta()).map(m -> m.getExternalKey()).orElse(null)).build());
            return Optional.ofNullable(equityCashSettlementAmount).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends PerformancePayout> equityPerformancePayout(TradeState tradeState, Date date) {
            return MapperS.of((Object)((PerformancePayout)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).map("getProduct", tradableProduct -> tradableProduct.getProduct()).map("getContractualProduct", product -> product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()));
        }

        @Override
        protected MapperS<BigDecimal> equityPerformance1(TradeState tradeState, Date date) {
            return MapperS.of((Object)this.equityPerformance0.evaluate((Trade)MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).get(), (Price)MapperS.of((Object)((Reset)MapperS.of((Object)tradeState).mapC("getResetHistory", _tradeState -> _tradeState.getResetHistory()).get())).map("getResetValue", reset -> reset.getResetValue()).get(), date));
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaParty> payer(TradeState tradeState, Date date) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.equityPerformancePayout(tradeState, date).map("getPayerReceiver", performancePayout -> performancePayout.getPayerReceiver()).map("getPayer", payerReceiver -> payerReceiver.getPayer()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference());
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaParty> receiver(TradeState tradeState, Date date) {
            return MapperS.of((Object)this.extractCounterpartyByRole.evaluate(MapperS.of((Object)tradeState).map("getTrade", _tradeState -> _tradeState.getTrade()).map("getTradableProduct", trade -> trade.getTradableProduct()).mapC("getCounterparty", tradableProduct -> tradableProduct.getCounterparty()).getMulti(), (CounterpartyRoleEnum)((Object)this.equityPerformancePayout(tradeState, date).map("getPayerReceiver", performancePayout -> performancePayout.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()).get()))).map("getPartyReference", counterparty -> counterparty.getPartyReference());
        }
    }
}

