/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.Reset;
import cdm.observable.asset.Price;
import cdm.observable.event.Observation;
import cdm.observable.event.metafields.ReferenceWithMetaObservation;
import cdm.product.asset.InterestRatePayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveInterestRateResetDefault.class)
public abstract class ResolveInterestRateReset
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Reset evaluate(List<? extends InterestRatePayout> payouts, Observation observation, Date resetDate, Date rateRecordDate) {
        Reset reset;
        Reset.ResetBuilder resetBuilder = this.doEvaluate(payouts, observation, resetDate, rateRecordDate);
        if (resetBuilder == null) {
            reset = null;
        } else {
            reset = resetBuilder.build();
            this.objectValidator.validate(Reset.class, (RosettaModelObject)reset);
        }
        return reset;
    }

    protected abstract Reset.ResetBuilder doEvaluate(List<? extends InterestRatePayout> var1, Observation var2, Date var3, Date var4);

    public static class ResolveInterestRateResetDefault
    extends ResolveInterestRateReset {
        @Override
        protected Reset.ResetBuilder doEvaluate(List<? extends InterestRatePayout> payouts, Observation observation, Date resetDate, Date rateRecordDate) {
            if (payouts == null) {
                payouts = Collections.emptyList();
            }
            Reset.ResetBuilder reset = Reset.builder();
            return this.assignOutput(reset, payouts, observation, resetDate, rateRecordDate);
        }

        protected Reset.ResetBuilder assignOutput(Reset.ResetBuilder reset, List<? extends InterestRatePayout> payouts, Observation observation, Date resetDate, Date rateRecordDate) {
            reset.setResetValue((Price)MapperS.of((Object)observation).map("getObservedValue", _observation -> _observation.getObservedValue()).get());
            reset.setResetDate(resetDate);
            reset.setRateRecordDate(rateRecordDate);
            reset.addObservations(observation == null ? Collections.emptyList() : Collections.singletonList(ReferenceWithMetaObservation.builder().setValue(observation).build()));
            return Optional.ofNullable(reset).map(o -> o.prune()).orElse(null);
        }
    }
}

