/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.base.math.Quantity;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.event.common.CalculateTransferInstruction;
import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.event.common.functions.EquityCashSettlementAmount;
import cdm.event.common.functions.InterestCashSettlementAmount;
import cdm.event.common.functions.SecurityFinanceCashSettlementAmount;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.metafields.ReferenceWithMetaPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.FieldWithMetaDate;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ResolveTransferDefault.class)
public abstract class ResolveTransfer
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EquityCashSettlementAmount equityCashSettlementAmount;
    @Inject
    protected InterestCashSettlementAmount interestCashSettlementAmount;
    @Inject
    protected SecurityFinanceCashSettlementAmount securityFinanceCashSettlementAmount;

    public Transfer evaluate(CalculateTransferInstruction instruction) {
        Transfer transfer;
        Transfer.TransferBuilder transferBuilder = this.doEvaluate(instruction);
        if (transferBuilder == null) {
            transfer = null;
        } else {
            transfer = transferBuilder.build();
            this.objectValidator.validate(Transfer.class, (RosettaModelObject)transfer);
        }
        return transfer;
    }

    protected abstract Transfer.TransferBuilder doEvaluate(CalculateTransferInstruction var1);

    protected abstract MapperS<? extends ReferenceWithMetaPayout> payout(CalculateTransferInstruction var1);

    public static class ResolveTransferDefault
    extends ResolveTransfer {
        @Override
        protected Transfer.TransferBuilder doEvaluate(CalculateTransferInstruction instruction) {
            Transfer.TransferBuilder transfer = Transfer.builder();
            return this.assignOutput(transfer, instruction);
        }

        protected Transfer.TransferBuilder assignOutput(Transfer.TransferBuilder transfer, CalculateTransferInstruction instruction) {
            transfer = ExpressionOperators.exists((Mapper)this.payout(instruction).map("Type coercion", referenceWithMetaPayout0 -> referenceWithMetaPayout0 == null ? null : referenceWithMetaPayout0.getValue()).mapC("getAssetPayout", _payout -> _payout.getAssetPayout())).getOrDefault(Boolean.valueOf(false)) != false ? (Transfer.TransferBuilder)this.toBuilder(this.securityFinanceCashSettlementAmount.evaluate((TradeState)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).get(), (Date)MapperS.of((Object)instruction).map("getDate", calculateTransferInstruction -> calculateTransferInstruction.getDate()).get(), (Quantity)MapperS.of((Object)instruction).map("getQuantity", calculateTransferInstruction -> calculateTransferInstruction.getQuantity()).get(), (PayerReceiver)MapperS.of((Object)instruction).map("getPayerReceiver", calculateTransferInstruction -> calculateTransferInstruction.getPayerReceiver()).get())) : (ExpressionOperators.exists((Mapper)this.payout(instruction).map("Type coercion", referenceWithMetaPayout1 -> referenceWithMetaPayout1 == null ? null : referenceWithMetaPayout1.getValue()).mapC("getPerformancePayout", _payout -> _payout.getPerformancePayout())).getOrDefault(Boolean.valueOf(false)) != false ? (Transfer.TransferBuilder)this.toBuilder(this.equityCashSettlementAmount.evaluate((TradeState)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).get(), (Date)MapperS.of((Object)instruction).map("getDate", calculateTransferInstruction -> calculateTransferInstruction.getDate()).get())) : (ExpressionOperators.exists((Mapper)this.payout(instruction).map("Type coercion", referenceWithMetaPayout2 -> referenceWithMetaPayout2 == null ? null : referenceWithMetaPayout2.getValue()).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).or(ExpressionOperators.exists((Mapper)this.payout(instruction).map("Type coercion", referenceWithMetaPayout3 -> referenceWithMetaPayout3 == null ? null : referenceWithMetaPayout3.getValue()).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFixedRate", rateSpecification -> rateSpecification.getFixedRate()))).getOrDefault(Boolean.valueOf(false)) != false ? (Transfer.TransferBuilder)this.toBuilder(this.interestCashSettlementAmount.evaluate((TradeState)MapperS.of((Object)instruction).map("getTradeState", calculateTransferInstruction -> calculateTransferInstruction.getTradeState()).get(), (InterestRatePayout)this.payout(instruction).map("Type coercion", referenceWithMetaPayout4 -> referenceWithMetaPayout4 == null ? null : referenceWithMetaPayout4.getValue()).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()).get(), MapperS.of((Object)instruction).mapC("getResets", calculateTransferInstruction -> calculateTransferInstruction.getResets()).getMulti(), (Date)MapperS.of((Object)instruction).map("getDate", calculateTransferInstruction -> calculateTransferInstruction.getDate()).get())) : null));
            Date date = (Date)MapperS.of((Object)instruction).map("getDate", calculateTransferInstruction -> calculateTransferInstruction.getDate()).get();
            transfer.getOrCreateSettlementDate().setAdjustedDate(date == null ? FieldWithMetaDate.builder().build() : FieldWithMetaDate.builder().setValue(date).build());
            return Optional.ofNullable(transfer).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaPayout> payout(CalculateTransferInstruction instruction) {
            return MapperS.of((Object)instruction).map("getPayout", calculateTransferInstruction -> calculateTransferInstruction.getPayout());
        }
    }
}

