/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.legaldocumentation.common.AgreementTerms;
import cdm.legaldocumentation.common.LegalAgreementBase;
import cdm.legaldocumentation.common.LegalAgreementIdentification;
import cdm.legaldocumentation.common.Resource;
import cdm.legaldocumentation.common.UmbrellaAgreement;
import cdm.legaldocumentation.common.meta.LegalAgreementMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LegalAgreement", builder=LegalAgreementBuilderImpl.class, version="5.24.0")
@RuneDataType(value="LegalAgreement", model="cdm", builder=LegalAgreementBuilderImpl.class, version="5.24.0")
public interface LegalAgreement
extends LegalAgreementBase,
GlobalKey {
    public static final LegalAgreementMeta metaData = new LegalAgreementMeta();

    public AgreementTerms getAgreementTerms();

    public List<? extends LegalAgreement> getRelatedAgreements();

    public UmbrellaAgreement getUmbrellaAgreement();

    public MetaFields getMeta();

    @Override
    public LegalAgreement build();

    @Override
    public LegalAgreementBuilder toBuilder();

    public static LegalAgreementBuilder builder() {
        return new LegalAgreementBuilderImpl();
    }

    default public RosettaMetaData<? extends LegalAgreement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegalAgreement> getType() {
        return LegalAgreement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("agreementDate"), Date.class, (Object)this.getAgreementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("identifier"), processor, Identifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalAgreementIdentification"), processor, LegalAgreementIdentification.class, this.getLegalAgreementIdentification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractualParty"), processor, ReferenceWithMetaParty.class, this.getContractualParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherParty"), processor, PartyRole.class, this.getOtherParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("attachment"), processor, Resource.class, this.getAttachment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementTerms"), processor, AgreementTerms.class, this.getAgreementTerms(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("relatedAgreements"), processor, LegalAgreement.class, this.getRelatedAgreements(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("umbrellaAgreement"), processor, UmbrellaAgreement.class, this.getUmbrellaAgreement(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class LegalAgreementBuilderImpl
    extends LegalAgreementBase.LegalAgreementBaseBuilderImpl
    implements LegalAgreementBuilder {
        protected AgreementTerms.AgreementTermsBuilder agreementTerms;
        protected List<LegalAgreementBuilder> relatedAgreements = new ArrayList<LegalAgreementBuilder>();
        protected UmbrellaAgreement.UmbrellaAgreementBuilder umbrellaAgreement;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="agreementTerms")
        @RuneAttribute(value="agreementTerms")
        public AgreementTerms.AgreementTermsBuilder getAgreementTerms() {
            return this.agreementTerms;
        }

        @Override
        public AgreementTerms.AgreementTermsBuilder getOrCreateAgreementTerms() {
            AgreementTerms.AgreementTermsBuilder result = this.agreementTerms != null ? this.agreementTerms : (this.agreementTerms = AgreementTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="relatedAgreements")
        @RuneAttribute(value="relatedAgreements")
        public List<? extends LegalAgreementBuilder> getRelatedAgreements() {
            return this.relatedAgreements;
        }

        @Override
        public LegalAgreementBuilder getOrCreateRelatedAgreements(int _index) {
            if (this.relatedAgreements == null) {
                this.relatedAgreements = new ArrayList<LegalAgreementBuilder>();
            }
            return (LegalAgreementBuilder)this.getIndex(this.relatedAgreements, _index, () -> {
                LegalAgreementBuilder newRelatedAgreements = LegalAgreement.builder();
                return newRelatedAgreements;
            });
        }

        @Override
        @RosettaAttribute(value="umbrellaAgreement")
        @RuneAttribute(value="umbrellaAgreement")
        public UmbrellaAgreement.UmbrellaAgreementBuilder getUmbrellaAgreement() {
            return this.umbrellaAgreement;
        }

        @Override
        public UmbrellaAgreement.UmbrellaAgreementBuilder getOrCreateUmbrellaAgreement() {
            UmbrellaAgreement.UmbrellaAgreementBuilder result = this.umbrellaAgreement != null ? this.umbrellaAgreement : (this.umbrellaAgreement = UmbrellaAgreement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="agreementDate")
        @RuneAttribute(value="agreementDate")
        public LegalAgreementBuilder setAgreementDate(Date _agreementDate) {
            this.agreementDate = _agreementDate == null ? null : _agreementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public LegalAgreementBuilder setEffectiveDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="identifier")
        @RuneAttribute(value="identifier")
        public LegalAgreementBuilder addIdentifier(Identifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder addIdentifier(Identifier _identifier, int _idx) {
            this.getIndex(this.identifier, _idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addIdentifier(List<? extends Identifier> identifiers) {
            if (identifiers != null) {
                for (Identifier identifier : identifiers) {
                    this.identifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public LegalAgreementBuilder setIdentifier(List<? extends Identifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="legalAgreementIdentification")
        @RuneAttribute(value="legalAgreementIdentification")
        public LegalAgreementBuilder setLegalAgreementIdentification(LegalAgreementIdentification _legalAgreementIdentification) {
            this.legalAgreementIdentification = _legalAgreementIdentification == null ? null : _legalAgreementIdentification.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contractualParty")
        @RuneAttribute(value="contractualParty")
        public LegalAgreementBuilder addContractualParty(ReferenceWithMetaParty _contractualParty) {
            if (_contractualParty != null) {
                this.contractualParty.add(_contractualParty.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualParty(ReferenceWithMetaParty _contractualParty, int _idx) {
            this.getIndex(this.contractualParty, _idx, () -> _contractualParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualPartyValue(Party _contractualParty) {
            this.getOrCreateContractualParty(-1).setValue(_contractualParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualPartyValue(Party _contractualParty, int _idx) {
            this.getOrCreateContractualParty(_idx).setValue(_contractualParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualParty(List<? extends ReferenceWithMetaParty> contractualPartys) {
            if (contractualPartys != null) {
                for (ReferenceWithMetaParty referenceWithMetaParty : contractualPartys) {
                    this.contractualParty.add(referenceWithMetaParty.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractualParty")
        public LegalAgreementBuilder setContractualParty(List<? extends ReferenceWithMetaParty> contractualPartys) {
            this.contractualParty = contractualPartys == null ? new ArrayList() : (List)contractualPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LegalAgreementBuilder addContractualPartyValue(List<? extends Party> contractualPartys) {
            if (contractualPartys != null) {
                for (Party party : contractualPartys) {
                    this.addContractualPartyValue(party);
                }
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder setContractualPartyValue(List<? extends Party> contractualPartys) {
            this.contractualParty.clear();
            if (contractualPartys != null) {
                contractualPartys.forEach(this::addContractualPartyValue);
            }
            return this;
        }

        @Override
        @RosettaAttribute(value="otherParty")
        @RuneAttribute(value="otherParty")
        public LegalAgreementBuilder addOtherParty(PartyRole _otherParty) {
            if (_otherParty != null) {
                this.otherParty.add(_otherParty.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder addOtherParty(PartyRole _otherParty, int _idx) {
            this.getIndex(this.otherParty, _idx, () -> _otherParty.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addOtherParty(List<? extends PartyRole> otherPartys) {
            if (otherPartys != null) {
                for (PartyRole partyRole : otherPartys) {
                    this.otherParty.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherParty")
        public LegalAgreementBuilder setOtherParty(List<? extends PartyRole> otherPartys) {
            this.otherParty = otherPartys == null ? new ArrayList() : (List)otherPartys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="attachment")
        @RuneAttribute(value="attachment")
        public LegalAgreementBuilder addAttachment(Resource _attachment) {
            if (_attachment != null) {
                this.attachment.add(_attachment.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder addAttachment(Resource _attachment, int _idx) {
            this.getIndex(this.attachment, _idx, () -> _attachment.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addAttachment(List<? extends Resource> attachments) {
            if (attachments != null) {
                for (Resource resource : attachments) {
                    this.attachment.add(resource.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="attachment")
        public LegalAgreementBuilder setAttachment(List<? extends Resource> attachments) {
            this.attachment = attachments == null ? new ArrayList() : (List)attachments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementTerms")
        @RuneAttribute(value="agreementTerms")
        public LegalAgreementBuilder setAgreementTerms(AgreementTerms _agreementTerms) {
            this.agreementTerms = _agreementTerms == null ? null : _agreementTerms.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="relatedAgreements")
        @RuneAttribute(value="relatedAgreements")
        public LegalAgreementBuilder addRelatedAgreements(LegalAgreement _relatedAgreements) {
            if (_relatedAgreements != null) {
                this.relatedAgreements.add(_relatedAgreements.toBuilder());
            }
            return this;
        }

        @Override
        public LegalAgreementBuilder addRelatedAgreements(LegalAgreement _relatedAgreements, int _idx) {
            this.getIndex(this.relatedAgreements, _idx, () -> _relatedAgreements.toBuilder());
            return this;
        }

        @Override
        public LegalAgreementBuilder addRelatedAgreements(List<? extends LegalAgreement> relatedAgreementss) {
            if (relatedAgreementss != null) {
                for (LegalAgreement legalAgreement : relatedAgreementss) {
                    this.relatedAgreements.add(legalAgreement.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="relatedAgreements")
        public LegalAgreementBuilder setRelatedAgreements(List<? extends LegalAgreement> relatedAgreementss) {
            this.relatedAgreements = relatedAgreementss == null ? new ArrayList<LegalAgreementBuilder>() : (List)relatedAgreementss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="umbrellaAgreement")
        @RuneAttribute(value="umbrellaAgreement")
        public LegalAgreementBuilder setUmbrellaAgreement(UmbrellaAgreement _umbrellaAgreement) {
            this.umbrellaAgreement = _umbrellaAgreement == null ? null : _umbrellaAgreement.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public LegalAgreementBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public LegalAgreement build() {
            return new LegalAgreementImpl(this);
        }

        @Override
        public LegalAgreementBuilder toBuilder() {
            return this;
        }

        @Override
        public LegalAgreementBuilder prune() {
            super.prune();
            if (this.agreementTerms != null && !this.agreementTerms.prune().hasData()) {
                this.agreementTerms = null;
            }
            this.relatedAgreements = this.relatedAgreements.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.umbrellaAgreement != null && !this.umbrellaAgreement.prune().hasData()) {
                this.umbrellaAgreement = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getAgreementTerms() != null && this.getAgreementTerms().hasData()) {
                return true;
            }
            if (this.getRelatedAgreements() != null && this.getRelatedAgreements().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getUmbrellaAgreement() != null && this.getUmbrellaAgreement().hasData();
        }

        @Override
        public LegalAgreementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LegalAgreementBuilder o = (LegalAgreementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementTerms(), (RosettaModelObjectBuilder)o.getAgreementTerms(), this::setAgreementTerms);
            merger.mergeRosetta(this.getRelatedAgreements(), o.getRelatedAgreements(), this::getOrCreateRelatedAgreements);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUmbrellaAgreement(), (RosettaModelObjectBuilder)o.getUmbrellaAgreement(), this::setUmbrellaAgreement);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LegalAgreement _that = (LegalAgreement)this.getType().cast(o);
            if (!Objects.equals(this.agreementTerms, _that.getAgreementTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedAgreements, _that.getRelatedAgreements())) {
                return false;
            }
            if (!Objects.equals(this.umbrellaAgreement, _that.getUmbrellaAgreement())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.agreementTerms != null ? this.agreementTerms.hashCode() : 0);
            _result = 31 * _result + (this.relatedAgreements != null ? this.relatedAgreements.hashCode() : 0);
            _result = 31 * _result + (this.umbrellaAgreement != null ? this.umbrellaAgreement.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LegalAgreementBuilder {agreementTerms=" + this.agreementTerms + ", relatedAgreements=" + this.relatedAgreements + ", umbrellaAgreement=" + this.umbrellaAgreement + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static class LegalAgreementImpl
    extends LegalAgreementBase.LegalAgreementBaseImpl
    implements LegalAgreement {
        private final AgreementTerms agreementTerms;
        private final List<? extends LegalAgreement> relatedAgreements;
        private final UmbrellaAgreement umbrellaAgreement;
        private final MetaFields meta;

        protected LegalAgreementImpl(LegalAgreementBuilder builder) {
            super(builder);
            this.agreementTerms = Optional.ofNullable(builder.getAgreementTerms()).map(f -> f.build()).orElse(null);
            this.relatedAgreements = Optional.ofNullable(builder.getRelatedAgreements()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.umbrellaAgreement = Optional.ofNullable(builder.getUmbrellaAgreement()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="agreementTerms")
        @RuneAttribute(value="agreementTerms")
        public AgreementTerms getAgreementTerms() {
            return this.agreementTerms;
        }

        @Override
        @RosettaAttribute(value="relatedAgreements")
        @RuneAttribute(value="relatedAgreements")
        public List<? extends LegalAgreement> getRelatedAgreements() {
            return this.relatedAgreements;
        }

        @Override
        @RosettaAttribute(value="umbrellaAgreement")
        @RuneAttribute(value="umbrellaAgreement")
        public UmbrellaAgreement getUmbrellaAgreement() {
            return this.umbrellaAgreement;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public LegalAgreement build() {
            return this;
        }

        @Override
        public LegalAgreementBuilder toBuilder() {
            LegalAgreementBuilder builder = LegalAgreement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegalAgreementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAgreementTerms()).ifPresent(builder::setAgreementTerms);
            Optional.ofNullable(this.getRelatedAgreements()).ifPresent(builder::setRelatedAgreements);
            Optional.ofNullable(this.getUmbrellaAgreement()).ifPresent(builder::setUmbrellaAgreement);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LegalAgreement _that = (LegalAgreement)this.getType().cast(o);
            if (!Objects.equals(this.agreementTerms, _that.getAgreementTerms())) {
                return false;
            }
            if (!ListEquals.listEquals(this.relatedAgreements, _that.getRelatedAgreements())) {
                return false;
            }
            if (!Objects.equals(this.umbrellaAgreement, _that.getUmbrellaAgreement())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.agreementTerms != null ? this.agreementTerms.hashCode() : 0);
            _result = 31 * _result + (this.relatedAgreements != null ? this.relatedAgreements.hashCode() : 0);
            _result = 31 * _result + (this.umbrellaAgreement != null ? this.umbrellaAgreement.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LegalAgreement {agreementTerms=" + this.agreementTerms + ", relatedAgreements=" + this.relatedAgreements + ", umbrellaAgreement=" + this.umbrellaAgreement + ", meta=" + this.meta + '}' + " " + super.toString();
        }
    }

    public static interface LegalAgreementBuilder
    extends LegalAgreement,
    LegalAgreementBase.LegalAgreementBaseBuilder,
    GlobalKey.GlobalKeyBuilder {
        public AgreementTerms.AgreementTermsBuilder getOrCreateAgreementTerms();

        @Override
        public AgreementTerms.AgreementTermsBuilder getAgreementTerms();

        public LegalAgreementBuilder getOrCreateRelatedAgreements(int var1);

        public List<? extends LegalAgreementBuilder> getRelatedAgreements();

        public UmbrellaAgreement.UmbrellaAgreementBuilder getOrCreateUmbrellaAgreement();

        @Override
        public UmbrellaAgreement.UmbrellaAgreementBuilder getUmbrellaAgreement();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        @Override
        public LegalAgreementBuilder setAgreementDate(Date var1);

        @Override
        public LegalAgreementBuilder setEffectiveDate(Date var1);

        @Override
        public LegalAgreementBuilder addIdentifier(Identifier var1);

        @Override
        public LegalAgreementBuilder addIdentifier(Identifier var1, int var2);

        @Override
        public LegalAgreementBuilder addIdentifier(List<? extends Identifier> var1);

        @Override
        public LegalAgreementBuilder setIdentifier(List<? extends Identifier> var1);

        @Override
        public LegalAgreementBuilder setLegalAgreementIdentification(LegalAgreementIdentification var1);

        @Override
        public LegalAgreementBuilder addContractualParty(ReferenceWithMetaParty var1);

        @Override
        public LegalAgreementBuilder addContractualParty(ReferenceWithMetaParty var1, int var2);

        @Override
        public LegalAgreementBuilder addContractualPartyValue(Party var1);

        @Override
        public LegalAgreementBuilder addContractualPartyValue(Party var1, int var2);

        @Override
        public LegalAgreementBuilder addContractualParty(List<? extends ReferenceWithMetaParty> var1);

        @Override
        public LegalAgreementBuilder setContractualParty(List<? extends ReferenceWithMetaParty> var1);

        @Override
        public LegalAgreementBuilder addContractualPartyValue(List<? extends Party> var1);

        @Override
        public LegalAgreementBuilder setContractualPartyValue(List<? extends Party> var1);

        @Override
        public LegalAgreementBuilder addOtherParty(PartyRole var1);

        @Override
        public LegalAgreementBuilder addOtherParty(PartyRole var1, int var2);

        @Override
        public LegalAgreementBuilder addOtherParty(List<? extends PartyRole> var1);

        @Override
        public LegalAgreementBuilder setOtherParty(List<? extends PartyRole> var1);

        @Override
        public LegalAgreementBuilder addAttachment(Resource var1);

        @Override
        public LegalAgreementBuilder addAttachment(Resource var1, int var2);

        @Override
        public LegalAgreementBuilder addAttachment(List<? extends Resource> var1);

        @Override
        public LegalAgreementBuilder setAttachment(List<? extends Resource> var1);

        public LegalAgreementBuilder setAgreementTerms(AgreementTerms var1);

        public LegalAgreementBuilder addRelatedAgreements(LegalAgreement var1);

        public LegalAgreementBuilder addRelatedAgreements(LegalAgreement var1, int var2);

        public LegalAgreementBuilder addRelatedAgreements(List<? extends LegalAgreement> var1);

        public LegalAgreementBuilder setRelatedAgreements(List<? extends LegalAgreement> var1);

        public LegalAgreementBuilder setUmbrellaAgreement(UmbrellaAgreement var1);

        public LegalAgreementBuilder setMeta(MetaFields var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("agreementDate"), Date.class, (Object)this.getAgreementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("identifier"), processor, Identifier.IdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalAgreementIdentification"), processor, LegalAgreementIdentification.LegalAgreementIdentificationBuilder.class, (RosettaModelObjectBuilder)this.getLegalAgreementIdentification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractualParty"), processor, ReferenceWithMetaParty.ReferenceWithMetaPartyBuilder.class, this.getContractualParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherParty"), processor, PartyRole.PartyRoleBuilder.class, this.getOtherParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("attachment"), processor, Resource.ResourceBuilder.class, this.getAttachment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementTerms"), processor, AgreementTerms.AgreementTermsBuilder.class, this.getAgreementTerms(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("relatedAgreements"), processor, LegalAgreementBuilder.class, this.getRelatedAgreements(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("umbrellaAgreement"), processor, UmbrellaAgreement.UmbrellaAgreementBuilder.class, this.getUmbrellaAgreement(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        @Override
        public LegalAgreementBuilder prune();
    }
}

