/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate;

import cdm.observable.asset.calculatedrate.CalculatedRateObservations;
import cdm.observable.asset.calculatedrate.meta.CalculatedRateDetailsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CalculatedRateDetails", builder=CalculatedRateDetailsBuilderImpl.class, version="5.24.0")
@RuneDataType(value="CalculatedRateDetails", model="cdm", builder=CalculatedRateDetailsBuilderImpl.class, version="5.24.0")
public interface CalculatedRateDetails
extends RosettaModelObject {
    public static final CalculatedRateDetailsMeta metaData = new CalculatedRateDetailsMeta();

    public CalculatedRateObservations getObservations();

    public List<BigDecimal> getWeightedRates();

    public List<BigDecimal> getGrowthFactor();

    public List<BigDecimal> getCompoundedGrowth();

    public BigDecimal getAggregateValue();

    public BigDecimal getAggregateWeight();

    public BigDecimal getCalculatedRate();

    public CalculatedRateDetails build();

    public CalculatedRateDetailsBuilder toBuilder();

    public static CalculatedRateDetailsBuilder builder() {
        return new CalculatedRateDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends CalculatedRateDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CalculatedRateDetails> getType() {
        return CalculatedRateDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("observations"), processor, CalculatedRateObservations.class, this.getObservations(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("weightedRates"), BigDecimal.class, this.getWeightedRates(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("growthFactor"), BigDecimal.class, this.getGrowthFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("compoundedGrowth"), BigDecimal.class, this.getCompoundedGrowth(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("aggregateValue"), BigDecimal.class, (Object)this.getAggregateValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("aggregateWeight"), BigDecimal.class, (Object)this.getAggregateWeight(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculatedRate"), BigDecimal.class, (Object)this.getCalculatedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CalculatedRateDetailsBuilderImpl
    implements CalculatedRateDetailsBuilder {
        protected CalculatedRateObservations.CalculatedRateObservationsBuilder observations;
        protected List<BigDecimal> weightedRates = new ArrayList<BigDecimal>();
        protected List<BigDecimal> growthFactor = new ArrayList<BigDecimal>();
        protected List<BigDecimal> compoundedGrowth = new ArrayList<BigDecimal>();
        protected BigDecimal aggregateValue;
        protected BigDecimal aggregateWeight;
        protected BigDecimal calculatedRate;

        @Override
        @RosettaAttribute(value="observations")
        @RuneAttribute(value="observations")
        public CalculatedRateObservations.CalculatedRateObservationsBuilder getObservations() {
            return this.observations;
        }

        @Override
        public CalculatedRateObservations.CalculatedRateObservationsBuilder getOrCreateObservations() {
            CalculatedRateObservations.CalculatedRateObservationsBuilder result = this.observations != null ? this.observations : (this.observations = CalculatedRateObservations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="weightedRates")
        @RuneAttribute(value="weightedRates")
        public List<BigDecimal> getWeightedRates() {
            return this.weightedRates;
        }

        @Override
        @RosettaAttribute(value="growthFactor")
        @RuneAttribute(value="growthFactor")
        public List<BigDecimal> getGrowthFactor() {
            return this.growthFactor;
        }

        @Override
        @RosettaAttribute(value="compoundedGrowth")
        @RuneAttribute(value="compoundedGrowth")
        public List<BigDecimal> getCompoundedGrowth() {
            return this.compoundedGrowth;
        }

        @Override
        @RosettaAttribute(value="aggregateValue")
        @RuneAttribute(value="aggregateValue")
        public BigDecimal getAggregateValue() {
            return this.aggregateValue;
        }

        @Override
        @RosettaAttribute(value="aggregateWeight")
        @RuneAttribute(value="aggregateWeight")
        public BigDecimal getAggregateWeight() {
            return this.aggregateWeight;
        }

        @Override
        @RosettaAttribute(value="calculatedRate")
        @RuneAttribute(value="calculatedRate")
        public BigDecimal getCalculatedRate() {
            return this.calculatedRate;
        }

        @Override
        @RosettaAttribute(value="observations")
        @RuneAttribute(value="observations")
        public CalculatedRateDetailsBuilder setObservations(CalculatedRateObservations _observations) {
            this.observations = _observations == null ? null : _observations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="weightedRates")
        @RuneAttribute(value="weightedRates")
        public CalculatedRateDetailsBuilder addWeightedRates(BigDecimal _weightedRates) {
            if (_weightedRates != null) {
                this.weightedRates.add(_weightedRates);
            }
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addWeightedRates(BigDecimal _weightedRates, int _idx) {
            this.getIndex(this.weightedRates, _idx, () -> _weightedRates);
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addWeightedRates(List<BigDecimal> weightedRatess) {
            if (weightedRatess != null) {
                for (BigDecimal toAdd : weightedRatess) {
                    this.weightedRates.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="weightedRates")
        public CalculatedRateDetailsBuilder setWeightedRates(List<BigDecimal> weightedRatess) {
            this.weightedRates = weightedRatess == null ? new ArrayList<BigDecimal>() : (List)weightedRatess.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="growthFactor")
        @RuneAttribute(value="growthFactor")
        public CalculatedRateDetailsBuilder addGrowthFactor(BigDecimal _growthFactor) {
            if (_growthFactor != null) {
                this.growthFactor.add(_growthFactor);
            }
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addGrowthFactor(BigDecimal _growthFactor, int _idx) {
            this.getIndex(this.growthFactor, _idx, () -> _growthFactor);
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addGrowthFactor(List<BigDecimal> growthFactors) {
            if (growthFactors != null) {
                for (BigDecimal toAdd : growthFactors) {
                    this.growthFactor.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="growthFactor")
        public CalculatedRateDetailsBuilder setGrowthFactor(List<BigDecimal> growthFactors) {
            this.growthFactor = growthFactors == null ? new ArrayList<BigDecimal>() : (List)growthFactors.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="compoundedGrowth")
        @RuneAttribute(value="compoundedGrowth")
        public CalculatedRateDetailsBuilder addCompoundedGrowth(BigDecimal _compoundedGrowth) {
            if (_compoundedGrowth != null) {
                this.compoundedGrowth.add(_compoundedGrowth);
            }
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addCompoundedGrowth(BigDecimal _compoundedGrowth, int _idx) {
            this.getIndex(this.compoundedGrowth, _idx, () -> _compoundedGrowth);
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder addCompoundedGrowth(List<BigDecimal> compoundedGrowths) {
            if (compoundedGrowths != null) {
                for (BigDecimal toAdd : compoundedGrowths) {
                    this.compoundedGrowth.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="compoundedGrowth")
        public CalculatedRateDetailsBuilder setCompoundedGrowth(List<BigDecimal> compoundedGrowths) {
            this.compoundedGrowth = compoundedGrowths == null ? new ArrayList<BigDecimal>() : (List)compoundedGrowths.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="aggregateValue")
        @RuneAttribute(value="aggregateValue")
        public CalculatedRateDetailsBuilder setAggregateValue(BigDecimal _aggregateValue) {
            this.aggregateValue = _aggregateValue == null ? null : _aggregateValue;
            return this;
        }

        @Override
        @RosettaAttribute(value="aggregateWeight")
        @RuneAttribute(value="aggregateWeight")
        public CalculatedRateDetailsBuilder setAggregateWeight(BigDecimal _aggregateWeight) {
            this.aggregateWeight = _aggregateWeight == null ? null : _aggregateWeight;
            return this;
        }

        @Override
        @RosettaAttribute(value="calculatedRate")
        @RuneAttribute(value="calculatedRate")
        public CalculatedRateDetailsBuilder setCalculatedRate(BigDecimal _calculatedRate) {
            this.calculatedRate = _calculatedRate == null ? null : _calculatedRate;
            return this;
        }

        @Override
        public CalculatedRateDetails build() {
            return new CalculatedRateDetailsImpl(this);
        }

        @Override
        public CalculatedRateDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder prune() {
            if (this.observations != null && !this.observations.prune().hasData()) {
                this.observations = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getObservations() != null && this.getObservations().hasData()) {
                return true;
            }
            if (this.getWeightedRates() != null && !this.getWeightedRates().isEmpty()) {
                return true;
            }
            if (this.getGrowthFactor() != null && !this.getGrowthFactor().isEmpty()) {
                return true;
            }
            if (this.getCompoundedGrowth() != null && !this.getCompoundedGrowth().isEmpty()) {
                return true;
            }
            if (this.getAggregateValue() != null) {
                return true;
            }
            if (this.getAggregateWeight() != null) {
                return true;
            }
            return this.getCalculatedRate() != null;
        }

        public CalculatedRateDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculatedRateDetailsBuilder o = (CalculatedRateDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getObservations(), (RosettaModelObjectBuilder)o.getObservations(), this::setObservations);
            merger.mergeBasic(this.getWeightedRates(), o.getWeightedRates(), this::addWeightedRates);
            merger.mergeBasic(this.getGrowthFactor(), o.getGrowthFactor(), this::addGrowthFactor);
            merger.mergeBasic(this.getCompoundedGrowth(), o.getCompoundedGrowth(), this::addCompoundedGrowth);
            merger.mergeBasic((Object)this.getAggregateValue(), (Object)o.getAggregateValue(), this::setAggregateValue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAggregateWeight(), (Object)o.getAggregateWeight(), this::setAggregateWeight, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCalculatedRate(), (Object)o.getCalculatedRate(), this::setCalculatedRate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculatedRateDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.observations, _that.getObservations())) {
                return false;
            }
            if (!ListEquals.listEquals(this.weightedRates, _that.getWeightedRates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.growthFactor, _that.getGrowthFactor())) {
                return false;
            }
            if (!ListEquals.listEquals(this.compoundedGrowth, _that.getCompoundedGrowth())) {
                return false;
            }
            if (!Objects.equals(this.aggregateValue, _that.getAggregateValue())) {
                return false;
            }
            if (!Objects.equals(this.aggregateWeight, _that.getAggregateWeight())) {
                return false;
            }
            return Objects.equals(this.calculatedRate, _that.getCalculatedRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observations != null ? this.observations.hashCode() : 0);
            _result = 31 * _result + (this.weightedRates != null ? this.weightedRates.hashCode() : 0);
            _result = 31 * _result + (this.growthFactor != null ? this.growthFactor.hashCode() : 0);
            _result = 31 * _result + (this.compoundedGrowth != null ? this.compoundedGrowth.hashCode() : 0);
            _result = 31 * _result + (this.aggregateValue != null ? this.aggregateValue.hashCode() : 0);
            _result = 31 * _result + (this.aggregateWeight != null ? this.aggregateWeight.hashCode() : 0);
            _result = 31 * _result + (this.calculatedRate != null ? this.calculatedRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculatedRateDetailsBuilder {observations=" + this.observations + ", weightedRates=" + this.weightedRates + ", growthFactor=" + this.growthFactor + ", compoundedGrowth=" + this.compoundedGrowth + ", aggregateValue=" + this.aggregateValue + ", aggregateWeight=" + this.aggregateWeight + ", calculatedRate=" + this.calculatedRate + '}';
        }
    }

    public static class CalculatedRateDetailsImpl
    implements CalculatedRateDetails {
        private final CalculatedRateObservations observations;
        private final List<BigDecimal> weightedRates;
        private final List<BigDecimal> growthFactor;
        private final List<BigDecimal> compoundedGrowth;
        private final BigDecimal aggregateValue;
        private final BigDecimal aggregateWeight;
        private final BigDecimal calculatedRate;

        protected CalculatedRateDetailsImpl(CalculatedRateDetailsBuilder builder) {
            this.observations = Optional.ofNullable(builder.getObservations()).map(f -> f.build()).orElse(null);
            this.weightedRates = Optional.ofNullable(builder.getWeightedRates()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.growthFactor = Optional.ofNullable(builder.getGrowthFactor()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.compoundedGrowth = Optional.ofNullable(builder.getCompoundedGrowth()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.aggregateValue = builder.getAggregateValue();
            this.aggregateWeight = builder.getAggregateWeight();
            this.calculatedRate = builder.getCalculatedRate();
        }

        @Override
        @RosettaAttribute(value="observations")
        @RuneAttribute(value="observations")
        public CalculatedRateObservations getObservations() {
            return this.observations;
        }

        @Override
        @RosettaAttribute(value="weightedRates")
        @RuneAttribute(value="weightedRates")
        public List<BigDecimal> getWeightedRates() {
            return this.weightedRates;
        }

        @Override
        @RosettaAttribute(value="growthFactor")
        @RuneAttribute(value="growthFactor")
        public List<BigDecimal> getGrowthFactor() {
            return this.growthFactor;
        }

        @Override
        @RosettaAttribute(value="compoundedGrowth")
        @RuneAttribute(value="compoundedGrowth")
        public List<BigDecimal> getCompoundedGrowth() {
            return this.compoundedGrowth;
        }

        @Override
        @RosettaAttribute(value="aggregateValue")
        @RuneAttribute(value="aggregateValue")
        public BigDecimal getAggregateValue() {
            return this.aggregateValue;
        }

        @Override
        @RosettaAttribute(value="aggregateWeight")
        @RuneAttribute(value="aggregateWeight")
        public BigDecimal getAggregateWeight() {
            return this.aggregateWeight;
        }

        @Override
        @RosettaAttribute(value="calculatedRate")
        @RuneAttribute(value="calculatedRate")
        public BigDecimal getCalculatedRate() {
            return this.calculatedRate;
        }

        @Override
        public CalculatedRateDetails build() {
            return this;
        }

        @Override
        public CalculatedRateDetailsBuilder toBuilder() {
            CalculatedRateDetailsBuilder builder = CalculatedRateDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculatedRateDetailsBuilder builder) {
            Optional.ofNullable(this.getObservations()).ifPresent(builder::setObservations);
            Optional.ofNullable(this.getWeightedRates()).ifPresent(builder::setWeightedRates);
            Optional.ofNullable(this.getGrowthFactor()).ifPresent(builder::setGrowthFactor);
            Optional.ofNullable(this.getCompoundedGrowth()).ifPresent(builder::setCompoundedGrowth);
            Optional.ofNullable(this.getAggregateValue()).ifPresent(builder::setAggregateValue);
            Optional.ofNullable(this.getAggregateWeight()).ifPresent(builder::setAggregateWeight);
            Optional.ofNullable(this.getCalculatedRate()).ifPresent(builder::setCalculatedRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculatedRateDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.observations, _that.getObservations())) {
                return false;
            }
            if (!ListEquals.listEquals(this.weightedRates, _that.getWeightedRates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.growthFactor, _that.getGrowthFactor())) {
                return false;
            }
            if (!ListEquals.listEquals(this.compoundedGrowth, _that.getCompoundedGrowth())) {
                return false;
            }
            if (!Objects.equals(this.aggregateValue, _that.getAggregateValue())) {
                return false;
            }
            if (!Objects.equals(this.aggregateWeight, _that.getAggregateWeight())) {
                return false;
            }
            return Objects.equals(this.calculatedRate, _that.getCalculatedRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observations != null ? this.observations.hashCode() : 0);
            _result = 31 * _result + (this.weightedRates != null ? this.weightedRates.hashCode() : 0);
            _result = 31 * _result + (this.growthFactor != null ? this.growthFactor.hashCode() : 0);
            _result = 31 * _result + (this.compoundedGrowth != null ? this.compoundedGrowth.hashCode() : 0);
            _result = 31 * _result + (this.aggregateValue != null ? this.aggregateValue.hashCode() : 0);
            _result = 31 * _result + (this.aggregateWeight != null ? this.aggregateWeight.hashCode() : 0);
            _result = 31 * _result + (this.calculatedRate != null ? this.calculatedRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculatedRateDetails {observations=" + this.observations + ", weightedRates=" + this.weightedRates + ", growthFactor=" + this.growthFactor + ", compoundedGrowth=" + this.compoundedGrowth + ", aggregateValue=" + this.aggregateValue + ", aggregateWeight=" + this.aggregateWeight + ", calculatedRate=" + this.calculatedRate + '}';
        }
    }

    public static interface CalculatedRateDetailsBuilder
    extends CalculatedRateDetails,
    RosettaModelObjectBuilder {
        public CalculatedRateObservations.CalculatedRateObservationsBuilder getOrCreateObservations();

        @Override
        public CalculatedRateObservations.CalculatedRateObservationsBuilder getObservations();

        public CalculatedRateDetailsBuilder setObservations(CalculatedRateObservations var1);

        public CalculatedRateDetailsBuilder addWeightedRates(BigDecimal var1);

        public CalculatedRateDetailsBuilder addWeightedRates(BigDecimal var1, int var2);

        public CalculatedRateDetailsBuilder addWeightedRates(List<BigDecimal> var1);

        public CalculatedRateDetailsBuilder setWeightedRates(List<BigDecimal> var1);

        public CalculatedRateDetailsBuilder addGrowthFactor(BigDecimal var1);

        public CalculatedRateDetailsBuilder addGrowthFactor(BigDecimal var1, int var2);

        public CalculatedRateDetailsBuilder addGrowthFactor(List<BigDecimal> var1);

        public CalculatedRateDetailsBuilder setGrowthFactor(List<BigDecimal> var1);

        public CalculatedRateDetailsBuilder addCompoundedGrowth(BigDecimal var1);

        public CalculatedRateDetailsBuilder addCompoundedGrowth(BigDecimal var1, int var2);

        public CalculatedRateDetailsBuilder addCompoundedGrowth(List<BigDecimal> var1);

        public CalculatedRateDetailsBuilder setCompoundedGrowth(List<BigDecimal> var1);

        public CalculatedRateDetailsBuilder setAggregateValue(BigDecimal var1);

        public CalculatedRateDetailsBuilder setAggregateWeight(BigDecimal var1);

        public CalculatedRateDetailsBuilder setCalculatedRate(BigDecimal var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("observations"), processor, CalculatedRateObservations.CalculatedRateObservationsBuilder.class, this.getObservations(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("weightedRates"), BigDecimal.class, this.getWeightedRates(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("growthFactor"), BigDecimal.class, this.getGrowthFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("compoundedGrowth"), BigDecimal.class, this.getCompoundedGrowth(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("aggregateValue"), BigDecimal.class, (Object)this.getAggregateValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("aggregateWeight"), BigDecimal.class, (Object)this.getAggregateWeight(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculatedRate"), BigDecimal.class, (Object)this.getCalculatedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CalculatedRateDetailsBuilder prune();
    }
}

