/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate;

import cdm.observable.asset.calculatedrate.meta.CalculatedRateObservationsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CalculatedRateObservations", builder=CalculatedRateObservationsBuilderImpl.class, version="5.24.0")
@RuneDataType(value="CalculatedRateObservations", model="cdm", builder=CalculatedRateObservationsBuilderImpl.class, version="5.24.0")
public interface CalculatedRateObservations
extends RosettaModelObject {
    public static final CalculatedRateObservationsMeta metaData = new CalculatedRateObservationsMeta();

    public List<Date> getObservationDates();

    public List<BigDecimal> getWeights();

    public List<BigDecimal> getObservedRates();

    public List<BigDecimal> getProcessedRates();

    public CalculatedRateObservations build();

    public CalculatedRateObservationsBuilder toBuilder();

    public static CalculatedRateObservationsBuilder builder() {
        return new CalculatedRateObservationsBuilderImpl();
    }

    default public RosettaMetaData<? extends CalculatedRateObservations> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CalculatedRateObservations> getType() {
        return CalculatedRateObservations.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("observationDates"), Date.class, this.getObservationDates(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("weights"), BigDecimal.class, this.getWeights(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("observedRates"), BigDecimal.class, this.getObservedRates(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("processedRates"), BigDecimal.class, this.getProcessedRates(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CalculatedRateObservationsBuilderImpl
    implements CalculatedRateObservationsBuilder {
        protected List<Date> observationDates = new ArrayList<Date>();
        protected List<BigDecimal> weights = new ArrayList<BigDecimal>();
        protected List<BigDecimal> observedRates = new ArrayList<BigDecimal>();
        protected List<BigDecimal> processedRates = new ArrayList<BigDecimal>();

        @Override
        @RosettaAttribute(value="observationDates")
        @RuneAttribute(value="observationDates")
        public List<Date> getObservationDates() {
            return this.observationDates;
        }

        @Override
        @RosettaAttribute(value="weights")
        @RuneAttribute(value="weights")
        public List<BigDecimal> getWeights() {
            return this.weights;
        }

        @Override
        @RosettaAttribute(value="observedRates")
        @RuneAttribute(value="observedRates")
        public List<BigDecimal> getObservedRates() {
            return this.observedRates;
        }

        @Override
        @RosettaAttribute(value="processedRates")
        @RuneAttribute(value="processedRates")
        public List<BigDecimal> getProcessedRates() {
            return this.processedRates;
        }

        @Override
        @RosettaAttribute(value="observationDates")
        @RuneAttribute(value="observationDates")
        public CalculatedRateObservationsBuilder addObservationDates(Date _observationDates) {
            if (_observationDates != null) {
                this.observationDates.add(_observationDates);
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addObservationDates(Date _observationDates, int _idx) {
            this.getIndex(this.observationDates, _idx, () -> _observationDates);
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addObservationDates(List<Date> observationDatess) {
            if (observationDatess != null) {
                for (Date toAdd : observationDatess) {
                    this.observationDates.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observationDates")
        public CalculatedRateObservationsBuilder setObservationDates(List<Date> observationDatess) {
            this.observationDates = observationDatess == null ? new ArrayList<Date>() : (List)observationDatess.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="weights")
        @RuneAttribute(value="weights")
        public CalculatedRateObservationsBuilder addWeights(BigDecimal _weights) {
            if (_weights != null) {
                this.weights.add(_weights);
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addWeights(BigDecimal _weights, int _idx) {
            this.getIndex(this.weights, _idx, () -> _weights);
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addWeights(List<BigDecimal> weightss) {
            if (weightss != null) {
                for (BigDecimal toAdd : weightss) {
                    this.weights.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="weights")
        public CalculatedRateObservationsBuilder setWeights(List<BigDecimal> weightss) {
            this.weights = weightss == null ? new ArrayList<BigDecimal>() : (List)weightss.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="observedRates")
        @RuneAttribute(value="observedRates")
        public CalculatedRateObservationsBuilder addObservedRates(BigDecimal _observedRates) {
            if (_observedRates != null) {
                this.observedRates.add(_observedRates);
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addObservedRates(BigDecimal _observedRates, int _idx) {
            this.getIndex(this.observedRates, _idx, () -> _observedRates);
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addObservedRates(List<BigDecimal> observedRatess) {
            if (observedRatess != null) {
                for (BigDecimal toAdd : observedRatess) {
                    this.observedRates.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observedRates")
        public CalculatedRateObservationsBuilder setObservedRates(List<BigDecimal> observedRatess) {
            this.observedRates = observedRatess == null ? new ArrayList<BigDecimal>() : (List)observedRatess.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="processedRates")
        @RuneAttribute(value="processedRates")
        public CalculatedRateObservationsBuilder addProcessedRates(BigDecimal _processedRates) {
            if (_processedRates != null) {
                this.processedRates.add(_processedRates);
            }
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addProcessedRates(BigDecimal _processedRates, int _idx) {
            this.getIndex(this.processedRates, _idx, () -> _processedRates);
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder addProcessedRates(List<BigDecimal> processedRatess) {
            if (processedRatess != null) {
                for (BigDecimal toAdd : processedRatess) {
                    this.processedRates.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="processedRates")
        public CalculatedRateObservationsBuilder setProcessedRates(List<BigDecimal> processedRatess) {
            this.processedRates = processedRatess == null ? new ArrayList<BigDecimal>() : (List)processedRatess.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CalculatedRateObservations build() {
            return new CalculatedRateObservationsImpl(this);
        }

        @Override
        public CalculatedRateObservationsBuilder toBuilder() {
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getObservationDates() != null && !this.getObservationDates().isEmpty()) {
                return true;
            }
            if (this.getWeights() != null && !this.getWeights().isEmpty()) {
                return true;
            }
            if (this.getObservedRates() != null && !this.getObservedRates().isEmpty()) {
                return true;
            }
            return this.getProcessedRates() != null && !this.getProcessedRates().isEmpty();
        }

        public CalculatedRateObservationsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CalculatedRateObservationsBuilder o = (CalculatedRateObservationsBuilder)other;
            merger.mergeBasic(this.getObservationDates(), o.getObservationDates(), this::addObservationDates);
            merger.mergeBasic(this.getWeights(), o.getWeights(), this::addWeights);
            merger.mergeBasic(this.getObservedRates(), o.getObservedRates(), this::addObservedRates);
            merger.mergeBasic(this.getProcessedRates(), o.getProcessedRates(), this::addProcessedRates);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculatedRateObservations _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observationDates, _that.getObservationDates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.weights, _that.getWeights())) {
                return false;
            }
            if (!ListEquals.listEquals(this.observedRates, _that.getObservedRates())) {
                return false;
            }
            return ListEquals.listEquals(this.processedRates, _that.getProcessedRates());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationDates != null ? this.observationDates.hashCode() : 0);
            _result = 31 * _result + (this.weights != null ? this.weights.hashCode() : 0);
            _result = 31 * _result + (this.observedRates != null ? this.observedRates.hashCode() : 0);
            _result = 31 * _result + (this.processedRates != null ? this.processedRates.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculatedRateObservationsBuilder {observationDates=" + this.observationDates + ", weights=" + this.weights + ", observedRates=" + this.observedRates + ", processedRates=" + this.processedRates + '}';
        }
    }

    public static class CalculatedRateObservationsImpl
    implements CalculatedRateObservations {
        private final List<Date> observationDates;
        private final List<BigDecimal> weights;
        private final List<BigDecimal> observedRates;
        private final List<BigDecimal> processedRates;

        protected CalculatedRateObservationsImpl(CalculatedRateObservationsBuilder builder) {
            this.observationDates = Optional.ofNullable(builder.getObservationDates()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.weights = Optional.ofNullable(builder.getWeights()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.observedRates = Optional.ofNullable(builder.getObservedRates()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.processedRates = Optional.ofNullable(builder.getProcessedRates()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="observationDates")
        @RuneAttribute(value="observationDates")
        public List<Date> getObservationDates() {
            return this.observationDates;
        }

        @Override
        @RosettaAttribute(value="weights")
        @RuneAttribute(value="weights")
        public List<BigDecimal> getWeights() {
            return this.weights;
        }

        @Override
        @RosettaAttribute(value="observedRates")
        @RuneAttribute(value="observedRates")
        public List<BigDecimal> getObservedRates() {
            return this.observedRates;
        }

        @Override
        @RosettaAttribute(value="processedRates")
        @RuneAttribute(value="processedRates")
        public List<BigDecimal> getProcessedRates() {
            return this.processedRates;
        }

        @Override
        public CalculatedRateObservations build() {
            return this;
        }

        @Override
        public CalculatedRateObservationsBuilder toBuilder() {
            CalculatedRateObservationsBuilder builder = CalculatedRateObservations.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CalculatedRateObservationsBuilder builder) {
            Optional.ofNullable(this.getObservationDates()).ifPresent(builder::setObservationDates);
            Optional.ofNullable(this.getWeights()).ifPresent(builder::setWeights);
            Optional.ofNullable(this.getObservedRates()).ifPresent(builder::setObservedRates);
            Optional.ofNullable(this.getProcessedRates()).ifPresent(builder::setProcessedRates);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CalculatedRateObservations _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.observationDates, _that.getObservationDates())) {
                return false;
            }
            if (!ListEquals.listEquals(this.weights, _that.getWeights())) {
                return false;
            }
            if (!ListEquals.listEquals(this.observedRates, _that.getObservedRates())) {
                return false;
            }
            return ListEquals.listEquals(this.processedRates, _that.getProcessedRates());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.observationDates != null ? this.observationDates.hashCode() : 0);
            _result = 31 * _result + (this.weights != null ? this.weights.hashCode() : 0);
            _result = 31 * _result + (this.observedRates != null ? this.observedRates.hashCode() : 0);
            _result = 31 * _result + (this.processedRates != null ? this.processedRates.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CalculatedRateObservations {observationDates=" + this.observationDates + ", weights=" + this.weights + ", observedRates=" + this.observedRates + ", processedRates=" + this.processedRates + '}';
        }
    }

    public static interface CalculatedRateObservationsBuilder
    extends CalculatedRateObservations,
    RosettaModelObjectBuilder {
        public CalculatedRateObservationsBuilder addObservationDates(Date var1);

        public CalculatedRateObservationsBuilder addObservationDates(Date var1, int var2);

        public CalculatedRateObservationsBuilder addObservationDates(List<Date> var1);

        public CalculatedRateObservationsBuilder setObservationDates(List<Date> var1);

        public CalculatedRateObservationsBuilder addWeights(BigDecimal var1);

        public CalculatedRateObservationsBuilder addWeights(BigDecimal var1, int var2);

        public CalculatedRateObservationsBuilder addWeights(List<BigDecimal> var1);

        public CalculatedRateObservationsBuilder setWeights(List<BigDecimal> var1);

        public CalculatedRateObservationsBuilder addObservedRates(BigDecimal var1);

        public CalculatedRateObservationsBuilder addObservedRates(BigDecimal var1, int var2);

        public CalculatedRateObservationsBuilder addObservedRates(List<BigDecimal> var1);

        public CalculatedRateObservationsBuilder setObservedRates(List<BigDecimal> var1);

        public CalculatedRateObservationsBuilder addProcessedRates(BigDecimal var1);

        public CalculatedRateObservationsBuilder addProcessedRates(BigDecimal var1, int var2);

        public CalculatedRateObservationsBuilder addProcessedRates(List<BigDecimal> var1);

        public CalculatedRateObservationsBuilder setProcessedRates(List<BigDecimal> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("observationDates"), Date.class, this.getObservationDates(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("weights"), BigDecimal.class, this.getWeights(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("observedRates"), BigDecimal.class, this.getObservedRates(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("processedRates"), BigDecimal.class, this.getProcessedRates(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CalculatedRateObservationsBuilder prune();
    }
}

