/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.event;

import cdm.base.datetime.AveragingSchedule;
import cdm.base.datetime.DateList;
import cdm.observable.event.FeaturePayment;
import cdm.observable.event.Trigger;
import cdm.observable.event.meta.TriggerEventMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TriggerEvent", builder=TriggerEventBuilderImpl.class, version="5.24.0")
@RuneDataType(value="TriggerEvent", model="cdm", builder=TriggerEventBuilderImpl.class, version="5.24.0")
public interface TriggerEvent
extends RosettaModelObject {
    public static final TriggerEventMeta metaData = new TriggerEventMeta();

    public List<? extends AveragingSchedule> getSchedule();

    public DateList getTriggerDates();

    public Trigger getTrigger();

    public FeaturePayment getFeaturePayment();

    public TriggerEvent build();

    public TriggerEventBuilder toBuilder();

    public static TriggerEventBuilder builder() {
        return new TriggerEventBuilderImpl();
    }

    default public RosettaMetaData<? extends TriggerEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TriggerEvent> getType() {
        return TriggerEvent.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("schedule"), processor, AveragingSchedule.class, this.getSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("triggerDates"), processor, DateList.class, this.getTriggerDates(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trigger"), processor, Trigger.class, this.getTrigger(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("featurePayment"), processor, FeaturePayment.class, this.getFeaturePayment(), new AttributeMeta[0]);
    }

    public static class TriggerEventBuilderImpl
    implements TriggerEventBuilder {
        protected List<AveragingSchedule.AveragingScheduleBuilder> schedule = new ArrayList<AveragingSchedule.AveragingScheduleBuilder>();
        protected DateList.DateListBuilder triggerDates;
        protected Trigger.TriggerBuilder trigger;
        protected FeaturePayment.FeaturePaymentBuilder featurePayment;

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public List<? extends AveragingSchedule.AveragingScheduleBuilder> getSchedule() {
            return this.schedule;
        }

        @Override
        public AveragingSchedule.AveragingScheduleBuilder getOrCreateSchedule(int _index) {
            if (this.schedule == null) {
                this.schedule = new ArrayList<AveragingSchedule.AveragingScheduleBuilder>();
            }
            return (AveragingSchedule.AveragingScheduleBuilder)this.getIndex(this.schedule, _index, () -> {
                AveragingSchedule.AveragingScheduleBuilder newSchedule = AveragingSchedule.builder();
                return newSchedule;
            });
        }

        @Override
        @RosettaAttribute(value="triggerDates")
        @RuneAttribute(value="triggerDates")
        public DateList.DateListBuilder getTriggerDates() {
            return this.triggerDates;
        }

        @Override
        public DateList.DateListBuilder getOrCreateTriggerDates() {
            DateList.DateListBuilder result = this.triggerDates != null ? this.triggerDates : (this.triggerDates = DateList.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trigger")
        @RuneAttribute(value="trigger")
        public Trigger.TriggerBuilder getTrigger() {
            return this.trigger;
        }

        @Override
        public Trigger.TriggerBuilder getOrCreateTrigger() {
            Trigger.TriggerBuilder result = this.trigger != null ? this.trigger : (this.trigger = Trigger.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="featurePayment")
        @RuneAttribute(value="featurePayment")
        public FeaturePayment.FeaturePaymentBuilder getFeaturePayment() {
            return this.featurePayment;
        }

        @Override
        public FeaturePayment.FeaturePaymentBuilder getOrCreateFeaturePayment() {
            FeaturePayment.FeaturePaymentBuilder result = this.featurePayment != null ? this.featurePayment : (this.featurePayment = FeaturePayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public TriggerEventBuilder addSchedule(AveragingSchedule _schedule) {
            if (_schedule != null) {
                this.schedule.add(_schedule.toBuilder());
            }
            return this;
        }

        @Override
        public TriggerEventBuilder addSchedule(AveragingSchedule _schedule, int _idx) {
            this.getIndex(this.schedule, _idx, () -> _schedule.toBuilder());
            return this;
        }

        @Override
        public TriggerEventBuilder addSchedule(List<? extends AveragingSchedule> schedules) {
            if (schedules != null) {
                for (AveragingSchedule averagingSchedule : schedules) {
                    this.schedule.add(averagingSchedule.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="schedule")
        public TriggerEventBuilder setSchedule(List<? extends AveragingSchedule> schedules) {
            this.schedule = schedules == null ? new ArrayList<AveragingSchedule.AveragingScheduleBuilder>() : (List)schedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerDates")
        @RuneAttribute(value="triggerDates")
        public TriggerEventBuilder setTriggerDates(DateList _triggerDates) {
            this.triggerDates = _triggerDates == null ? null : _triggerDates.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trigger")
        @RuneAttribute(value="trigger")
        public TriggerEventBuilder setTrigger(Trigger _trigger) {
            this.trigger = _trigger == null ? null : _trigger.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="featurePayment")
        @RuneAttribute(value="featurePayment")
        public TriggerEventBuilder setFeaturePayment(FeaturePayment _featurePayment) {
            this.featurePayment = _featurePayment == null ? null : _featurePayment.toBuilder();
            return this;
        }

        @Override
        public TriggerEvent build() {
            return new TriggerEventImpl(this);
        }

        @Override
        public TriggerEventBuilder toBuilder() {
            return this;
        }

        @Override
        public TriggerEventBuilder prune() {
            this.schedule = this.schedule.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.triggerDates != null && !this.triggerDates.prune().hasData()) {
                this.triggerDates = null;
            }
            if (this.trigger != null && !this.trigger.prune().hasData()) {
                this.trigger = null;
            }
            if (this.featurePayment != null && !this.featurePayment.prune().hasData()) {
                this.featurePayment = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSchedule() != null && this.getSchedule().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTriggerDates() != null && this.getTriggerDates().hasData()) {
                return true;
            }
            if (this.getTrigger() != null && this.getTrigger().hasData()) {
                return true;
            }
            return this.getFeaturePayment() != null && this.getFeaturePayment().hasData();
        }

        public TriggerEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TriggerEventBuilder o = (TriggerEventBuilder)other;
            merger.mergeRosetta(this.getSchedule(), o.getSchedule(), this::getOrCreateSchedule);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTriggerDates(), (RosettaModelObjectBuilder)o.getTriggerDates(), this::setTriggerDates);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrigger(), (RosettaModelObjectBuilder)o.getTrigger(), this::setTrigger);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFeaturePayment(), (RosettaModelObjectBuilder)o.getFeaturePayment(), this::setFeaturePayment);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TriggerEvent _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.schedule, _that.getSchedule())) {
                return false;
            }
            if (!Objects.equals(this.triggerDates, _that.getTriggerDates())) {
                return false;
            }
            if (!Objects.equals(this.trigger, _that.getTrigger())) {
                return false;
            }
            return Objects.equals(this.featurePayment, _that.getFeaturePayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.triggerDates != null ? this.triggerDates.hashCode() : 0);
            _result = 31 * _result + (this.trigger != null ? this.trigger.hashCode() : 0);
            _result = 31 * _result + (this.featurePayment != null ? this.featurePayment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TriggerEventBuilder {schedule=" + this.schedule + ", triggerDates=" + this.triggerDates + ", trigger=" + this.trigger + ", featurePayment=" + this.featurePayment + '}';
        }
    }

    public static class TriggerEventImpl
    implements TriggerEvent {
        private final List<? extends AveragingSchedule> schedule;
        private final DateList triggerDates;
        private final Trigger trigger;
        private final FeaturePayment featurePayment;

        protected TriggerEventImpl(TriggerEventBuilder builder) {
            this.schedule = Optional.ofNullable(builder.getSchedule()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.triggerDates = Optional.ofNullable(builder.getTriggerDates()).map(f -> f.build()).orElse(null);
            this.trigger = Optional.ofNullable(builder.getTrigger()).map(f -> f.build()).orElse(null);
            this.featurePayment = Optional.ofNullable(builder.getFeaturePayment()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="schedule")
        @RuneAttribute(value="schedule")
        public List<? extends AveragingSchedule> getSchedule() {
            return this.schedule;
        }

        @Override
        @RosettaAttribute(value="triggerDates")
        @RuneAttribute(value="triggerDates")
        public DateList getTriggerDates() {
            return this.triggerDates;
        }

        @Override
        @RosettaAttribute(value="trigger")
        @RuneAttribute(value="trigger")
        public Trigger getTrigger() {
            return this.trigger;
        }

        @Override
        @RosettaAttribute(value="featurePayment")
        @RuneAttribute(value="featurePayment")
        public FeaturePayment getFeaturePayment() {
            return this.featurePayment;
        }

        @Override
        public TriggerEvent build() {
            return this;
        }

        @Override
        public TriggerEventBuilder toBuilder() {
            TriggerEventBuilder builder = TriggerEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TriggerEventBuilder builder) {
            Optional.ofNullable(this.getSchedule()).ifPresent(builder::setSchedule);
            Optional.ofNullable(this.getTriggerDates()).ifPresent(builder::setTriggerDates);
            Optional.ofNullable(this.getTrigger()).ifPresent(builder::setTrigger);
            Optional.ofNullable(this.getFeaturePayment()).ifPresent(builder::setFeaturePayment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TriggerEvent _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.schedule, _that.getSchedule())) {
                return false;
            }
            if (!Objects.equals(this.triggerDates, _that.getTriggerDates())) {
                return false;
            }
            if (!Objects.equals(this.trigger, _that.getTrigger())) {
                return false;
            }
            return Objects.equals(this.featurePayment, _that.getFeaturePayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.schedule != null ? this.schedule.hashCode() : 0);
            _result = 31 * _result + (this.triggerDates != null ? this.triggerDates.hashCode() : 0);
            _result = 31 * _result + (this.trigger != null ? this.trigger.hashCode() : 0);
            _result = 31 * _result + (this.featurePayment != null ? this.featurePayment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TriggerEvent {schedule=" + this.schedule + ", triggerDates=" + this.triggerDates + ", trigger=" + this.trigger + ", featurePayment=" + this.featurePayment + '}';
        }
    }

    public static interface TriggerEventBuilder
    extends TriggerEvent,
    RosettaModelObjectBuilder {
        public AveragingSchedule.AveragingScheduleBuilder getOrCreateSchedule(int var1);

        public List<? extends AveragingSchedule.AveragingScheduleBuilder> getSchedule();

        public DateList.DateListBuilder getOrCreateTriggerDates();

        @Override
        public DateList.DateListBuilder getTriggerDates();

        public Trigger.TriggerBuilder getOrCreateTrigger();

        @Override
        public Trigger.TriggerBuilder getTrigger();

        public FeaturePayment.FeaturePaymentBuilder getOrCreateFeaturePayment();

        @Override
        public FeaturePayment.FeaturePaymentBuilder getFeaturePayment();

        public TriggerEventBuilder addSchedule(AveragingSchedule var1);

        public TriggerEventBuilder addSchedule(AveragingSchedule var1, int var2);

        public TriggerEventBuilder addSchedule(List<? extends AveragingSchedule> var1);

        public TriggerEventBuilder setSchedule(List<? extends AveragingSchedule> var1);

        public TriggerEventBuilder setTriggerDates(DateList var1);

        public TriggerEventBuilder setTrigger(Trigger var1);

        public TriggerEventBuilder setFeaturePayment(FeaturePayment var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("schedule"), processor, AveragingSchedule.AveragingScheduleBuilder.class, this.getSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("triggerDates"), processor, DateList.DateListBuilder.class, this.getTriggerDates(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trigger"), processor, Trigger.TriggerBuilder.class, this.getTrigger(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("featurePayment"), processor, FeaturePayment.FeaturePaymentBuilder.class, this.getFeaturePayment(), new AttributeMeta[0]);
        }

        public TriggerEventBuilder prune();
    }
}

