/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.product.asset.FixedRateSpecification;
import cdm.product.asset.meta.BondReferenceMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BondReference", builder=BondReferenceBuilderImpl.class, version="5.24.0")
@RuneDataType(value="BondReference", model="cdm", builder=BondReferenceBuilderImpl.class, version="5.24.0")
public interface BondReference
extends RosettaModelObject {
    public static final BondReferenceMeta metaData = new BondReferenceMeta();

    public ProductIdentifier getBond();

    public Boolean getConditionPrecedentBond();

    public Boolean getDiscrepancyClause();

    public FixedRateSpecification getCouponRate();

    public BondReference build();

    public BondReferenceBuilder toBuilder();

    public static BondReferenceBuilder builder() {
        return new BondReferenceBuilderImpl();
    }

    default public RosettaMetaData<? extends BondReference> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BondReference> getType() {
        return BondReference.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("bond"), processor, ProductIdentifier.class, this.getBond(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("conditionPrecedentBond"), Boolean.class, (Object)this.getConditionPrecedentBond(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("discrepancyClause"), Boolean.class, (Object)this.getDiscrepancyClause(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("couponRate"), processor, FixedRateSpecification.class, this.getCouponRate(), new AttributeMeta[0]);
    }

    public static class BondReferenceBuilderImpl
    implements BondReferenceBuilder {
        protected ProductIdentifier.ProductIdentifierBuilder bond;
        protected Boolean conditionPrecedentBond;
        protected Boolean discrepancyClause;
        protected FixedRateSpecification.FixedRateSpecificationBuilder couponRate;

        @Override
        @RosettaAttribute(value="bond")
        @RuneAttribute(value="bond")
        public ProductIdentifier.ProductIdentifierBuilder getBond() {
            return this.bond;
        }

        @Override
        public ProductIdentifier.ProductIdentifierBuilder getOrCreateBond() {
            ProductIdentifier.ProductIdentifierBuilder result = this.bond != null ? this.bond : (this.bond = ProductIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="conditionPrecedentBond")
        @RuneAttribute(value="conditionPrecedentBond")
        public Boolean getConditionPrecedentBond() {
            return this.conditionPrecedentBond;
        }

        @Override
        @RosettaAttribute(value="discrepancyClause")
        @RuneAttribute(value="discrepancyClause")
        public Boolean getDiscrepancyClause() {
            return this.discrepancyClause;
        }

        @Override
        @RosettaAttribute(value="couponRate")
        @RuneAttribute(value="couponRate")
        public FixedRateSpecification.FixedRateSpecificationBuilder getCouponRate() {
            return this.couponRate;
        }

        @Override
        public FixedRateSpecification.FixedRateSpecificationBuilder getOrCreateCouponRate() {
            FixedRateSpecification.FixedRateSpecificationBuilder result = this.couponRate != null ? this.couponRate : (this.couponRate = FixedRateSpecification.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="bond")
        @RuneAttribute(value="bond")
        public BondReferenceBuilder setBond(ProductIdentifier _bond) {
            this.bond = _bond == null ? null : _bond.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="conditionPrecedentBond")
        @RuneAttribute(value="conditionPrecedentBond")
        public BondReferenceBuilder setConditionPrecedentBond(Boolean _conditionPrecedentBond) {
            this.conditionPrecedentBond = _conditionPrecedentBond == null ? null : _conditionPrecedentBond;
            return this;
        }

        @Override
        @RosettaAttribute(value="discrepancyClause")
        @RuneAttribute(value="discrepancyClause")
        public BondReferenceBuilder setDiscrepancyClause(Boolean _discrepancyClause) {
            this.discrepancyClause = _discrepancyClause == null ? null : _discrepancyClause;
            return this;
        }

        @Override
        @RosettaAttribute(value="couponRate")
        @RuneAttribute(value="couponRate")
        public BondReferenceBuilder setCouponRate(FixedRateSpecification _couponRate) {
            this.couponRate = _couponRate == null ? null : _couponRate.toBuilder();
            return this;
        }

        @Override
        public BondReference build() {
            return new BondReferenceImpl(this);
        }

        @Override
        public BondReferenceBuilder toBuilder() {
            return this;
        }

        @Override
        public BondReferenceBuilder prune() {
            if (this.bond != null && !this.bond.prune().hasData()) {
                this.bond = null;
            }
            if (this.couponRate != null && !this.couponRate.prune().hasData()) {
                this.couponRate = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getBond() != null && this.getBond().hasData()) {
                return true;
            }
            if (this.getConditionPrecedentBond() != null) {
                return true;
            }
            if (this.getDiscrepancyClause() != null) {
                return true;
            }
            return this.getCouponRate() != null && this.getCouponRate().hasData();
        }

        public BondReferenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BondReferenceBuilder o = (BondReferenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBond(), (RosettaModelObjectBuilder)o.getBond(), this::setBond);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCouponRate(), (RosettaModelObjectBuilder)o.getCouponRate(), this::setCouponRate);
            merger.mergeBasic((Object)this.getConditionPrecedentBond(), (Object)o.getConditionPrecedentBond(), this::setConditionPrecedentBond, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDiscrepancyClause(), (Object)o.getDiscrepancyClause(), this::setDiscrepancyClause, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BondReference _that = this.getType().cast(o);
            if (!Objects.equals(this.bond, _that.getBond())) {
                return false;
            }
            if (!Objects.equals(this.conditionPrecedentBond, _that.getConditionPrecedentBond())) {
                return false;
            }
            if (!Objects.equals(this.discrepancyClause, _that.getDiscrepancyClause())) {
                return false;
            }
            return Objects.equals(this.couponRate, _that.getCouponRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bond != null ? this.bond.hashCode() : 0);
            _result = 31 * _result + (this.conditionPrecedentBond != null ? this.conditionPrecedentBond.hashCode() : 0);
            _result = 31 * _result + (this.discrepancyClause != null ? this.discrepancyClause.hashCode() : 0);
            _result = 31 * _result + (this.couponRate != null ? this.couponRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BondReferenceBuilder {bond=" + this.bond + ", conditionPrecedentBond=" + this.conditionPrecedentBond + ", discrepancyClause=" + this.discrepancyClause + ", couponRate=" + this.couponRate + '}';
        }
    }

    public static class BondReferenceImpl
    implements BondReference {
        private final ProductIdentifier bond;
        private final Boolean conditionPrecedentBond;
        private final Boolean discrepancyClause;
        private final FixedRateSpecification couponRate;

        protected BondReferenceImpl(BondReferenceBuilder builder) {
            this.bond = Optional.ofNullable(builder.getBond()).map(f -> f.build()).orElse(null);
            this.conditionPrecedentBond = builder.getConditionPrecedentBond();
            this.discrepancyClause = builder.getDiscrepancyClause();
            this.couponRate = Optional.ofNullable(builder.getCouponRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="bond")
        @RuneAttribute(value="bond")
        public ProductIdentifier getBond() {
            return this.bond;
        }

        @Override
        @RosettaAttribute(value="conditionPrecedentBond")
        @RuneAttribute(value="conditionPrecedentBond")
        public Boolean getConditionPrecedentBond() {
            return this.conditionPrecedentBond;
        }

        @Override
        @RosettaAttribute(value="discrepancyClause")
        @RuneAttribute(value="discrepancyClause")
        public Boolean getDiscrepancyClause() {
            return this.discrepancyClause;
        }

        @Override
        @RosettaAttribute(value="couponRate")
        @RuneAttribute(value="couponRate")
        public FixedRateSpecification getCouponRate() {
            return this.couponRate;
        }

        @Override
        public BondReference build() {
            return this;
        }

        @Override
        public BondReferenceBuilder toBuilder() {
            BondReferenceBuilder builder = BondReference.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BondReferenceBuilder builder) {
            Optional.ofNullable(this.getBond()).ifPresent(builder::setBond);
            Optional.ofNullable(this.getConditionPrecedentBond()).ifPresent(builder::setConditionPrecedentBond);
            Optional.ofNullable(this.getDiscrepancyClause()).ifPresent(builder::setDiscrepancyClause);
            Optional.ofNullable(this.getCouponRate()).ifPresent(builder::setCouponRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BondReference _that = this.getType().cast(o);
            if (!Objects.equals(this.bond, _that.getBond())) {
                return false;
            }
            if (!Objects.equals(this.conditionPrecedentBond, _that.getConditionPrecedentBond())) {
                return false;
            }
            if (!Objects.equals(this.discrepancyClause, _that.getDiscrepancyClause())) {
                return false;
            }
            return Objects.equals(this.couponRate, _that.getCouponRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.bond != null ? this.bond.hashCode() : 0);
            _result = 31 * _result + (this.conditionPrecedentBond != null ? this.conditionPrecedentBond.hashCode() : 0);
            _result = 31 * _result + (this.discrepancyClause != null ? this.discrepancyClause.hashCode() : 0);
            _result = 31 * _result + (this.couponRate != null ? this.couponRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BondReference {bond=" + this.bond + ", conditionPrecedentBond=" + this.conditionPrecedentBond + ", discrepancyClause=" + this.discrepancyClause + ", couponRate=" + this.couponRate + '}';
        }
    }

    public static interface BondReferenceBuilder
    extends BondReference,
    RosettaModelObjectBuilder {
        public ProductIdentifier.ProductIdentifierBuilder getOrCreateBond();

        @Override
        public ProductIdentifier.ProductIdentifierBuilder getBond();

        public FixedRateSpecification.FixedRateSpecificationBuilder getOrCreateCouponRate();

        @Override
        public FixedRateSpecification.FixedRateSpecificationBuilder getCouponRate();

        public BondReferenceBuilder setBond(ProductIdentifier var1);

        public BondReferenceBuilder setConditionPrecedentBond(Boolean var1);

        public BondReferenceBuilder setDiscrepancyClause(Boolean var1);

        public BondReferenceBuilder setCouponRate(FixedRateSpecification var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("bond"), processor, ProductIdentifier.ProductIdentifierBuilder.class, this.getBond(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("conditionPrecedentBond"), Boolean.class, (Object)this.getConditionPrecedentBond(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("discrepancyClause"), Boolean.class, (Object)this.getDiscrepancyClause(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("couponRate"), processor, FixedRateSpecification.FixedRateSpecificationBuilder.class, this.getCouponRate(), new AttributeMeta[0]);
        }

        public BondReferenceBuilder prune();
    }
}

