/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset;

import cdm.observable.asset.RateObservation;
import cdm.product.asset.meta.FloatingRateDefinitionMeta;
import cdm.product.template.Strike;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FloatingRateDefinition", builder=FloatingRateDefinitionBuilderImpl.class, version="5.24.0")
@RuneDataType(value="FloatingRateDefinition", model="cdm", builder=FloatingRateDefinitionBuilderImpl.class, version="5.24.0")
public interface FloatingRateDefinition
extends RosettaModelObject {
    public static final FloatingRateDefinitionMeta metaData = new FloatingRateDefinitionMeta();

    public BigDecimal getCalculatedRate();

    public List<? extends RateObservation> getRateObservation();

    public BigDecimal getFloatingRateMultiplier();

    public BigDecimal getSpread();

    public List<? extends Strike> getCapRate();

    public List<? extends Strike> getFloorRate();

    public FloatingRateDefinition build();

    public FloatingRateDefinitionBuilder toBuilder();

    public static FloatingRateDefinitionBuilder builder() {
        return new FloatingRateDefinitionBuilderImpl();
    }

    default public RosettaMetaData<? extends FloatingRateDefinition> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FloatingRateDefinition> getType() {
        return FloatingRateDefinition.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("calculatedRate"), BigDecimal.class, (Object)this.getCalculatedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rateObservation"), processor, RateObservation.class, this.getRateObservation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("floatingRateMultiplier"), BigDecimal.class, (Object)this.getFloatingRateMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("capRate"), processor, Strike.class, this.getCapRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floorRate"), processor, Strike.class, this.getFloorRate(), new AttributeMeta[0]);
    }

    public static class FloatingRateDefinitionBuilderImpl
    implements FloatingRateDefinitionBuilder {
        protected BigDecimal calculatedRate;
        protected List<RateObservation.RateObservationBuilder> rateObservation = new ArrayList<RateObservation.RateObservationBuilder>();
        protected BigDecimal floatingRateMultiplier;
        protected BigDecimal spread;
        protected List<Strike.StrikeBuilder> capRate = new ArrayList<Strike.StrikeBuilder>();
        protected List<Strike.StrikeBuilder> floorRate = new ArrayList<Strike.StrikeBuilder>();

        @Override
        @RosettaAttribute(value="calculatedRate")
        @RuneAttribute(value="calculatedRate")
        public BigDecimal getCalculatedRate() {
            return this.calculatedRate;
        }

        @Override
        @RosettaAttribute(value="rateObservation")
        @RuneAttribute(value="rateObservation")
        public List<? extends RateObservation.RateObservationBuilder> getRateObservation() {
            return this.rateObservation;
        }

        @Override
        public RateObservation.RateObservationBuilder getOrCreateRateObservation(int _index) {
            if (this.rateObservation == null) {
                this.rateObservation = new ArrayList<RateObservation.RateObservationBuilder>();
            }
            return (RateObservation.RateObservationBuilder)this.getIndex(this.rateObservation, _index, () -> {
                RateObservation.RateObservationBuilder newRateObservation = RateObservation.builder();
                return newRateObservation;
            });
        }

        @Override
        @RosettaAttribute(value="floatingRateMultiplier")
        @RuneAttribute(value="floatingRateMultiplier")
        public BigDecimal getFloatingRateMultiplier() {
            return this.floatingRateMultiplier;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="capRate")
        @RuneAttribute(value="capRate")
        public List<? extends Strike.StrikeBuilder> getCapRate() {
            return this.capRate;
        }

        @Override
        public Strike.StrikeBuilder getOrCreateCapRate(int _index) {
            if (this.capRate == null) {
                this.capRate = new ArrayList<Strike.StrikeBuilder>();
            }
            return (Strike.StrikeBuilder)this.getIndex(this.capRate, _index, () -> {
                Strike.StrikeBuilder newCapRate = Strike.builder();
                return newCapRate;
            });
        }

        @Override
        @RosettaAttribute(value="floorRate")
        @RuneAttribute(value="floorRate")
        public List<? extends Strike.StrikeBuilder> getFloorRate() {
            return this.floorRate;
        }

        @Override
        public Strike.StrikeBuilder getOrCreateFloorRate(int _index) {
            if (this.floorRate == null) {
                this.floorRate = new ArrayList<Strike.StrikeBuilder>();
            }
            return (Strike.StrikeBuilder)this.getIndex(this.floorRate, _index, () -> {
                Strike.StrikeBuilder newFloorRate = Strike.builder();
                return newFloorRate;
            });
        }

        @Override
        @RosettaAttribute(value="calculatedRate")
        @RuneAttribute(value="calculatedRate")
        public FloatingRateDefinitionBuilder setCalculatedRate(BigDecimal _calculatedRate) {
            this.calculatedRate = _calculatedRate == null ? null : _calculatedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="rateObservation")
        @RuneAttribute(value="rateObservation")
        public FloatingRateDefinitionBuilder addRateObservation(RateObservation _rateObservation) {
            if (_rateObservation != null) {
                this.rateObservation.add(_rateObservation.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingRateDefinitionBuilder addRateObservation(RateObservation _rateObservation, int _idx) {
            this.getIndex(this.rateObservation, _idx, () -> _rateObservation.toBuilder());
            return this;
        }

        @Override
        public FloatingRateDefinitionBuilder addRateObservation(List<? extends RateObservation> rateObservations) {
            if (rateObservations != null) {
                for (RateObservation rateObservation : rateObservations) {
                    this.rateObservation.add(rateObservation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="rateObservation")
        public FloatingRateDefinitionBuilder setRateObservation(List<? extends RateObservation> rateObservations) {
            this.rateObservation = rateObservations == null ? new ArrayList<RateObservation.RateObservationBuilder>() : (List)rateObservations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateMultiplier")
        @RuneAttribute(value="floatingRateMultiplier")
        public FloatingRateDefinitionBuilder setFloatingRateMultiplier(BigDecimal _floatingRateMultiplier) {
            this.floatingRateMultiplier = _floatingRateMultiplier == null ? null : _floatingRateMultiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public FloatingRateDefinitionBuilder setSpread(BigDecimal _spread) {
            this.spread = _spread == null ? null : _spread;
            return this;
        }

        @Override
        @RosettaAttribute(value="capRate")
        @RuneAttribute(value="capRate")
        public FloatingRateDefinitionBuilder addCapRate(Strike _capRate) {
            if (_capRate != null) {
                this.capRate.add(_capRate.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingRateDefinitionBuilder addCapRate(Strike _capRate, int _idx) {
            this.getIndex(this.capRate, _idx, () -> _capRate.toBuilder());
            return this;
        }

        @Override
        public FloatingRateDefinitionBuilder addCapRate(List<? extends Strike> capRates) {
            if (capRates != null) {
                for (Strike strike : capRates) {
                    this.capRate.add(strike.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="capRate")
        public FloatingRateDefinitionBuilder setCapRate(List<? extends Strike> capRates) {
            this.capRate = capRates == null ? new ArrayList<Strike.StrikeBuilder>() : (List)capRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="floorRate")
        @RuneAttribute(value="floorRate")
        public FloatingRateDefinitionBuilder addFloorRate(Strike _floorRate) {
            if (_floorRate != null) {
                this.floorRate.add(_floorRate.toBuilder());
            }
            return this;
        }

        @Override
        public FloatingRateDefinitionBuilder addFloorRate(Strike _floorRate, int _idx) {
            this.getIndex(this.floorRate, _idx, () -> _floorRate.toBuilder());
            return this;
        }

        @Override
        public FloatingRateDefinitionBuilder addFloorRate(List<? extends Strike> floorRates) {
            if (floorRates != null) {
                for (Strike strike : floorRates) {
                    this.floorRate.add(strike.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="floorRate")
        public FloatingRateDefinitionBuilder setFloorRate(List<? extends Strike> floorRates) {
            this.floorRate = floorRates == null ? new ArrayList<Strike.StrikeBuilder>() : (List)floorRates.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FloatingRateDefinition build() {
            return new FloatingRateDefinitionImpl(this);
        }

        @Override
        public FloatingRateDefinitionBuilder toBuilder() {
            return this;
        }

        @Override
        public FloatingRateDefinitionBuilder prune() {
            this.rateObservation = this.rateObservation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.capRate = this.capRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.floorRate = this.floorRate.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getCalculatedRate() != null) {
                return true;
            }
            if (this.getRateObservation() != null && this.getRateObservation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getFloatingRateMultiplier() != null) {
                return true;
            }
            if (this.getSpread() != null) {
                return true;
            }
            if (this.getCapRate() != null && this.getCapRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getFloorRate() != null && this.getFloorRate().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FloatingRateDefinitionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FloatingRateDefinitionBuilder o = (FloatingRateDefinitionBuilder)other;
            merger.mergeRosetta(this.getRateObservation(), o.getRateObservation(), this::getOrCreateRateObservation);
            merger.mergeRosetta(this.getCapRate(), o.getCapRate(), this::getOrCreateCapRate);
            merger.mergeRosetta(this.getFloorRate(), o.getFloorRate(), this::getOrCreateFloorRate);
            merger.mergeBasic((Object)this.getCalculatedRate(), (Object)o.getCalculatedRate(), this::setCalculatedRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFloatingRateMultiplier(), (Object)o.getFloatingRateMultiplier(), this::setFloatingRateMultiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpread(), (Object)o.getSpread(), this::setSpread, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateDefinition _that = this.getType().cast(o);
            if (!Objects.equals(this.calculatedRate, _that.getCalculatedRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.rateObservation, _that.getRateObservation())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateMultiplier, _that.getFloatingRateMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!ListEquals.listEquals(this.capRate, _that.getCapRate())) {
                return false;
            }
            return ListEquals.listEquals(this.floorRate, _that.getFloorRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculatedRate != null ? this.calculatedRate.hashCode() : 0);
            _result = 31 * _result + (this.rateObservation != null ? this.rateObservation.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateMultiplier != null ? this.floatingRateMultiplier.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.capRate != null ? this.capRate.hashCode() : 0);
            _result = 31 * _result + (this.floorRate != null ? this.floorRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateDefinitionBuilder {calculatedRate=" + this.calculatedRate + ", rateObservation=" + this.rateObservation + ", floatingRateMultiplier=" + this.floatingRateMultiplier + ", spread=" + this.spread + ", capRate=" + this.capRate + ", floorRate=" + this.floorRate + '}';
        }
    }

    public static class FloatingRateDefinitionImpl
    implements FloatingRateDefinition {
        private final BigDecimal calculatedRate;
        private final List<? extends RateObservation> rateObservation;
        private final BigDecimal floatingRateMultiplier;
        private final BigDecimal spread;
        private final List<? extends Strike> capRate;
        private final List<? extends Strike> floorRate;

        protected FloatingRateDefinitionImpl(FloatingRateDefinitionBuilder builder) {
            this.calculatedRate = builder.getCalculatedRate();
            this.rateObservation = Optional.ofNullable(builder.getRateObservation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.floatingRateMultiplier = builder.getFloatingRateMultiplier();
            this.spread = builder.getSpread();
            this.capRate = Optional.ofNullable(builder.getCapRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.floorRate = Optional.ofNullable(builder.getFloorRate()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="calculatedRate")
        @RuneAttribute(value="calculatedRate")
        public BigDecimal getCalculatedRate() {
            return this.calculatedRate;
        }

        @Override
        @RosettaAttribute(value="rateObservation")
        @RuneAttribute(value="rateObservation")
        public List<? extends RateObservation> getRateObservation() {
            return this.rateObservation;
        }

        @Override
        @RosettaAttribute(value="floatingRateMultiplier")
        @RuneAttribute(value="floatingRateMultiplier")
        public BigDecimal getFloatingRateMultiplier() {
            return this.floatingRateMultiplier;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public BigDecimal getSpread() {
            return this.spread;
        }

        @Override
        @RosettaAttribute(value="capRate")
        @RuneAttribute(value="capRate")
        public List<? extends Strike> getCapRate() {
            return this.capRate;
        }

        @Override
        @RosettaAttribute(value="floorRate")
        @RuneAttribute(value="floorRate")
        public List<? extends Strike> getFloorRate() {
            return this.floorRate;
        }

        @Override
        public FloatingRateDefinition build() {
            return this;
        }

        @Override
        public FloatingRateDefinitionBuilder toBuilder() {
            FloatingRateDefinitionBuilder builder = FloatingRateDefinition.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FloatingRateDefinitionBuilder builder) {
            Optional.ofNullable(this.getCalculatedRate()).ifPresent(builder::setCalculatedRate);
            Optional.ofNullable(this.getRateObservation()).ifPresent(builder::setRateObservation);
            Optional.ofNullable(this.getFloatingRateMultiplier()).ifPresent(builder::setFloatingRateMultiplier);
            Optional.ofNullable(this.getSpread()).ifPresent(builder::setSpread);
            Optional.ofNullable(this.getCapRate()).ifPresent(builder::setCapRate);
            Optional.ofNullable(this.getFloorRate()).ifPresent(builder::setFloorRate);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FloatingRateDefinition _that = this.getType().cast(o);
            if (!Objects.equals(this.calculatedRate, _that.getCalculatedRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.rateObservation, _that.getRateObservation())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateMultiplier, _that.getFloatingRateMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.spread, _that.getSpread())) {
                return false;
            }
            if (!ListEquals.listEquals(this.capRate, _that.getCapRate())) {
                return false;
            }
            return ListEquals.listEquals(this.floorRate, _that.getFloorRate());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.calculatedRate != null ? this.calculatedRate.hashCode() : 0);
            _result = 31 * _result + (this.rateObservation != null ? this.rateObservation.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateMultiplier != null ? this.floatingRateMultiplier.hashCode() : 0);
            _result = 31 * _result + (this.spread != null ? this.spread.hashCode() : 0);
            _result = 31 * _result + (this.capRate != null ? this.capRate.hashCode() : 0);
            _result = 31 * _result + (this.floorRate != null ? this.floorRate.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FloatingRateDefinition {calculatedRate=" + this.calculatedRate + ", rateObservation=" + this.rateObservation + ", floatingRateMultiplier=" + this.floatingRateMultiplier + ", spread=" + this.spread + ", capRate=" + this.capRate + ", floorRate=" + this.floorRate + '}';
        }
    }

    public static interface FloatingRateDefinitionBuilder
    extends FloatingRateDefinition,
    RosettaModelObjectBuilder {
        public RateObservation.RateObservationBuilder getOrCreateRateObservation(int var1);

        public List<? extends RateObservation.RateObservationBuilder> getRateObservation();

        public Strike.StrikeBuilder getOrCreateCapRate(int var1);

        public List<? extends Strike.StrikeBuilder> getCapRate();

        public Strike.StrikeBuilder getOrCreateFloorRate(int var1);

        public List<? extends Strike.StrikeBuilder> getFloorRate();

        public FloatingRateDefinitionBuilder setCalculatedRate(BigDecimal var1);

        public FloatingRateDefinitionBuilder addRateObservation(RateObservation var1);

        public FloatingRateDefinitionBuilder addRateObservation(RateObservation var1, int var2);

        public FloatingRateDefinitionBuilder addRateObservation(List<? extends RateObservation> var1);

        public FloatingRateDefinitionBuilder setRateObservation(List<? extends RateObservation> var1);

        public FloatingRateDefinitionBuilder setFloatingRateMultiplier(BigDecimal var1);

        public FloatingRateDefinitionBuilder setSpread(BigDecimal var1);

        public FloatingRateDefinitionBuilder addCapRate(Strike var1);

        public FloatingRateDefinitionBuilder addCapRate(Strike var1, int var2);

        public FloatingRateDefinitionBuilder addCapRate(List<? extends Strike> var1);

        public FloatingRateDefinitionBuilder setCapRate(List<? extends Strike> var1);

        public FloatingRateDefinitionBuilder addFloorRate(Strike var1);

        public FloatingRateDefinitionBuilder addFloorRate(Strike var1, int var2);

        public FloatingRateDefinitionBuilder addFloorRate(List<? extends Strike> var1);

        public FloatingRateDefinitionBuilder setFloorRate(List<? extends Strike> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("calculatedRate"), BigDecimal.class, (Object)this.getCalculatedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rateObservation"), processor, RateObservation.RateObservationBuilder.class, this.getRateObservation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("floatingRateMultiplier"), BigDecimal.class, (Object)this.getFloatingRateMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spread"), BigDecimal.class, (Object)this.getSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("capRate"), processor, Strike.StrikeBuilder.class, this.getCapRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floorRate"), processor, Strike.StrikeBuilder.class, this.getFloorRate(), new AttributeMeta[0]);
        }

        public FloatingRateDefinitionBuilder prune();
    }
}

