/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.product.collateral.CollateralTypeEnum;
import cdm.product.collateral.EligibleCollateralCriteria;
import cdm.product.collateral.SubstitutionProvisions;
import cdm.product.collateral.meta.CollateralProvisionsMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CollateralProvisions", builder=CollateralProvisionsBuilderImpl.class, version="5.24.0")
@RuneDataType(value="CollateralProvisions", model="cdm", builder=CollateralProvisionsBuilderImpl.class, version="5.24.0")
public interface CollateralProvisions
extends RosettaModelObject {
    public static final CollateralProvisionsMeta metaData = new CollateralProvisionsMeta();

    public CollateralTypeEnum getCollateralType();

    public List<? extends EligibleCollateralCriteria> getEligibleCollateral();

    public SubstitutionProvisions getSubstitutionProvisions();

    public CollateralProvisions build();

    public CollateralProvisionsBuilder toBuilder();

    public static CollateralProvisionsBuilder builder() {
        return new CollateralProvisionsBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralProvisions> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralProvisions> getType() {
        return CollateralProvisions.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("collateralType"), CollateralTypeEnum.class, (Object)this.getCollateralType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eligibleCollateral"), processor, EligibleCollateralCriteria.class, this.getEligibleCollateral(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("substitutionProvisions"), processor, SubstitutionProvisions.class, this.getSubstitutionProvisions(), new AttributeMeta[0]);
    }

    public static class CollateralProvisionsBuilderImpl
    implements CollateralProvisionsBuilder {
        protected CollateralTypeEnum collateralType;
        protected List<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> eligibleCollateral = new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>();
        protected SubstitutionProvisions.SubstitutionProvisionsBuilder substitutionProvisions;

        @Override
        @RosettaAttribute(value="collateralType")
        @RuneAttribute(value="collateralType")
        public CollateralTypeEnum getCollateralType() {
            return this.collateralType;
        }

        @Override
        @RosettaAttribute(value="eligibleCollateral")
        @RuneAttribute(value="eligibleCollateral")
        public List<? extends EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> getEligibleCollateral() {
            return this.eligibleCollateral;
        }

        @Override
        public EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder getOrCreateEligibleCollateral(int _index) {
            if (this.eligibleCollateral == null) {
                this.eligibleCollateral = new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>();
            }
            return (EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder)this.getIndex(this.eligibleCollateral, _index, () -> {
                EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder newEligibleCollateral = EligibleCollateralCriteria.builder();
                return newEligibleCollateral;
            });
        }

        @Override
        @RosettaAttribute(value="substitutionProvisions")
        @RuneAttribute(value="substitutionProvisions")
        public SubstitutionProvisions.SubstitutionProvisionsBuilder getSubstitutionProvisions() {
            return this.substitutionProvisions;
        }

        @Override
        public SubstitutionProvisions.SubstitutionProvisionsBuilder getOrCreateSubstitutionProvisions() {
            SubstitutionProvisions.SubstitutionProvisionsBuilder result = this.substitutionProvisions != null ? this.substitutionProvisions : (this.substitutionProvisions = SubstitutionProvisions.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralType")
        @RuneAttribute(value="collateralType")
        public CollateralProvisionsBuilder setCollateralType(CollateralTypeEnum _collateralType) {
            this.collateralType = _collateralType == null ? null : _collateralType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eligibleCollateral")
        @RuneAttribute(value="eligibleCollateral")
        public CollateralProvisionsBuilder addEligibleCollateral(EligibleCollateralCriteria _eligibleCollateral) {
            if (_eligibleCollateral != null) {
                this.eligibleCollateral.add(_eligibleCollateral.toBuilder());
            }
            return this;
        }

        @Override
        public CollateralProvisionsBuilder addEligibleCollateral(EligibleCollateralCriteria _eligibleCollateral, int _idx) {
            this.getIndex(this.eligibleCollateral, _idx, () -> _eligibleCollateral.toBuilder());
            return this;
        }

        @Override
        public CollateralProvisionsBuilder addEligibleCollateral(List<? extends EligibleCollateralCriteria> eligibleCollaterals) {
            if (eligibleCollaterals != null) {
                for (EligibleCollateralCriteria eligibleCollateralCriteria : eligibleCollaterals) {
                    this.eligibleCollateral.add(eligibleCollateralCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eligibleCollateral")
        public CollateralProvisionsBuilder setEligibleCollateral(List<? extends EligibleCollateralCriteria> eligibleCollaterals) {
            this.eligibleCollateral = eligibleCollaterals == null ? new ArrayList<EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder>() : (List)eligibleCollaterals.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="substitutionProvisions")
        @RuneAttribute(value="substitutionProvisions")
        public CollateralProvisionsBuilder setSubstitutionProvisions(SubstitutionProvisions _substitutionProvisions) {
            this.substitutionProvisions = _substitutionProvisions == null ? null : _substitutionProvisions.toBuilder();
            return this;
        }

        @Override
        public CollateralProvisions build() {
            return new CollateralProvisionsImpl(this);
        }

        @Override
        public CollateralProvisionsBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralProvisionsBuilder prune() {
            this.eligibleCollateral = this.eligibleCollateral.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.substitutionProvisions != null && !this.substitutionProvisions.prune().hasData()) {
                this.substitutionProvisions = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getCollateralType() != null) {
                return true;
            }
            if (this.getEligibleCollateral() != null && this.getEligibleCollateral().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getSubstitutionProvisions() != null && this.getSubstitutionProvisions().hasData();
        }

        public CollateralProvisionsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralProvisionsBuilder o = (CollateralProvisionsBuilder)other;
            merger.mergeRosetta(this.getEligibleCollateral(), o.getEligibleCollateral(), this::getOrCreateEligibleCollateral);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSubstitutionProvisions(), (RosettaModelObjectBuilder)o.getSubstitutionProvisions(), this::setSubstitutionProvisions);
            merger.mergeBasic((Object)this.getCollateralType(), (Object)o.getCollateralType(), this::setCollateralType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralProvisions _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.collateralType, (Object)_that.getCollateralType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eligibleCollateral, _that.getEligibleCollateral())) {
                return false;
            }
            return Objects.equals(this.substitutionProvisions, _that.getSubstitutionProvisions());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralType != null ? ((Object)((Object)this.collateralType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eligibleCollateral != null ? this.eligibleCollateral.hashCode() : 0);
            _result = 31 * _result + (this.substitutionProvisions != null ? this.substitutionProvisions.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralProvisionsBuilder {collateralType=" + (Object)((Object)this.collateralType) + ", eligibleCollateral=" + this.eligibleCollateral + ", substitutionProvisions=" + this.substitutionProvisions + '}';
        }
    }

    public static class CollateralProvisionsImpl
    implements CollateralProvisions {
        private final CollateralTypeEnum collateralType;
        private final List<? extends EligibleCollateralCriteria> eligibleCollateral;
        private final SubstitutionProvisions substitutionProvisions;

        protected CollateralProvisionsImpl(CollateralProvisionsBuilder builder) {
            this.collateralType = builder.getCollateralType();
            this.eligibleCollateral = Optional.ofNullable(builder.getEligibleCollateral()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.substitutionProvisions = Optional.ofNullable(builder.getSubstitutionProvisions()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="collateralType")
        @RuneAttribute(value="collateralType")
        public CollateralTypeEnum getCollateralType() {
            return this.collateralType;
        }

        @Override
        @RosettaAttribute(value="eligibleCollateral")
        @RuneAttribute(value="eligibleCollateral")
        public List<? extends EligibleCollateralCriteria> getEligibleCollateral() {
            return this.eligibleCollateral;
        }

        @Override
        @RosettaAttribute(value="substitutionProvisions")
        @RuneAttribute(value="substitutionProvisions")
        public SubstitutionProvisions getSubstitutionProvisions() {
            return this.substitutionProvisions;
        }

        @Override
        public CollateralProvisions build() {
            return this;
        }

        @Override
        public CollateralProvisionsBuilder toBuilder() {
            CollateralProvisionsBuilder builder = CollateralProvisions.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralProvisionsBuilder builder) {
            Optional.ofNullable(this.getCollateralType()).ifPresent(builder::setCollateralType);
            Optional.ofNullable(this.getEligibleCollateral()).ifPresent(builder::setEligibleCollateral);
            Optional.ofNullable(this.getSubstitutionProvisions()).ifPresent(builder::setSubstitutionProvisions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralProvisions _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.collateralType, (Object)_that.getCollateralType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.eligibleCollateral, _that.getEligibleCollateral())) {
                return false;
            }
            return Objects.equals(this.substitutionProvisions, _that.getSubstitutionProvisions());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.collateralType != null ? ((Object)((Object)this.collateralType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eligibleCollateral != null ? this.eligibleCollateral.hashCode() : 0);
            _result = 31 * _result + (this.substitutionProvisions != null ? this.substitutionProvisions.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralProvisions {collateralType=" + (Object)((Object)this.collateralType) + ", eligibleCollateral=" + this.eligibleCollateral + ", substitutionProvisions=" + this.substitutionProvisions + '}';
        }
    }

    public static interface CollateralProvisionsBuilder
    extends CollateralProvisions,
    RosettaModelObjectBuilder {
        public EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder getOrCreateEligibleCollateral(int var1);

        public List<? extends EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder> getEligibleCollateral();

        public SubstitutionProvisions.SubstitutionProvisionsBuilder getOrCreateSubstitutionProvisions();

        @Override
        public SubstitutionProvisions.SubstitutionProvisionsBuilder getSubstitutionProvisions();

        public CollateralProvisionsBuilder setCollateralType(CollateralTypeEnum var1);

        public CollateralProvisionsBuilder addEligibleCollateral(EligibleCollateralCriteria var1);

        public CollateralProvisionsBuilder addEligibleCollateral(EligibleCollateralCriteria var1, int var2);

        public CollateralProvisionsBuilder addEligibleCollateral(List<? extends EligibleCollateralCriteria> var1);

        public CollateralProvisionsBuilder setEligibleCollateral(List<? extends EligibleCollateralCriteria> var1);

        public CollateralProvisionsBuilder setSubstitutionProvisions(SubstitutionProvisions var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("collateralType"), CollateralTypeEnum.class, (Object)this.getCollateralType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eligibleCollateral"), processor, EligibleCollateralCriteria.EligibleCollateralCriteriaBuilder.class, this.getEligibleCollateral(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("substitutionProvisions"), processor, SubstitutionProvisions.SubstitutionProvisionsBuilder.class, this.getSubstitutionProvisions(), new AttributeMeta[0]);
        }

        public CollateralProvisionsBuilder prune();
    }
}

