/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.math.MoneyRange;
import cdm.base.math.NumberRange;
import cdm.product.collateral.ConcentrationLimitCriteria;
import cdm.product.collateral.meta.ConcentrationLimitMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ConcentrationLimit", builder=ConcentrationLimitBuilderImpl.class, version="5.24.0")
@RuneDataType(value="ConcentrationLimit", model="cdm", builder=ConcentrationLimitBuilderImpl.class, version="5.24.0")
public interface ConcentrationLimit
extends RosettaModelObject {
    public static final ConcentrationLimitMeta metaData = new ConcentrationLimitMeta();

    public List<? extends ConcentrationLimitCriteria> getConcentrationLimitCriteria();

    public MoneyRange getValueLimit();

    public NumberRange getPercentageLimit();

    public ConcentrationLimit build();

    public ConcentrationLimitBuilder toBuilder();

    public static ConcentrationLimitBuilder builder() {
        return new ConcentrationLimitBuilderImpl();
    }

    default public RosettaMetaData<? extends ConcentrationLimit> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ConcentrationLimit> getType() {
        return ConcentrationLimit.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("concentrationLimitCriteria"), processor, ConcentrationLimitCriteria.class, this.getConcentrationLimitCriteria(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("valueLimit"), processor, MoneyRange.class, this.getValueLimit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("percentageLimit"), processor, NumberRange.class, this.getPercentageLimit(), new AttributeMeta[0]);
    }

    public static class ConcentrationLimitBuilderImpl
    implements ConcentrationLimitBuilder {
        protected List<ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder> concentrationLimitCriteria = new ArrayList<ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder>();
        protected MoneyRange.MoneyRangeBuilder valueLimit;
        protected NumberRange.NumberRangeBuilder percentageLimit;

        @Override
        @RosettaAttribute(value="concentrationLimitCriteria")
        @RuneAttribute(value="concentrationLimitCriteria")
        public List<? extends ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder> getConcentrationLimitCriteria() {
            return this.concentrationLimitCriteria;
        }

        @Override
        public ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder getOrCreateConcentrationLimitCriteria(int _index) {
            if (this.concentrationLimitCriteria == null) {
                this.concentrationLimitCriteria = new ArrayList<ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder>();
            }
            return (ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder)this.getIndex(this.concentrationLimitCriteria, _index, () -> {
                ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder newConcentrationLimitCriteria = ConcentrationLimitCriteria.builder();
                return newConcentrationLimitCriteria;
            });
        }

        @Override
        @RosettaAttribute(value="valueLimit")
        @RuneAttribute(value="valueLimit")
        public MoneyRange.MoneyRangeBuilder getValueLimit() {
            return this.valueLimit;
        }

        @Override
        public MoneyRange.MoneyRangeBuilder getOrCreateValueLimit() {
            MoneyRange.MoneyRangeBuilder result = this.valueLimit != null ? this.valueLimit : (this.valueLimit = MoneyRange.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="percentageLimit")
        @RuneAttribute(value="percentageLimit")
        public NumberRange.NumberRangeBuilder getPercentageLimit() {
            return this.percentageLimit;
        }

        @Override
        public NumberRange.NumberRangeBuilder getOrCreatePercentageLimit() {
            NumberRange.NumberRangeBuilder result = this.percentageLimit != null ? this.percentageLimit : (this.percentageLimit = NumberRange.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="concentrationLimitCriteria")
        @RuneAttribute(value="concentrationLimitCriteria")
        public ConcentrationLimitBuilder addConcentrationLimitCriteria(ConcentrationLimitCriteria _concentrationLimitCriteria) {
            if (_concentrationLimitCriteria != null) {
                this.concentrationLimitCriteria.add(_concentrationLimitCriteria.toBuilder());
            }
            return this;
        }

        @Override
        public ConcentrationLimitBuilder addConcentrationLimitCriteria(ConcentrationLimitCriteria _concentrationLimitCriteria, int _idx) {
            this.getIndex(this.concentrationLimitCriteria, _idx, () -> _concentrationLimitCriteria.toBuilder());
            return this;
        }

        @Override
        public ConcentrationLimitBuilder addConcentrationLimitCriteria(List<? extends ConcentrationLimitCriteria> concentrationLimitCriterias) {
            if (concentrationLimitCriterias != null) {
                for (ConcentrationLimitCriteria concentrationLimitCriteria : concentrationLimitCriterias) {
                    this.concentrationLimitCriteria.add(concentrationLimitCriteria.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="concentrationLimitCriteria")
        public ConcentrationLimitBuilder setConcentrationLimitCriteria(List<? extends ConcentrationLimitCriteria> concentrationLimitCriterias) {
            this.concentrationLimitCriteria = concentrationLimitCriterias == null ? new ArrayList<ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder>() : (List)concentrationLimitCriterias.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="valueLimit")
        @RuneAttribute(value="valueLimit")
        public ConcentrationLimitBuilder setValueLimit(MoneyRange _valueLimit) {
            this.valueLimit = _valueLimit == null ? null : _valueLimit.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="percentageLimit")
        @RuneAttribute(value="percentageLimit")
        public ConcentrationLimitBuilder setPercentageLimit(NumberRange _percentageLimit) {
            this.percentageLimit = _percentageLimit == null ? null : _percentageLimit.toBuilder();
            return this;
        }

        @Override
        public ConcentrationLimit build() {
            return new ConcentrationLimitImpl(this);
        }

        @Override
        public ConcentrationLimitBuilder toBuilder() {
            return this;
        }

        @Override
        public ConcentrationLimitBuilder prune() {
            this.concentrationLimitCriteria = this.concentrationLimitCriteria.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.valueLimit != null && !this.valueLimit.prune().hasData()) {
                this.valueLimit = null;
            }
            if (this.percentageLimit != null && !this.percentageLimit.prune().hasData()) {
                this.percentageLimit = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getConcentrationLimitCriteria() != null && this.getConcentrationLimitCriteria().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getValueLimit() != null && this.getValueLimit().hasData()) {
                return true;
            }
            return this.getPercentageLimit() != null && this.getPercentageLimit().hasData();
        }

        public ConcentrationLimitBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ConcentrationLimitBuilder o = (ConcentrationLimitBuilder)other;
            merger.mergeRosetta(this.getConcentrationLimitCriteria(), o.getConcentrationLimitCriteria(), this::getOrCreateConcentrationLimitCriteria);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getValueLimit(), (RosettaModelObjectBuilder)o.getValueLimit(), this::setValueLimit);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPercentageLimit(), (RosettaModelObjectBuilder)o.getPercentageLimit(), this::setPercentageLimit);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ConcentrationLimit _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.concentrationLimitCriteria, _that.getConcentrationLimitCriteria())) {
                return false;
            }
            if (!Objects.equals(this.valueLimit, _that.getValueLimit())) {
                return false;
            }
            return Objects.equals(this.percentageLimit, _that.getPercentageLimit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.concentrationLimitCriteria != null ? this.concentrationLimitCriteria.hashCode() : 0);
            _result = 31 * _result + (this.valueLimit != null ? this.valueLimit.hashCode() : 0);
            _result = 31 * _result + (this.percentageLimit != null ? this.percentageLimit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ConcentrationLimitBuilder {concentrationLimitCriteria=" + this.concentrationLimitCriteria + ", valueLimit=" + this.valueLimit + ", percentageLimit=" + this.percentageLimit + '}';
        }
    }

    public static class ConcentrationLimitImpl
    implements ConcentrationLimit {
        private final List<? extends ConcentrationLimitCriteria> concentrationLimitCriteria;
        private final MoneyRange valueLimit;
        private final NumberRange percentageLimit;

        protected ConcentrationLimitImpl(ConcentrationLimitBuilder builder) {
            this.concentrationLimitCriteria = Optional.ofNullable(builder.getConcentrationLimitCriteria()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.valueLimit = Optional.ofNullable(builder.getValueLimit()).map(f -> f.build()).orElse(null);
            this.percentageLimit = Optional.ofNullable(builder.getPercentageLimit()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="concentrationLimitCriteria")
        @RuneAttribute(value="concentrationLimitCriteria")
        public List<? extends ConcentrationLimitCriteria> getConcentrationLimitCriteria() {
            return this.concentrationLimitCriteria;
        }

        @Override
        @RosettaAttribute(value="valueLimit")
        @RuneAttribute(value="valueLimit")
        public MoneyRange getValueLimit() {
            return this.valueLimit;
        }

        @Override
        @RosettaAttribute(value="percentageLimit")
        @RuneAttribute(value="percentageLimit")
        public NumberRange getPercentageLimit() {
            return this.percentageLimit;
        }

        @Override
        public ConcentrationLimit build() {
            return this;
        }

        @Override
        public ConcentrationLimitBuilder toBuilder() {
            ConcentrationLimitBuilder builder = ConcentrationLimit.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ConcentrationLimitBuilder builder) {
            Optional.ofNullable(this.getConcentrationLimitCriteria()).ifPresent(builder::setConcentrationLimitCriteria);
            Optional.ofNullable(this.getValueLimit()).ifPresent(builder::setValueLimit);
            Optional.ofNullable(this.getPercentageLimit()).ifPresent(builder::setPercentageLimit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ConcentrationLimit _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.concentrationLimitCriteria, _that.getConcentrationLimitCriteria())) {
                return false;
            }
            if (!Objects.equals(this.valueLimit, _that.getValueLimit())) {
                return false;
            }
            return Objects.equals(this.percentageLimit, _that.getPercentageLimit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.concentrationLimitCriteria != null ? this.concentrationLimitCriteria.hashCode() : 0);
            _result = 31 * _result + (this.valueLimit != null ? this.valueLimit.hashCode() : 0);
            _result = 31 * _result + (this.percentageLimit != null ? this.percentageLimit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ConcentrationLimit {concentrationLimitCriteria=" + this.concentrationLimitCriteria + ", valueLimit=" + this.valueLimit + ", percentageLimit=" + this.percentageLimit + '}';
        }
    }

    public static interface ConcentrationLimitBuilder
    extends ConcentrationLimit,
    RosettaModelObjectBuilder {
        public ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder getOrCreateConcentrationLimitCriteria(int var1);

        public List<? extends ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder> getConcentrationLimitCriteria();

        public MoneyRange.MoneyRangeBuilder getOrCreateValueLimit();

        @Override
        public MoneyRange.MoneyRangeBuilder getValueLimit();

        public NumberRange.NumberRangeBuilder getOrCreatePercentageLimit();

        @Override
        public NumberRange.NumberRangeBuilder getPercentageLimit();

        public ConcentrationLimitBuilder addConcentrationLimitCriteria(ConcentrationLimitCriteria var1);

        public ConcentrationLimitBuilder addConcentrationLimitCriteria(ConcentrationLimitCriteria var1, int var2);

        public ConcentrationLimitBuilder addConcentrationLimitCriteria(List<? extends ConcentrationLimitCriteria> var1);

        public ConcentrationLimitBuilder setConcentrationLimitCriteria(List<? extends ConcentrationLimitCriteria> var1);

        public ConcentrationLimitBuilder setValueLimit(MoneyRange var1);

        public ConcentrationLimitBuilder setPercentageLimit(NumberRange var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("concentrationLimitCriteria"), processor, ConcentrationLimitCriteria.ConcentrationLimitCriteriaBuilder.class, this.getConcentrationLimitCriteria(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("valueLimit"), processor, MoneyRange.MoneyRangeBuilder.class, this.getValueLimit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("percentageLimit"), processor, NumberRange.NumberRangeBuilder.class, this.getPercentageLimit(), new AttributeMeta[0]);
        }

        public ConcentrationLimitBuilder prune();
    }
}

