/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.meta.PayoutBaseMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="PayoutBase", builder=PayoutBaseBuilderImpl.class, version="5.24.0")
@RuneDataType(value="PayoutBase", model="cdm", builder=PayoutBaseBuilderImpl.class, version="5.24.0")
public interface PayoutBase
extends RosettaModelObject {
    public static final PayoutBaseMeta metaData = new PayoutBaseMeta();

    public PayerReceiver getPayerReceiver();

    public ResolvablePriceQuantity getPriceQuantity();

    public PrincipalPayments getPrincipalPayment();

    public SettlementTerms getSettlementTerms();

    public PayoutBase build();

    public PayoutBaseBuilder toBuilder();

    public static PayoutBaseBuilder builder() {
        return new PayoutBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends PayoutBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PayoutBase> getType() {
        return PayoutBase.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.class, this.getPayerReceiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.class, this.getPriceQuantity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.class, this.getPrincipalPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.class, this.getSettlementTerms(), new AttributeMeta[0]);
    }

    public static class PayoutBaseBuilderImpl
    implements PayoutBaseBuilder {
        protected PayerReceiver.PayerReceiverBuilder payerReceiver;
        protected ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantity;
        protected PrincipalPayments.PrincipalPaymentsBuilder principalPayment;
        protected SettlementTerms.SettlementTermsBuilder settlementTerms;

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver() {
            PayerReceiver.PayerReceiverBuilder result = this.payerReceiver != null ? this.payerReceiver : (this.payerReceiver = PayerReceiver.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public ResolvablePriceQuantity.ResolvablePriceQuantityBuilder getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        public ResolvablePriceQuantity.ResolvablePriceQuantityBuilder getOrCreatePriceQuantity() {
            ResolvablePriceQuantity.ResolvablePriceQuantityBuilder result = this.priceQuantity != null ? this.priceQuantity : (this.priceQuantity = ResolvablePriceQuantity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public PrincipalPayments.PrincipalPaymentsBuilder getPrincipalPayment() {
            return this.principalPayment;
        }

        @Override
        public PrincipalPayments.PrincipalPaymentsBuilder getOrCreatePrincipalPayment() {
            PrincipalPayments.PrincipalPaymentsBuilder result = this.principalPayment != null ? this.principalPayment : (this.principalPayment = PrincipalPayments.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public SettlementTerms.SettlementTermsBuilder getSettlementTerms() {
            return this.settlementTerms;
        }

        @Override
        public SettlementTerms.SettlementTermsBuilder getOrCreateSettlementTerms() {
            SettlementTerms.SettlementTermsBuilder result = this.settlementTerms != null ? this.settlementTerms : (this.settlementTerms = SettlementTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public PayoutBaseBuilder setPayerReceiver(PayerReceiver _payerReceiver) {
            this.payerReceiver = _payerReceiver == null ? null : _payerReceiver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public PayoutBaseBuilder setPriceQuantity(ResolvablePriceQuantity _priceQuantity) {
            this.priceQuantity = _priceQuantity == null ? null : _priceQuantity.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public PayoutBaseBuilder setPrincipalPayment(PrincipalPayments _principalPayment) {
            this.principalPayment = _principalPayment == null ? null : _principalPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public PayoutBaseBuilder setSettlementTerms(SettlementTerms _settlementTerms) {
            this.settlementTerms = _settlementTerms == null ? null : _settlementTerms.toBuilder();
            return this;
        }

        @Override
        public PayoutBase build() {
            return new PayoutBaseImpl(this);
        }

        @Override
        public PayoutBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public PayoutBaseBuilder prune() {
            if (this.payerReceiver != null && !this.payerReceiver.prune().hasData()) {
                this.payerReceiver = null;
            }
            if (this.priceQuantity != null && !this.priceQuantity.prune().hasData()) {
                this.priceQuantity = null;
            }
            if (this.principalPayment != null && !this.principalPayment.prune().hasData()) {
                this.principalPayment = null;
            }
            if (this.settlementTerms != null && !this.settlementTerms.prune().hasData()) {
                this.settlementTerms = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPayerReceiver() != null && this.getPayerReceiver().hasData()) {
                return true;
            }
            if (this.getPriceQuantity() != null && this.getPriceQuantity().hasData()) {
                return true;
            }
            if (this.getPrincipalPayment() != null && this.getPrincipalPayment().hasData()) {
                return true;
            }
            return this.getSettlementTerms() != null && this.getSettlementTerms().hasData();
        }

        public PayoutBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PayoutBaseBuilder o = (PayoutBaseBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiver(), (RosettaModelObjectBuilder)o.getPayerReceiver(), this::setPayerReceiver);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPriceQuantity(), (RosettaModelObjectBuilder)o.getPriceQuantity(), this::setPriceQuantity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrincipalPayment(), (RosettaModelObjectBuilder)o.getPrincipalPayment(), this::setPrincipalPayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementTerms(), (RosettaModelObjectBuilder)o.getSettlementTerms(), this::setSettlementTerms);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PayoutBase _that = this.getType().cast(o);
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!Objects.equals(this.principalPayment, _that.getPrincipalPayment())) {
                return false;
            }
            return Objects.equals(this.settlementTerms, _that.getSettlementTerms());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.principalPayment != null ? this.principalPayment.hashCode() : 0);
            _result = 31 * _result + (this.settlementTerms != null ? this.settlementTerms.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PayoutBaseBuilder {payerReceiver=" + this.payerReceiver + ", priceQuantity=" + this.priceQuantity + ", principalPayment=" + this.principalPayment + ", settlementTerms=" + this.settlementTerms + '}';
        }
    }

    public static class PayoutBaseImpl
    implements PayoutBase {
        private final PayerReceiver payerReceiver;
        private final ResolvablePriceQuantity priceQuantity;
        private final PrincipalPayments principalPayment;
        private final SettlementTerms settlementTerms;

        protected PayoutBaseImpl(PayoutBaseBuilder builder) {
            this.payerReceiver = Optional.ofNullable(builder.getPayerReceiver()).map(f -> f.build()).orElse(null);
            this.priceQuantity = Optional.ofNullable(builder.getPriceQuantity()).map(f -> f.build()).orElse(null);
            this.principalPayment = Optional.ofNullable(builder.getPrincipalPayment()).map(f -> f.build()).orElse(null);
            this.settlementTerms = Optional.ofNullable(builder.getSettlementTerms()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payerReceiver")
        @RuneAttribute(value="payerReceiver")
        public PayerReceiver getPayerReceiver() {
            return this.payerReceiver;
        }

        @Override
        @RosettaAttribute(value="priceQuantity")
        @RuneAttribute(value="priceQuantity")
        public ResolvablePriceQuantity getPriceQuantity() {
            return this.priceQuantity;
        }

        @Override
        @RosettaAttribute(value="principalPayment")
        @RuneAttribute(value="principalPayment")
        public PrincipalPayments getPrincipalPayment() {
            return this.principalPayment;
        }

        @Override
        @RosettaAttribute(value="settlementTerms")
        @RuneAttribute(value="settlementTerms")
        public SettlementTerms getSettlementTerms() {
            return this.settlementTerms;
        }

        @Override
        public PayoutBase build() {
            return this;
        }

        @Override
        public PayoutBaseBuilder toBuilder() {
            PayoutBaseBuilder builder = PayoutBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PayoutBaseBuilder builder) {
            Optional.ofNullable(this.getPayerReceiver()).ifPresent(builder::setPayerReceiver);
            Optional.ofNullable(this.getPriceQuantity()).ifPresent(builder::setPriceQuantity);
            Optional.ofNullable(this.getPrincipalPayment()).ifPresent(builder::setPrincipalPayment);
            Optional.ofNullable(this.getSettlementTerms()).ifPresent(builder::setSettlementTerms);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PayoutBase _that = this.getType().cast(o);
            if (!Objects.equals(this.payerReceiver, _that.getPayerReceiver())) {
                return false;
            }
            if (!Objects.equals(this.priceQuantity, _that.getPriceQuantity())) {
                return false;
            }
            if (!Objects.equals(this.principalPayment, _that.getPrincipalPayment())) {
                return false;
            }
            return Objects.equals(this.settlementTerms, _that.getSettlementTerms());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.payerReceiver != null ? this.payerReceiver.hashCode() : 0);
            _result = 31 * _result + (this.priceQuantity != null ? this.priceQuantity.hashCode() : 0);
            _result = 31 * _result + (this.principalPayment != null ? this.principalPayment.hashCode() : 0);
            _result = 31 * _result + (this.settlementTerms != null ? this.settlementTerms.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PayoutBase {payerReceiver=" + this.payerReceiver + ", priceQuantity=" + this.priceQuantity + ", principalPayment=" + this.principalPayment + ", settlementTerms=" + this.settlementTerms + '}';
        }
    }

    public static interface PayoutBaseBuilder
    extends PayoutBase,
    RosettaModelObjectBuilder {
        public PayerReceiver.PayerReceiverBuilder getOrCreatePayerReceiver();

        @Override
        public PayerReceiver.PayerReceiverBuilder getPayerReceiver();

        public ResolvablePriceQuantity.ResolvablePriceQuantityBuilder getOrCreatePriceQuantity();

        @Override
        public ResolvablePriceQuantity.ResolvablePriceQuantityBuilder getPriceQuantity();

        public PrincipalPayments.PrincipalPaymentsBuilder getOrCreatePrincipalPayment();

        @Override
        public PrincipalPayments.PrincipalPaymentsBuilder getPrincipalPayment();

        public SettlementTerms.SettlementTermsBuilder getOrCreateSettlementTerms();

        @Override
        public SettlementTerms.SettlementTermsBuilder getSettlementTerms();

        public PayoutBaseBuilder setPayerReceiver(PayerReceiver var1);

        public PayoutBaseBuilder setPriceQuantity(ResolvablePriceQuantity var1);

        public PayoutBaseBuilder setPrincipalPayment(PrincipalPayments var1);

        public PayoutBaseBuilder setSettlementTerms(SettlementTerms var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("payerReceiver"), processor, PayerReceiver.PayerReceiverBuilder.class, this.getPayerReceiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceQuantity"), processor, ResolvablePriceQuantity.ResolvablePriceQuantityBuilder.class, this.getPriceQuantity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("principalPayment"), processor, PrincipalPayments.PrincipalPaymentsBuilder.class, this.getPrincipalPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementTerms"), processor, SettlementTerms.SettlementTermsBuilder.class, this.getSettlementTerms(), new AttributeMeta[0]);
        }

        public PayoutBaseBuilder prune();
    }
}

