/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template;

import cdm.base.staticdata.asset.common.AssetPool;
import cdm.base.staticdata.asset.common.Commodity;
import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaCommodity;
import cdm.product.asset.ForeignExchange;
import cdm.product.template.Basket;
import cdm.product.template.ContractualProduct;
import cdm.product.template.meta.ProductMeta;
import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.annotations.RuneScopedAttributeReference;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.metafields.MetaFields;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Product", builder=ProductBuilderImpl.class, version="5.24.0")
@RuneDataType(value="Product", model="cdm", builder=ProductBuilderImpl.class, version="5.24.0")
public interface Product
extends RosettaModelObject,
GlobalKey {
    public static final ProductMeta metaData = new ProductMeta();

    public ContractualProduct getContractualProduct();

    public Index getIndex();

    public Loan getLoan();

    public AssetPool getAssetPool();

    public ForeignExchange getForeignExchange();

    public ReferenceWithMetaCommodity getCommodity();

    public Security getSecurity();

    public Basket getBasket();

    public MetaFields getMeta();

    public Product build();

    public ProductBuilder toBuilder();

    public static ProductBuilder builder() {
        return new ProductBuilderImpl();
    }

    default public RosettaMetaData<? extends Product> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Product> getType() {
        return Product.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("contractualProduct"), processor, ContractualProduct.class, this.getContractualProduct(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("index"), processor, Index.class, this.getIndex(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loan"), processor, Loan.class, this.getLoan(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("assetPool"), processor, AssetPool.class, this.getAssetPool(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("foreignExchange"), processor, ForeignExchange.class, this.getForeignExchange(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("commodity"), processor, ReferenceWithMetaCommodity.class, this.getCommodity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("security"), processor, Security.class, this.getSecurity(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basket"), processor, Basket.class, this.getBasket(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("meta"), processor, MetaFields.class, (RosettaModelObject)this.getMeta(), new AttributeMeta[0]);
    }

    public static class ProductBuilderImpl
    implements ProductBuilder {
        protected ContractualProduct.ContractualProductBuilder contractualProduct;
        protected Index.IndexBuilder index;
        protected Loan.LoanBuilder loan;
        protected AssetPool.AssetPoolBuilder assetPool;
        protected ForeignExchange.ForeignExchangeBuilder foreignExchange;
        protected ReferenceWithMetaCommodity.ReferenceWithMetaCommodityBuilder commodity;
        protected Security.SecurityBuilder security;
        protected Basket.BasketBuilder basket;
        protected MetaFields.MetaFieldsBuilder meta;

        @Override
        @RosettaAttribute(value="contractualProduct")
        @RuneAttribute(value="contractualProduct")
        public ContractualProduct.ContractualProductBuilder getContractualProduct() {
            return this.contractualProduct;
        }

        @Override
        public ContractualProduct.ContractualProductBuilder getOrCreateContractualProduct() {
            ContractualProduct.ContractualProductBuilder result = this.contractualProduct != null ? this.contractualProduct : (this.contractualProduct = ContractualProduct.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="index")
        @RuneAttribute(value="index")
        public Index.IndexBuilder getIndex() {
            return this.index;
        }

        @Override
        public Index.IndexBuilder getOrCreateIndex() {
            Index.IndexBuilder result = this.index != null ? this.index : (this.index = Index.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="loan")
        @RuneAttribute(value="loan")
        public Loan.LoanBuilder getLoan() {
            return this.loan;
        }

        @Override
        public Loan.LoanBuilder getOrCreateLoan() {
            Loan.LoanBuilder result = this.loan != null ? this.loan : (this.loan = Loan.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assetPool")
        @RuneAttribute(value="assetPool")
        public AssetPool.AssetPoolBuilder getAssetPool() {
            return this.assetPool;
        }

        @Override
        public AssetPool.AssetPoolBuilder getOrCreateAssetPool() {
            AssetPool.AssetPoolBuilder result = this.assetPool != null ? this.assetPool : (this.assetPool = AssetPool.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="foreignExchange")
        @RuneAttribute(value="foreignExchange")
        public ForeignExchange.ForeignExchangeBuilder getForeignExchange() {
            return this.foreignExchange;
        }

        @Override
        public ForeignExchange.ForeignExchangeBuilder getOrCreateForeignExchange() {
            ForeignExchange.ForeignExchangeBuilder result = this.foreignExchange != null ? this.foreignExchange : (this.foreignExchange = ForeignExchange.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="commodity")
        @RuneAttribute(value="commodity")
        @RuneScopedAttributeReference
        public ReferenceWithMetaCommodity.ReferenceWithMetaCommodityBuilder getCommodity() {
            return this.commodity;
        }

        @Override
        public ReferenceWithMetaCommodity.ReferenceWithMetaCommodityBuilder getOrCreateCommodity() {
            ReferenceWithMetaCommodity.ReferenceWithMetaCommodityBuilder result = this.commodity != null ? this.commodity : (this.commodity = ReferenceWithMetaCommodity.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="security")
        @RuneAttribute(value="security")
        public Security.SecurityBuilder getSecurity() {
            return this.security;
        }

        @Override
        public Security.SecurityBuilder getOrCreateSecurity() {
            Security.SecurityBuilder result = this.security != null ? this.security : (this.security = Security.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="basket")
        @RuneAttribute(value="basket")
        public Basket.BasketBuilder getBasket() {
            return this.basket;
        }

        @Override
        public Basket.BasketBuilder getOrCreateBasket() {
            Basket.BasketBuilder result = this.basket != null ? this.basket : (this.basket = Basket.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields.MetaFieldsBuilder getMeta() {
            return this.meta;
        }

        @Override
        public MetaFields.MetaFieldsBuilder getOrCreateMeta() {
            MetaFields.MetaFieldsBuilder result = this.meta != null ? this.meta : (this.meta = MetaFields.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="contractualProduct")
        @RuneAttribute(value="contractualProduct")
        public ProductBuilder setContractualProduct(ContractualProduct _contractualProduct) {
            this.contractualProduct = _contractualProduct == null ? null : _contractualProduct.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="index")
        @RuneAttribute(value="index")
        public ProductBuilder setIndex(Index _index) {
            this.index = _index == null ? null : _index.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loan")
        @RuneAttribute(value="loan")
        public ProductBuilder setLoan(Loan _loan) {
            this.loan = _loan == null ? null : _loan.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetPool")
        @RuneAttribute(value="assetPool")
        public ProductBuilder setAssetPool(AssetPool _assetPool) {
            this.assetPool = _assetPool == null ? null : _assetPool.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="foreignExchange")
        @RuneAttribute(value="foreignExchange")
        public ProductBuilder setForeignExchange(ForeignExchange _foreignExchange) {
            this.foreignExchange = _foreignExchange == null ? null : _foreignExchange.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="commodity")
        @RuneAttribute(value="commodity")
        @RuneScopedAttributeReference
        public ProductBuilder setCommodity(ReferenceWithMetaCommodity _commodity) {
            this.commodity = _commodity == null ? null : _commodity.toBuilder();
            return this;
        }

        @Override
        public ProductBuilder setCommodityValue(Commodity _commodity) {
            this.getOrCreateCommodity().setValue(_commodity);
            return this;
        }

        @Override
        @RosettaAttribute(value="security")
        @RuneAttribute(value="security")
        public ProductBuilder setSecurity(Security _security) {
            this.security = _security == null ? null : _security.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="basket")
        @RuneAttribute(value="basket")
        public ProductBuilder setBasket(Basket _basket) {
            this.basket = _basket == null ? null : _basket.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public ProductBuilder setMeta(MetaFields _meta) {
            this.meta = _meta == null ? null : _meta.toBuilder();
            return this;
        }

        @Override
        public Product build() {
            return new ProductImpl(this);
        }

        @Override
        public ProductBuilder toBuilder() {
            return this;
        }

        @Override
        public ProductBuilder prune() {
            if (this.contractualProduct != null && !this.contractualProduct.prune().hasData()) {
                this.contractualProduct = null;
            }
            if (this.index != null && !this.index.prune().hasData()) {
                this.index = null;
            }
            if (this.loan != null && !this.loan.prune().hasData()) {
                this.loan = null;
            }
            if (this.assetPool != null && !this.assetPool.prune().hasData()) {
                this.assetPool = null;
            }
            if (this.foreignExchange != null && !this.foreignExchange.prune().hasData()) {
                this.foreignExchange = null;
            }
            if (this.commodity != null && !this.commodity.prune().hasData()) {
                this.commodity = null;
            }
            if (this.security != null && !this.security.prune().hasData()) {
                this.security = null;
            }
            if (this.basket != null && !this.basket.prune().hasData()) {
                this.basket = null;
            }
            if (this.meta != null && !this.meta.prune().hasData()) {
                this.meta = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getContractualProduct() != null && this.getContractualProduct().hasData()) {
                return true;
            }
            if (this.getIndex() != null && this.getIndex().hasData()) {
                return true;
            }
            if (this.getLoan() != null && this.getLoan().hasData()) {
                return true;
            }
            if (this.getAssetPool() != null && this.getAssetPool().hasData()) {
                return true;
            }
            if (this.getForeignExchange() != null && this.getForeignExchange().hasData()) {
                return true;
            }
            if (this.getCommodity() != null && this.getCommodity().hasData()) {
                return true;
            }
            if (this.getSecurity() != null && this.getSecurity().hasData()) {
                return true;
            }
            return this.getBasket() != null && this.getBasket().hasData();
        }

        public ProductBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ProductBuilder o = (ProductBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getContractualProduct(), (RosettaModelObjectBuilder)o.getContractualProduct(), this::setContractualProduct);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIndex(), (RosettaModelObjectBuilder)o.getIndex(), this::setIndex);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoan(), (RosettaModelObjectBuilder)o.getLoan(), this::setLoan);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAssetPool(), (RosettaModelObjectBuilder)o.getAssetPool(), this::setAssetPool);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getForeignExchange(), (RosettaModelObjectBuilder)o.getForeignExchange(), this::setForeignExchange);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCommodity(), (RosettaModelObjectBuilder)o.getCommodity(), this::setCommodity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSecurity(), (RosettaModelObjectBuilder)o.getSecurity(), this::setSecurity);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBasket(), (RosettaModelObjectBuilder)o.getBasket(), this::setBasket);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMeta(), (RosettaModelObjectBuilder)o.getMeta(), this::setMeta);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Product _that = this.getType().cast(o);
            if (!Objects.equals(this.contractualProduct, _that.getContractualProduct())) {
                return false;
            }
            if (!Objects.equals(this.index, _that.getIndex())) {
                return false;
            }
            if (!Objects.equals(this.loan, _that.getLoan())) {
                return false;
            }
            if (!Objects.equals(this.assetPool, _that.getAssetPool())) {
                return false;
            }
            if (!Objects.equals(this.foreignExchange, _that.getForeignExchange())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!Objects.equals(this.security, _that.getSecurity())) {
                return false;
            }
            if (!Objects.equals(this.basket, _that.getBasket())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.contractualProduct != null ? this.contractualProduct.hashCode() : 0);
            _result = 31 * _result + (this.index != null ? this.index.hashCode() : 0);
            _result = 31 * _result + (this.loan != null ? this.loan.hashCode() : 0);
            _result = 31 * _result + (this.assetPool != null ? this.assetPool.hashCode() : 0);
            _result = 31 * _result + (this.foreignExchange != null ? this.foreignExchange.hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.security != null ? this.security.hashCode() : 0);
            _result = 31 * _result + (this.basket != null ? this.basket.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductBuilder {contractualProduct=" + this.contractualProduct + ", index=" + this.index + ", loan=" + this.loan + ", assetPool=" + this.assetPool + ", foreignExchange=" + this.foreignExchange + ", commodity=" + this.commodity + ", security=" + this.security + ", basket=" + this.basket + ", meta=" + this.meta + '}';
        }
    }

    public static class ProductImpl
    implements Product {
        private final ContractualProduct contractualProduct;
        private final Index index;
        private final Loan loan;
        private final AssetPool assetPool;
        private final ForeignExchange foreignExchange;
        private final ReferenceWithMetaCommodity commodity;
        private final Security security;
        private final Basket basket;
        private final MetaFields meta;

        protected ProductImpl(ProductBuilder builder) {
            this.contractualProduct = Optional.ofNullable(builder.getContractualProduct()).map(f -> f.build()).orElse(null);
            this.index = Optional.ofNullable(builder.getIndex()).map(f -> f.build()).orElse(null);
            this.loan = Optional.ofNullable(builder.getLoan()).map(f -> f.build()).orElse(null);
            this.assetPool = Optional.ofNullable(builder.getAssetPool()).map(f -> f.build()).orElse(null);
            this.foreignExchange = Optional.ofNullable(builder.getForeignExchange()).map(f -> f.build()).orElse(null);
            this.commodity = Optional.ofNullable(builder.getCommodity()).map(f -> f.build()).orElse(null);
            this.security = Optional.ofNullable(builder.getSecurity()).map(f -> f.build()).orElse(null);
            this.basket = Optional.ofNullable(builder.getBasket()).map(f -> f.build()).orElse(null);
            this.meta = Optional.ofNullable(builder.getMeta()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="contractualProduct")
        @RuneAttribute(value="contractualProduct")
        public ContractualProduct getContractualProduct() {
            return this.contractualProduct;
        }

        @Override
        @RosettaAttribute(value="index")
        @RuneAttribute(value="index")
        public Index getIndex() {
            return this.index;
        }

        @Override
        @RosettaAttribute(value="loan")
        @RuneAttribute(value="loan")
        public Loan getLoan() {
            return this.loan;
        }

        @Override
        @RosettaAttribute(value="assetPool")
        @RuneAttribute(value="assetPool")
        public AssetPool getAssetPool() {
            return this.assetPool;
        }

        @Override
        @RosettaAttribute(value="foreignExchange")
        @RuneAttribute(value="foreignExchange")
        public ForeignExchange getForeignExchange() {
            return this.foreignExchange;
        }

        @Override
        @RosettaAttribute(value="commodity")
        @RuneAttribute(value="commodity")
        @RuneScopedAttributeReference
        public ReferenceWithMetaCommodity getCommodity() {
            return this.commodity;
        }

        @Override
        @RosettaAttribute(value="security")
        @RuneAttribute(value="security")
        public Security getSecurity() {
            return this.security;
        }

        @Override
        @RosettaAttribute(value="basket")
        @RuneAttribute(value="basket")
        public Basket getBasket() {
            return this.basket;
        }

        @Override
        @RosettaAttribute(value="meta")
        @RuneAttribute(value="meta")
        @RuneMetaType
        public MetaFields getMeta() {
            return this.meta;
        }

        @Override
        public Product build() {
            return this;
        }

        @Override
        public ProductBuilder toBuilder() {
            ProductBuilder builder = Product.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ProductBuilder builder) {
            Optional.ofNullable(this.getContractualProduct()).ifPresent(builder::setContractualProduct);
            Optional.ofNullable(this.getIndex()).ifPresent(builder::setIndex);
            Optional.ofNullable(this.getLoan()).ifPresent(builder::setLoan);
            Optional.ofNullable(this.getAssetPool()).ifPresent(builder::setAssetPool);
            Optional.ofNullable(this.getForeignExchange()).ifPresent(builder::setForeignExchange);
            Optional.ofNullable(this.getCommodity()).ifPresent(builder::setCommodity);
            Optional.ofNullable(this.getSecurity()).ifPresent(builder::setSecurity);
            Optional.ofNullable(this.getBasket()).ifPresent(builder::setBasket);
            Optional.ofNullable(this.getMeta()).ifPresent(builder::setMeta);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Product _that = this.getType().cast(o);
            if (!Objects.equals(this.contractualProduct, _that.getContractualProduct())) {
                return false;
            }
            if (!Objects.equals(this.index, _that.getIndex())) {
                return false;
            }
            if (!Objects.equals(this.loan, _that.getLoan())) {
                return false;
            }
            if (!Objects.equals(this.assetPool, _that.getAssetPool())) {
                return false;
            }
            if (!Objects.equals(this.foreignExchange, _that.getForeignExchange())) {
                return false;
            }
            if (!Objects.equals(this.commodity, _that.getCommodity())) {
                return false;
            }
            if (!Objects.equals(this.security, _that.getSecurity())) {
                return false;
            }
            if (!Objects.equals(this.basket, _that.getBasket())) {
                return false;
            }
            return Objects.equals(this.meta, _that.getMeta());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.contractualProduct != null ? this.contractualProduct.hashCode() : 0);
            _result = 31 * _result + (this.index != null ? this.index.hashCode() : 0);
            _result = 31 * _result + (this.loan != null ? this.loan.hashCode() : 0);
            _result = 31 * _result + (this.assetPool != null ? this.assetPool.hashCode() : 0);
            _result = 31 * _result + (this.foreignExchange != null ? this.foreignExchange.hashCode() : 0);
            _result = 31 * _result + (this.commodity != null ? this.commodity.hashCode() : 0);
            _result = 31 * _result + (this.security != null ? this.security.hashCode() : 0);
            _result = 31 * _result + (this.basket != null ? this.basket.hashCode() : 0);
            _result = 31 * _result + (this.meta != null ? this.meta.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Product {contractualProduct=" + this.contractualProduct + ", index=" + this.index + ", loan=" + this.loan + ", assetPool=" + this.assetPool + ", foreignExchange=" + this.foreignExchange + ", commodity=" + this.commodity + ", security=" + this.security + ", basket=" + this.basket + ", meta=" + this.meta + '}';
        }
    }

    public static interface ProductBuilder
    extends Product,
    RosettaModelObjectBuilder,
    GlobalKey.GlobalKeyBuilder {
        public ContractualProduct.ContractualProductBuilder getOrCreateContractualProduct();

        @Override
        public ContractualProduct.ContractualProductBuilder getContractualProduct();

        public Index.IndexBuilder getOrCreateIndex();

        @Override
        public Index.IndexBuilder getIndex();

        public Loan.LoanBuilder getOrCreateLoan();

        @Override
        public Loan.LoanBuilder getLoan();

        public AssetPool.AssetPoolBuilder getOrCreateAssetPool();

        @Override
        public AssetPool.AssetPoolBuilder getAssetPool();

        public ForeignExchange.ForeignExchangeBuilder getOrCreateForeignExchange();

        @Override
        public ForeignExchange.ForeignExchangeBuilder getForeignExchange();

        public ReferenceWithMetaCommodity.ReferenceWithMetaCommodityBuilder getOrCreateCommodity();

        @Override
        public ReferenceWithMetaCommodity.ReferenceWithMetaCommodityBuilder getCommodity();

        public Security.SecurityBuilder getOrCreateSecurity();

        @Override
        public Security.SecurityBuilder getSecurity();

        public Basket.BasketBuilder getOrCreateBasket();

        @Override
        public Basket.BasketBuilder getBasket();

        public MetaFields.MetaFieldsBuilder getOrCreateMeta();

        public MetaFields.MetaFieldsBuilder getMeta();

        public ProductBuilder setContractualProduct(ContractualProduct var1);

        public ProductBuilder setIndex(Index var1);

        public ProductBuilder setLoan(Loan var1);

        public ProductBuilder setAssetPool(AssetPool var1);

        public ProductBuilder setForeignExchange(ForeignExchange var1);

        public ProductBuilder setCommodity(ReferenceWithMetaCommodity var1);

        public ProductBuilder setCommodityValue(Commodity var1);

        public ProductBuilder setSecurity(Security var1);

        public ProductBuilder setBasket(Basket var1);

        public ProductBuilder setMeta(MetaFields var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("contractualProduct"), processor, ContractualProduct.ContractualProductBuilder.class, this.getContractualProduct(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("index"), processor, Index.IndexBuilder.class, this.getIndex(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loan"), processor, Loan.LoanBuilder.class, this.getLoan(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("assetPool"), processor, AssetPool.AssetPoolBuilder.class, this.getAssetPool(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("foreignExchange"), processor, ForeignExchange.ForeignExchangeBuilder.class, this.getForeignExchange(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("commodity"), processor, ReferenceWithMetaCommodity.ReferenceWithMetaCommodityBuilder.class, this.getCommodity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("security"), processor, Security.SecurityBuilder.class, this.getSecurity(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basket"), processor, Basket.BasketBuilder.class, this.getBasket(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("meta"), processor, MetaFields.MetaFieldsBuilder.class, (RosettaModelObjectBuilder)this.getMeta(), new AttributeMeta[0]);
        }

        public ProductBuilder prune();
    }
}

