/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.metafields;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.metafields.ReferenceWithMetaDateMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ReferenceWithMetaDate", builder=ReferenceWithMetaDateBuilderImpl.class, version="0.0.0")
@RuneDataType(value="ReferenceWithMetaDate", model="com", builder=ReferenceWithMetaDateBuilderImpl.class, version="0.0.0")
public interface ReferenceWithMetaDate
extends RosettaModelObject,
ReferenceWithMeta<Date> {
    public static final ReferenceWithMetaDateMeta metaData = new ReferenceWithMetaDateMeta();

    public Date getValue();

    public String getGlobalReference();

    public String getExternalReference();

    public Reference getReference();

    public ReferenceWithMetaDate build();

    public ReferenceWithMetaDateBuilder toBuilder();

    public static ReferenceWithMetaDateBuilder builder() {
        return new ReferenceWithMetaDateBuilderImpl();
    }

    default public RosettaMetaData<? extends ReferenceWithMetaDate> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReferenceWithMetaDate> getType() {
        return ReferenceWithMetaDate.class;
    }

    default public Class<Date> getValueType() {
        return Date.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("value"), Date.class, (Object)this.getValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("globalReference"), String.class, (Object)this.getGlobalReference(), (RosettaModelObject)this, new AttributeMeta[]{AttributeMeta.META});
        processor.processBasic(path.newSubPath("externalReference"), String.class, (Object)this.getExternalReference(), (RosettaModelObject)this, new AttributeMeta[]{AttributeMeta.META});
        this.processRosetta(path.newSubPath("reference"), processor, Reference.class, (RosettaModelObject)this.getReference(), new AttributeMeta[0]);
    }

    public static class ReferenceWithMetaDateBuilderImpl
    implements ReferenceWithMetaDateBuilder {
        protected Date value;
        protected String globalReference;
        protected String externalReference;
        protected Reference.ReferenceBuilder reference;

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="@data")
        public Date getValue() {
            return this.value;
        }

        @Override
        @RosettaAttribute(value="globalReference")
        @RuneAttribute(value="@ref")
        public String getGlobalReference() {
            return this.globalReference;
        }

        @Override
        @RosettaAttribute(value="externalReference")
        @RuneAttribute(value="@ref:external")
        public String getExternalReference() {
            return this.externalReference;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="@ref:scoped")
        @RuneMetaType
        public Reference.ReferenceBuilder getReference() {
            return this.reference;
        }

        @Override
        public Reference.ReferenceBuilder getOrCreateReference() {
            Reference.ReferenceBuilder result = this.reference != null ? this.reference : (this.reference = Reference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="@data")
        public ReferenceWithMetaDateBuilder setValue(Date _value) {
            this.value = _value == null ? null : _value;
            return this;
        }

        @Override
        @RosettaAttribute(value="globalReference")
        @RuneAttribute(value="@ref")
        public ReferenceWithMetaDateBuilder setGlobalReference(String _globalReference) {
            this.globalReference = _globalReference == null ? null : _globalReference;
            return this;
        }

        @Override
        @RosettaAttribute(value="externalReference")
        @RuneAttribute(value="@ref:external")
        public ReferenceWithMetaDateBuilder setExternalReference(String _externalReference) {
            this.externalReference = _externalReference == null ? null : _externalReference;
            return this;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="@ref:scoped")
        @RuneMetaType
        public ReferenceWithMetaDateBuilder setReference(Reference _reference) {
            this.reference = _reference == null ? null : _reference.toBuilder();
            return this;
        }

        @Override
        public ReferenceWithMetaDate build() {
            return new ReferenceWithMetaDateImpl(this);
        }

        @Override
        public ReferenceWithMetaDateBuilder toBuilder() {
            return this;
        }

        @Override
        public ReferenceWithMetaDateBuilder prune() {
            if (this.reference != null && !this.reference.prune().hasData()) {
                this.reference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getValue() != null) {
                return true;
            }
            if (this.getGlobalReference() != null) {
                return true;
            }
            if (this.getExternalReference() != null) {
                return true;
            }
            return this.getReference() != null && this.getReference().hasData();
        }

        public ReferenceWithMetaDateBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ReferenceWithMetaDateBuilder o = (ReferenceWithMetaDateBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReference(), (RosettaModelObjectBuilder)o.getReference(), this::setReference);
            merger.mergeBasic((Object)this.getValue(), (Object)((Date)o.getValue()), this::setValue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGlobalReference(), (Object)o.getGlobalReference(), this::setGlobalReference, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExternalReference(), (Object)o.getExternalReference(), this::setExternalReference, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceWithMetaDate _that = this.getType().cast(o);
            if (!Objects.equals(this.value, _that.getValue())) {
                return false;
            }
            if (!Objects.equals(this.globalReference, _that.getGlobalReference())) {
                return false;
            }
            if (!Objects.equals(this.externalReference, _that.getExternalReference())) {
                return false;
            }
            return Objects.equals(this.reference, _that.getReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            _result = 31 * _result + (this.globalReference != null ? this.globalReference.hashCode() : 0);
            _result = 31 * _result + (this.externalReference != null ? this.externalReference.hashCode() : 0);
            _result = 31 * _result + (this.reference != null ? this.reference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceWithMetaDateBuilder {value=" + this.value + ", globalReference=" + this.globalReference + ", externalReference=" + this.externalReference + ", reference=" + this.reference + '}';
        }
    }

    public static class ReferenceWithMetaDateImpl
    implements ReferenceWithMetaDate {
        private final Date value;
        private final String globalReference;
        private final String externalReference;
        private final Reference reference;

        protected ReferenceWithMetaDateImpl(ReferenceWithMetaDateBuilder builder) {
            this.value = (Date)builder.getValue();
            this.globalReference = builder.getGlobalReference();
            this.externalReference = builder.getExternalReference();
            this.reference = Optional.ofNullable(builder.getReference()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="@data")
        public Date getValue() {
            return this.value;
        }

        @Override
        @RosettaAttribute(value="globalReference")
        @RuneAttribute(value="@ref")
        public String getGlobalReference() {
            return this.globalReference;
        }

        @Override
        @RosettaAttribute(value="externalReference")
        @RuneAttribute(value="@ref:external")
        public String getExternalReference() {
            return this.externalReference;
        }

        @Override
        @RosettaAttribute(value="address")
        @RuneAttribute(value="@ref:scoped")
        @RuneMetaType
        public Reference getReference() {
            return this.reference;
        }

        @Override
        public ReferenceWithMetaDate build() {
            return this;
        }

        @Override
        public ReferenceWithMetaDateBuilder toBuilder() {
            ReferenceWithMetaDateBuilder builder = ReferenceWithMetaDate.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReferenceWithMetaDateBuilder builder) {
            Optional.ofNullable(this.getValue()).ifPresent(builder::setValue);
            Optional.ofNullable(this.getGlobalReference()).ifPresent(builder::setGlobalReference);
            Optional.ofNullable(this.getExternalReference()).ifPresent(builder::setExternalReference);
            Optional.ofNullable(this.getReference()).ifPresent(builder::setReference);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ReferenceWithMetaDate _that = this.getType().cast(o);
            if (!Objects.equals(this.value, _that.getValue())) {
                return false;
            }
            if (!Objects.equals(this.globalReference, _that.getGlobalReference())) {
                return false;
            }
            if (!Objects.equals(this.externalReference, _that.getExternalReference())) {
                return false;
            }
            return Objects.equals(this.reference, _that.getReference());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            _result = 31 * _result + (this.globalReference != null ? this.globalReference.hashCode() : 0);
            _result = 31 * _result + (this.externalReference != null ? this.externalReference.hashCode() : 0);
            _result = 31 * _result + (this.reference != null ? this.reference.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ReferenceWithMetaDate {value=" + this.value + ", globalReference=" + this.globalReference + ", externalReference=" + this.externalReference + ", reference=" + this.reference + '}';
        }
    }

    public static interface ReferenceWithMetaDateBuilder
    extends ReferenceWithMetaDate,
    RosettaModelObjectBuilder,
    ReferenceWithMeta.ReferenceWithMetaBuilder<Date> {
        public Reference.ReferenceBuilder getOrCreateReference();

        public Reference.ReferenceBuilder getReference();

        public ReferenceWithMetaDateBuilder setValue(Date var1);

        public ReferenceWithMetaDateBuilder setGlobalReference(String var1);

        public ReferenceWithMetaDateBuilder setExternalReference(String var1);

        public ReferenceWithMetaDateBuilder setReference(Reference var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("value"), Date.class, (Object)((Date)this.getValue()), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("globalReference"), String.class, (Object)this.getGlobalReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[]{AttributeMeta.META});
            processor.processBasic(path.newSubPath("externalReference"), String.class, (Object)this.getExternalReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[]{AttributeMeta.META});
            this.processRosetta(path.newSubPath("reference"), processor, Reference.ReferenceBuilder.class, (RosettaModelObjectBuilder)this.getReference(), new AttributeMeta[0]);
        }

        public ReferenceWithMetaDateBuilder prune();
    }
}

