/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta;

import com.google.common.collect.Iterables;
import com.regnosys.rosetta.rosetta.ExternalAnnotationSource;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumeration;
import com.regnosys.rosetta.rosetta.RosettaExternalClass;
import com.regnosys.rosetta.rosetta.RosettaExternalRuleSource;
import com.regnosys.rosetta.rosetta.RosettaExternalSynonymSource;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaRecordType;
import com.regnosys.rosetta.rosetta.RosettaSynonym;
import com.regnosys.rosetta.rosetta.RosettaSynonymSource;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.simple.Annotated;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.AnnotationRef;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Condition;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RMetaAttribute;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.utils.RosettaConfigExtension;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class RosettaEcoreUtil {
    @Inject
    private RBuiltinTypeService builtins;
    @Inject
    @Extension
    private RosettaConfigExtension configs;

    public boolean isResolved(EObject obj) {
        return obj != null && !obj.eIsProxy();
    }

    public Iterable<? extends RosettaFeature> allFeatures(RMetaAnnotatedType t, EObject context) {
        Iterable _xblockexpression = null;
        List<Object> _xifexpression = null;
        _xifexpression = t == this.builtins.NOTHING_WITH_ANY_META ? CollectionLiterals.newArrayList() : this.getMetaDescriptions(t, context);
        ArrayList metas = _xifexpression;
        RType _rType = t.getRType();
        Resource _eResource = null;
        if (context != null) {
            _eResource = context.eResource();
        }
        ResourceSet _resourceSet = null;
        if (_eResource != null) {
            _resourceSet = _eResource.getResourceSet();
        }
        Iterable<? extends RosettaFeature> _allFeatures = this.allFeatures(_rType, _resourceSet);
        _xblockexpression = Iterables.concat(_allFeatures, (Iterable)metas);
        return _xblockexpression;
    }

    public Iterable<? extends RosettaFeature> allFeatures(RMetaAnnotatedType t, EObject context, Predicate<RType> restrictType) {
        Iterable _xblockexpression = null;
        List<RosettaFeature> metas = this.getMetaDescriptions(t, context);
        Iterable<? extends RosettaFeature> _allFeatures = this.allFeatures(t.getRType(), context, restrictType);
        _xblockexpression = Iterables.concat(_allFeatures, metas);
        return _xblockexpression;
    }

    public Iterable<? extends RosettaFeature> allFeatures(RType t, EObject context) {
        Resource _eResource = null;
        if (context != null) {
            _eResource = context.eResource();
        }
        ResourceSet _resourceSet = null;
        if (_eResource != null) {
            _resourceSet = _eResource.getResourceSet();
        }
        return this.allFeatures(t, _resourceSet);
    }

    public Iterable<? extends RosettaFeature> allFeatures(RType t, EObject context, Predicate<RType> restrictType) {
        Iterable<Object> _xifexpression = null;
        boolean _test = restrictType.test(t);
        if (_test) {
            Resource _eResource = null;
            if (context != null) {
                _eResource = context.eResource();
            }
            ResourceSet _resourceSet = null;
            if (_eResource != null) {
                _resourceSet = _eResource.getResourceSet();
            }
            _xifexpression = this.allFeatures(t, _resourceSet);
        } else {
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _xifexpression;
    }

    public Iterable<? extends RosettaFeature> allFeatures(RType t, ResourceSet resourceSet) {
        Iterable<Object> _switchResult = null;
        boolean _matched = false;
        if (t instanceof RDataType) {
            _matched = true;
            Functions.Function1 _function = it -> it.getEObject();
            _switchResult = IterableExtensions.map(((RDataType)t).getAllAttributes(), (Functions.Function1)_function);
        }
        if (!_matched && t instanceof RChoiceType) {
            _matched = true;
            _switchResult = this.allFeatures((RType)((RChoiceType)t).asRDataType(), resourceSet);
        }
        if (!_matched && t instanceof REnumType) {
            _matched = true;
            _switchResult = ((REnumType)t).getAllEnumValues();
        }
        if (!_matched && t instanceof RRecordType) {
            _matched = true;
            List<Object> _xifexpression = null;
            _xifexpression = resourceSet != null ? this.builtins.toRosettaType(t, RosettaRecordType.class, resourceSet).getFeatures() : Collections.unmodifiableList(CollectionLiterals.newArrayList());
            _switchResult = _xifexpression;
        }
        if (!_matched) {
            _switchResult = Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        return _switchResult;
    }

    public List<RosettaFeature> getMetaDescriptions(List<RMetaAttribute> metaAttributes, EObject context) {
        boolean _not;
        List _xblockexpression = null;
        Functions.Function1 _function = it -> it.getName();
        List metas = IterableExtensions.toList((Iterable)ListExtensions.map(metaAttributes, (Functions.Function1)_function));
        List _xifexpression = null;
        boolean _isEmpty = metas.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            Functions.Function1 _function_1 = it -> metas.contains(it.getName().getLastSegment().toString());
            Functions.Function1 _function_2 = it -> it.getEObjectOrProxy();
            Functions.Function1 _function_3 = it -> EcoreUtil.resolve((EObject)it, (EObject)context);
            _xifexpression = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(this.configs.findMetaTypes(context), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (Functions.Function1)_function_3), RosettaFeature.class));
        } else {
            _xifexpression = CollectionLiterals.emptyList();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Deprecated
    public List<Data> getAllSuperTypes(Data data) {
        List _xblockexpression = null;
        LinkedHashSet reversedResult = CollectionLiterals.newLinkedHashSet();
        this.doGetAllSuperTypes(data, reversedResult);
        _xblockexpression = ListExtensions.reverse((List)IterableExtensions.toList((Iterable)reversedResult));
        return _xblockexpression;
    }

    private void doGetAllSuperTypes(Data current, LinkedHashSet<Data> superTypes) {
        Data s;
        boolean _add = superTypes.add(current);
        if (_add && (s = current.getSuperType()) != null) {
            this.doGetAllSuperTypes(s, superTypes);
        }
    }

    @Deprecated
    public Iterable<Attribute> getAllAttributes(Data data) {
        Functions.Function1 _function = it -> it.getAttributes();
        return IterableExtensions.flatMap(this.getAllSuperTypes(data), (Functions.Function1)_function);
    }

    @Deprecated
    public Collection<Attribute> getAllNonOverridenAttributes(Data data) {
        LinkedHashMap result = CollectionLiterals.newLinkedHashMap();
        Consumer<Attribute> _function = it -> result.put(it.getName(), it);
        this.getAllAttributes(data).forEach(_function);
        return result.values();
    }

    @Deprecated
    public Set<RosettaEnumeration> getAllSuperEnumerations(RosettaEnumeration e) {
        return this.doGetSuperEnumerations(e, CollectionLiterals.newLinkedHashSet());
    }

    private Set<RosettaEnumeration> doGetSuperEnumerations(RosettaEnumeration e, Set<RosettaEnumeration> seenEnums) {
        if (e != null && seenEnums.add(e)) {
            this.doGetSuperEnumerations(e.getParent(), seenEnums);
        }
        return seenEnums;
    }

    @Deprecated
    public Iterable<RosettaEnumValue> getAllEnumValues(RosettaEnumeration e) {
        Functions.Function1 _function = it -> it.getEnumValues();
        return Iterables.concat((Iterable)IterableExtensions.map(this.getAllSuperEnumerations(e), (Functions.Function1)_function));
    }

    public Attribute getParentAttribute(Attribute attr) {
        EObject t = attr.eContainer();
        if (t instanceof Data) {
            HashSet visited = CollectionLiterals.newHashSet();
            visited.add((Data)t);
            Data st = ((Data)t).getSuperType();
            while (st != null) {
                Functions.Function1 _function = it -> {
                    String _name = it.getName();
                    String _name_1 = attr.getName();
                    return Objects.equals(_name, _name_1);
                };
                Attribute p = (Attribute)IterableExtensions.findFirst(st.getAttributes(), (Functions.Function1)_function);
                if (p != null) {
                    return p;
                }
                boolean _add = visited.add(st = st.getSuperType());
                boolean _not = !_add;
                if (!_not) continue;
                return null;
            }
        }
        return null;
    }

    public List<EObject> getParentsOfExternalType(RosettaExternalClass externalType) {
        List<ExternalAnnotationSource> superSources;
        boolean _isEmpty;
        boolean _tripleNotEquals;
        ExternalAnnotationSource source = (ExternalAnnotationSource)EcoreUtil2.getContainerOfType((EObject)externalType, ExternalAnnotationSource.class);
        if (source == null) {
            return CollectionLiterals.emptyList();
        }
        Data type = externalType.getData();
        LinkedHashSet parents = CollectionLiterals.newLinkedHashSet();
        RosettaExternalClass superTypeInSource = null;
        Data _superType = type.getSuperType();
        boolean bl = _tripleNotEquals = _superType != null;
        if (_tripleNotEquals && (superTypeInSource = this.findSuperTypeInSource(type.getSuperType(), null, source)) != null) {
            parents.add(superTypeInSource);
        }
        if (_isEmpty = (superSources = this.getSuperSources(source)).isEmpty()) {
            parents.add(type);
        } else {
            HashSet visitedSources = CollectionLiterals.newHashSet();
            visitedSources.add(source);
            Data _data = null;
            if (superTypeInSource != null) {
                _data = superTypeInSource.getData();
            }
            Data stop = _data;
            Consumer<ExternalAnnotationSource> _function = it -> this.collectParentsOfTypeInSource(parents, type, stop, (ExternalAnnotationSource)it, visitedSources);
            superSources.forEach(_function);
        }
        return IterableExtensions.toList((Iterable)parents);
    }

    private void collectParentsOfTypeInSource(Set<EObject> parents, Data type, Data stop, ExternalAnnotationSource currentSource, Set<ExternalAnnotationSource> visitedSources) {
        List<ExternalAnnotationSource> superSources;
        boolean _isEmpty;
        boolean _not;
        boolean _add = visitedSources.add(currentSource);
        boolean bl = _not = !_add;
        if (_not) {
            return;
        }
        RosettaExternalClass superTypeInSource = this.findSuperTypeInSource(type, stop, currentSource);
        if (superTypeInSource != null) {
            parents.add(superTypeInSource);
        }
        if (_isEmpty = (superSources = this.getSuperSources(currentSource)).isEmpty()) {
            parents.add(type);
        } else {
            Consumer<ExternalAnnotationSource> _function = it -> {
                Data _elvis = null;
                Data _data = null;
                if (superTypeInSource != null) {
                    _data = superTypeInSource.getData();
                }
                _elvis = _data != null ? _data : stop;
                this.collectParentsOfTypeInSource(parents, type, _elvis, (ExternalAnnotationSource)it, visitedSources);
            };
            superSources.forEach(_function);
        }
    }

    private RosettaExternalClass findSuperTypeInSource(Data type, Data stop, ExternalAnnotationSource source) {
        HashSet visitedTypes = CollectionLiterals.newHashSet();
        for (Data current = type; current != null && !Objects.equals(current, stop) && !visitedTypes.add(current); current = current.getSuperType()) {
            Data d = current;
            Functions.Function1 _function = it -> {
                Data _data = it.getData();
                return Objects.equals(_data, d);
            };
            RosettaExternalClass externalType = (RosettaExternalClass)IterableExtensions.findFirst(source.getExternalClasses(), (Functions.Function1)_function);
            if (externalType == null) continue;
            return externalType;
        }
        return null;
    }

    private List<ExternalAnnotationSource> getSuperSources(ExternalAnnotationSource source) {
        if (source instanceof RosettaExternalSynonymSource) {
            Predicate<RosettaSynonymSource> _function = s -> s instanceof ExternalAnnotationSource;
            Function<RosettaSynonymSource, ExternalAnnotationSource> _function_1 = s -> (ExternalAnnotationSource)((Object)s);
            return ((RosettaExternalSynonymSource)source).getSuperSources().stream().filter(_function).map(_function_1).collect(Collectors.toList());
        }
        if (source instanceof RosettaExternalRuleSource) {
            return ((RosettaExternalRuleSource)source).getSuperSources();
        }
        return CollectionLiterals.emptyList();
    }

    public Set<RosettaSynonym> getAllSynonyms(RosettaSynonym s) {
        return this.doGetSynonyms(s, CollectionLiterals.newLinkedHashSet());
    }

    private Set<RosettaSynonym> doGetSynonyms(RosettaSynonym s, Set<RosettaSynonym> seenSynonyms) {
        if (s != null && seenSynonyms.add(s)) {
            this.doGetSynonyms(s, seenSynonyms);
        }
        return seenSynonyms;
    }

    @Deprecated
    public Iterable<AnnotationRef> metaAnnotations(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Annotation _annotation = it_1.getAnnotation();
            String _name = null;
            if (_annotation != null) {
                _name = _annotation.getName();
            }
            return Objects.equals(_name, "metadata");
        };
        return IterableExtensions.filter(this.allAnnotations(it), (Functions.Function1)_function);
    }

    @Deprecated
    public boolean hasKeyedAnnotation(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equals(_name, "key");
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    @Deprecated
    public boolean hasTemplateAnnotation(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equals(_name, "template");
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    @Deprecated
    public boolean hasMetaDataAnnotations(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            boolean _equals;
            boolean _or = false;
            boolean _or_1 = false;
            boolean _or_2 = false;
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            if (_equals = Objects.equals(_name, "reference")) {
                _or_2 = true;
            } else {
                boolean _equals_1;
                Attribute _attribute_1 = it_1.getAttribute();
                String _name_1 = null;
                if (_attribute_1 != null) {
                    _name_1 = _attribute_1.getName();
                }
                _or_2 = _equals_1 = Objects.equals(_name_1, "location");
            }
            if (_or_2) {
                _or_1 = true;
            } else {
                boolean _equals_2;
                Attribute _attribute_2 = it_1.getAttribute();
                String _name_2 = null;
                if (_attribute_2 != null) {
                    _name_2 = _attribute_2.getName();
                }
                _or_1 = _equals_2 = Objects.equals(_name_2, "scheme");
            }
            if (_or_1) {
                _or = true;
            } else {
                boolean _equals_3;
                Attribute _attribute_3 = it_1.getAttribute();
                String _name_3 = null;
                if (_attribute_3 != null) {
                    _name_3 = _attribute_3.getName();
                }
                _or = _equals_3 = Objects.equals(_name_3, "id");
            }
            return _or;
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    @Deprecated
    public boolean hasMetaFieldAnnotations(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            boolean _notEquals;
            boolean _and = false;
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            boolean bl = _notEquals = !Objects.equals(_name, "reference");
            if (!_notEquals) {
                _and = false;
            } else {
                boolean _notEquals_1;
                Attribute _attribute_1 = it_1.getAttribute();
                String _name_1 = null;
                if (_attribute_1 != null) {
                    _name_1 = _attribute_1.getName();
                }
                _and = _notEquals_1 = !Objects.equals(_name_1, "address");
            }
            return _and;
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    @Deprecated
    public boolean hasMetaDataAddress(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equals(_name, "address");
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    @Deprecated
    public boolean hasIdAnnotation(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equals(_name, "id");
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    @Deprecated
    public boolean hasReferenceAnnotation(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Attribute _attribute = it_1.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            return Objects.equals(_name, "reference");
        };
        return IterableExtensions.exists(this.metaAnnotations(it), (Functions.Function1)_function);
    }

    @Deprecated
    public boolean hasCalculationAnnotation(Annotated it) {
        Functions.Function1 _function = it_1 -> {
            Annotation _annotation = it_1.getAnnotation();
            String _name = null;
            if (_annotation != null) {
                _name = _annotation.getName();
            }
            return Objects.equals(_name, "calculation");
        };
        return IterableExtensions.exists(this.allAnnotations(it), (Functions.Function1)_function);
    }

    @Deprecated
    private Iterable<AnnotationRef> allAnnotations(Annotated withAnnotations) {
        EList<AnnotationRef> _annotations = null;
        if (withAnnotations != null) {
            _annotations = withAnnotations.getAnnotations();
        }
        Iterable _filter = null;
        if (_annotations != null) {
            Functions.Function1 _function = it -> this.isResolved(it.getAnnotation());
            _filter = IterableExtensions.filter(_annotations, (Functions.Function1)_function);
        }
        return _filter;
    }

    @Deprecated
    public boolean isConstraintCondition(Condition cond) {
        return this.isOneOf(cond) || this.isChoice(cond);
    }

    private boolean isOneOf(Condition cond) {
        RosettaExpression _expression = cond.getExpression();
        return _expression instanceof OneOfOperation;
    }

    private boolean isChoice(Condition cond) {
        RosettaExpression _expression = cond.getExpression();
        return _expression instanceof ChoiceOperation;
    }

    private List<RosettaFeature> getMetaDescriptions(RMetaAnnotatedType type, EObject context) {
        return this.getMetaDescriptions(type.getMetaAttributes(), context);
    }
}

