/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.expression;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.GenerationException;
import com.regnosys.rosetta.generator.java.JavaIdentifierRepresentationService;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.enums.EnumHelper;
import com.regnosys.rosetta.generator.java.expression.TypeCoercionService;
import com.regnosys.rosetta.generator.java.statement.JavaBlock;
import com.regnosys.rosetta.generator.java.statement.JavaLambdaBody;
import com.regnosys.rosetta.generator.java.statement.JavaLocalVariableDeclarationStatement;
import com.regnosys.rosetta.generator.java.statement.JavaStatement;
import com.regnosys.rosetta.generator.java.statement.builder.JavaBlockBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaConditionalExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaIfThenElseBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaLiteral;
import com.regnosys.rosetta.generator.java.statement.builder.JavaStatementBuilder;
import com.regnosys.rosetta.generator.java.statement.builder.JavaVariable;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoProperty;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.types.RJavaEnum;
import com.regnosys.rosetta.generator.java.types.RJavaFieldWithMeta;
import com.regnosys.rosetta.generator.java.types.RJavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.RJavaReferenceWithMeta;
import com.regnosys.rosetta.generator.java.types.RJavaWithMetaValue;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.generator.java.util.PreferWildcardImportMethod;
import com.regnosys.rosetta.generator.java.util.RecordJavaUtil;
import com.regnosys.rosetta.generator.util.RosettaFunctionExtensions;
import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaEnumValue;
import com.regnosys.rosetta.rosetta.RosettaEnumValueReference;
import com.regnosys.rosetta.rosetta.RosettaExternalFunction;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaMetaType;
import com.regnosys.rosetta.rosetta.RosettaNamed;
import com.regnosys.rosetta.rosetta.RosettaParameter;
import com.regnosys.rosetta.rosetta.RosettaRecordFeature;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.RosettaSymbol;
import com.regnosys.rosetta.rosetta.RosettaTypeWithConditions;
import com.regnosys.rosetta.rosetta.TypeParameter;
import com.regnosys.rosetta.rosetta.expression.ArithmeticOperation;
import com.regnosys.rosetta.rosetta.expression.AsKeyOperation;
import com.regnosys.rosetta.rosetta.expression.CardinalityModifier;
import com.regnosys.rosetta.rosetta.expression.ChoiceOperation;
import com.regnosys.rosetta.rosetta.expression.ClosureParameter;
import com.regnosys.rosetta.rosetta.expression.ComparisonOperation;
import com.regnosys.rosetta.rosetta.expression.DefaultOperation;
import com.regnosys.rosetta.rosetta.expression.DistinctOperation;
import com.regnosys.rosetta.rosetta.expression.EqualityOperation;
import com.regnosys.rosetta.rosetta.expression.ExistsModifier;
import com.regnosys.rosetta.rosetta.expression.FilterOperation;
import com.regnosys.rosetta.rosetta.expression.FirstOperation;
import com.regnosys.rosetta.rosetta.expression.FlattenOperation;
import com.regnosys.rosetta.rosetta.expression.InlineFunction;
import com.regnosys.rosetta.rosetta.expression.JoinOperation;
import com.regnosys.rosetta.rosetta.expression.LastOperation;
import com.regnosys.rosetta.rosetta.expression.ListLiteral;
import com.regnosys.rosetta.rosetta.expression.LogicalOperation;
import com.regnosys.rosetta.rosetta.expression.MapOperation;
import com.regnosys.rosetta.rosetta.expression.MaxOperation;
import com.regnosys.rosetta.rosetta.expression.MinOperation;
import com.regnosys.rosetta.rosetta.expression.ModifiableBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.Necessity;
import com.regnosys.rosetta.rosetta.expression.OneOfOperation;
import com.regnosys.rosetta.rosetta.expression.ReduceOperation;
import com.regnosys.rosetta.rosetta.expression.ReverseOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaAbsentExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaBinaryOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaBooleanLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaConditionalExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaContainsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaCountOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaDeepFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaDisjointExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaFeatureCall;
import com.regnosys.rosetta.rosetta.expression.RosettaFunctionalOperation;
import com.regnosys.rosetta.rosetta.expression.RosettaImplicitVariable;
import com.regnosys.rosetta.rosetta.expression.RosettaIntLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaNumberLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyElement;
import com.regnosys.rosetta.rosetta.expression.RosettaOnlyExistsExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaStringLiteral;
import com.regnosys.rosetta.rosetta.expression.RosettaSymbolReference;
import com.regnosys.rosetta.rosetta.expression.RosettaUnaryOperation;
import com.regnosys.rosetta.rosetta.expression.SortOperation;
import com.regnosys.rosetta.rosetta.expression.SumOperation;
import com.regnosys.rosetta.rosetta.expression.SwitchCaseOrDefault;
import com.regnosys.rosetta.rosetta.expression.SwitchOperation;
import com.regnosys.rosetta.rosetta.expression.ThenOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateOperation;
import com.regnosys.rosetta.rosetta.expression.ToDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToEnumOperation;
import com.regnosys.rosetta.rosetta.expression.ToIntOperation;
import com.regnosys.rosetta.rosetta.expression.ToNumberOperation;
import com.regnosys.rosetta.rosetta.expression.ToStringOperation;
import com.regnosys.rosetta.rosetta.expression.ToTimeOperation;
import com.regnosys.rosetta.rosetta.expression.ToZonedDateTimeOperation;
import com.regnosys.rosetta.rosetta.expression.WithMetaOperation;
import com.regnosys.rosetta.rosetta.simple.AssignPathRoot;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.ChoiceOption;
import com.regnosys.rosetta.rosetta.simple.ShortcutDeclaration;
import com.regnosys.rosetta.types.CardinalityProvider;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceOption;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RShortcut;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.RosettaTypeProvider;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.utils.ExpressionHelper;
import com.regnosys.rosetta.utils.ImplicitVariableUtil;
import com.regnosys.rosetta.utils.PojoPropertyUtil;
import com.regnosys.rosetta.utils.RosettaExpressionSwitch;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.metafields.MetaFields;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaType;
import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class ExpressionGenerator
extends RosettaExpressionSwitch<JavaStatementBuilder, Context> {
    @Inject
    protected RosettaTypeProvider typeProvider;
    @Inject
    @Extension
    private CardinalityProvider cardinalityProvider;
    @Inject
    private RosettaFunctionExtensions funcExt;
    @Inject
    @Extension
    private RosettaEcoreUtil _rosettaEcoreUtil;
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    private ExpressionHelper exprHelper;
    @Inject
    @Extension
    private ImplicitVariableUtil _implicitVariableUtil;
    @Inject
    @Extension
    private JavaIdentifierRepresentationService _javaIdentifierRepresentationService;
    @Inject
    private RecordJavaUtil recordUtil;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private TypeSystem _typeSystem;
    @Inject
    private RObjectFactory rObjectFactory;
    @Inject
    private TypeCoercionService typeCoercionService;
    @Inject
    @Extension
    private JavaTypeUtil typeUtil;
    @Inject
    @Extension
    private RObjectFactory _rObjectFactory;

    public JavaStatementBuilder javaCode(RosettaExpression expr, JavaType expectedType, JavaScope scope) {
        try {
            Context _context = new Context();
            Procedures.Procedure1 _function = it -> {
                it.expectedType = expectedType;
                it.scope = scope;
            };
            Context _doubleArrow = (Context)ObjectExtensions.operator_doubleArrow((Object)_context, (Procedures.Procedure1)_function);
            JavaStatementBuilder rawResult = (JavaStatementBuilder)this.doSwitch(expr, _doubleArrow);
            return this.typeCoercionService.addCoercions(rawResult, expectedType, scope);
        }
        catch (Throwable _t) {
            if (_t instanceof GenerationException) {
                GenerationException e = (GenerationException)_t;
                throw e;
            }
            if (_t instanceof Exception) {
                Exception e_1 = (Exception)_t;
                String _message = e_1.getMessage();
                URI _uRI = expr.eResource().getURI();
                throw new GenerationException(_message, _uRI, expr, e_1);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private StringConcatenationClient runtimeMethod(final String methodName) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                PreferWildcardImportMethod _importWildcard = ExpressionGenerator.this._importManagerExtension.importWildcard(ExpressionGenerator.this._importManagerExtension.method(ExpressionOperators.class, methodName));
                _builder.append((Object)_importWildcard);
            }
        };
        return _client;
    }

    private JavaStatementBuilder applyRuntimeMethod(JavaStatementBuilder expr, final String methodName, JavaType resultType) {
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                final /* synthetic */ JavaExpression val$it;
                {
                    this.val$it = javaExpression;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod(methodName);
                    _builder.append((Object)_runtimeMethod);
                    _builder.append((Object)"(");
                    _builder.append((Object)this.val$it);
                    _builder.append((Object)")");
                }
            };
            return JavaExpression.from(_client, resultType);
        };
        return expr.mapExpression(_function);
    }

    private JavaStatementBuilder callableWithArgsCall(final RosettaCallableWithArgs callable, List<RosettaExpression> arguments, final JavaScope scope) {
        JavaStatementBuilder _switchResult = null;
        boolean _matched = false;
        if (callable instanceof com.regnosys.rosetta.rosetta.simple.Function) {
            _matched = true;
        }
        if (!_matched && callable instanceof RosettaRule) {
            _matched = true;
        }
        if (_matched) {
            JavaStatementBuilder _xblockexpression = null;
            RFunction _xifexpression = null;
            _xifexpression = callable instanceof com.regnosys.rosetta.rosetta.simple.Function ? this.rObjectFactory.buildRFunction((com.regnosys.rosetta.rosetta.simple.Function)callable) : this.rObjectFactory.buildRFunction((RosettaRule)callable);
            final RFunction rCallable = _xifexpression;
            JavaClass<?> outputType = this._javaTypeTranslator.toMetaJavaType(rCallable.getOutput());
            ArrayList args = CollectionLiterals.newArrayList();
            for (int i = 0; i < arguments.size(); ++i) {
                args.add(this.javaCode(arguments.get(i), (JavaType)this._javaTypeTranslator.toMetaJavaType(rCallable.getInputs().get(i)), scope));
            }
            Function<JavaExpression, JavaStatementBuilder> _function = it -> {
                StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it){
                    final /* synthetic */ JavaExpression val$it;
                    {
                        this.val$it = javaExpression;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(ExpressionGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(ExpressionGenerator.this._javaTypeTranslator.toFunctionJavaClass(rCallable)));
                        _builder.append((Object)_identifierOrThrow);
                        _builder.append((Object)".evaluate(");
                        _builder.append((Object)this.val$it);
                        _builder.append((Object)")");
                    }
                };
                return JavaExpression.from(_client, (JavaType)outputType);
            };
            _xblockexpression = JavaStatementBuilder.invokeMethod(args, _function, scope);
            _switchResult = _xblockexpression;
        }
        if (!_matched && callable instanceof RosettaExternalFunction) {
            _matched = true;
            JavaExpression _xblockexpression_1 = null;
            RMetaAnnotatedType returnRType = this.typeProvider.getRTypeOfSymbol(callable);
            JavaStatementBuilder _xifexpression = null;
            boolean _isEmpty = arguments.isEmpty();
            if (_isEmpty) {
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)"new ");
                        JavaClass<RosettaFunction> _functionJavaClass = ExpressionGenerator.this._javaTypeTranslator.toFunctionJavaClass((RosettaExternalFunction)callable);
                        _builder.append(_functionJavaClass);
                        _builder.append((Object)"().execute()");
                    }
                };
                _xifexpression = JavaExpression.from(_client, this._javaTypeTranslator.toJavaReferenceType(returnRType));
            } else {
                JavaStatementBuilder _xblockexpression_2 = null;
                JavaStatementBuilder argCode = null;
                Functions.Function1 _function = it -> this.typeProvider.getRMetaAnnotatedType((RosettaExpression)it);
                List argRTypes = ListExtensions.map(arguments, (Functions.Function1)_function);
                JavaStatementBuilder _xifexpression_1 = null;
                Functions.Function1 _function_1 = it -> this._typeSystem.isSubtypeOf((RMetaAnnotatedType)it, returnRType);
                boolean _forall = IterableExtensions.forall((Iterable)argRTypes, (Functions.Function1)_function_1);
                if (_forall) {
                    JavaStatementBuilder _xblockexpression_3 = null;
                    JavaClass<?> argAndReturnType = this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.joinMetaAnnotatedTypes(argRTypes));
                    argCode = this.javaCode((RosettaExpression)IterableExtensions.head(arguments), (JavaType)argAndReturnType, scope);
                    for (int i = 1; i < arguments.size(); ++i) {
                        BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_2 = (argList, newArg) -> {
                            StringConcatenationClient _client_1 = new StringConcatenationClient(this, (JavaExpression)argList, (JavaExpression)newArg){
                                final /* synthetic */ JavaExpression val$argList;
                                final /* synthetic */ JavaExpression val$newArg;
                                {
                                    this.val$argList = javaExpression;
                                    this.val$newArg = javaExpression2;
                                }

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)this.val$argList);
                                    _builder.append((Object)", ");
                                    _builder.append((Object)this.val$newArg);
                                }
                            };
                            return JavaExpression.from(_client_1, null);
                        };
                        argCode = argCode.then(this.javaCode(arguments.get(i), (JavaType)argAndReturnType, scope), _function_2, scope);
                    }
                    Function<JavaExpression, JavaStatementBuilder> _function_2 = it -> {
                        StringConcatenationClient _client_1 = new StringConcatenationClient((JavaExpression)it){
                            final /* synthetic */ JavaExpression val$it;
                            {
                                this.val$it = javaExpression;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"new ");
                                JavaClass<RosettaFunction> _functionJavaClass = ExpressionGenerator.this._javaTypeTranslator.toFunctionJavaClass((RosettaExternalFunction)callable);
                                _builder.append(_functionJavaClass);
                                _builder.append((Object)"().execute(");
                                _builder.append((Object)this.val$it);
                                _builder.append((Object)")");
                            }
                        };
                        return JavaExpression.from(_client_1, (JavaType)argAndReturnType);
                    };
                    _xifexpression_1 = _xblockexpression_3 = argCode.mapExpressionIfNotNull(_function_2);
                } else {
                    JavaStatementBuilder _xblockexpression_4 = null;
                    argCode = this.javaCode((RosettaExpression)IterableExtensions.head(arguments), (JavaType)this._javaTypeTranslator.toJavaReferenceType(RMetaAnnotatedType.withNoMeta(this._typeSystem.typeCallToRType(((RosettaParameter)IterableExtensions.head(((RosettaExternalFunction)callable).getParameters())).getTypeCall()))), scope);
                    for (int i = 1; i < arguments.size(); ++i) {
                        BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_2 = (argList, newArg) -> {
                            StringConcatenationClient _client_1 = new StringConcatenationClient(this, (JavaExpression)argList, (JavaExpression)newArg){
                                final /* synthetic */ JavaExpression val$argList;
                                final /* synthetic */ JavaExpression val$newArg;
                                {
                                    this.val$argList = javaExpression;
                                    this.val$newArg = javaExpression2;
                                }

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)this.val$argList);
                                    _builder.append((Object)", ");
                                    _builder.append((Object)this.val$newArg);
                                }
                            };
                            return JavaExpression.from(_client_1, null);
                        };
                        argCode = argCode.then(this.javaCode(arguments.get(i), (JavaType)this._javaTypeTranslator.toJavaReferenceType(RMetaAnnotatedType.withNoMeta(this._typeSystem.typeCallToRType(((RosettaParameter)((RosettaExternalFunction)callable).getParameters().get(i)).getTypeCall()))), scope), _function_2, scope);
                    }
                    Function<JavaExpression, JavaStatementBuilder> _function_2 = it -> {
                        StringConcatenationClient _client_1 = new StringConcatenationClient((JavaExpression)it){
                            final /* synthetic */ JavaExpression val$it;
                            {
                                this.val$it = javaExpression;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)"new ");
                                JavaClass<RosettaFunction> _functionJavaClass = ExpressionGenerator.this._javaTypeTranslator.toFunctionJavaClass((RosettaExternalFunction)callable);
                                _builder.append(_functionJavaClass);
                                _builder.append((Object)"().execute(");
                                _builder.append((Object)this.val$it);
                                _builder.append((Object)")");
                            }
                        };
                        return JavaExpression.from(_client_1, this._javaTypeTranslator.toJavaReferenceType(returnRType));
                    };
                    _xifexpression_1 = _xblockexpression_4 = argCode.mapExpressionIfNotNull(_function_2);
                }
                _xblockexpression_2 = _xifexpression_1;
                _xifexpression = _xblockexpression_2;
            }
            _switchResult = _xblockexpression_1 = _xifexpression;
        }
        if (!_matched) {
            EClass _eClass = null;
            if (callable != null) {
                _eClass = callable.eClass();
            }
            String _name = null;
            if (_eClass != null) {
                _name = _eClass.getName();
            }
            String _plus = "Unsupported callable with args of type " + _name;
            throw new UnsupportedOperationException(_plus);
        }
        return _switchResult;
    }

    private JavaStatementBuilder implicitVariable(EObject context, JavaScope scope) {
        JavaVariable _xblockexpression = null;
        JavaClass<?> itemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.typeOfImplicitVariable(context));
        EObject definingContainer = this._implicitVariableUtil.findContainerDefiningImplicitVariable(context).get();
        JavaClass<?> _xifexpression = null;
        if (definingContainer instanceof RosettaTypeWithConditions || definingContainer instanceof RosettaRule) {
            _xifexpression = itemType;
        } else {
            JavaParameterizedType<MapperS<?>> _xifexpression_1 = null;
            if (definingContainer instanceof SwitchCaseOrDefault) {
                _xifexpression_1 = this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)itemType);
            } else {
                JavaParameterizedType<MapperListOfLists<?>> _xblockexpression_1 = null;
                RosettaFunctionalOperation f = (RosettaFunctionalOperation)definingContainer;
                JavaParameterizedType<MapperListOfLists<?>> _xifexpression_2 = null;
                if (f instanceof ThenOperation && this.cardinalityProvider.isOutputListOfLists(f.getArgument())) {
                    JavaParameterizedType<MapperListOfLists<?>> _wrap;
                    _xifexpression_2 = _wrap = this.typeUtil.wrap(this.typeUtil.MAPPER_LIST_OF_LISTS, (JavaType)itemType);
                } else {
                    JavaParameterizedType<MapperC<?>> _xifexpression_3 = null;
                    boolean _isImplicitVariableMulti = this.cardinalityProvider.isImplicitVariableMulti(context);
                    if (_isImplicitVariableMulti) {
                        JavaParameterizedType<MapperC<?>> _wrap_1;
                        _xifexpression_3 = _wrap_1 = this.typeUtil.wrap(this.typeUtil.MAPPER_C, (JavaType)itemType);
                    } else {
                        JavaParameterizedType<MapperS<?>> _wrap_2 = this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)itemType);
                        _xifexpression_3 = _wrap_2;
                    }
                    _xifexpression_2 = _xifexpression_3;
                }
                _xblockexpression_1 = _xifexpression_2;
                _xifexpression_1 = _xblockexpression_1;
            }
            _xifexpression = _xifexpression_1;
        }
        JavaClass<?> actualType = _xifexpression;
        GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(this._javaIdentifierRepresentationService.getImplicitVarInContext(context));
        _xblockexpression = new JavaVariable(_identifierOrThrow, (JavaType)actualType);
        return _xblockexpression;
    }

    public StringConcatenationClient aliasCallArgs(final RShortcut alias, RFunction function, final JavaScope scope) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        final RAttribute output = function.getOutput();
        final List<RAttribute> inputs = function.getInputs();
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _usesOutputParameter = ExpressionGenerator.this.exprHelper.usesOutputParameter(alias.getExpression());
                if (_usesOutputParameter) {
                    boolean _not;
                    GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(output);
                    _builder.append((Object)_identifierOrThrow);
                    _builder.append((Object)".toBuilder()");
                    boolean _isEmpty = inputs.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        _builder.append((Object)", ");
                    }
                }
                boolean _hasElements = false;
                for (RAttribute input : inputs) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(input);
                    _builder.append((Object)_identifierOrThrow_1);
                }
            }
        };
        return _xblockexpression;
    }

    private StringConcatenationClient aliasCallArgs(final ShortcutDeclaration alias, final JavaScope scope) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        com.regnosys.rosetta.rosetta.simple.Function func = (com.regnosys.rosetta.rosetta.simple.Function)EcoreUtil2.getContainerOfType((EObject)alias, com.regnosys.rosetta.rosetta.simple.Function.class);
        final RAttribute output = this.rObjectFactory.buildRAttributeWithEnclosingType(null, this.funcExt.getOutput(func));
        Functions.Function1 _function = it -> this.rObjectFactory.buildRAttributeWithEnclosingType(null, (Attribute)it);
        final List inputs = ListExtensions.map(this.funcExt.getInputs(func), (Functions.Function1)_function);
        _xblockexpression = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                boolean _usesOutputParameter = ExpressionGenerator.this.exprHelper.usesOutputParameter(alias.getExpression());
                if (_usesOutputParameter) {
                    boolean _not;
                    GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(output);
                    _builder.append((Object)_identifierOrThrow);
                    _builder.append((Object)".toBuilder()");
                    boolean _isEmpty = inputs.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (_not) {
                        _builder.append((Object)", ");
                    }
                }
                boolean _hasElements = false;
                for (RAttribute input : inputs) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    GeneratedIdentifier _identifierOrThrow_1 = scope.getIdentifierOrThrow(input);
                    _builder.append((Object)_identifierOrThrow_1);
                }
            }
        };
        return _xblockexpression;
    }

    public JavaStatementBuilder enumCall(final RosettaEnumValue feature, JavaType expectedType) {
        JavaExpression _xblockexpression = null;
        final JavaType itemType = this.typeUtil.getItemValueType(expectedType);
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)itemType);
                _builder.append((Object)".");
                String _convertValue = EnumHelper.convertValue(feature);
                _builder.append((Object)_convertValue);
            }
        };
        _xblockexpression = JavaExpression.from(_client, itemType);
        return _xblockexpression;
    }

    public JavaStatementBuilder metaCall(JavaStatementBuilder receiverCode, RMetaAnnotatedType receiverType, RosettaMetaType feature, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        JavaClass<?> resultItemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRTypeOfFeature(feature, null));
        StringConcatenationClient right = ExpressionGenerator.buildMapFunc(feature, scope);
        JavaStatementBuilder mapperReceiverCode = this.typeCoercionService.addCoercions(receiverCode, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, this.typeUtil.getItemType(receiverCode.getExpressionType())), scope);
        _xblockexpression = this.featureCall(mapperReceiverCode, (JavaType)resultItemType, right, receiverCode, receiverType, this.cardinalityProvider.isFeatureMulti(feature), scope);
        return _xblockexpression;
    }

    public JavaStatementBuilder recordCall(JavaStatementBuilder receiverCode, final RMetaAnnotatedType receiverType, final RosettaRecordFeature feature, final JavaScope scope) {
        StringConcatenationClient _client;
        JavaStatementBuilder _xblockexpression = null;
        final JavaClass<?> resultItemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRTypeOfFeature(feature, null));
        StringConcatenationClient right = _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)".<");
                _builder.append((Object)resultItemType);
                _builder.append((Object)">map(\"");
                String _firstUpper = StringExtensions.toFirstUpper((String)feature.getName());
                _builder.append((Object)_firstUpper);
                _builder.append((Object)"\", ");
                RType _rType = receiverType.getRType();
                StringConcatenationClient _recordFeatureToLambda = ExpressionGenerator.this.recordUtil.recordFeatureToLambda((RRecordType)_rType, feature, scope);
                _builder.append((Object)_recordFeatureToLambda);
                _builder.append((Object)")");
            }
        };
        JavaStatementBuilder mapperReceiverCode = this.typeCoercionService.addCoercions(receiverCode, (JavaType)this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER, this.typeUtil.getItemType(receiverCode.getExpressionType())), scope);
        _xblockexpression = this.featureCall(mapperReceiverCode, (JavaType)resultItemType, right, receiverCode, receiverType, this.cardinalityProvider.isFeatureMulti(feature), scope);
        return _xblockexpression;
    }

    public JavaStatementBuilder attributeCall(JavaStatementBuilder receiverCode, RMetaAnnotatedType receiverType, final RAttribute attr, boolean isDeepFeature, JavaType expectedType, final JavaScope scope) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        JavaStatementBuilder _xblockexpression = null;
        RType receiverRType = receiverType.getRType();
        RDataType _xifexpression = null;
        _xifexpression = receiverRType instanceof RChoiceType ? ((RChoiceType)receiverRType).asRDataType() : (RDataType)receiverRType;
        final RDataType t = _xifexpression;
        JavaPojoInterface javaType = this._javaTypeTranslator.toJavaReferenceType(t);
        JavaScope lambdaScope = scope.lambdaScope();
        GeneratedIdentifier _createUniqueIdentifier = lambdaScope.createUniqueIdentifier(StringExtensions.toFirstLower((String)javaType.getRosettaName()));
        final JavaVariable lambdaParam = new JavaVariable(_createUniqueIdentifier, (JavaType)javaType);
        JavaType resultItemType = null;
        StringConcatenationClient _xifexpression_1 = null;
        if (isDeepFeature) {
            StringConcatenationClient _client2;
            StringConcatenationClient _xblockexpression_1 = null;
            resultItemType = this._javaTypeTranslator.toMetaItemJavaType(attr);
            _xifexpression_1 = _xblockexpression_1 = (_client2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"\"choose");
                    String _firstUpper = StringExtensions.toFirstUpper((String)attr.getName());
                    _builder.append((Object)_firstUpper);
                    _builder.append((Object)"\", ");
                    _builder.append((Object)lambdaParam);
                    _builder.append((Object)" -> ");
                    GeneratedIdentifier _identifierOrThrow = scope.getIdentifierOrThrow(ExpressionGenerator.this._javaIdentifierRepresentationService.toDependencyInstance(ExpressionGenerator.this._javaTypeTranslator.toDeepPathUtilJavaClass(t)));
                    _builder.append((Object)_identifierOrThrow);
                    _builder.append((Object)".choose");
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)attr.getName());
                    _builder.append((Object)_firstUpper_1);
                    _builder.append((Object)"(");
                    _builder.append((Object)lambdaParam);
                    _builder.append((Object)")");
                }
            });
        } else {
            StringConcatenationClient _client3;
            StringConcatenationClient _xblockexpression_2 = null;
            final JavaPojoProperty prop = javaType.findProperty(attr.getName(), expectedType);
            resultItemType = this.typeUtil.getItemType(prop.getType());
            _xifexpression_1 = _xblockexpression_2 = (_client3 = new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"\"get");
                    String _firstUpper = StringExtensions.toFirstUpper((String)prop.getName());
                    _builder.append((Object)_firstUpper);
                    _builder.append((Object)"\", ");
                    _builder.append((Object)lambdaParam);
                    _builder.append((Object)" -> ");
                    JavaExpression _applyGetter = prop.applyGetter(lambdaParam);
                    _builder.append((Object)_applyGetter);
                }
            });
        }
        final StringConcatenationClient mappingCode = _xifexpression_1;
        final JavaType r = resultItemType;
        StringConcatenationClient _xifexpression_2 = null;
        boolean _isMulti = attr.isMulti();
        _xifexpression_2 = _isMulti ? (_client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)".<");
                _builder.append((Object)r);
                _builder.append((Object)">mapC(");
                _builder.append((Object)mappingCode);
                _builder.append((Object)")");
            }
        }) : (_client_1 = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)".<");
                _builder.append((Object)r);
                _builder.append((Object)">map(");
                _builder.append((Object)mappingCode);
                _builder.append((Object)")");
            }
        });
        StringConcatenationClient right = _xifexpression_2;
        JavaStatementBuilder mapperReceiverCode = this.typeCoercionService.addCoercions(receiverCode, (JavaType)this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER, this.typeUtil.getItemType(receiverCode.getExpressionType())), scope);
        _xblockexpression = this.featureCall(mapperReceiverCode, resultItemType, right, receiverCode, receiverType, attr.isMulti(), scope);
        return _xblockexpression;
    }

    private JavaStatementBuilder featureCall(JavaStatementBuilder mapperReceiverCode, JavaType resultItemType, StringConcatenationClient right, JavaStatementBuilder receiverCode, RMetaAnnotatedType receiverType, boolean isMulti, JavaScope scope) {
        Object _xifexpression = null;
        _xifexpression = this.typeUtil.isMapperS(mapperReceiverCode.getExpressionType()) && !isMulti ? this.typeUtil.MAPPER_S : this.typeUtil.MAPPER_C;
        JavaGenericTypeDeclaration<MapperC<?>> resultWrapper = _xifexpression;
        JavaParameterizedType<MapperC<?>> resultType = this.typeUtil.wrap(resultWrapper, resultItemType);
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, right){
                final /* synthetic */ JavaExpression val$it;
                final /* synthetic */ StringConcatenationClient val$right;
                {
                    this.val$it = javaExpression;
                    this.val$right = stringConcatenationClient;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)this.val$it);
                    _builder.append((Object)this.val$right);
                }
            };
            return JavaExpression.from(_client, (JavaType)resultType);
        };
        return mapperReceiverCode.collapseToSingleExpression(scope).mapExpression(_function);
    }

    private JavaStatementBuilder binaryExpr(final RosettaBinaryOperation expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        RosettaExpression left = expr.getLeft();
        RosettaExpression right = expr.getRight();
        JavaStatementBuilder _switchResult = null;
        String _operator = expr.getOperator();
        if (_operator != null) {
            switch (_operator) {
                case "and": 
                case "or": {
                    JavaStatementBuilder _xblockexpression_1 = null;
                    JavaStatementBuilder leftCode = this.javaCode(left, (JavaType)this.typeUtil.COMPARISON_RESULT, context.scope);
                    JavaStatementBuilder rightCode = this.javaCode(right, (JavaType)this.typeUtil.COMPARISON_RESULT, context.scope);
                    BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (l, r) -> {
                        StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)l, expr, (JavaExpression)r){
                            final /* synthetic */ JavaExpression val$l;
                            final /* synthetic */ RosettaBinaryOperation val$expr;
                            final /* synthetic */ JavaExpression val$r;
                            {
                                this.val$l = javaExpression;
                                this.val$expr = rosettaBinaryOperation;
                                this.val$r = javaExpression2;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$l);
                                _builder.append((Object)".");
                                String _operator = this.val$expr.getOperator();
                                _builder.append((Object)_operator);
                                _builder.append((Object)"(");
                                _builder.append((Object)this.val$r);
                                _builder.append((Object)")");
                            }
                        };
                        return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
                    };
                    _switchResult = _xblockexpression_1 = leftCode.then(rightCode, _function, context.scope);
                    break;
                }
                case "+": 
                case "-": 
                case "*": 
                case "/": {
                    JavaStatementBuilder _xblockexpression_2 = null;
                    RType leftRtype = this.typeProvider.getRMetaAnnotatedType(expr.getLeft()).getRType();
                    RType rightRtype = this.typeProvider.getRMetaAnnotatedType(expr.getRight()).getRType();
                    JavaClass<?> leftType = this._javaTypeTranslator.toJavaReferenceType(leftRtype);
                    JavaClass<?> rightType = this._javaTypeTranslator.toJavaReferenceType(rightRtype);
                    JavaClass<?> joinedWithoutMeta = this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.join(leftRtype, rightRtype));
                    JavaClass<?> resultType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRMetaAnnotatedType(expr));
                    String _switchResult_1 = null;
                    String _operator_1 = expr.getOperator();
                    if (_operator_1 != null) {
                        switch (_operator_1) {
                            case "+": {
                                _switchResult_1 = "add";
                                break;
                            }
                            case "-": {
                                _switchResult_1 = "subtract";
                                break;
                            }
                            case "*": {
                                _switchResult_1 = "multiply";
                                break;
                            }
                            case "/": {
                                _switchResult_1 = "divide";
                            }
                        }
                    }
                    String method = _switchResult_1;
                    JavaStatementBuilder _xifexpression = null;
                    if (this.typeUtil.extendsNumber((JavaType)leftType) && this.typeUtil.extendsNumber((JavaType)rightType)) {
                        JavaStatementBuilder _xblockexpression_3 = null;
                        JavaStatementBuilder leftCode = this.javaCode(left, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)joinedWithoutMeta), context.scope);
                        JavaStatementBuilder rightCode = this.javaCode(right, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)joinedWithoutMeta), context.scope);
                        BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (l, r) -> {
                            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaClass)resultType, (JavaClass)joinedWithoutMeta, method, (JavaExpression)l, (JavaExpression)r){
                                final /* synthetic */ JavaClass val$resultType;
                                final /* synthetic */ JavaClass val$joinedWithoutMeta;
                                final /* synthetic */ String val$method;
                                final /* synthetic */ JavaExpression val$l;
                                final /* synthetic */ JavaExpression val$r;
                                {
                                    this.val$resultType = javaClass;
                                    this.val$joinedWithoutMeta = javaClass2;
                                    this.val$method = string;
                                    this.val$l = javaExpression;
                                    this.val$r = javaExpression2;
                                }

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append(MapperMaths.class);
                                    _builder.append((Object)".<");
                                    _builder.append((Object)this.val$resultType);
                                    _builder.append((Object)", ");
                                    _builder.append((Object)this.val$joinedWithoutMeta);
                                    _builder.append((Object)", ");
                                    _builder.append((Object)this.val$joinedWithoutMeta);
                                    _builder.append((Object)">");
                                    _builder.append((Object)this.val$method);
                                    _builder.append((Object)"(");
                                    _builder.append((Object)this.val$l);
                                    _builder.append((Object)", ");
                                    _builder.append((Object)this.val$r);
                                    _builder.append((Object)")");
                                }
                            };
                            return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)resultType));
                        };
                        _xifexpression = _xblockexpression_3 = leftCode.then(rightCode, _function, context.scope);
                    } else {
                        JavaStatementBuilder _xblockexpression_4 = null;
                        JavaStatementBuilder leftCode = this.javaCode(left, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)leftType), context.scope);
                        JavaStatementBuilder rightCode = this.javaCode(right, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)rightType), context.scope);
                        BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (l, r) -> {
                            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaClass)resultType, (JavaClass)leftType, (JavaClass)rightType, method, (JavaExpression)l, (JavaExpression)r){
                                final /* synthetic */ JavaClass val$resultType;
                                final /* synthetic */ JavaClass val$leftType;
                                final /* synthetic */ JavaClass val$rightType;
                                final /* synthetic */ String val$method;
                                final /* synthetic */ JavaExpression val$l;
                                final /* synthetic */ JavaExpression val$r;
                                {
                                    this.val$resultType = javaClass;
                                    this.val$leftType = javaClass2;
                                    this.val$rightType = javaClass3;
                                    this.val$method = string;
                                    this.val$l = javaExpression;
                                    this.val$r = javaExpression2;
                                }

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append(MapperMaths.class);
                                    _builder.append((Object)".<");
                                    _builder.append((Object)this.val$resultType);
                                    _builder.append((Object)", ");
                                    _builder.append((Object)this.val$leftType);
                                    _builder.append((Object)", ");
                                    _builder.append((Object)this.val$rightType);
                                    _builder.append((Object)">");
                                    _builder.append((Object)this.val$method);
                                    _builder.append((Object)"(");
                                    _builder.append((Object)this.val$l);
                                    _builder.append((Object)", ");
                                    _builder.append((Object)this.val$r);
                                    _builder.append((Object)")");
                                }
                            };
                            return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)resultType));
                        };
                        _xifexpression = _xblockexpression_4 = leftCode.then(rightCode, _function, context.scope);
                    }
                    _switchResult = _xblockexpression_2 = _xifexpression;
                    break;
                }
                case "contains": 
                case "disjoint": {
                    JavaStatementBuilder _xblockexpression_3 = null;
                    RMetaAnnotatedType leftRMetaType = this.typeProvider.getRMetaAnnotatedType(expr.getLeft());
                    RMetaAnnotatedType rightRMetaType = this.typeProvider.getRMetaAnnotatedType(expr.getRight());
                    JavaClass<?> joined = this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.joinMetaAnnotatedTypes(leftRMetaType, rightRMetaType));
                    JavaStatementBuilder leftCode = this.javaCode(left, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)joined), context.scope);
                    JavaStatementBuilder rightCode = this.javaCode(right, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)joined), context.scope);
                    BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (l, r) -> {
                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)l, (JavaExpression)r){
                            final /* synthetic */ JavaExpression val$l;
                            final /* synthetic */ JavaExpression val$r;
                            {
                                this.val$l = javaExpression;
                                this.val$r = javaExpression2;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod(expr.getOperator());
                                _builder.append((Object)_runtimeMethod);
                                _builder.append((Object)"(");
                                _builder.append((Object)this.val$l);
                                _builder.append((Object)", ");
                                _builder.append((Object)this.val$r);
                                _builder.append((Object)")");
                            }
                        };
                        return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
                    };
                    _switchResult = _xblockexpression_3 = leftCode.then(rightCode, _function, context.scope);
                    break;
                }
                case "default": {
                    JavaStatementBuilder _xblockexpression_4 = null;
                    RMetaAnnotatedType leftRMetaType = this.typeProvider.getRMetaAnnotatedType(expr.getLeft());
                    RMetaAnnotatedType rightRMetaType = this.typeProvider.getRMetaAnnotatedType(expr.getRight());
                    JavaClass<?> joined = this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.joinMetaAnnotatedTypes(leftRMetaType, rightRMetaType));
                    JavaStatementBuilder leftCode = this.javaCode(left, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)joined), context.scope);
                    JavaStatementBuilder _xifexpression = null;
                    boolean _isMulti = this.cardinalityProvider.isMulti(left);
                    if (_isMulti) {
                        JavaStatementBuilder _xblockexpression_5 = null;
                        JavaStatementBuilder rightCode = this.javaCode(right, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)joined), context.scope);
                        BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (l, r) -> {
                            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)l){
                                final /* synthetic */ JavaExpression val$l;
                                {
                                    this.val$l = javaExpression;
                                }

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)this.val$l);
                                    _builder.append((Object)".getMulti().isEmpty()");
                                }
                            };
                            JavaExpression _from = JavaExpression.from(_client, (JavaType)JavaPrimitiveType.BOOLEAN);
                            return new JavaConditionalExpression(_from, (JavaExpression)r, (JavaExpression)l, this.typeUtil);
                        };
                        _xifexpression = _xblockexpression_5 = leftCode.then(rightCode, _function, context.scope);
                    } else {
                        JavaStatementBuilder _xblockexpression_6 = null;
                        JavaClass<?> resultType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRMetaAnnotatedType(expr));
                        JavaStatementBuilder rightCode = this.javaCode(right, (JavaType)joined, context.scope);
                        BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (l, r) -> {
                            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)l, (JavaExpression)r){
                                final /* synthetic */ JavaExpression val$l;
                                final /* synthetic */ JavaExpression val$r;
                                {
                                    this.val$l = javaExpression;
                                    this.val$r = javaExpression2;
                                }

                                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                    _builder.append((Object)this.val$l);
                                    _builder.append((Object)".getOrDefault(");
                                    _builder.append((Object)this.val$r);
                                    _builder.append((Object)")");
                                }
                            };
                            return JavaExpression.from(_client, (JavaType)resultType);
                        };
                        _xifexpression = _xblockexpression_6 = leftCode.then(rightCode, _function, context.scope);
                    }
                    _switchResult = _xblockexpression_4 = _xifexpression;
                    break;
                }
                case "join": {
                    boolean _tripleEquals;
                    JavaStatementBuilder _xblockexpression_5 = null;
                    JavaStatementBuilder leftCode = this.javaCode(left, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, (JavaType)this.typeUtil.STRING), context.scope);
                    JavaStatementBuilder _xifexpression = null;
                    RosettaExpression _right = expr.getRight();
                    boolean bl = _tripleEquals = _right == null;
                    if (_tripleEquals) {
                        StringConcatenationClient _client = new StringConcatenationClient(this){

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append(MapperS.class);
                                _builder.append((Object)".of(\"\")");
                            }
                        };
                        _xifexpression = JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)this.typeUtil.STRING));
                    } else {
                        _xifexpression = this.javaCode(right, (JavaType)this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)this.typeUtil.STRING), context.scope);
                    }
                    JavaStatementBuilder rightCode = _xifexpression;
                    BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (l, r) -> {
                        StringConcatenationClient _client_1 = new StringConcatenationClient(this, (JavaExpression)l, (JavaExpression)r){
                            final /* synthetic */ JavaExpression val$l;
                            final /* synthetic */ JavaExpression val$r;
                            {
                                this.val$l = javaExpression;
                                this.val$r = javaExpression2;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$l);
                                _builder.append((Object)".join(");
                                _builder.append((Object)this.val$r);
                                _builder.append((Object)")");
                            }
                        };
                        return JavaExpression.from(_client_1, this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)this.typeUtil.STRING));
                    };
                    _switchResult = _xblockexpression_5 = leftCode.then(rightCode, _function, context.scope);
                    break;
                }
                case "=": 
                case "<>": 
                case "<": 
                case "<=": 
                case ">": 
                case ">=": {
                    JavaStatementBuilder _xblockexpression_6 = null;
                    RType leftRtype = this.typeProvider.getRMetaAnnotatedType(expr.getLeft()).getRType();
                    RType rightRtype = this.typeProvider.getRMetaAnnotatedType(expr.getRight()).getRType();
                    JavaClass<?> joinedWithoutMeta = this._javaTypeTranslator.toJavaReferenceType(this._typeSystem.join(leftRtype, rightRtype));
                    String _switchResult_1 = null;
                    String _operator_1 = expr.getOperator();
                    if (_operator_1 != null) {
                        switch (_operator_1) {
                            case "=": {
                                _switchResult_1 = "areEqual";
                                break;
                            }
                            case "<>": {
                                _switchResult_1 = "notEqual";
                                break;
                            }
                            case "<": {
                                _switchResult_1 = "lessThan";
                                break;
                            }
                            case "<=": {
                                _switchResult_1 = "lessThanEquals";
                                break;
                            }
                            case ">": {
                                _switchResult_1 = "greaterThan";
                                break;
                            }
                            case ">=": {
                                _switchResult_1 = "greaterThanEquals";
                            }
                        }
                    }
                    final String method = _switchResult_1;
                    CardinalityModifier modifier = ((ModifiableBinaryOperation)expr).getCardMod();
                    CardinalityModifier _xifexpression = null;
                    String _operator_2 = expr.getOperator();
                    boolean _equals = Objects.equals(_operator_2, "<>");
                    _xifexpression = _equals ? CardinalityModifier.ANY : CardinalityModifier.ALL;
                    CardinalityModifier defaultModifier = _xifexpression;
                    JavaStatementBuilder leftCode = this.javaCode(left, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)joinedWithoutMeta), context.scope);
                    JavaStatementBuilder rightCode = this.javaCode(right, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)joinedWithoutMeta), context.scope);
                    BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (l, r) -> {
                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)l, (JavaExpression)r, modifier, defaultModifier){
                            final /* synthetic */ JavaExpression val$l;
                            final /* synthetic */ JavaExpression val$r;
                            final /* synthetic */ CardinalityModifier val$modifier;
                            final /* synthetic */ CardinalityModifier val$defaultModifier;
                            {
                                this.val$l = javaExpression;
                                this.val$r = javaExpression2;
                                this.val$modifier = cardinalityModifier;
                                this.val$defaultModifier = cardinalityModifier2;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod(method);
                                _builder.append((Object)_runtimeMethod);
                                _builder.append((Object)"(");
                                _builder.append((Object)this.val$l);
                                _builder.append((Object)", ");
                                _builder.append((Object)this.val$r);
                                _builder.append((Object)", ");
                                StringConcatenationClient _cardinalityOperator = ExpressionGenerator.this.toCardinalityOperator(this.val$modifier, this.val$defaultModifier);
                                _builder.append((Object)_cardinalityOperator);
                                _builder.append((Object)")");
                            }
                        };
                        return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
                    };
                    _switchResult = _xblockexpression_6 = leftCode.then(rightCode, _function, context.scope);
                    break;
                }
                default: {
                    String _operator_1 = expr.getOperator();
                    String _plus = "Unsupported binary operation of " + _operator_1;
                    throw new UnsupportedOperationException(_plus);
                }
            }
        } else {
            String _operator_1 = expr.getOperator();
            String _plus = "Unsupported binary operation of " + _operator_1;
            throw new UnsupportedOperationException(_plus);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    private StringConcatenationClient toCardinalityOperator(final CardinalityModifier cardOp, final CardinalityModifier defaultOp) {
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(CardinalityOperator.class);
                _builder.append((Object)".");
                String _xifexpression = null;
                _xifexpression = cardOp == CardinalityModifier.NONE ? StringExtensions.toFirstUpper((String)defaultOp.toString()) : StringExtensions.toFirstUpper((String)cardOp.toString());
                _builder.append((Object)_xifexpression);
            }
        };
        return _client;
    }

    private static StringConcatenationClient buildMapFunc(final RosettaMetaType meta, JavaScope scope) {
        StringConcatenationClient _xifexpression = null;
        String _name = meta.getName();
        boolean _equals = Objects.equals(_name, "reference");
        if (_equals) {
            StringConcatenationClient _client;
            StringConcatenationClient _xblockexpression = null;
            JavaScope lambdaScope = scope.lambdaScope();
            final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier("a");
            _xifexpression = _xblockexpression = (_client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)".map(\"get");
                    String _firstUpper = StringExtensions.toFirstUpper((String)meta.getName());
                    _builder.append((Object)_firstUpper);
                    _builder.append((Object)"\", ");
                    _builder.append((Object)lambdaParam);
                    _builder.append((Object)"->");
                    _builder.append((Object)lambdaParam);
                    _builder.append((Object)".getExternalReference())");
                }
            });
        } else {
            StringConcatenationClient _client;
            StringConcatenationClient _xblockexpression_1 = null;
            JavaScope lambdaScope1 = scope.lambdaScope();
            final GeneratedIdentifier lambdaParam1 = lambdaScope1.createUniqueIdentifier("a");
            JavaScope lambdaScope2 = scope.lambdaScope();
            final GeneratedIdentifier lambdaParam2 = lambdaScope2.createUniqueIdentifier("a");
            _xifexpression = _xblockexpression_1 = (_client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)".map(\"getMeta\", ");
                    _builder.append((Object)lambdaParam1);
                    _builder.append((Object)"->");
                    _builder.append((Object)lambdaParam1);
                    _builder.append((Object)".getMeta()).map(\"get");
                    String _firstUpper = StringExtensions.toFirstUpper((String)meta.getName());
                    _builder.append((Object)_firstUpper);
                    _builder.append((Object)"\", ");
                    _builder.append((Object)lambdaParam2);
                    _builder.append((Object)"->");
                    _builder.append((Object)lambdaParam2);
                    _builder.append((Object)".get");
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)meta.getName());
                    _builder.append((Object)_firstUpper_1);
                    _builder.append((Object)"())");
                }
            });
        }
        return _xifexpression;
    }

    private Pair<StringConcatenationClient, JavaType> inlineFunction(InlineFunction ref, JavaType expectedType, JavaScope scope) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        boolean _equals;
        Pair _xblockexpression = null;
        JavaScope lambdaScope = scope.lambdaScope();
        List _xifexpression = null;
        int _size = ref.getParameters().size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            GeneratedIdentifier _createIdentifier = lambdaScope.createIdentifier(this._javaIdentifierRepresentationService.getImplicitVarInContext(ref), this._implicitVariableUtil.getDefaultImplicitVariable().getName());
            _xifexpression = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new GeneratedIdentifier[]{_createIdentifier}));
        } else {
            Function<ClosureParameter, GeneratedIdentifier> _function = it -> lambdaScope.createIdentifier((RosettaNamed)it);
            _xifexpression = ref.getParameters().stream().map(_function).collect(Collectors.toList());
        }
        final List paramIds = _xifexpression;
        final JavaStatementBuilder body = this.javaCode(ref.getBody(), expectedType, lambdaScope);
        StringConcatenationClient _xifexpression_1 = null;
        int _size_1 = paramIds.size();
        boolean _equals_1 = _size_1 == 1;
        _xifexpression_1 = _equals_1 ? (_client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                GeneratedIdentifier _head = (GeneratedIdentifier)IterableExtensions.head((Iterable)paramIds);
                _builder.append((Object)_head);
                _builder.append((Object)" -> ");
                JavaLambdaBody _lambdaBody = body.toLambdaBody();
                _builder.append((Object)_lambdaBody);
            }
        }) : (_client_1 = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"(");
                boolean _hasElements = false;
                for (GeneratedIdentifier id : paramIds) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    _builder.append((Object)id);
                }
                _builder.append((Object)") -> ");
                JavaLambdaBody _lambdaBody = body.toLambdaBody();
                _builder.append((Object)_lambdaBody);
            }
        });
        JavaType _expressionType = body.getExpressionType();
        _xblockexpression = new Pair((Object)_xifexpression_1, (Object)_expressionType);
        return _xblockexpression;
    }

    private JavaStatementBuilder buildConstraint(RosettaExpression arg, Collection<RAttribute> usedAttributes, Necessity validationType, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        JavaClass<?> argItemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRMetaAnnotatedType(arg).getRType());
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it, usedAttributes, validationType){
                final /* synthetic */ JavaExpression val$it;
                final /* synthetic */ Collection val$usedAttributes;
                final /* synthetic */ Necessity val$validationType;
                {
                    this.val$it = javaExpression;
                    this.val$usedAttributes = collection;
                    this.val$validationType = necessity;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod("choice");
                    _builder.append((Object)_runtimeMethod);
                    _builder.append((Object)"(");
                    _builder.append((Object)this.val$it);
                    _builder.append((Object)", ");
                    _builder.append(Arrays.class);
                    _builder.append((Object)".asList(");
                    Functions.Function1 _function = it_1 -> {
                        String _name = it_1.getName();
                        String _plus = "\"" + _name;
                        return _plus + "\"";
                    };
                    String _join = IterableExtensions.join((Iterable)this.val$usedAttributes, (CharSequence)", ", (Functions.Function1)_function);
                    _builder.append((Object)_join);
                    _builder.append((Object)"), ");
                    _builder.append(ChoiceRuleValidationMethod.class);
                    _builder.append((Object)".");
                    String _name = this.val$validationType.name();
                    _builder.append((Object)_name);
                    _builder.append((Object)")");
                }
            };
            return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
        };
        _xblockexpression = this.javaCode(arg, (JavaType)this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER, (JavaType)argItemType), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function);
        return _xblockexpression;
    }

    private JavaStatementBuilder buildListOperationNoBody(RosettaUnaryOperation op, String name, JavaType expectedArgumentType, Functions.Function1<? super JavaType, ? extends JavaType> argumentTypeToReturnType, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        JavaStatementBuilder argCode = this.javaCode(op.getArgument(), expectedArgumentType, scope).collapseToSingleExpression(scope);
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, name){
                final /* synthetic */ JavaExpression val$it;
                final /* synthetic */ String val$name;
                {
                    this.val$it = javaExpression;
                    this.val$name = string;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)this.val$it);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".");
                    _builder.append((Object)this.val$name, "\t");
                    _builder.append((Object)"()");
                }
            };
            return JavaExpression.from(_client, (JavaType)argumentTypeToReturnType.apply((Object)argCode.getExpressionType()));
        };
        _xblockexpression = argCode.mapExpression(_function);
        return _xblockexpression;
    }

    private JavaStatementBuilder buildSingleItemListOperationOptionalBody(RosettaFunctionalOperation op, String name, JavaType expectedArgumentType, JavaType expectedBodyType, Functions.Function2<? super JavaType, ? super JavaType, ? extends JavaType> argumentAndBodyTypeToReturnType, boolean autoUnwrapMeta, JavaScope scope) {
        boolean _tripleEquals;
        JavaStatementBuilder _xifexpression = null;
        InlineFunction _function = op.getFunction();
        boolean bl = _tripleEquals = _function == null;
        if (_tripleEquals) {
            JavaStatementBuilder _xifexpression_1 = null;
            if (autoUnwrapMeta && this.typeUtil.getItemType(expectedArgumentType) instanceof RJavaFieldWithMeta) {
                JavaType _itemType = this.typeUtil.getItemType(expectedArgumentType);
                _xifexpression_1 = this.buildUnwrappingListOperation(op, name, expectedArgumentType, (RJavaFieldWithMeta)_itemType, expectedBodyType, argumentAndBodyTypeToReturnType, scope);
            } else {
                Functions.Function1 _function_1 = it -> (JavaType)argumentAndBodyTypeToReturnType.apply(it, null);
                _xifexpression_1 = this.buildListOperationNoBody(op, name, expectedArgumentType, (Functions.Function1<? super JavaType, ? extends JavaType>)_function_1, scope);
            }
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = this.buildSingleItemListOperation(op, name, expectedArgumentType, expectedBodyType, argumentAndBodyTypeToReturnType, scope);
        }
        return _xifexpression;
    }

    private JavaStatementBuilder buildSingleItemListOperation(RosettaFunctionalOperation op, String name, JavaType expectedArgumentType, JavaType expectedBodyType, Functions.Function2<? super JavaType, ? super JavaType, ? extends JavaType> argumentAndBodyTypeToReturnType, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        JavaStatementBuilder argCode = this.javaCode(op.getArgument(), expectedArgumentType, scope).collapseToSingleExpression(scope);
        Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(op.getFunction(), expectedBodyType, scope);
        StringConcatenationClient inlineFunctionCode = (StringConcatenationClient)inlineFunctionCodeAndBodyType.getKey();
        JavaType inlineFunctionBodyType = (JavaType)inlineFunctionCodeAndBodyType.getValue();
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, name, inlineFunctionCode){
                final /* synthetic */ JavaExpression val$it;
                final /* synthetic */ String val$name;
                final /* synthetic */ StringConcatenationClient val$inlineFunctionCode;
                {
                    this.val$it = javaExpression;
                    this.val$name = string;
                    this.val$inlineFunctionCode = stringConcatenationClient;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)this.val$it);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".");
                    _builder.append((Object)this.val$name, "\t");
                    _builder.append((Object)"(");
                    _builder.append((Object)this.val$inlineFunctionCode, "\t");
                    _builder.append((Object)")");
                }
            };
            return JavaExpression.from(_client, (JavaType)argumentAndBodyTypeToReturnType.apply((Object)argCode.getExpressionType(), (Object)inlineFunctionBodyType));
        };
        _xblockexpression = argCode.mapExpression(_function);
        return _xblockexpression;
    }

    private JavaStatementBuilder buildUnwrappingListOperation(RosettaFunctionalOperation op, String name, JavaType expectedArgumentType, RJavaWithMetaValue expectedItemType, JavaType expectedBodyType, Functions.Function2<? super JavaType, ? super JavaType, ? extends JavaType> argumentAndBodyTypeToReturnType, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        JavaStatementBuilder argCode = this.javaCode(op.getArgument(), expectedArgumentType, scope).collapseToSingleExpression(scope);
        GeneratedIdentifier _createUniqueIdentifier = scope.createUniqueIdentifier("lambdaParam");
        JavaParameterizedType<MapperS<?>> _wrap = this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)expectedItemType);
        JavaVariable lambdaPara = new JavaVariable(_createUniqueIdentifier, (JavaType)_wrap);
        JavaStatementBuilder unwrapCoerceon = this.typeCoercionService.addCoercions(lambdaPara, (JavaType)this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)expectedItemType.getValueType()), scope);
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, name, lambdaPara, unwrapCoerceon){
                final /* synthetic */ JavaExpression val$it;
                final /* synthetic */ String val$name;
                final /* synthetic */ JavaVariable val$lambdaPara;
                final /* synthetic */ JavaStatementBuilder val$unwrapCoerceon;
                {
                    this.val$it = javaExpression;
                    this.val$name = string;
                    this.val$lambdaPara = javaVariable;
                    this.val$unwrapCoerceon = javaStatementBuilder;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)this.val$it);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".");
                    _builder.append((Object)this.val$name, "\t");
                    _builder.append((Object)"(");
                    _builder.append((Object)this.val$lambdaPara, "\t");
                    _builder.append((Object)" -> ");
                    JavaLambdaBody _lambdaBody = this.val$unwrapCoerceon.toLambdaBody();
                    _builder.append((Object)_lambdaBody, "\t");
                    _builder.append((Object)")");
                }
            };
            return JavaExpression.from(_client, (JavaType)argumentAndBodyTypeToReturnType.apply((Object)argCode.getExpressionType(), (Object)expectedItemType.getValueType()));
        };
        _xblockexpression = argCode.mapExpression(_function);
        return _xblockexpression;
    }

    public StringConcatenationClient toNodeLabel(final RosettaExpression expr) {
        StringConcatenationClient _client;
        StringConcatenationClient _switchResult = null;
        boolean _matched = false;
        if (expr instanceof RosettaFeatureCall) {
            _matched = true;
            _switchResult = this.toNodeLabel((RosettaFeatureCall)expr);
        }
        if (!_matched && expr instanceof RosettaBinaryOperation) {
            _matched = true;
            _switchResult = this.toNodeLabel((RosettaBinaryOperation)expr);
        }
        if (!_matched && expr instanceof RosettaStringLiteral) {
            _matched = true;
            _switchResult = _client = new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"\\\"");
                    String _value = ((RosettaStringLiteral)expr).getValue();
                    _builder.append((Object)_value);
                    _builder.append((Object)"\\\"");
                }
            };
        }
        if (!_matched && expr instanceof RosettaConditionalExpression) {
            _matched = true;
            _switchResult = _client = new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"choice");
                }
            };
        }
        if (!_matched && expr instanceof RosettaEnumValueReference) {
            _matched = true;
            _switchResult = _client = new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _name = ((RosettaEnumValueReference)((Object)expr)).getEnumeration().getName();
                    _builder.append((Object)_name);
                }
            };
        }
        if (!_matched && expr instanceof RosettaEnumValue) {
            _matched = true;
            _switchResult = _client = new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _name = ((RosettaEnumValue)((Object)expr)).getName();
                    _builder.append((Object)_name);
                }
            };
        }
        if (!_matched && expr instanceof ListLiteral) {
            _matched = true;
            _switchResult = _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"[");
                    EList<RosettaExpression> _elements = ((ListLiteral)expr).getElements();
                    boolean _hasElements = false;
                    for (RosettaExpression el : _elements) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder.appendImmediate((Object)", ", "");
                        }
                        StringConcatenationClient _nodeLabel = ExpressionGenerator.this.toNodeLabel(el);
                        _builder.append((Object)_nodeLabel);
                    }
                    _builder.append((Object)"]");
                }
            };
        }
        if (!_matched && expr instanceof RosettaLiteral) {
            _matched = true;
            _switchResult = _client = new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _stringValue = ((RosettaLiteral)expr).stringValue();
                    _builder.append((Object)_stringValue);
                }
            };
        }
        if (!_matched && expr instanceof RosettaSymbolReference) {
            _matched = true;
            _switchResult = _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _name = ((RosettaSymbolReference)expr).getSymbol().getName();
                    _builder.append((Object)_name);
                    boolean _isExplicitArguments = ((RosettaSymbolReference)expr).isExplicitArguments();
                    if (_isExplicitArguments) {
                        _builder.append((Object)"(");
                        EList<RosettaExpression> _args = ((RosettaSymbolReference)expr).getArgs();
                        boolean _hasElements = false;
                        for (RosettaExpression arg : _args) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)", ", "");
                            }
                            StringConcatenationClient _nodeLabel = ExpressionGenerator.this.toNodeLabel(arg);
                            _builder.append((Object)_nodeLabel);
                        }
                        _builder.append((Object)")");
                    }
                }
            };
        }
        if (!_matched && expr instanceof RosettaImplicitVariable) {
            _matched = true;
            _switchResult = _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _name = ExpressionGenerator.this._implicitVariableUtil.getDefaultImplicitVariable().getName();
                    _builder.append((Object)_name);
                }
            };
        }
        if (!_matched && expr instanceof RosettaFunctionalOperation) {
            _matched = true;
            _switchResult = _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    boolean _tripleNotEquals;
                    StringConcatenationClient _nodeLabel = ExpressionGenerator.this.toNodeLabel(((RosettaFunctionalOperation)expr).getArgument());
                    _builder.append((Object)_nodeLabel);
                    _builder.append((Object)" ");
                    String _operator = ((RosettaFunctionalOperation)expr).getOperator();
                    _builder.append((Object)_operator);
                    InlineFunction _function = ((RosettaFunctionalOperation)expr).getFunction();
                    boolean bl = _tripleNotEquals = _function != null;
                    if (_tripleNotEquals) {
                        _builder.append((Object)" [");
                        StringConcatenationClient _nodeLabel_1 = ExpressionGenerator.this.toNodeLabel(((RosettaFunctionalOperation)expr).getFunction().getBody());
                        _builder.append((Object)_nodeLabel_1);
                        _builder.append((Object)"]");
                    }
                }
            };
        }
        if (!_matched && expr instanceof RosettaUnaryOperation) {
            _matched = true;
            _switchResult = _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    StringConcatenationClient _nodeLabel = ExpressionGenerator.this.toNodeLabel(((RosettaUnaryOperation)expr).getArgument());
                    _builder.append((Object)_nodeLabel);
                    _builder.append((Object)" ");
                    String _operator = ((RosettaUnaryOperation)expr).getOperator();
                    _builder.append((Object)_operator);
                }
            };
        }
        if (!_matched) {
            _switchResult = _client = new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"Unsupported expression type of ");
                    Class<?> _class = null;
                    if (expr != null) {
                        _class = expr.getClass();
                    }
                    String _name = null;
                    if (_class != null) {
                        _name = _class.getName();
                    }
                    _builder.append((Object)_name);
                }
            };
        }
        return _switchResult;
    }

    public StringConcatenationClient toNodeLabel(RosettaFeatureCall call) {
        StringConcatenationClient _client;
        StringConcatenationClient _xblockexpression = null;
        RosettaFeature feature = call.getFeature();
        String _switchResult = null;
        boolean _matched = false;
        if (feature instanceof RosettaMetaType) {
            _matched = true;
        }
        if (!_matched && feature instanceof Attribute) {
            _matched = true;
        }
        if (!_matched && feature instanceof RosettaEnumValue) {
            _matched = true;
        }
        if (_matched) {
            _switchResult = feature.getName();
        }
        if (!_matched) {
            Class<?> _class = null;
            if (feature != null) {
                _class = feature.getClass();
            }
            String _plus = "Unsupported expression type (feature) " + String.valueOf(_class);
            throw new UnsupportedOperationException(_plus);
        }
        final String right = _switchResult;
        RosettaExpression receiver = call.getReceiver();
        final StringConcatenationClient left = this.toNodeLabel(receiver);
        _xblockexpression = _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)left);
                _builder.append((Object)"->");
                _builder.append((Object)right);
            }
        };
        return _xblockexpression;
    }

    public StringConcatenationClient toNodeLabel(final RosettaBinaryOperation binOp) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                StringConcatenationClient _nodeLabel = ExpressionGenerator.this.toNodeLabel(binOp.getLeft());
                _builder.append((Object)_nodeLabel);
                _builder.append((Object)" ");
                String _operator = binOp.getOperator();
                _builder.append((Object)_operator);
                _builder.append((Object)" ");
                StringConcatenationClient _nodeLabel_1 = ExpressionGenerator.this.toNodeLabel(binOp.getRight());
                _builder.append((Object)_nodeLabel_1);
            }
        };
        return _client;
    }

    @Override
    protected JavaStatementBuilder caseAbsentOperation(RosettaAbsentExpression expr, Context context) {
        return this.applyRuntimeMethod(this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, expr.getArgument()), context.scope), "notExists", (JavaType)this.typeUtil.COMPARISON_RESULT);
    }

    @Override
    protected JavaStatementBuilder caseAddOperation(ArithmeticOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseAndOperation(LogicalOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseAsKeyOperation(AsKeyOperation expr, Context context) {
        return (JavaStatementBuilder)this.doSwitch(expr.getArgument(), context);
    }

    @Override
    protected JavaStatementBuilder caseBooleanLiteral(RosettaBooleanLiteral expr, Context context) {
        JavaLiteral _xifexpression = null;
        boolean _isValue = expr.isValue();
        _xifexpression = _isValue ? JavaLiteral.TRUE : JavaLiteral.FALSE;
        return _xifexpression;
    }

    @Override
    protected JavaStatementBuilder caseChoiceOperation(ChoiceOperation expr, Context context) {
        Functions.Function1 _function = it -> this._rObjectFactory.buildRAttribute((Attribute)it);
        return this.buildConstraint(expr.getArgument(), ListExtensions.map(expr.getAttributes(), (Functions.Function1)_function), expr.getNecessity(), context);
    }

    @Override
    protected JavaStatementBuilder caseConditionalExpression(RosettaConditionalExpression expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        JavaStatementBuilder condition = this.javaCode(expr.getIf(), (JavaType)JavaPrimitiveType.BOOLEAN, context.scope);
        JavaStatementBuilder thenBranch = this.javaCode(expr.getIfthen(), context.expectedType, context.scope);
        JavaStatementBuilder elseBranch = this.javaCode(expr.getElsethen(), context.expectedType, context.scope);
        Function<JavaExpression, JavaStatementBuilder> _function = it -> new JavaIfThenElseBuilder((JavaExpression)it, thenBranch, elseBranch, this.typeUtil);
        _xblockexpression = condition.collapseToSingleExpression(context.scope).mapExpression(_function);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseContainsOperation(RosettaContainsExpression expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseDefaultOperation(DefaultOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseCountOperation(RosettaCountOperation expr, Context context) {
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it){
                final /* synthetic */ JavaExpression val$it;
                {
                    this.val$it = javaExpression;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)this.val$it);
                    _builder.append((Object)".resultCount()");
                }
            };
            return JavaExpression.from(_client, (JavaType)JavaPrimitiveType.INT);
        };
        return this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, expr.getArgument()), context.scope).mapExpression(_function);
    }

    @Override
    protected JavaStatementBuilder caseDisjointOperation(RosettaDisjointExpression expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseDistinctOperation(DistinctOperation expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        JavaClass<?> argItemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRMetaAnnotatedType(expr.getArgument()));
        JavaStatementBuilder argCode = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)argItemType), context.scope);
        JavaType argType = argCode.getExpressionType();
        JavaParameterizedType<MapperC<?>> _xifexpression = null;
        boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument(argType);
        _xifexpression = _hasWildcardArgument ? this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, (JavaType)argItemType) : this.typeUtil.wrap(this.typeUtil.MAPPER_C, (JavaType)argItemType);
        _xblockexpression = this.applyRuntimeMethod(argCode, "distinct", (JavaType)_xifexpression);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseDivideOperation(ArithmeticOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseEqualsOperation(EqualityOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    public JavaStatementBuilder exists(JavaStatementBuilder arg, ExistsModifier modifier, JavaScope scope) {
        JavaStatementBuilder _xblockexpression = null;
        String _xifexpression = null;
        if (modifier == ExistsModifier.SINGLE) {
            _xifexpression = "singleExists";
        } else {
            String _xifexpression_1 = null;
            _xifexpression_1 = modifier == ExistsModifier.MULTIPLE ? "multipleExists" : "exists";
            _xifexpression = _xifexpression_1;
        }
        String methodName = _xifexpression;
        _xblockexpression = this.applyRuntimeMethod(this.typeCoercionService.addCoercions(arg, (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, this.typeUtil.getItemType(arg.getExpressionType())), scope), methodName, (JavaType)this.typeUtil.COMPARISON_RESULT);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseExistsOperation(RosettaExistsExpression expr, Context context) {
        return this.exists(this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, expr.getArgument()), context.scope), expr.getModifier(), context.scope);
    }

    @Override
    protected JavaStatementBuilder caseFeatureCall(RosettaFeatureCall expr, Context context) {
        RosettaFeature feature = expr.getFeature();
        if (feature instanceof RosettaEnumValue) {
            return this.enumCall((RosettaEnumValue)feature, context.expectedType);
        }
        if (feature instanceof Attribute) {
            return this.attributeCall(this.javaCode(expr.getReceiver(), (JavaType)this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER, expr.getReceiver()), context.scope), this.typeProvider.getRMetaAnnotatedType(expr.getReceiver()), this._rObjectFactory.buildRAttribute((Attribute)feature), false, context.expectedType, context.scope);
        }
        if (feature instanceof RosettaMetaType) {
            return this.metaCall(this.javaCode(expr.getReceiver(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, expr.getReceiver()), context.scope), this.typeProvider.getRMetaAnnotatedType(expr.getReceiver()), (RosettaMetaType)feature, context.scope);
        }
        if (feature instanceof RosettaRecordFeature) {
            return this.recordCall(this.javaCode(expr.getReceiver(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, expr.getReceiver()), context.scope), this.typeProvider.getRMetaAnnotatedType(expr.getReceiver()), (RosettaRecordFeature)feature, context.scope);
        }
        Class<?> _class = null;
        if (feature != null) {
            _class = feature.getClass();
        }
        String _name = null;
        if (_class != null) {
            _name = _class.getName();
        }
        String _plus = "Unsupported feature type of " + _name;
        throw new UnsupportedOperationException(_plus);
    }

    @Override
    protected JavaStatementBuilder caseDeepFeatureCall(RosettaDeepFeatureCall expr, Context context) {
        return this.attributeCall(this.javaCode(expr.getReceiver(), (JavaType)this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER, expr.getReceiver()), context.scope), this.typeProvider.getRMetaAnnotatedType(expr.getReceiver()), this._rObjectFactory.buildRAttribute(expr.getFeature()), true, context.expectedType, context.scope);
    }

    @Override
    protected JavaStatementBuilder caseFilterOperation(FilterOperation expr, Context context) {
        boolean _not;
        JavaStatementBuilder _xblockexpression = null;
        StringConcatenationClient inlineFunctionCode = (StringConcatenationClient)this.inlineFunction(expr.getFunction(), (JavaType)JavaPrimitiveType.BOOLEAN.toReferenceType(), context.scope).getKey();
        JavaStatementBuilder _xifexpression = null;
        boolean _isPreviousOperationMulti = this.cardinalityProvider.isPreviousOperationMulti(expr);
        boolean bl = _not = !_isPreviousOperationMulti;
        if (_not) {
            JavaStatementBuilder _xblockexpression_1 = null;
            JavaStatementBuilder argCode = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope);
            Function<JavaExpression, JavaStatementBuilder> _function = it -> {
                StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, inlineFunctionCode){
                    final /* synthetic */ JavaExpression val$it;
                    final /* synthetic */ StringConcatenationClient val$inlineFunctionCode;
                    {
                        this.val$it = javaExpression;
                        this.val$inlineFunctionCode = stringConcatenationClient;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)this.val$it);
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)".filterSingleNullSafe(");
                        _builder.append((Object)this.val$inlineFunctionCode, "\t");
                        _builder.append((Object)")");
                    }
                };
                return JavaExpression.from(_client, argCode.getExpressionType());
            };
            _xifexpression = _xblockexpression_1 = argCode.mapExpression(_function);
        } else {
            JavaStatementBuilder _xifexpression_1 = null;
            boolean _isOutputListOfLists = this.cardinalityProvider.isOutputListOfLists(expr.getArgument());
            if (_isOutputListOfLists) {
                JavaStatementBuilder _xblockexpression_2 = null;
                JavaStatementBuilder argCode = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope);
                Function<JavaExpression, JavaStatementBuilder> _function = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, inlineFunctionCode){
                        final /* synthetic */ JavaExpression val$it;
                        final /* synthetic */ StringConcatenationClient val$inlineFunctionCode;
                        {
                            this.val$it = javaExpression;
                            this.val$inlineFunctionCode = stringConcatenationClient;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$it);
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".filterListNullSafe(");
                            _builder.append((Object)this.val$inlineFunctionCode, "\t");
                            _builder.append((Object)")");
                        }
                    };
                    return JavaExpression.from(_client, argCode.getExpressionType());
                };
                _xifexpression_1 = _xblockexpression_2 = argCode.mapExpression(_function);
            } else {
                JavaStatementBuilder _xblockexpression_3 = null;
                JavaStatementBuilder argCode = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope);
                Function<JavaExpression, JavaStatementBuilder> _function = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, inlineFunctionCode){
                        final /* synthetic */ JavaExpression val$it;
                        final /* synthetic */ StringConcatenationClient val$inlineFunctionCode;
                        {
                            this.val$it = javaExpression;
                            this.val$inlineFunctionCode = stringConcatenationClient;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$it);
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".filterItemNullSafe(");
                            _builder.append((Object)this.val$inlineFunctionCode, "\t");
                            _builder.append((Object)")");
                        }
                    };
                    return JavaExpression.from(_client, argCode.getExpressionType());
                };
                _xifexpression_1 = _xblockexpression_3 = argCode.mapExpression(_function);
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseFirstOperation(FirstOperation expr, Context context) {
        Functions.Function1 _function = it -> this.typeUtil.wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType((JavaType)it));
        return this.buildListOperationNoBody(expr, "first", (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), (Functions.Function1<? super JavaType, ? extends JavaType>)_function, context.scope);
    }

    @Override
    protected JavaStatementBuilder caseFlattenOperation(FlattenOperation expr, Context context) {
        Functions.Function1 _function = it -> {
            JavaParameterizedType<MapperC<?>> _xifexpression = null;
            boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument((JavaType)it);
            _xifexpression = _hasWildcardArgument ? this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()) : this.typeUtil.wrap(this.typeUtil.MAPPER_C, expr.getArgument());
            return _xifexpression;
        };
        return this.buildListOperationNoBody(expr, "flattenList", (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, expr.getArgument()), (Functions.Function1<? super JavaType, ? extends JavaType>)_function, context.scope);
    }

    @Override
    protected JavaStatementBuilder caseGreaterThanOperation(ComparisonOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseGreaterThanOrEqualOperation(ComparisonOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseImplicitVariable(RosettaImplicitVariable expr, Context context) {
        return this.implicitVariable(expr, context.scope);
    }

    @Override
    protected JavaStatementBuilder caseIntLiteral(final RosettaIntLiteral expr, Context context) {
        BigInteger _value_1;
        BigInteger _value;
        int intValue = expr.getValue().intValue();
        BigInteger _valueOf = BigInteger.valueOf(intValue);
        boolean _equals = Objects.equals(_valueOf, _value = expr.getValue());
        if (_equals) {
            return JavaLiteral.INT(intValue);
        }
        long longValue = expr.getValue().longValue();
        BigInteger _valueOf_1 = BigInteger.valueOf(longValue);
        boolean _equals_1 = Objects.equals(_valueOf_1, _value_1 = expr.getValue());
        if (_equals_1) {
            return JavaLiteral.LONG(longValue);
        }
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"new ");
                _builder.append(BigInteger.class);
                _builder.append((Object)"(\"");
                BigInteger _value = expr.getValue();
                _builder.append((Object)_value);
                _builder.append((Object)"\")");
            }
        };
        return JavaExpression.from(_client, this.typeUtil.BIG_INTEGER);
    }

    @Override
    protected JavaStatementBuilder caseJoinOperation(JoinOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseLastOperation(LastOperation expr, Context context) {
        Functions.Function1 _function = it -> this.typeUtil.wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType((JavaType)it));
        return this.buildListOperationNoBody(expr, "last", (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), (Functions.Function1<? super JavaType, ? extends JavaType>)_function, context.scope);
    }

    @Override
    protected JavaStatementBuilder caseLessThanOperation(ComparisonOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseLessThanOrEqualOperation(ComparisonOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseListLiteral(ListLiteral expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        boolean _isEmpty = expr.getElements().isEmpty();
        if (_isEmpty) {
            return JavaLiteral.NULL;
        }
        JavaClass<?> itemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRMetaAnnotatedType(expr));
        ArrayList elements = CollectionLiterals.newArrayList();
        for (int i = 0; i < expr.getElements().size(); ++i) {
            RosettaExpression elem = (RosettaExpression)expr.getElements().get(i);
            JavaParameterizedType<MapperS<?>> _xifexpression = null;
            boolean _isMulti = this.cardinalityProvider.isMulti(elem);
            if (_isMulti) {
                JavaParameterizedType<MapperC<?>> _wrapExtends = this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, (JavaType)itemType);
                _xifexpression = _wrapExtends;
            } else {
                _xifexpression = this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, (JavaType)itemType);
            }
            elements.add(this.javaCode(elem, (JavaType)_xifexpression, context.scope));
        }
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaClass)itemType, (JavaExpression)it){
                final /* synthetic */ JavaClass val$itemType;
                final /* synthetic */ JavaExpression val$it;
                {
                    this.val$itemType = javaClass;
                    this.val$it = javaExpression;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append(MapperC.class);
                    _builder.append((Object)".<");
                    _builder.append((Object)this.val$itemType);
                    _builder.append((Object)">of(");
                    _builder.append((Object)this.val$it);
                    _builder.append((Object)")");
                }
            };
            return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_C, (JavaType)itemType));
        };
        _xblockexpression = JavaStatementBuilder.invokeMethod(elements, _function, context.scope);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseMapOperation(MapOperation expr, Context context) {
        boolean _not;
        JavaStatementBuilder _xblockexpression = null;
        JavaClass<?> bodyItemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRMetaAnnotatedType(expr.getFunction().getBody()));
        boolean isBodyMulti = this.cardinalityProvider.isBodyExpressionMulti(expr.getFunction());
        JavaStatementBuilder _xifexpression = null;
        boolean _isPreviousOperationMulti = this.cardinalityProvider.isPreviousOperationMulti(expr);
        boolean bl = _not = !_isPreviousOperationMulti;
        if (_not) {
            JavaStatementBuilder _xifexpression_1 = null;
            if (isBodyMulti) {
                JavaStatementBuilder _xblockexpression_1 = null;
                Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(expr.getFunction(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, (JavaType)bodyItemType), context.scope);
                StringConcatenationClient inlineFunctionCode = (StringConcatenationClient)inlineFunctionCodeAndBodyType.getKey();
                JavaType inlineFunctionBodyType = (JavaType)inlineFunctionCodeAndBodyType.getValue();
                Function<JavaExpression, JavaStatementBuilder> _function = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, inlineFunctionCode){
                        final /* synthetic */ JavaExpression val$it;
                        final /* synthetic */ StringConcatenationClient val$inlineFunctionCode;
                        {
                            this.val$it = javaExpression;
                            this.val$inlineFunctionCode = stringConcatenationClient;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$it);
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".mapSingleToList(");
                            _builder.append((Object)this.val$inlineFunctionCode, "\t");
                            _builder.append((Object)")");
                        }
                    };
                    return JavaExpression.from(_client, inlineFunctionBodyType);
                };
                _xifexpression_1 = _xblockexpression_1 = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function);
            } else {
                Functions.Function2 _function = (a, b) -> b;
                _xifexpression_1 = this.buildSingleItemListOperation(expr, "mapSingleToItem", (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, expr.getArgument()), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, (JavaType)bodyItemType), (Functions.Function2<? super JavaType, ? super JavaType, ? extends JavaType>)_function, context.scope);
            }
            _xifexpression = _xifexpression_1;
        } else {
            JavaStatementBuilder _xifexpression_2 = null;
            boolean _isOutputListOfLists = this.cardinalityProvider.isOutputListOfLists(expr.getArgument());
            if (_isOutputListOfLists) {
                JavaStatementBuilder _xifexpression_3 = null;
                if (isBodyMulti) {
                    JavaStatementBuilder _xblockexpression_2 = null;
                    Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(expr.getFunction(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, (JavaType)bodyItemType), context.scope);
                    StringConcatenationClient inlineFunctionCode = (StringConcatenationClient)inlineFunctionCodeAndBodyType.getKey();
                    JavaType inlineFunctionBodyType = (JavaType)inlineFunctionCodeAndBodyType.getValue();
                    Function<JavaExpression, JavaStatementBuilder> _function_1 = it -> {
                        StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, inlineFunctionCode){
                            final /* synthetic */ JavaExpression val$it;
                            final /* synthetic */ StringConcatenationClient val$inlineFunctionCode;
                            {
                                this.val$it = javaExpression;
                                this.val$inlineFunctionCode = stringConcatenationClient;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$it);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t");
                                _builder.append((Object)".mapListToList(");
                                _builder.append((Object)this.val$inlineFunctionCode, "\t");
                                _builder.append((Object)")");
                            }
                        };
                        JavaParameterizedType<MapperListOfLists<?>> _xifexpression_4 = null;
                        boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument(inlineFunctionBodyType);
                        _xifexpression_4 = _hasWildcardArgument ? this.typeUtil.wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, (JavaType)bodyItemType) : this.typeUtil.wrap(this.typeUtil.MAPPER_LIST_OF_LISTS, (JavaType)bodyItemType);
                        return JavaExpression.from(_client, _xifexpression_4);
                    };
                    _xifexpression_3 = _xblockexpression_2 = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function_1);
                } else {
                    JavaStatementBuilder _xblockexpression_3 = null;
                    Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(expr.getFunction(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, (JavaType)bodyItemType), context.scope);
                    StringConcatenationClient inlineFunctionCode = (StringConcatenationClient)inlineFunctionCodeAndBodyType.getKey();
                    JavaType inlineFunctionBodyType = (JavaType)inlineFunctionCodeAndBodyType.getValue();
                    Function<JavaExpression, JavaStatementBuilder> _function_1 = it -> {
                        StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, inlineFunctionCode){
                            final /* synthetic */ JavaExpression val$it;
                            final /* synthetic */ StringConcatenationClient val$inlineFunctionCode;
                            {
                                this.val$it = javaExpression;
                                this.val$inlineFunctionCode = stringConcatenationClient;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$it);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t");
                                _builder.append((Object)".mapListToItem(");
                                _builder.append((Object)this.val$inlineFunctionCode, "\t");
                                _builder.append((Object)")");
                            }
                        };
                        JavaParameterizedType<MapperC<?>> _xifexpression_4 = null;
                        boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument(inlineFunctionBodyType);
                        _xifexpression_4 = _hasWildcardArgument ? this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, (JavaType)bodyItemType) : this.typeUtil.wrap(this.typeUtil.MAPPER_C, (JavaType)bodyItemType);
                        return JavaExpression.from(_client, _xifexpression_4);
                    };
                    _xifexpression_3 = _xblockexpression_3 = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function_1);
                }
                _xifexpression_2 = _xifexpression_3;
            } else {
                JavaStatementBuilder _xifexpression_4 = null;
                if (isBodyMulti) {
                    JavaStatementBuilder _xblockexpression_4 = null;
                    Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(expr.getFunction(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, (JavaType)bodyItemType), context.scope);
                    StringConcatenationClient inlineFunctionCode = (StringConcatenationClient)inlineFunctionCodeAndBodyType.getKey();
                    JavaType inlineFunctionBodyType = (JavaType)inlineFunctionCodeAndBodyType.getValue();
                    Function<JavaExpression, JavaStatementBuilder> _function_1 = it -> {
                        StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, inlineFunctionCode){
                            final /* synthetic */ JavaExpression val$it;
                            final /* synthetic */ StringConcatenationClient val$inlineFunctionCode;
                            {
                                this.val$it = javaExpression;
                                this.val$inlineFunctionCode = stringConcatenationClient;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$it);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)"\t");
                                _builder.append((Object)".mapItemToList(");
                                _builder.append((Object)this.val$inlineFunctionCode, "\t");
                                _builder.append((Object)")");
                            }
                        };
                        JavaParameterizedType<MapperListOfLists<?>> _xifexpression_5 = null;
                        boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument(inlineFunctionBodyType);
                        _xifexpression_5 = _hasWildcardArgument ? this.typeUtil.wrapExtends(this.typeUtil.MAPPER_LIST_OF_LISTS, (JavaType)bodyItemType) : this.typeUtil.wrap(this.typeUtil.MAPPER_LIST_OF_LISTS, (JavaType)bodyItemType);
                        return JavaExpression.from(_client, _xifexpression_5);
                    };
                    _xifexpression_4 = _xblockexpression_4 = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function_1);
                } else {
                    Functions.Function2 _function_1 = (a, b) -> {
                        JavaParameterizedType<MapperC<?>> _xifexpression_5 = null;
                        boolean _hasWildcardArgument = this.typeUtil.hasWildcardArgument((JavaType)b);
                        _xifexpression_5 = _hasWildcardArgument ? this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, (JavaType)bodyItemType) : this.typeUtil.wrap(this.typeUtil.MAPPER_C, (JavaType)bodyItemType);
                        return _xifexpression_5;
                    };
                    _xifexpression_4 = this.buildSingleItemListOperation(expr, "mapItem", (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, (JavaType)bodyItemType), (Functions.Function2<? super JavaType, ? super JavaType, ? extends JavaType>)_function_1, context.scope);
                }
                _xifexpression_2 = _xifexpression_4;
            }
            _xifexpression = _xifexpression_2;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseMaxOperation(MaxOperation expr, Context context) {
        boolean _tripleNotEquals;
        JavaStatementBuilder _xblockexpression = null;
        JavaParameterizedType<MapperS<?>> _xifexpression = null;
        InlineFunction _function = expr.getFunction();
        boolean bl = _tripleNotEquals = _function != null;
        if (_tripleNotEquals) {
            _xifexpression = this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER_S, expr.getFunction().getBody());
        }
        JavaParameterizedType<MapperS<?>> bodyType = _xifexpression;
        Functions.Function2 _function_1 = (a, b) -> this.typeUtil.wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType((JavaType)a));
        _xblockexpression = this.buildSingleItemListOperationOptionalBody(expr, "max", (JavaType)this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER_C, expr.getArgument()), (JavaType)bodyType, (Functions.Function2<? super JavaType, ? super JavaType, ? extends JavaType>)_function_1, true, context.scope);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseMinOperation(MinOperation expr, Context context) {
        boolean _tripleNotEquals;
        JavaStatementBuilder _xblockexpression = null;
        JavaParameterizedType<MapperS<?>> _xifexpression = null;
        InlineFunction _function = expr.getFunction();
        boolean bl = _tripleNotEquals = _function != null;
        if (_tripleNotEquals) {
            _xifexpression = this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER_S, expr.getFunction().getBody());
        }
        JavaParameterizedType<MapperS<?>> bodyType = _xifexpression;
        Functions.Function2 _function_1 = (a, b) -> this.typeUtil.wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType((JavaType)a));
        _xblockexpression = this.buildSingleItemListOperationOptionalBody(expr, "min", (JavaType)this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER_C, expr.getArgument()), (JavaType)bodyType, (Functions.Function2<? super JavaType, ? super JavaType, ? extends JavaType>)_function_1, true, context.scope);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseMultiplyOperation(ArithmeticOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseNotEqualsOperation(EqualityOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseNumberLiteral(final RosettaNumberLiteral expr, Context context) {
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"new ");
                _builder.append(BigDecimal.class);
                _builder.append((Object)"(\"");
                BigDecimal _value = expr.getValue();
                _builder.append((Object)_value);
                _builder.append((Object)"\")");
            }
        };
        return JavaExpression.from(_client, this.typeUtil.BIG_DECIMAL);
    }

    @Override
    protected JavaStatementBuilder caseOneOfOperation(OneOfOperation expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        RType type = this.typeProvider.getRMetaAnnotatedType(expr.getArgument()).getRType();
        RDataType _xifexpression = null;
        _xifexpression = type instanceof RChoiceType ? ((RChoiceType)type).asRDataType() : (RDataType)type;
        RDataType t = _xifexpression;
        _xblockexpression = this.buildConstraint(expr.getArgument(), t.getAllAttributes(), Necessity.REQUIRED, context);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseOnlyElementOperation(RosettaOnlyElement expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        JavaClass<?> itemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRMetaAnnotatedType(expr.getArgument()));
        _xblockexpression = this.javaCode(expr.getArgument(), (JavaType)itemType, context.scope);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseOnlyExists(RosettaOnlyExistsExpression expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        RosettaExpression first = (RosettaExpression)IterableExtensions.head(expr.getArgs());
        RDataType parentType = null;
        JavaStatementBuilder _xifexpression = null;
        if (first instanceof RosettaFeatureCall) {
            JavaStatementBuilder _xblockexpression_1 = null;
            t = this.typeProvider.getRMetaAnnotatedType(((RosettaFeatureCall)first).getReceiver()).getRType();
            _xifexpression_1 = null;
            _xifexpression_1 = t instanceof RChoiceType ? ((RChoiceType)t).asRDataType() : (RDataType)t;
            parentType = _xifexpression_1;
            _xifexpression = _xblockexpression_1 = this.javaCode(((RosettaFeatureCall)first).getReceiver(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)this._javaTypeTranslator.toJavaReferenceType(parentType)), context.scope);
        } else {
            JavaStatementBuilder _xblockexpression_2 = null;
            t = this.typeProvider.typeOfImplicitVariable(expr).getRType();
            _xifexpression_1 = null;
            _xifexpression_1 = t instanceof RChoiceType ? ((RChoiceType)t).asRDataType() : (RDataType)t;
            parentType = _xifexpression_1;
            _xifexpression = _xblockexpression_2 = this.typeCoercionService.addCoercions(this.implicitVariable(expr, context.scope), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER, (JavaType)this._javaTypeTranslator.toJavaReferenceType(parentType)), context.scope);
        }
        JavaStatementBuilder parent = _xifexpression;
        Functions.Function1 _function = it -> {
            if (it instanceof RosettaFeatureCall) {
                return ((RosettaFeatureCall)it).getFeature();
            }
            if (it instanceof RosettaSymbolReference) {
                return ((RosettaSymbolReference)it).getSymbol();
            }
            Class<?> _class = null;
            if (it != null) {
                _class = it.getClass();
            }
            String _name = null;
            if (_class != null) {
                _name = _class.getName();
            }
            String _plus = "Unsupported parent in `only exists` expression of type " + _name;
            throw new UnsupportedOperationException(_plus);
        };
        List requiredAttributes = ListExtensions.map(expr.getArgs(), (Functions.Function1)_function);
        Collection<RAttribute> allAttrs = parentType.getAllAttributes();
        Function<JavaExpression, JavaStatementBuilder> _function_1 = it -> {
            StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it, allAttrs, requiredAttributes){
                final /* synthetic */ JavaExpression val$it;
                final /* synthetic */ Collection val$allAttrs;
                final /* synthetic */ List val$requiredAttributes;
                {
                    this.val$it = javaExpression;
                    this.val$allAttrs = collection;
                    this.val$requiredAttributes = list;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod("onlyExists");
                    _builder.append((Object)_runtimeMethod);
                    _builder.append((Object)"(");
                    _builder.append((Object)this.val$it);
                    _builder.append((Object)", ");
                    _builder.append(Arrays.class);
                    _builder.append((Object)".asList(");
                    Functions.Function1 _function = it_1 -> {
                        String _name = it_1.getName();
                        String _plus = "\"" + _name;
                        return _plus + "\"";
                    };
                    String _join = IterableExtensions.join((Iterable)this.val$allAttrs, (CharSequence)", ", (Functions.Function1)_function);
                    _builder.append((Object)_join);
                    _builder.append((Object)"), ");
                    _builder.append(Arrays.class);
                    _builder.append((Object)".asList(");
                    Functions.Function1 _function_1 = it_1 -> {
                        String _name = it_1.getName();
                        String _plus = "\"" + _name;
                        return _plus + "\"";
                    };
                    String _join_1 = IterableExtensions.join((Iterable)this.val$requiredAttributes, (CharSequence)", ", (Functions.Function1)_function_1);
                    _builder.append((Object)_join_1);
                    _builder.append((Object)"))");
                }
            };
            return JavaExpression.from(_client, this.typeUtil.COMPARISON_RESULT);
        };
        _xblockexpression = parent.collapseToSingleExpression(context.scope).mapExpression(_function_1);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseOrOperation(LogicalOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseReduceOperation(ReduceOperation expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        JavaClass<?> outputType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRMetaAnnotatedType(expr.getFunction().getBody()));
        Pair<StringConcatenationClient, JavaType> inlineFunctionCodeAndBodyType = this.inlineFunction(expr.getFunction(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, (JavaType)outputType), context.scope);
        StringConcatenationClient inlineFunctionCode = (StringConcatenationClient)inlineFunctionCodeAndBodyType.getKey();
        JavaType inlineFunctionBodyType = (JavaType)inlineFunctionCodeAndBodyType.getValue();
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, (JavaClass)outputType, inlineFunctionCode){
                final /* synthetic */ JavaExpression val$it;
                final /* synthetic */ JavaClass val$outputType;
                final /* synthetic */ StringConcatenationClient val$inlineFunctionCode;
                {
                    this.val$it = javaExpression;
                    this.val$outputType = javaClass;
                    this.val$inlineFunctionCode = stringConcatenationClient;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)this.val$it);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)".<");
                    _builder.append((Object)this.val$outputType, "\t");
                    _builder.append((Object)">reduce(");
                    _builder.append((Object)this.val$inlineFunctionCode, "\t");
                    _builder.append((Object)")");
                }
            };
            return JavaExpression.from(_client, inlineFunctionBodyType);
        };
        _xblockexpression = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseReverseOperation(ReverseOperation expr, Context context) {
        Functions.Function1 _function = it -> it;
        return this.buildListOperationNoBody(expr, "reverse", (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), (Functions.Function1<? super JavaType, ? extends JavaType>)_function, context.scope);
    }

    @Override
    protected JavaStatementBuilder caseSortOperation(SortOperation expr, Context context) {
        boolean _tripleNotEquals;
        JavaStatementBuilder _xblockexpression = null;
        JavaParameterizedType<MapperS<?>> _xifexpression = null;
        InlineFunction _function = expr.getFunction();
        boolean bl = _tripleNotEquals = _function != null;
        if (_tripleNotEquals) {
            _xifexpression = this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER_S, expr.getFunction().getBody());
        }
        JavaParameterizedType<MapperS<?>> bodyType = _xifexpression;
        Functions.Function2 _function_1 = (a, b) -> a;
        _xblockexpression = this.buildSingleItemListOperationOptionalBody(expr, "sort", (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument()), (JavaType)bodyType, (Functions.Function2<? super JavaType, ? super JavaType, ? extends JavaType>)_function_1, true, context.scope);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseStringLiteral(RosettaStringLiteral expr, Context context) {
        return JavaLiteral.STRING(expr.getValue());
    }

    @Override
    protected JavaStatementBuilder caseSubtractOperation(ArithmeticOperation expr, Context context) {
        return this.binaryExpr(expr, context);
    }

    @Override
    protected JavaStatementBuilder caseSumOperation(SumOperation expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        JavaClass<?> itemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRMetaAnnotatedType(expr.getArgument()).getRType());
        String _simpleName = itemType.getSimpleName();
        String _plus = "sum" + _simpleName;
        Functions.Function1 _function = it -> this.typeUtil.wrap(this.typeUtil.MAPPER_S, (JavaType)itemType);
        _xblockexpression = this.buildListOperationNoBody(expr, _plus, (JavaType)this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER_C, (JavaType)itemType), (Functions.Function1<? super JavaType, ? extends JavaType>)_function, context.scope);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseSymbolReference(RosettaSymbolReference expr, final Context context) {
        JavaStatementBuilder _xifexpression;
        JavaStatementBuilder _xblockexpression_1;
        JavaStatementBuilder _xblockexpression = null;
        final RosettaSymbol s = expr.getSymbol();
        JavaStatementBuilder _switchResult = null;
        boolean _matched = false;
        if (s instanceof Attribute) {
            _matched = true;
            _xblockexpression_1 = null;
            RAttribute attribute = this.rObjectFactory.buildRAttribute((Attribute)s);
            RMetaAnnotatedType implicitType = this.typeProvider.typeOfImplicitVariable(expr);
            Iterable<? extends RosettaFeature> implicitFeatures = this._rosettaEcoreUtil.allFeatures(implicitType.getRType(), (EObject)expr);
            _xifexpression = null;
            boolean _contains = IterableExtensions.contains(implicitFeatures, (Object)s);
            if (_contains) {
                _xifexpression = this.attributeCall(this.implicitVariable(expr, context.scope), implicitType, this._rObjectFactory.buildRAttribute((Attribute)s), false, context.expectedType, context.scope);
            } else {
                GeneratedIdentifier _identifierOrThrow = context.scope.getIdentifierOrThrow(attribute);
                JavaClass<?> _metaJavaType = this._javaTypeTranslator.toMetaJavaType(attribute);
                _xifexpression = new JavaVariable(_identifierOrThrow, (JavaType)_metaJavaType);
            }
            _switchResult = _xblockexpression_1 = _xifexpression;
        }
        if (!_matched && s instanceof ShortcutDeclaration) {
            _matched = true;
            _xblockexpression_1 = null;
            boolean isMulti = this.cardinalityProvider.isSymbolMulti(s);
            final RShortcut shortcut = this.rObjectFactory.buildRShortcut((ShortcutDeclaration)s);
            JavaClass<?> itemType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRTypeOfSymbol((AssignPathRoot)s));
            _xifexpression = null;
            boolean _usesOutputParameter = this.exprHelper.usesOutputParameter(((ShortcutDeclaration)s).getExpression());
            if (_usesOutputParameter) {
                JavaExpression _xblockexpression_2 = null;
                _xifexpression_1 = null;
                _xifexpression_1 = isMulti ? this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)itemType) : itemType;
                JavaClass<?> aliasType = _xifexpression_1;
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        GeneratedIdentifier _identifierOrThrow = context.scope.getIdentifierOrThrow(shortcut);
                        _builder.append((Object)_identifierOrThrow);
                        _builder.append((Object)"(");
                        StringConcatenationClient _aliasCallArgs = ExpressionGenerator.this.aliasCallArgs((ShortcutDeclaration)s, context.scope);
                        _builder.append((Object)_aliasCallArgs);
                        _builder.append((Object)").build()");
                    }
                };
                _xblockexpression_2 = JavaExpression.from(_client, aliasType);
                _xifexpression = _xblockexpression_2;
            } else {
                JavaExpression _xblockexpression_3 = null;
                _xifexpression_1 = null;
                if (isMulti) {
                    JavaParameterizedType<MapperC<?>> _wrapExtendsIfNotFinal = this.typeUtil.wrapExtendsIfNotFinal(this.typeUtil.MAPPER_C, (JavaType)itemType);
                    _xifexpression_1 = _wrapExtendsIfNotFinal;
                } else {
                    _xifexpression_1 = this.typeUtil.wrapExtendsIfNotFinal(this.typeUtil.MAPPER_S, (JavaType)itemType);
                }
                JavaClass<?> aliasType = _xifexpression_1;
                StringConcatenationClient _client = new StringConcatenationClient(){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        GeneratedIdentifier _identifierOrThrow = context.scope.getIdentifierOrThrow(shortcut);
                        _builder.append((Object)_identifierOrThrow);
                        _builder.append((Object)"(");
                        StringConcatenationClient _aliasCallArgs = ExpressionGenerator.this.aliasCallArgs((ShortcutDeclaration)s, context.scope);
                        _builder.append((Object)_aliasCallArgs);
                        _builder.append((Object)")");
                    }
                };
                _xblockexpression_3 = JavaExpression.from(_client, aliasType);
                _xifexpression = _xblockexpression_3;
            }
            _switchResult = _xblockexpression_1 = _xifexpression;
        }
        if (!_matched && s instanceof RosettaEnumValue) {
            _matched = true;
            _switchResult = this.enumCall((RosettaEnumValue)s, context.expectedType);
        }
        if (!_matched && s instanceof ClosureParameter) {
            _matched = true;
            GeneratedIdentifier _identifierOrThrow = context.scope.getIdentifierOrThrow(s);
            JavaParameterizedType<MapperS<?>> _xifexpression2 = null;
            boolean _isMulti = this.cardinalityProvider.isMulti(expr);
            if (_isMulti) {
                JavaParameterizedType<MapperC<?>> _wrap = this.typeUtil.wrap(this.typeUtil.MAPPER_C, expr);
                _xifexpression2 = _wrap;
            } else {
                _xifexpression2 = this.typeUtil.wrap(this.typeUtil.MAPPER_S, expr);
            }
            _switchResult = new JavaVariable(_identifierOrThrow, (JavaType)_xifexpression2);
        }
        if (!_matched && s instanceof RosettaCallableWithArgs) {
            _matched = true;
            _switchResult = this.callableWithArgsCall((RosettaCallableWithArgs)s, (List<RosettaExpression>)expr.getArgs(), context.scope);
        }
        if (!_matched && s instanceof RosettaMetaType) {
            _matched = true;
            _xblockexpression_1 = null;
            RMetaAnnotatedType implicitType = this.typeProvider.typeOfImplicitVariable(expr);
            _switchResult = _xblockexpression_1 = this.metaCall(this.implicitVariable(expr, context.scope), implicitType, (RosettaMetaType)s, context.scope);
        }
        if (!_matched && s instanceof TypeParameter) {
            _matched = true;
            _xblockexpression_1 = null;
            RMetaAnnotatedType type = this.typeProvider.getRTypeOfSymbol((TypeParameter)s);
            GeneratedIdentifier _identifierOrThrow = context.scope.getIdentifierOrThrow(s);
            JavaClass<?> _javaReferenceType = this._javaTypeTranslator.toJavaReferenceType(type);
            _switchResult = _xblockexpression_1 = new JavaVariable(_identifierOrThrow, (JavaType)_javaReferenceType);
        }
        if (!_matched) {
            Class<?> _class = null;
            if (s != null) {
                _class = s.getClass();
            }
            String _name = null;
            if (_class != null) {
                _name = _class.getName();
            }
            String _plus = "Unsupported symbol type of " + _name;
            throw new UnsupportedOperationException(_plus);
        }
        _xblockexpression = _switchResult;
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseThenOperation(ThenOperation expr, Context context) {
        boolean _equals;
        JavaStatementBuilder _xblockexpression = null;
        RosettaExpression _argument = expr.getArgument();
        JavaParameterizedType<MapperS<?>> _xifexpression = null;
        boolean _isMulti = this.cardinalityProvider.isMulti(expr.getArgument());
        if (_isMulti) {
            JavaParameterizedType<MapperC<?>> _wrapExtends = this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr.getArgument());
            _xifexpression = _wrapExtends;
        } else {
            _xifexpression = this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, expr.getArgument());
        }
        JavaStatementBuilder thenArgCode = this.javaCode(_argument, (JavaType)_xifexpression, context.scope);
        JavaStatementBuilder thenAsVarCode = thenArgCode.declareAsVariable(true, "thenArg", context.scope);
        int _size = expr.getFunction().getParameters().size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            context.scope.createKeySynonym(this._javaIdentifierRepresentationService.getImplicitVarInContext(expr.getFunction()), thenArgCode);
        } else {
            context.scope.createKeySynonym(IterableExtensions.head(expr.getFunction().getParameters()), thenArgCode);
        }
        RosettaExpression _body = expr.getFunction().getBody();
        JavaParameterizedType<MapperS<?>> _xifexpression_1 = null;
        boolean _isMulti_1 = this.cardinalityProvider.isMulti(expr);
        if (_isMulti_1) {
            JavaParameterizedType<MapperC<?>> _wrapExtends_1 = this.typeUtil.wrapExtends(this.typeUtil.MAPPER_C, expr);
            _xifexpression_1 = _wrapExtends_1;
        } else {
            _xifexpression_1 = this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, expr);
        }
        BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function = (a, b) -> b;
        _xblockexpression = thenAsVarCode.then(this.javaCode(_body, (JavaType)_xifexpression_1, context.scope), _function, context.scope);
        return _xblockexpression;
    }

    private JavaStatementBuilder conversionOperation(RosettaUnaryOperation expr, Context context, StringConcatenationClient conversion, Class<? extends Exception> errorClass) {
        JavaStatementBuilder _xblockexpression = null;
        JavaClass<?> argumentJavaType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRMetaAnnotatedType(expr.getArgument()).getRType());
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, expr, conversion, errorClass){
                final /* synthetic */ JavaExpression val$it;
                final /* synthetic */ RosettaUnaryOperation val$expr;
                final /* synthetic */ StringConcatenationClient val$conversion;
                final /* synthetic */ Class val$errorClass;
                {
                    this.val$it = javaExpression;
                    this.val$expr = rosettaUnaryOperation;
                    this.val$conversion = stringConcatenationClient;
                    this.val$errorClass = clazz;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)this.val$it);
                    _builder.append((Object)".checkedMap(\"");
                    String _operator = this.val$expr.getOperator();
                    _builder.append((Object)_operator);
                    _builder.append((Object)"\", ");
                    _builder.append((Object)this.val$conversion);
                    _builder.append((Object)", ");
                    _builder.append((Object)this.val$errorClass);
                    _builder.append((Object)".class)");
                }
            };
            return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.MAPPER_S, expr));
        };
        _xblockexpression = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtends(this.typeUtil.MAPPER_S, (JavaType)argumentJavaType), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseToEnumOperation(ToEnumOperation expr, Context context) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        JavaStatementBuilder _xblockexpression = null;
        final RJavaEnum javaEnum = this._javaTypeTranslator.toJavaType(this._rObjectFactory.buildREnumType(expr.getEnumeration()));
        RType _stripFromTypeAliases = this._typeSystem.stripFromTypeAliases(this.typeProvider.getRMetaAnnotatedType(expr.getArgument()).getRType());
        boolean argIsEnum = _stripFromTypeAliases instanceof REnumType;
        StringConcatenationClient _xifexpression = null;
        _xifexpression = argIsEnum ? (_client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"e -> ");
                _builder.append((Object)javaEnum);
                _builder.append((Object)".valueOf(e.name())");
            }
        }) : (_client_1 = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)javaEnum);
                _builder.append((Object)"::fromDisplayName");
            }
        });
        StringConcatenationClient conversion = _xifexpression;
        _xblockexpression = this.conversionOperation(expr, context, conversion, IllegalArgumentException.class);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseToIntOperation(ToIntOperation expr, Context context) {
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Integer.class);
                _builder.append((Object)"::parseInt");
            }
        };
        return this.conversionOperation(expr, context, _client, NumberFormatException.class);
    }

    @Override
    protected JavaStatementBuilder caseToNumberOperation(ToNumberOperation expr, Context context) {
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(BigDecimal.class);
                _builder.append((Object)"::new");
            }
        };
        return this.conversionOperation(expr, context, _client, NumberFormatException.class);
    }

    @Override
    protected JavaStatementBuilder caseToStringOperation(ToStringOperation expr, Context context) {
        StringConcatenationClient _client_1;
        StringConcatenationClient _client;
        JavaStatementBuilder _xblockexpression = null;
        final RType rType = this.typeProvider.getRMetaAnnotatedType(expr.getArgument()).getRType();
        StringConcatenationClient _xifexpression = null;
        RType _stripFromTypeAliases = this._typeSystem.stripFromTypeAliases(rType);
        _xifexpression = _stripFromTypeAliases instanceof REnumType ? (_client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                JavaClass<?> _javaReferenceType = ExpressionGenerator.this._javaTypeTranslator.toJavaReferenceType(rType);
                _builder.append(_javaReferenceType);
                _builder.append((Object)"::toDisplayString");
            }
        }) : (_client_1 = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Object.class);
                _builder.append((Object)"::toString");
            }
        });
        StringConcatenationClient toStringMethod = _xifexpression;
        Function<JavaExpression, JavaStatementBuilder> _function = it -> {
            StringConcatenationClient _client_2 = new StringConcatenationClient(this, (JavaExpression)it, expr, toStringMethod){
                final /* synthetic */ JavaExpression val$it;
                final /* synthetic */ ToStringOperation val$expr;
                final /* synthetic */ StringConcatenationClient val$toStringMethod;
                {
                    this.val$it = javaExpression;
                    this.val$expr = toStringOperation;
                    this.val$toStringMethod = stringConcatenationClient;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)this.val$it);
                    _builder.append((Object)".map(\"");
                    String _operator = this.val$expr.getOperator();
                    _builder.append((Object)_operator);
                    _builder.append((Object)"\", ");
                    _builder.append((Object)this.val$toStringMethod);
                    _builder.append((Object)")");
                }
            };
            return JavaExpression.from(_client_2, this.typeUtil.wrap(this.typeUtil.MAPPER_S, expr));
        };
        _xblockexpression = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER_S, expr.getArgument()), context.scope).collapseToSingleExpression(context.scope).mapExpression(_function);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseToTimeOperation(ToTimeOperation expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        JavaScope lambdaScope = context.scope.lambdaScope();
        final GeneratedIdentifier lambdaParam = lambdaScope.createUniqueIdentifier("s");
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)lambdaParam);
                _builder.append((Object)" -> ");
                _builder.append(LocalTime.class);
                _builder.append((Object)".parse(");
                _builder.append((Object)lambdaParam);
                _builder.append((Object)", ");
                _builder.append(DateTimeFormatter.class);
                _builder.append((Object)".ISO_LOCAL_TIME)");
            }
        };
        _xblockexpression = this.conversionOperation(expr, context, _client, DateTimeParseException.class);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseConstructorExpression(RosettaConstructorExpression expr, Context context) {
        JavaExpression _xblockexpression = null;
        RMetaAnnotatedType metaAnnotatedType = this.typeProvider.getRMetaAnnotatedType(expr);
        final JavaClass<?> clazz = this._javaTypeTranslator.toJavaReferenceType(metaAnnotatedType);
        JavaStatementBuilder _xifexpression = null;
        if (clazz instanceof JavaPojoInterface) {
            JavaStatementBuilder _xifexpression_1 = null;
            boolean _isEmpty = expr.getValues().isEmpty();
            if (_isEmpty) {
                StringConcatenationClient _client = new StringConcatenationClient(this){

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)((JavaPojoInterface)clazz));
                        _builder.append((Object)".builder()");
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)"\t");
                        _builder.append((Object)".build()");
                    }
                };
                _xifexpression_1 = JavaExpression.from(_client, clazz);
            } else {
                Functions.Function1 _function = pair -> {
                    JavaStatementBuilder _xblockexpression_1 = null;
                    RosettaFeature _key = pair.getKey();
                    Attribute attr = (Attribute)_key;
                    RosettaExpression attrExpr = pair.getValue();
                    JavaPojoProperty prop = ((JavaPojoInterface)clazz).findProperty(attr.getName());
                    boolean assignAsKey = attrExpr instanceof AsKeyOperation;
                    boolean requiresValueAssignment = this.requiresValueAssignment(assignAsKey, attr, attrExpr);
                    String _xifexpression_2 = null;
                    _xifexpression_2 = requiresValueAssignment ? prop.getValueSetterName() : prop.getSetterName();
                    final String setterName = _xifexpression_2;
                    Function<JavaExpression, JavaStatementBuilder> _function_1 = it -> {
                        StringConcatenationClient _client_1 = new StringConcatenationClient(this, (JavaExpression)it){
                            final /* synthetic */ JavaExpression val$it;
                            {
                                this.val$it = javaExpression;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)".");
                                _builder.append((Object)setterName);
                                _builder.append((Object)"(");
                                _builder.append((Object)this.val$it);
                                _builder.append((Object)")");
                            }
                        };
                        return JavaExpression.from(_client_1, null);
                    };
                    _xblockexpression_1 = this.evaluateConstructorValue(attr, attrExpr, this.cardinalityProvider.isFeatureMulti(attr), assignAsKey, context.scope).collapseToSingleExpression(context.scope).mapExpression(_function_1);
                    return _xblockexpression_1;
                };
                Functions.Function2 _function_1 = (acc, attrCode) -> {
                    BiFunction<JavaExpression, JavaExpression, JavaStatementBuilder> _function_2 = (allSetCode, setAttr) -> {
                        StringConcatenationClient _client_1 = new StringConcatenationClient(this, (JavaExpression)allSetCode, (JavaExpression)setAttr){
                            final /* synthetic */ JavaExpression val$allSetCode;
                            final /* synthetic */ JavaExpression val$setAttr;
                            {
                                this.val$allSetCode = javaExpression;
                                this.val$setAttr = javaExpression2;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$allSetCode);
                                _builder.newLineIfNotEmpty();
                                _builder.append((Object)this.val$setAttr);
                                _builder.newLineIfNotEmpty();
                            }
                        };
                        return JavaExpression.from(_client_1, null);
                    };
                    return acc.then((JavaStatementBuilder)attrCode, _function_2, context.scope);
                };
                Function<JavaExpression, JavaStatementBuilder> _function_2 = it -> {
                    StringConcatenationClient _client_1 = new StringConcatenationClient(this, (JavaClass)clazz, (JavaExpression)it){
                        final /* synthetic */ JavaClass val$clazz;
                        final /* synthetic */ JavaExpression val$it;
                        {
                            this.val$clazz = javaClass;
                            this.val$it = javaExpression;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)((JavaPojoInterface)this.val$clazz));
                            _builder.append((Object)".builder()");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)this.val$it, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".build()");
                        }
                    };
                    return JavaExpression.from(_client_1, (JavaType)clazz);
                };
                _xifexpression_1 = ((JavaStatementBuilder)IterableExtensions.reduce((Iterable)ListExtensions.map(expr.getValues(), (Functions.Function1)_function), (Functions.Function2)_function_1)).mapExpression(_function_2);
            }
            _xifexpression = _xifexpression_1;
        } else {
            JavaStatementBuilder _xblockexpression_1 = null;
            Functions.Function1 _function_3 = it -> it.getKey().getName();
            Functions.Function1 _function_4 = it -> this.evaluateConstructorValue(it.getKey(), it.getValue(), false, false, context.scope);
            Map featureMap = IterableExtensions.toMap(expr.getValues(), (Functions.Function1)_function_3, (Functions.Function1)_function_4);
            RType _rType = metaAnnotatedType.getRType();
            _xblockexpression_1 = this.recordUtil.recordConstructor((RRecordType)_rType, featureMap, context.scope);
            _xifexpression = _xblockexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private boolean requiresValueAssignment(boolean assignAsKey, Attribute attr, RosettaExpression attrExpr) {
        if (assignAsKey) {
            return false;
        }
        boolean attrHasMeta = this._rObjectFactory.buildRAttribute(attr).getRMetaAnnotatedType().hasMeta();
        boolean attrExprHasMeta = this.typeProvider.getRMetaAnnotatedType(attrExpr).hasMeta();
        return attrHasMeta && !attrExprHasMeta;
    }

    private JavaStatementBuilder evaluateConstructorValue(RosettaFeature feature, RosettaExpression value, boolean isMulti, boolean assignAsKey, JavaScope scope) {
        JavaStatementBuilder _xifexpression = null;
        if (assignAsKey) {
            JavaStatementBuilder _xblockexpression = null;
            final JavaType metaClass = this.typeUtil.getItemType((JavaType)this._javaTypeTranslator.toMetaJavaType(this._rObjectFactory.buildRAttribute((Attribute)feature)));
            JavaStatementBuilder _xifexpression_1 = null;
            if (isMulti) {
                JavaStatementBuilder _xblockexpression_1 = null;
                JavaScope lambdaScope = scope.lambdaScope();
                GeneratedIdentifier item = lambdaScope.createUniqueIdentifier("item");
                Function<JavaExpression, JavaStatementBuilder> _function = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, item, metaClass){
                        final /* synthetic */ JavaExpression val$it;
                        final /* synthetic */ GeneratedIdentifier val$item;
                        final /* synthetic */ JavaType val$metaClass;
                        {
                            this.val$it = javaExpression;
                            this.val$item = generatedIdentifier;
                            this.val$metaClass = javaType;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$it);
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".getItems()");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)this.val$item, "\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)this.val$metaClass, "\t");
                            _builder.append((Object)".builder()");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".setExternalReference(");
                            _builder.append((Object)this.val$item, "\t\t");
                            _builder.append((Object)".getMappedObject().getMeta().getExternalKey())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".setGlobalReference(");
                            _builder.append((Object)this.val$item, "\t\t");
                            _builder.append((Object)".getMappedObject().getMeta().getGlobalKey())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".build())");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".collect(");
                            _builder.append(Collectors.class, "\t");
                            _builder.append((Object)".toList())");
                        }
                    };
                    return JavaExpression.from(_client, this.typeUtil.wrap(this.typeUtil.LIST, metaClass));
                };
                _xifexpression_1 = _xblockexpression_1 = this.javaCode(value, (JavaType)this.typeUtil.wrapExtendsWithoutMeta(this.typeUtil.MAPPER_C, value), scope).collapseToSingleExpression(scope).mapExpression(_function);
            } else {
                JavaStatementBuilder _xblockexpression_2 = null;
                JavaScope lambdaScope = scope.lambdaScope();
                GeneratedIdentifier r = lambdaScope.createUniqueIdentifier("r");
                GeneratedIdentifier m = lambdaScope.createUniqueIdentifier("m");
                Function<JavaExpression, JavaStatementBuilder> _function = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it, r, m){
                        final /* synthetic */ JavaExpression val$it;
                        final /* synthetic */ GeneratedIdentifier val$r;
                        final /* synthetic */ GeneratedIdentifier val$m;
                        {
                            this.val$it = javaExpression;
                            this.val$r = generatedIdentifier;
                            this.val$m = generatedIdentifier2;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)metaClass);
                            _builder.append((Object)".builder()");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".setGlobalReference(");
                            _builder.append(Optional.class, "\t");
                            _builder.append((Object)".ofNullable(");
                            _builder.append((Object)this.val$it, "\t");
                            _builder.append((Object)")");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)this.val$r, "\t\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)this.val$r, "\t\t");
                            _builder.append((Object)".getMeta())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)this.val$m, "\t\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)this.val$m, "\t\t");
                            _builder.append((Object)".getGlobalKey())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".orElse(null))");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".setExternalReference(");
                            _builder.append(Optional.class, "\t");
                            _builder.append((Object)".ofNullable(");
                            _builder.append((Object)this.val$it, "\t");
                            _builder.append((Object)")");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)this.val$r, "\t\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)this.val$r, "\t\t");
                            _builder.append((Object)".getMeta())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".map(");
                            _builder.append((Object)this.val$m, "\t\t");
                            _builder.append((Object)" -> ");
                            _builder.append((Object)this.val$m, "\t\t");
                            _builder.append((Object)".getExternalKey())");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t\t");
                            _builder.append((Object)".orElse(null))");
                            _builder.newLine();
                            _builder.append((Object)"\t");
                            _builder.append((Object)".build()");
                        }
                    };
                    return JavaExpression.from(_client, metaClass);
                };
                _xifexpression_1 = _xblockexpression_2 = this.javaCode(value, (JavaType)this._javaTypeTranslator.toJavaReferenceType(RMetaAnnotatedType.withNoMeta(this.typeProvider.getRMetaAnnotatedType(value).getRType())), scope).declareAsVariable(true, feature.getName(), scope).mapExpression(_function);
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        } else {
            JavaStatementBuilder _xblockexpression_1 = null;
            JavaClass<?> clazz = this._javaTypeTranslator.toJavaReferenceType(RMetaAnnotatedType.withNoMeta(this.typeProvider.getRTypeOfFeature(feature, value).getRType()));
            if (feature instanceof Attribute) {
                boolean _not;
                boolean _requiresValueAssignment = this.requiresValueAssignment(assignAsKey, (Attribute)feature, value);
                boolean bl = _not = !_requiresValueAssignment;
                if (_not) {
                    clazz = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRTypeOfFeature(feature, value));
                }
            }
            Object _xifexpression_1 = null;
            _xifexpression_1 = isMulti ? this.typeUtil.wrap(this.typeUtil.LIST, (JavaType)clazz) : clazz;
            _xifexpression = _xblockexpression_1 = this.javaCode(value, (JavaType)_xifexpression_1, scope);
        }
        return _xifexpression;
    }

    @Override
    protected JavaStatementBuilder caseToDateOperation(ToDateOperation expr, Context context) {
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(Date.class);
                _builder.append((Object)"::parse");
            }
        };
        return this.conversionOperation(expr, context, _client, DateTimeParseException.class);
    }

    @Override
    protected JavaStatementBuilder caseToDateTimeOperation(ToDateTimeOperation expr, Context context) {
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(LocalDateTime.class);
                _builder.append((Object)"::parse");
            }
        };
        return this.conversionOperation(expr, context, _client, DateTimeParseException.class);
    }

    @Override
    protected JavaStatementBuilder caseToZonedDateTimeOperation(ToZonedDateTimeOperation expr, Context context) {
        StringConcatenationClient _client = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append(ZonedDateTime.class);
                _builder.append((Object)"::parse");
            }
        };
        return this.conversionOperation(expr, context, _client, DateTimeParseException.class);
    }

    @Override
    protected JavaStatementBuilder caseSwitchOperation(SwitchOperation expr, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        RType inputRType = this.typeProvider.getRMetaAnnotatedType(expr.getArgument()).getRType();
        JavaStatementBuilder _xifexpression = null;
        if (inputRType instanceof RChoiceType) {
            JavaStatementBuilder _xblockexpression_1 = null;
            JavaStatementBuilder switchArgument = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrap(this.typeUtil.MAPPER, (JavaType)this._javaTypeTranslator.toJavaReferenceType(inputRType)), context.scope);
            Functions.Function3 _function = (acc, switchCase, switchArg) -> {
                JavaStatementBuilder _xblockexpression_2 = null;
                ChoiceOption _choiceOptionGuard = switchCase.getGuard().getChoiceOptionGuard();
                RChoiceOption choiceOption = new RChoiceOption(_choiceOptionGuard, (RChoiceType)inputRType, this.typeProvider);
                List<RChoiceOption> optionPath = this.findOptionPath((RChoiceType)inputRType, choiceOption);
                GeneratedIdentifier itemVar = context.scope.createIdentifier(this._javaIdentifierRepresentationService.getImplicitVarInContext(switchCase.getExpression()), StringExtensions.toFirstLower((String)choiceOption.getType().getRType().getName()));
                Functions.Function2 _function_1 = (pathAcc, opt) -> {
                    ChoiceOption _eObject = opt.getEObject();
                    return this.attributeCall((JavaStatementBuilder)pathAcc, RMetaAnnotatedType.withNoMeta(opt.getChoiceType()), this._rObjectFactory.buildRAttribute(_eObject), false, context.expectedType, context.scope);
                };
                JavaStatementBuilder optionExpr = (JavaStatementBuilder)IterableExtensions.fold(optionPath, (Object)switchArg, (Functions.Function2)_function_1);
                Function<JavaExpression, JavaStatementBuilder> _function_2 = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it){
                        final /* synthetic */ JavaExpression val$it;
                        {
                            this.val$it = javaExpression;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$it);
                            _builder.append((Object)".get() != null");
                        }
                    };
                    JavaExpression _from = JavaExpression.from(_client, (JavaType)JavaPrimitiveType.BOOLEAN);
                    JavaType _expressionType = it.getExpressionType();
                    JavaBlockBuilder _append = new JavaLocalVariableDeclarationStatement(true, _expressionType, itemVar, (JavaExpression)it).append(this.javaCode(switchCase.getExpression(), context.expectedType, context.scope));
                    return new JavaIfThenElseBuilder(_from, _append, (JavaStatementBuilder)acc, this.typeUtil);
                };
                _xblockexpression_2 = optionExpr.collapseToSingleExpression(context.scope).mapExpression(_function_2);
                return _xblockexpression_2;
            };
            _xifexpression = _xblockexpression_1 = this.createSwitchJavaExpression(expr, switchArgument, (Functions.Function3<JavaStatementBuilder, SwitchCaseOrDefault, JavaExpression, JavaStatementBuilder>)_function, context);
        } else {
            JavaStatementBuilder _xifexpression_1 = null;
            if (inputRType instanceof REnumType) {
                JavaStatementBuilder _xblockexpression_2 = null;
                JavaStatementBuilder switchArgument = this.javaCode(expr.getArgument(), (JavaType)this._javaTypeTranslator.toJavaReferenceType((REnumType)inputRType), context.scope);
                Functions.Function3 _function = (acc, switchCase, switchArg) -> {
                    JavaIfThenElseBuilder _xblockexpression_3 = null;
                    JavaStatementBuilder enumCaseToCheck = this.enumCall(switchCase.getGuard().getEnumGuard(), switchArgument.getExpressionType());
                    StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)switchArg, enumCaseToCheck){
                        final /* synthetic */ JavaExpression val$switchArg;
                        final /* synthetic */ JavaStatementBuilder val$enumCaseToCheck;
                        {
                            this.val$switchArg = javaExpression;
                            this.val$enumCaseToCheck = javaStatementBuilder;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$switchArg);
                            _builder.append((Object)" == ");
                            _builder.append((Object)this.val$enumCaseToCheck);
                        }
                    };
                    JavaExpression _from = JavaExpression.from(_client, (JavaType)JavaPrimitiveType.BOOLEAN);
                    JavaStatementBuilder _javaCode = this.javaCode(switchCase.getExpression(), context.expectedType, context.scope);
                    _xblockexpression_3 = new JavaIfThenElseBuilder(_from, _javaCode, (JavaStatementBuilder)acc, this.typeUtil);
                    return _xblockexpression_3;
                };
                _xifexpression_1 = _xblockexpression_2 = this.createSwitchJavaExpression(expr, switchArgument, (Functions.Function3<JavaStatementBuilder, SwitchCaseOrDefault, JavaExpression, JavaStatementBuilder>)_function, context);
            } else {
                JavaStatementBuilder _xifexpression_2 = null;
                if (inputRType instanceof RBasicType) {
                    JavaStatementBuilder _xblockexpression_3 = null;
                    JavaStatementBuilder switchArgument = this.javaCode(expr.getArgument(), (JavaType)this.typeUtil.wrap(this.typeUtil.MAPPER, (JavaType)this._javaTypeTranslator.toJavaReferenceType(inputRType)), context.scope);
                    JavaParameterizedType<MapperS<?>> mapperSConditionType = this.typeUtil.wrap(this.typeUtil.MAPPER_S, this.typeUtil.getItemType(switchArgument.getExpressionType()));
                    Functions.Function3 _function = (acc, switchCase, switchArg) -> {
                        JavaIfThenElseBuilder _xblockexpression_4 = null;
                        JavaStatementBuilder literalCaseToCheck = this.javaCode(switchCase.getGuard().getLiteralGuard(), (JavaType)mapperSConditionType, context.scope);
                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)switchArg, literalCaseToCheck){
                            final /* synthetic */ JavaExpression val$switchArg;
                            final /* synthetic */ JavaStatementBuilder val$literalCaseToCheck;
                            {
                                this.val$switchArg = javaExpression;
                                this.val$literalCaseToCheck = javaStatementBuilder;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                StringConcatenationClient _runtimeMethod = ExpressionGenerator.this.runtimeMethod("areEqual");
                                _builder.append((Object)_runtimeMethod);
                                _builder.append((Object)"(");
                                _builder.append((Object)this.val$switchArg);
                                _builder.append((Object)", ");
                                _builder.append((Object)this.val$literalCaseToCheck);
                                _builder.append((Object)", ");
                                _builder.append(CardinalityOperator.class);
                                _builder.append((Object)".All).get()");
                            }
                        };
                        JavaExpression _from = JavaExpression.from(_client, (JavaType)JavaPrimitiveType.BOOLEAN);
                        JavaStatementBuilder _javaCode = this.javaCode(switchCase.getExpression(), context.expectedType, context.scope);
                        _xblockexpression_4 = new JavaIfThenElseBuilder(_from, _javaCode, (JavaStatementBuilder)acc, this.typeUtil);
                        return _xblockexpression_4;
                    };
                    _xifexpression_2 = _xblockexpression_3 = this.createSwitchJavaExpression(expr, switchArgument, (Functions.Function3<JavaStatementBuilder, SwitchCaseOrDefault, JavaExpression, JavaStatementBuilder>)_function, context);
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    private List<RChoiceOption> findOptionPath(RChoiceType from, RChoiceOption goal) {
        ArrayList _xblockexpression = null;
        ArrayList result = CollectionLiterals.newArrayList();
        RChoiceType currentChoice = from;
        Functions.Function1 _function = it -> this._typeSystem.isSubtypeOf(goal.getType(), it.getType(), false);
        RChoiceOption currentOption = (RChoiceOption)IterableExtensions.findFirst(currentChoice.getOwnOptions(), (Functions.Function1)_function);
        result.add(currentOption);
        while (!Objects.equals(currentOption, goal)) {
            if (currentOption == null || !(currentOption.getType().getRType() instanceof RChoiceType)) {
                throw new IllegalStateException("Did not find an option path from " + String.valueOf(from) + " to " + String.valueOf(goal) + ". " + String.valueOf(currentOption));
            }
            RType _rType = currentOption.getType().getRType();
            currentChoice = (RChoiceType)_rType;
            Functions.Function1 _function_1 = it -> this._typeSystem.isSubtypeOf(goal.getType(), it.getType(), false);
            currentOption = (RChoiceOption)IterableExtensions.findFirst(currentChoice.getOwnOptions(), (Functions.Function1)_function_1);
            result.add(currentOption);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    private JavaStatementBuilder createSwitchJavaExpression(SwitchOperation expr, JavaStatementBuilder switchArgument, Functions.Function3<JavaStatementBuilder, SwitchCaseOrDefault, JavaExpression, JavaStatementBuilder> fold, Context context) {
        JavaStatementBuilder _xblockexpression = null;
        JavaStatementBuilder _xifexpression = null;
        RosettaExpression _default = expr.getDefault();
        boolean _tripleEquals = _default == null;
        _xifexpression = _tripleEquals ? JavaLiteral.NULL : this.javaCode(expr.getDefault(), context.expectedType, context.scope);
        JavaLiteral defaultExpr = _xifexpression;
        Function<JavaExpression, JavaStatementBuilder> _function = switchArg -> {
            JavaStatementBuilder _xblockexpression_1 = null;
            Functions.Function1 _function_1 = it -> {
                boolean _isDefault = it.isDefault();
                return !_isDefault;
            };
            Functions.Function2 _function_2 = (acc, case_) -> (JavaStatementBuilder)fold.apply(acc, case_, switchArg);
            JavaStatementBuilder javaSwitchExpr = (JavaStatementBuilder)IterableExtensions.fold((Iterable)ListExtensions.reverseView((List)IterableExtensions.toList((Iterable)IterableExtensions.filter(expr.getCases(), (Functions.Function1)_function_1))), (Object)defaultExpr, (Functions.Function2)_function_2);
            Function<JavaExpression, JavaStatementBuilder> _function_3 = it -> {
                StringConcatenationClient _client = new StringConcatenationClient(this, (JavaExpression)it){
                    final /* synthetic */ JavaExpression val$it;
                    {
                        this.val$it = javaExpression;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)this.val$it);
                        _builder.append((Object)" == null");
                    }
                };
                return JavaExpression.from(_client, (JavaType)JavaPrimitiveType.BOOLEAN);
            };
            Function<JavaExpression, JavaStatementBuilder> _function_4 = it -> new JavaIfThenElseBuilder((JavaExpression)it, JavaLiteral.NULL, javaSwitchExpr, this.typeUtil);
            _xblockexpression_1 = this.typeCoercionService.addCoercions((JavaExpression)switchArg, this.typeUtil.getItemType(switchArg.getExpressionType()), context.scope).mapExpression(_function_3).mapExpression(_function_4);
            return _xblockexpression_1;
        };
        _xblockexpression = switchArgument.declareAsVariable(true, "switchArgument", context.scope).mapExpression(_function);
        return _xblockexpression;
    }

    @Override
    protected JavaStatementBuilder caseWithMetaOperation(WithMetaOperation expr, Context context) {
        RMetaAnnotatedType withMetaRMetaType = this.typeProvider.getRMetaAnnotatedType(expr);
        JavaClass<?> withMetaJavaType = this._javaTypeTranslator.toJavaReferenceType(withMetaRMetaType);
        RMetaAnnotatedType argumentrMetaType = this.typeProvider.getRMetaAnnotatedType(expr.getArgument());
        JavaClass<?> argumentJavaType = this._javaTypeTranslator.toJavaReferenceType(argumentrMetaType);
        Functions.Function1 _function = entry -> {
            JavaClass<?> entryType = this._javaTypeTranslator.toJavaReferenceType(this.typeProvider.getRTypeOfFeature(entry.getKey(), expr).getRType());
            String _name = entry.getKey().getName();
            JavaStatementBuilder _collapseToSingleExpression = this.javaCode(entry.getValue(), (JavaType)entryType, context.scope).collapseToSingleExpression(context.scope);
            return Pair.of((Object)_name, (Object)_collapseToSingleExpression);
        };
        List metaEntries = IterableExtensions.toList((Iterable)ListExtensions.map(expr.getEntries(), (Functions.Function1)_function));
        Function<JavaExpression, JavaStatementBuilder> _function_1 = it -> {
            StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it, (JavaClass)argumentJavaType){
                final /* synthetic */ JavaExpression val$it;
                final /* synthetic */ JavaClass val$argumentJavaType;
                {
                    this.val$it = javaExpression;
                    this.val$argumentJavaType = javaClass;
                }

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)this.val$it);
                    boolean _needsBuilder = ExpressionGenerator.this.needsBuilder(this.val$argumentJavaType);
                    if (_needsBuilder) {
                        _builder.append((Object)".toBuilder()");
                    }
                }
            };
            JavaType _xifexpression = null;
            boolean _needsBuilder = this.needsBuilder(argumentJavaType);
            _xifexpression = _needsBuilder ? this._javaTypeTranslator.toBuilderType(argumentJavaType) : this.typeUtil.getItemType((JavaType)argumentJavaType);
            return JavaExpression.from(_client, _xifexpression);
        };
        JavaStatementBuilder argumentExpression = this.javaCode(expr.getArgument(), (JavaType)argumentJavaType, context.scope).mapExpression(_function_1).collapseToSingleExpression(context.scope);
        if (withMetaJavaType instanceof RJavaFieldWithMeta || withMetaJavaType instanceof RJavaPojoInterface) {
            Functions.Function1 _function_2 = it -> {
                String _key = (String)it.getKey();
                return !Objects.equals(_key, "key");
            };
            List metaEntriesWithoutKey = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)metaEntries, (Functions.Function1)_function_2));
            Functions.Function1 _function_3 = it -> {
                String _key = (String)it.getKey();
                return Objects.equals(_key, "key");
            };
            Pair keyEntry = (Pair)IterableExtensions.findFirst((Iterable)metaEntries, (Functions.Function1)_function_3);
            boolean _isEmpty = metaEntriesWithoutKey.isEmpty();
            boolean setMeta = !_isEmpty;
            boolean setKey = keyEntry != null;
            JavaStatementBuilder withMetaArgument = argumentExpression.declareAsVariable(true, "withMetaArgument", context.scope);
            GeneratedIdentifier withMetaAgumentVar = context.scope.getIdentifierOrThrow(argumentExpression);
            if (setKey && !setMeta) {
                if (argumentJavaType instanceof RJavaWithMetaValue) {
                    Function<JavaExpression, JavaStatementBuilder> _function_4 = it -> {
                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it, keyEntry){
                            final /* synthetic */ JavaExpression val$it;
                            final /* synthetic */ Pair val$keyEntry;
                            {
                                this.val$it = javaExpression;
                                this.val$keyEntry = pair;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$it);
                                _builder.append((Object)".getOrCreateValue().getOrCreateMeta().set");
                                String _pojoSetter = ExpressionGenerator.this.toPojoSetter((String)this.val$keyEntry.getKey());
                                _builder.append((Object)_pojoSetter);
                                _builder.append((Object)"(");
                                JavaStatementBuilder _value = (JavaStatementBuilder)this.val$keyEntry.getValue();
                                _builder.append((Object)_value);
                                _builder.append((Object)")");
                            }
                        };
                        return JavaExpression.from(_client, this.typeUtil.getItemType((JavaType)withMetaJavaType));
                    };
                    JavaStatement _completeAsExpressionStatement = withMetaArgument.mapExpression(_function_4).completeAsExpressionStatement();
                    JavaVariable _javaVariable = new JavaVariable(withMetaAgumentVar, (JavaType)argumentJavaType);
                    return _completeAsExpressionStatement.append(_javaVariable);
                }
                Function<JavaExpression, JavaStatementBuilder> _function_5 = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it, keyEntry){
                        final /* synthetic */ JavaExpression val$it;
                        final /* synthetic */ Pair val$keyEntry;
                        {
                            this.val$it = javaExpression;
                            this.val$keyEntry = pair;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$it);
                            _builder.append((Object)".getOrCreateMeta().set");
                            String _pojoSetter = ExpressionGenerator.this.toPojoSetter((String)this.val$keyEntry.getKey());
                            _builder.append((Object)_pojoSetter);
                            _builder.append((Object)"(");
                            JavaStatementBuilder _value = (JavaStatementBuilder)this.val$keyEntry.getValue();
                            _builder.append((Object)_value);
                            _builder.append((Object)")");
                        }
                    };
                    return JavaExpression.from(_client, this.typeUtil.getItemType((JavaType)withMetaJavaType));
                };
                JavaStatement _completeAsExpressionStatement_1 = withMetaArgument.mapExpression(_function_5).completeAsExpressionStatement();
                JavaVariable _javaVariable_1 = new JavaVariable(withMetaAgumentVar, (JavaType)argumentJavaType);
                return _completeAsExpressionStatement_1.append(_javaVariable_1);
            }
            if (!setKey && setMeta) {
                if (argumentJavaType instanceof RJavaWithMetaValue) {
                    Function<JavaExpression, JavaStatementBuilder> _function_6 = it -> {
                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it, metaEntriesWithoutKey){
                            final /* synthetic */ JavaExpression val$it;
                            final /* synthetic */ List val$metaEntriesWithoutKey;
                            {
                                this.val$it = javaExpression;
                                this.val$metaEntriesWithoutKey = list;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$it);
                                _builder.append((Object)".getOrCreateMeta()");
                                for (Pair m : this.val$metaEntriesWithoutKey) {
                                    _builder.append((Object)".set");
                                    String _pojoSetter = ExpressionGenerator.this.toPojoSetter((String)m.getKey());
                                    _builder.append((Object)_pojoSetter);
                                    _builder.append((Object)"(");
                                    JavaStatementBuilder _value = (JavaStatementBuilder)m.getValue();
                                    _builder.append((Object)_value);
                                    _builder.append((Object)")");
                                }
                            }
                        };
                        return JavaExpression.from(_client, this.typeUtil.getItemType((JavaType)withMetaJavaType));
                    };
                    JavaStatement _completeAsExpressionStatement_2 = withMetaArgument.mapExpression(_function_6).completeAsExpressionStatement();
                    JavaVariable _javaVariable_2 = new JavaVariable(withMetaAgumentVar, (JavaType)withMetaJavaType);
                    return _completeAsExpressionStatement_2.append(_javaVariable_2);
                }
                Function<JavaExpression, JavaStatementBuilder> _function_7 = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient((JavaClass)withMetaJavaType, (JavaExpression)it, metaEntriesWithoutKey){
                        final /* synthetic */ JavaClass val$withMetaJavaType;
                        final /* synthetic */ JavaExpression val$it;
                        final /* synthetic */ List val$metaEntriesWithoutKey;
                        {
                            this.val$withMetaJavaType = javaClass;
                            this.val$it = javaExpression;
                            this.val$metaEntriesWithoutKey = list;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$withMetaJavaType);
                            _builder.append((Object)".builder().setValue(");
                            _builder.append((Object)this.val$it);
                            _builder.append((Object)").setMeta(");
                            _builder.append(MetaFields.class);
                            _builder.append((Object)".builder()");
                            for (Pair m : this.val$metaEntriesWithoutKey) {
                                _builder.append((Object)".set");
                                String _pojoSetter = ExpressionGenerator.this.toPojoSetter((String)m.getKey());
                                _builder.append((Object)_pojoSetter);
                                _builder.append((Object)"(");
                                JavaStatementBuilder _value = (JavaStatementBuilder)m.getValue();
                                _builder.append((Object)_value);
                                _builder.append((Object)")");
                            }
                            _builder.append((Object)")");
                        }
                    };
                    return JavaExpression.from(_client, this.typeUtil.getItemType((JavaType)withMetaJavaType));
                };
                return withMetaArgument.mapExpression(_function_7);
            }
            if (setKey && setMeta) {
                if (argumentJavaType instanceof RJavaWithMetaValue) {
                    Function<JavaExpression, JavaStatementBuilder> _function_8 = it -> {
                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it, keyEntry){
                            final /* synthetic */ JavaExpression val$it;
                            final /* synthetic */ Pair val$keyEntry;
                            {
                                this.val$it = javaExpression;
                                this.val$keyEntry = pair;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$it);
                                _builder.append((Object)".getOrCreateValue().getOrCreateMeta().set");
                                String _pojoSetter = ExpressionGenerator.this.toPojoSetter((String)this.val$keyEntry.getKey());
                                _builder.append((Object)_pojoSetter);
                                _builder.append((Object)"(");
                                JavaStatementBuilder _value = (JavaStatementBuilder)this.val$keyEntry.getValue();
                                _builder.append((Object)_value);
                                _builder.append((Object)")");
                            }
                        };
                        return JavaExpression.from(_client, (JavaType)JavaPrimitiveType.VOID);
                    };
                    JavaStatement _completeAsExpressionStatement_3 = withMetaArgument.mapExpression(_function_8).completeAsExpressionStatement();
                    JavaVariable _javaVariable_3 = new JavaVariable(withMetaAgumentVar, (JavaType)argumentJavaType);
                    Function<JavaExpression, JavaStatementBuilder> _function_9 = it -> {
                        StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it, metaEntriesWithoutKey){
                            final /* synthetic */ JavaExpression val$it;
                            final /* synthetic */ List val$metaEntriesWithoutKey;
                            {
                                this.val$it = javaExpression;
                                this.val$metaEntriesWithoutKey = list;
                            }

                            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                                _builder.append((Object)this.val$it);
                                _builder.append((Object)".getOrCreateMeta()");
                                for (Pair m : this.val$metaEntriesWithoutKey) {
                                    _builder.append((Object)".set");
                                    String _pojoSetter = ExpressionGenerator.this.toPojoSetter((String)m.getKey());
                                    _builder.append((Object)_pojoSetter);
                                    _builder.append((Object)"(");
                                    JavaStatementBuilder _value = (JavaStatementBuilder)m.getValue();
                                    _builder.append((Object)_value);
                                    _builder.append((Object)")");
                                }
                            }
                        };
                        return JavaExpression.from(_client, this.typeUtil.getItemType((JavaType)withMetaJavaType));
                    };
                    JavaBlock _completeAsExpressionStatement_4 = ((JavaBlockBuilder)_completeAsExpressionStatement_3.append(_javaVariable_3).mapExpression(_function_9)).completeAsExpressionStatement();
                    JavaVariable _javaVariable_4 = new JavaVariable(withMetaAgumentVar, (JavaType)withMetaJavaType);
                    return _completeAsExpressionStatement_4.append(_javaVariable_4);
                }
                Function<JavaExpression, JavaStatementBuilder> _function_10 = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient((JavaExpression)it, keyEntry){
                        final /* synthetic */ JavaExpression val$it;
                        final /* synthetic */ Pair val$keyEntry;
                        {
                            this.val$it = javaExpression;
                            this.val$keyEntry = pair;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$it);
                            _builder.append((Object)".getOrCreateMeta().set");
                            String _pojoSetter = ExpressionGenerator.this.toPojoSetter((String)this.val$keyEntry.getKey());
                            _builder.append((Object)_pojoSetter);
                            _builder.append((Object)"(");
                            JavaStatementBuilder _value = (JavaStatementBuilder)this.val$keyEntry.getValue();
                            _builder.append((Object)_value);
                            _builder.append((Object)")");
                        }
                    };
                    return JavaExpression.from(_client, (JavaType)JavaPrimitiveType.VOID);
                };
                JavaStatement _completeAsExpressionStatement_5 = withMetaArgument.mapExpression(_function_10).completeAsExpressionStatement();
                JavaVariable _javaVariable_5 = new JavaVariable(withMetaAgumentVar, (JavaType)argumentJavaType);
                Function<JavaExpression, JavaStatementBuilder> _function_11 = it -> {
                    StringConcatenationClient _client = new StringConcatenationClient((JavaClass)withMetaJavaType, (JavaExpression)it, metaEntriesWithoutKey){
                        final /* synthetic */ JavaClass val$withMetaJavaType;
                        final /* synthetic */ JavaExpression val$it;
                        final /* synthetic */ List val$metaEntriesWithoutKey;
                        {
                            this.val$withMetaJavaType = javaClass;
                            this.val$it = javaExpression;
                            this.val$metaEntriesWithoutKey = list;
                        }

                        protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                            _builder.append((Object)this.val$withMetaJavaType);
                            _builder.append((Object)".builder().setValue(");
                            _builder.append((Object)this.val$it);
                            _builder.append((Object)").setMeta(");
                            _builder.append(MetaFields.class);
                            _builder.append((Object)".builder()");
                            for (Pair m : this.val$metaEntriesWithoutKey) {
                                _builder.append((Object)".set");
                                String _pojoSetter = ExpressionGenerator.this.toPojoSetter((String)m.getKey());
                                _builder.append((Object)_pojoSetter);
                                _builder.append((Object)"(");
                                JavaStatementBuilder _value = (JavaStatementBuilder)m.getValue();
                                _builder.append((Object)_value);
                                _builder.append((Object)")");
                            }
                            _builder.append((Object)")");
                        }
                    };
                    return JavaExpression.from(_client, this.typeUtil.getItemType((JavaType)withMetaJavaType));
                };
                return _completeAsExpressionStatement_5.append(_javaVariable_5).mapExpression(_function_11);
            }
            return withMetaArgument;
        }
        if (withMetaJavaType instanceof RJavaReferenceWithMeta) {
            Functions.Function1 _function_12 = it -> {
                String _key = (String)it.getKey();
                return !Objects.equals(_key, "address");
            };
            List metaEntriesWithoutAddress = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)metaEntries, (Functions.Function1)_function_12));
            Functions.Function1 _function_13 = it -> {
                String _key = (String)it.getKey();
                return Objects.equals(_key, "address");
            };
            Pair metaAdressEntry = (Pair)IterableExtensions.findFirst((Iterable)metaEntries, (Functions.Function1)_function_13);
            Function<JavaExpression, JavaStatementBuilder> _function_14 = it -> {
                StringConcatenationClient _client = new StringConcatenationClient(this, (JavaClass)withMetaJavaType, (JavaExpression)it, metaEntriesWithoutAddress, metaAdressEntry){
                    final /* synthetic */ JavaClass val$withMetaJavaType;
                    final /* synthetic */ JavaExpression val$it;
                    final /* synthetic */ List val$metaEntriesWithoutAddress;
                    final /* synthetic */ Pair val$metaAdressEntry;
                    {
                        this.val$withMetaJavaType = javaClass;
                        this.val$it = javaExpression;
                        this.val$metaEntriesWithoutAddress = list;
                        this.val$metaAdressEntry = pair;
                    }

                    protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                        _builder.append((Object)((RJavaReferenceWithMeta)this.val$withMetaJavaType));
                        _builder.append((Object)".builder().setValue(");
                        _builder.append((Object)this.val$it);
                        _builder.append((Object)")");
                        for (Pair m : this.val$metaEntriesWithoutAddress) {
                            _builder.append((Object)".set");
                            String _firstUpper = StringExtensions.toFirstUpper((String)PojoPropertyUtil.toPojoPropertyName((String)m.getKey()));
                            _builder.append((Object)_firstUpper);
                            _builder.append((Object)"(");
                            JavaStatementBuilder _value = (JavaStatementBuilder)m.getValue();
                            _builder.append((Object)_value);
                            _builder.append((Object)")");
                        }
                        if (this.val$metaAdressEntry != null) {
                            _builder.append((Object)".set");
                            String _firstUpper_1 = StringExtensions.toFirstUpper((String)PojoPropertyUtil.toPojoPropertyName((String)this.val$metaAdressEntry.getKey()));
                            _builder.append((Object)_firstUpper_1);
                            _builder.append((Object)"(");
                            _builder.append(Reference.class);
                            _builder.append((Object)".builder().set");
                            String _firstUpper_2 = StringExtensions.toFirstUpper((String)PojoPropertyUtil.toPojoPropertyName((String)this.val$metaAdressEntry.getKey()));
                            _builder.append((Object)_firstUpper_2);
                            _builder.append((Object)"(");
                            JavaStatementBuilder _value_1 = (JavaStatementBuilder)this.val$metaAdressEntry.getValue();
                            _builder.append((Object)_value_1);
                            _builder.append((Object)"))");
                        }
                        _builder.append((Object)".build()");
                    }
                };
                return JavaExpression.from(_client, (JavaType)withMetaJavaType);
            };
            return argumentExpression.mapExpression(_function_14);
        }
        throw new IllegalStateException("caseWithMetaOperation with Java meta or Java POJO expected types: " + String.valueOf(withMetaJavaType));
    }

    private String toPojoSetter(String metaEntryName) {
        return StringExtensions.toFirstUpper((String)PojoPropertyUtil.toPojoPropertyName(metaEntryName));
    }

    private boolean needsBuilder(JavaClass<?> javaClass) {
        return javaClass instanceof JavaPojoInterface;
    }

    public static class Context {
        public JavaType expectedType;
        public JavaScope scope;
    }
}

