/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.expression;

import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.statement.builder.JavaLiteral;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.interpreter.RosettaBooleanValue;
import com.regnosys.rosetta.interpreter.RosettaDateTimeValue;
import com.regnosys.rosetta.interpreter.RosettaDateValue;
import com.regnosys.rosetta.interpreter.RosettaNumberValue;
import com.regnosys.rosetta.interpreter.RosettaStringValue;
import com.regnosys.rosetta.interpreter.RosettaTimeValue;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.interpreter.RosettaZonedDateTimeValue;
import com.rosetta.model.lib.RosettaNumber;
import com.rosetta.model.lib.records.Date;
import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public class InterpreterValueJavaConverter {
    @Inject
    private JavaTypeUtil typeUtil;

    public JavaExpression convertValueToJava(RosettaValue value) {
        if (value.size() == 0) {
            return JavaLiteral.NULL;
        }
        if (value instanceof RosettaBooleanValue) {
            return this.toJavaListIfNecessary(((RosettaBooleanValue)value).getItems(), this::convertBooleanValueToJava);
        }
        if (value instanceof RosettaDateTimeValue) {
            return this.toJavaListIfNecessary(((RosettaDateTimeValue)value).getItems(), this::convertDateTimeValueToJava);
        }
        if (value instanceof RosettaDateValue) {
            return this.toJavaListIfNecessary(((RosettaDateValue)value).getItems(), this::convertDateValueToJava);
        }
        if (value instanceof RosettaNumberValue) {
            return this.toJavaListIfNecessary(((RosettaNumberValue)value).getItems(), this::convertNumberValueToJava);
        }
        if (value instanceof RosettaStringValue) {
            return this.toJavaListIfNecessary(((RosettaStringValue)value).getItems(), this::convertStringValueToJava);
        }
        if (value instanceof RosettaTimeValue) {
            return this.toJavaListIfNecessary(((RosettaTimeValue)value).getItems(), this::convertTimeValueToJava);
        }
        if (value instanceof RosettaZonedDateTimeValue) {
            return this.toJavaListIfNecessary(((RosettaZonedDateTimeValue)value).getItems(), this::convertZonedDateTimeValueToJava);
        }
        throw new UnsupportedOperationException("Cannot convert " + String.valueOf(value) + " to Java code");
    }

    private <T> JavaExpression toJavaListIfNecessary(List<T> items, Function<T, JavaExpression> handler) {
        if (items.size() == 1) {
            return handler.apply(items.get(0));
        }
        final List expressions = items.stream().map(handler).collect(Collectors.toList());
        return JavaExpression.from(new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append(Arrays.class);
                target.append((Object)".asList(");
                for (int i = 0; i < expressions.size(); ++i) {
                    target.append(expressions.get(i));
                    if (i == expressions.size() - 1) continue;
                    target.append((Object)", ");
                }
                target.append((Object)")");
            }
        }, this.typeUtil.wrap(this.typeUtil.LIST, ((JavaExpression)expressions.get(0)).getExpressionType()));
    }

    private JavaExpression convertBooleanValueToJava(boolean value) {
        if (value) {
            return JavaLiteral.TRUE;
        }
        return JavaLiteral.FALSE;
    }

    private JavaExpression convertDateTimeValueToJava(final LocalDateTime value) {
        return JavaExpression.from(new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append(LocalDateTime.class);
                target.append((Object)".of(");
                target.append((Object)value.getYear());
                target.append((Object)", ");
                target.append((Object)value.getMonthValue());
                target.append((Object)", ");
                target.append((Object)value.getDayOfMonth());
                target.append((Object)", ");
                target.append((Object)value.getHour());
                target.append((Object)", ");
                target.append((Object)value.getMinute());
                target.append((Object)", ");
                target.append((Object)value.getSecond());
                target.append((Object)", ");
                target.append((Object)value.getNano());
                target.append((Object)")");
            }
        }, this.typeUtil.LOCAL_DATE_TIME);
    }

    private JavaExpression convertDateValueToJava(final LocalDate value) {
        return JavaExpression.from(new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append(Date.class);
                target.append((Object)".of(");
                target.append((Object)value.getYear());
                target.append((Object)", ");
                target.append((Object)value.getMonthValue());
                target.append((Object)", ");
                target.append((Object)value.getDayOfMonth());
                target.append((Object)")");
            }
        }, this.typeUtil.DATE);
    }

    private JavaExpression convertNumberValueToJava(final RosettaNumber value) {
        int intValue = value.intValue();
        if (value.equals((Object)RosettaNumber.valueOf((long)intValue))) {
            return JavaLiteral.INT(intValue);
        }
        long longValue = value.longValue();
        if (value.equals((Object)RosettaNumber.valueOf((long)longValue))) {
            return JavaLiteral.LONG(longValue);
        }
        final BigInteger bigIntegerValue = value.bigIntegerValue();
        if (value.equals((Object)RosettaNumber.valueOf((BigInteger)bigIntegerValue))) {
            return JavaExpression.from(new StringConcatenationClient(this){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                    target.append((Object)"new ");
                    target.append(BigInteger.class);
                    target.append((Object)"(\"");
                    target.append((Object)bigIntegerValue);
                    target.append((Object)"\")");
                }
            }, this.typeUtil.BIG_INTEGER);
        }
        return JavaExpression.from(new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append((Object)"new ");
                target.append(BigDecimal.class);
                target.append((Object)"(\"");
                target.append((Object)value);
                target.append((Object)"\")");
            }
        }, this.typeUtil.BIG_DECIMAL);
    }

    private JavaExpression convertStringValueToJava(String value) {
        return JavaLiteral.STRING(value);
    }

    private JavaExpression convertTimeValueToJava(final LocalTime value) {
        return JavaExpression.from(new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append(LocalTime.class);
                target.append((Object)value.getHour());
                target.append((Object)", ");
                target.append((Object)value.getMinute());
                target.append((Object)", ");
                target.append((Object)value.getSecond());
                target.append((Object)", ");
                target.append((Object)value.getNano());
                target.append((Object)")");
            }
        }, this.typeUtil.LOCAL_TIME);
    }

    private JavaExpression convertZonedDateTimeValueToJava(final ZonedDateTime value) {
        return JavaExpression.from(new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append(ZonedDateTime.class);
                target.append((Object)".of(");
                target.append((Object)value.getYear());
                target.append((Object)", ");
                target.append((Object)value.getMonthValue());
                target.append((Object)", ");
                target.append((Object)value.getDayOfMonth());
                target.append((Object)", ");
                target.append((Object)value.getHour());
                target.append((Object)", ");
                target.append((Object)value.getMinute());
                target.append((Object)", ");
                target.append((Object)value.getSecond());
                target.append((Object)", ");
                target.append((Object)value.getNano());
                target.append((Object)", ");
                target.append(ZoneId.class);
                target.append((Object)".of(");
                target.append((Object)JavaLiteral.STRING(value.getZone().getId()));
                target.append((Object)"))");
            }
        }, this.typeUtil.ZONED_DATE_TIME);
    }
}

