/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.reports;

import com.fasterxml.jackson.core.type.TypeReference;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.RosettaJavaPackages;
import com.regnosys.rosetta.generator.java.function.FunctionGenerator;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.util.ImportManagerExtension;
import com.regnosys.rosetta.rosetta.RosettaCorpus;
import com.regnosys.rosetta.rosetta.RosettaReport;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.utils.ModelIdProvider;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.LabelProvider;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeArgument;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.LinkedHashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ReportGenerator {
    @Inject
    @Extension
    private RObjectFactory _rObjectFactory;
    @Inject
    private FunctionGenerator functionGenerator;
    @Inject
    @Extension
    private JavaTypeTranslator _javaTypeTranslator;
    @Inject
    @Extension
    private ImportManagerExtension _importManagerExtension;
    @Inject
    @Extension
    private ModelIdProvider _modelIdProvider;

    public void generate(RosettaJavaPackages.RootPackage root, IFileSystemAccess2 fsa, final RosettaReport report, String version) {
        RFunction rFunction = this._rObjectFactory.buildRFunction(report);
        JavaClass<? extends RosettaFunction> clazz = this._javaTypeTranslator.toFunctionJavaClass(rFunction);
        DottedPath _packageName = clazz.getPackageName();
        JavaScope topScope = new JavaScope(_packageName);
        JavaParameterizedType baseInterface = JavaParameterizedType.from((TypeReference)new TypeReference<ReportFunction<?, ?>>(this){}, (JavaTypeArgument[])new JavaTypeArgument[]{this._javaTypeTranslator.toMetaJavaType((RAttribute)IterableExtensions.head(rFunction.getInputs())), this._javaTypeTranslator.toMetaJavaType(rFunction.getOutput())});
        LinkedHashMap annotations = CollectionLiterals.newLinkedHashMap();
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"namespace=\"");
                DottedPath _dottedPath = ReportGenerator.this._modelIdProvider.toDottedPath(report.getModel());
                _builder.append((Object)_dottedPath);
                _builder.append((Object)"\", body=\"");
                String _name = report.getRegulatoryBody().getBody().getName();
                _builder.append((Object)_name);
                _builder.append((Object)"\", corpusList={");
                EList<RosettaCorpus> _corpusList = report.getRegulatoryBody().getCorpusList();
                boolean _hasElements = false;
                for (RosettaCorpus corpus : _corpusList) {
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "");
                    }
                    _builder.append((Object)"\"");
                    String _name_1 = corpus.getName();
                    _builder.append((Object)_name_1);
                    _builder.append((Object)"\"");
                }
                _builder.append((Object)"}");
            }
        };
        annotations.put(com.rosetta.model.lib.annotations.RosettaReport.class, _client);
        final GeneratedJavaClass<LabelProvider> labelProviderClass = this._javaTypeTranslator.toLabelProviderJavaClass(rFunction);
        StringConcatenationClient _client_1 = new StringConcatenationClient(this){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"labelProvider=");
                _builder.append((Object)labelProviderClass);
                _builder.append((Object)".class");
            }
        };
        annotations.put(RuneLabelProvider.class, _client_1);
        StringConcatenationClient classBody = this.functionGenerator.rBuildClass(rFunction, false, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new JavaType[]{baseInterface})), annotations, true, topScope);
        String content = this._importManagerExtension.buildClass(clazz.getPackageName(), classBody, topScope);
        String _withForwardSlashes = clazz.getCanonicalName().withForwardSlashes();
        String _plus = _withForwardSlashes + ".java";
        fsa.generateFile(_plus, (CharSequence)content);
    }
}

