/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.regnosys.rosetta.generator.java.types.JavaPojoProperty;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeDeclaration;
import java.util.Collection;
import java.util.NoSuchElementException;

public abstract class JavaPojoInterface
extends JavaClass<RosettaModelObject> {
    public abstract String getJavadoc();

    public abstract String getRosettaName();

    public abstract String getVersion();

    public abstract Collection<JavaPojoProperty> getOwnProperties();

    public abstract Collection<JavaPojoProperty> getAllProperties();

    public abstract JavaPojoInterface getSuperPojo();

    public JavaPojoProperty findProperty(String propertyName, JavaType desiredType) {
        JavaPojoProperty prop;
        for (JavaPojoProperty currentProp = prop = this.findProperty(propertyName); currentProp != null; currentProp = currentProp.getParentProperty()) {
            if (!desiredType.isSubtypeOf(currentProp.getType())) continue;
            return currentProp;
        }
        return prop;
    }

    public JavaPojoProperty findProperty(String propertyName) {
        return this.getAllProperties().stream().filter(prop -> prop.getName().equals(propertyName)).findAny().orElseThrow(() -> new NoSuchElementException("No property named " + propertyName + " in pojo " + String.valueOf((Object)this)));
    }

    public JavaClass<? super RosettaModelObject> getSuperclassDeclaration() {
        return JavaClass.OBJECT;
    }

    public JavaClass<? super RosettaModelObject> getSuperclass() {
        return this.getSuperclassDeclaration();
    }

    public boolean extendsDeclaration(JavaTypeDeclaration<?> other) {
        if (other instanceof JavaClass) {
            return this.isSubtypeOf((JavaType)((JavaClass)other));
        }
        return false;
    }

    public boolean isFinal() {
        return false;
    }

    public Class<? extends RosettaModelObject> loadClass(ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(this.getCanonicalName().toString(), true, classLoader).asSubclass(RosettaModelObject.class);
    }
}

