/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.regnosys.rosetta.generator.java.statement.builder.JavaExpression;
import com.regnosys.rosetta.generator.java.types.AttributeMetaType;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.util.types.JavaType;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;

public class JavaPojoProperty {
    private final String name;
    private final String runeName;
    private final String serializedName;
    private final String getterCompatibilityName;
    private final String setterCompatibilityName;
    private final JavaType type;
    private final String javadoc;
    private final JavaPojoProperty parentProperty;
    private final AttributeMeta meta;
    private final boolean hasLocation;
    private final List<AttributeMetaType> attributeMetaTypes;

    public JavaPojoProperty(String name, String runeName, String serializedName, String getterCompatibilityName, String setterCompatibilityName, JavaType type, String javadoc, AttributeMeta meta, boolean hasLocation, List<AttributeMetaType> attributeMetaTypes) {
        this(name, runeName, serializedName, getterCompatibilityName, setterCompatibilityName, type, javadoc, meta, hasLocation, attributeMetaTypes, null);
    }

    private JavaPojoProperty(String name, String runeName, String serializedName, String getterCompatibilityName, String setterCompatibilityName, JavaType type, String javadoc, AttributeMeta meta, boolean hasLocation, List<AttributeMetaType> attributeMetaTypes, JavaPojoProperty parentProperty) {
        this.name = name;
        this.runeName = runeName;
        this.serializedName = serializedName;
        this.getterCompatibilityName = getterCompatibilityName;
        this.setterCompatibilityName = setterCompatibilityName;
        this.type = type;
        this.javadoc = javadoc;
        this.meta = meta;
        this.hasLocation = hasLocation;
        this.attributeMetaTypes = attributeMetaTypes;
        this.parentProperty = parentProperty;
    }

    public JavaPojoProperty specialize(String getterCompatibilityName, String setterCompatibilityName, JavaType newType, String newJavadoc, AttributeMeta newMeta, boolean newHasLocation, List<AttributeMetaType> attributeMetaTypes) {
        return new JavaPojoProperty(this.name, this.runeName, this.serializedName, getterCompatibilityName, setterCompatibilityName, newType, newJavadoc, newMeta, newHasLocation, attributeMetaTypes, this);
    }

    public boolean isCompatibleWithParent() {
        return this.parentProperty == null || this.type.isSubtypeOf(this.parentProperty.type);
    }

    public String getName() {
        return this.name;
    }

    public String getRuneName() {
        return this.runeName;
    }

    public String getSerializedName() {
        return this.serializedName;
    }

    public String getGetterCompatibilityName() {
        return this.getterCompatibilityName;
    }

    public String getSetterCompatibilityName() {
        return this.setterCompatibilityName;
    }

    public String getGetterName() {
        return "get" + StringUtils.capitalize((String)this.getterCompatibilityName);
    }

    public String getGetOrCreateName() {
        return "getOrCreate" + StringUtils.capitalize((String)this.getterCompatibilityName);
    }

    public String getSetterName() {
        return "set" + StringUtils.capitalize((String)this.setterCompatibilityName);
    }

    public String getAdderName() {
        return "add" + StringUtils.capitalize((String)this.setterCompatibilityName);
    }

    public String getValueSetterName() {
        return "set" + StringUtils.capitalize((String)this.setterCompatibilityName) + "Value";
    }

    public String getValueAdderName() {
        return "add" + StringUtils.capitalize((String)this.setterCompatibilityName) + "Value";
    }

    public JavaType getType() {
        return this.type;
    }

    public String getJavadoc() {
        return this.javadoc;
    }

    public AttributeMeta getMeta() {
        return this.meta;
    }

    public boolean hasLocation() {
        return this.hasLocation;
    }

    public List<AttributeMetaType> getAttributeMetaTypes() {
        return this.attributeMetaTypes;
    }

    public JavaPojoProperty getParentProperty() {
        return this.parentProperty;
    }

    public JavaExpression applyGetter(final JavaExpression expr) {
        return JavaExpression.from(new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation target) {
                target.append((Object)expr);
                target.append((Object)Character.valueOf('.'));
                target.append((Object)JavaPojoProperty.this.getGetterName());
                target.append((Object)"()");
            }
        }, this.type);
    }

    public String toString() {
        return JavaPojoProperty.class.getSimpleName() + "[" + this.type.getSimpleName() + " " + this.getGetterName() + "()]";
    }

    public int hashCode() {
        return Objects.hash(this.getterCompatibilityName, this.setterCompatibilityName, this.hasLocation, this.javadoc, this.meta, this.name, this.runeName, this.serializedName, this.parentProperty, this.type, this.attributeMetaTypes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaPojoProperty other = (JavaPojoProperty)obj;
        return Objects.equals(this.getterCompatibilityName, other.getterCompatibilityName) && Objects.equals(this.setterCompatibilityName, other.setterCompatibilityName) && this.hasLocation == other.hasLocation && Objects.equals(this.javadoc, other.javadoc) && this.meta == other.meta && Objects.equals(this.name, other.name) && Objects.equals(this.runeName, other.runeName) && Objects.equals(this.serializedName, other.serializedName) && Objects.equals(this.attributeMetaTypes, other.attributeMetaTypes) && Objects.equals(this.parentProperty, other.parentProperty) && Objects.equals(this.type, other.type);
    }
}

