/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.regnosys.rosetta.generator.java.types.AttributeMetaType;
import com.regnosys.rosetta.generator.java.types.JavaPojoInterface;
import com.regnosys.rosetta.generator.java.types.JavaPojoProperty;
import com.regnosys.rosetta.generator.java.types.JavaTypeTranslator;
import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.regnosys.rosetta.generator.java.util.ModelGeneratorUtil;
import com.regnosys.rosetta.rosetta.RosettaDocReference;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.TypeSystem;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.metafields.MetaAndTemplateFields;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RJavaPojoInterface
extends JavaPojoInterface {
    private final RDataType type;
    private RJavaPojoInterface superPojo = null;
    private Map<String, JavaPojoProperty> ownProperties = null;
    private Map<String, JavaPojoProperty> allProperties = null;
    private final TypeSystem typeSystem;
    private final JavaTypeTranslator typeTranslator;
    private final JavaTypeUtil typeUtil;
    private final ModelGeneratorUtil generatorUtil;

    public RJavaPojoInterface(RDataType type, TypeSystem typeSystem, JavaTypeTranslator typeTranslator, JavaTypeUtil typeUtil, ModelGeneratorUtil generatorUtil) {
        this.type = type;
        this.typeSystem = typeSystem;
        this.typeTranslator = typeTranslator;
        this.typeUtil = typeUtil;
        this.generatorUtil = generatorUtil;
    }

    @Override
    public String getJavadoc() {
        return this.generatorUtil.javadoc(this.type.getEObject().getDefinition(), (List<RosettaDocReference>)this.type.getEObject().getReferences(), this.getVersion());
    }

    @Override
    public String getRosettaName() {
        return this.type.getName();
    }

    @Override
    public String getVersion() {
        return this.type.getEObject().getModel().getVersion();
    }

    @Override
    public Collection<JavaPojoProperty> getOwnProperties() {
        this.initializeProperties();
        return this.ownProperties.values();
    }

    @Override
    public Collection<JavaPojoProperty> getAllProperties() {
        this.initializeProperties();
        return this.allProperties.values();
    }

    private void initializeProperties() {
        if (this.ownProperties == null) {
            RJavaPojoInterface superPojo = this.getSuperPojo();
            if (superPojo == null) {
                this.allProperties = new LinkedHashMap<String, JavaPojoProperty>();
            } else {
                superPojo.initializeProperties();
                this.allProperties = new LinkedHashMap<String, JavaPojoProperty>(superPojo.allProperties);
            }
            this.ownProperties = new LinkedHashMap<String, JavaPojoProperty>();
            this.type.getOwnAttributes().forEach(attr -> {
                String name = attr.getName();
                JavaClass<?> type = this.typeTranslator.toMetaJavaType((RAttribute)attr);
                this.addPropertyIfNecessary(name, name, name, (JavaType)type, this.generatorUtil.javadoc(attr.getDefinition(), attr.getAllDocReferences(), null), (AttributeMeta)(attr.getRMetaAnnotatedType().hasMetaAttribute("id") ? AttributeMeta.GLOBAL_KEY_FIELD : null), attr.getRMetaAnnotatedType().hasMetaAttribute("location"), this.generateAttributeMetaTypes((RAttribute)attr));
            });
            if (this.type.hasMetaAttribute("key")) {
                JavaClass<MetaAndTemplateFields> metaFieldsType = this.type.hasMetaAttribute("template") ? this.typeUtil.META_AND_TEMPLATE_FIELDS : this.typeUtil.META_FIELDS;
                this.addPropertyIfNecessary("meta", null, "meta", (JavaType)metaFieldsType, null, null, false, List.of());
            }
        }
    }

    private void addPropertyIfNecessary(String name, String runeName, String serializedName, JavaType type, String javadoc, AttributeMeta meta, boolean hasLocation, List<AttributeMetaType> attributeMetaTypes) {
        JavaPojoProperty parentProperty = this.allProperties.get(name);
        if (parentProperty == null) {
            JavaPojoProperty newProperty = new JavaPojoProperty(name, runeName, serializedName, name, name, type, javadoc, meta, hasLocation, attributeMetaTypes);
            this.ownProperties.put(name, newProperty);
            this.allProperties.put(name, newProperty);
        } else {
            JavaType parentType = parentProperty.getType();
            if (!type.equals((Object)parentType)) {
                String getterCompatibilityName = type.isSubtypeOf(parentType) ? parentProperty.getGetterCompatibilityName() : this.getIncompatiblePropertyName(name, parentType, type);
                String setterCompatibilityName = type.getTypeErasure().equals((Object)parentType.getTypeErasure()) ? this.getIncompatiblePropertyName(name, parentType, type) : parentProperty.getSetterCompatibilityName();
                JavaPojoProperty newProperty = parentProperty.specialize(getterCompatibilityName, setterCompatibilityName, type, javadoc, meta, hasLocation, attributeMetaTypes);
                this.ownProperties.put(name, newProperty);
                this.allProperties.put(name, newProperty);
            }
        }
    }

    private String getIncompatiblePropertyName(String propertyName, JavaType parentType, JavaType specializedType) {
        if (this.typeUtil.isList(parentType) && this.typeUtil.isList(specializedType)) {
            return this.getIncompatiblePropertyName(propertyName, this.typeUtil.getItemType(parentType), this.typeUtil.getItemType(specializedType));
        }
        if (this.typeUtil.isList(parentType)) {
            JavaType parentItemType = this.typeUtil.getItemType(parentType);
            if (parentItemType.equals((Object)specializedType)) {
                return propertyName + "OverriddenAsSingle";
            }
            return propertyName + "OverriddenAsSingle" + specializedType.getSimpleName();
        }
        return propertyName + "OverriddenAs" + specializedType.getSimpleName();
    }

    private List<AttributeMetaType> generateAttributeMetaTypes(RAttribute rAttribute) {
        return rAttribute.getRMetaAnnotatedType().getMetaAttributes().stream().filter(metaAttr -> metaAttr.getName().equals("address") || metaAttr.getName().equals("location")).map(metaAttr -> {
            if (metaAttr.getName().equals("address")) {
                return AttributeMetaType.SCOPED_REFERENCE;
            }
            if (metaAttr.getName().equals("location")) {
                return AttributeMetaType.SCOPED_KEY;
            }
            throw new IllegalStateException("AttributeMetaType for meta attributes of " + metaAttr.getName() + " are not supported");
        }).collect(Collectors.toList());
    }

    public boolean isSubtypeOf(JavaType other) {
        if (this.typeUtil.ROSETTA_MODEL_OBJECT.isSubtypeOf(other)) {
            return true;
        }
        if (other instanceof RJavaPojoInterface) {
            return this.typeSystem.isSubtypeOf(this.type, ((RJavaPojoInterface)other).type);
        }
        return false;
    }

    public String getSimpleName() {
        return this.type.getName();
    }

    @Override
    public RJavaPojoInterface getSuperPojo() {
        RDataType superType;
        if (this.superPojo == null && (superType = this.type.getSuperType()) != null) {
            this.superPojo = new RJavaPojoInterface(superType, this.typeSystem, this.typeTranslator, this.typeUtil, this.generatorUtil);
        }
        return this.superPojo;
    }

    public List<JavaClass<?>> getInterfaceDeclarations() {
        ArrayList interfaces = new ArrayList();
        RJavaPojoInterface superPojo = this.getSuperPojo();
        if (superPojo == null) {
            interfaces.add(this.typeUtil.ROSETTA_MODEL_OBJECT);
        } else {
            interfaces.add(superPojo);
        }
        if (this.type.hasMetaAttribute("key")) {
            interfaces.add(this.typeUtil.GLOBAL_KEY);
        }
        if (this.type.hasMetaAttribute("template")) {
            interfaces.add(this.typeUtil.TEMPLATABLE);
        }
        return interfaces;
    }

    public List<JavaClass<?>> getInterfaces() {
        return this.getInterfaceDeclarations();
    }

    public DottedPath getPackageName() {
        return this.type.getNamespace();
    }
}

