/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.util;

import com.regnosys.rosetta.generator.GeneratedIdentifier;
import com.regnosys.rosetta.generator.TargetLanguageStringConcatenation;
import com.regnosys.rosetta.generator.java.JavaScope;
import com.regnosys.rosetta.generator.java.types.JavaTypeRepresentation;
import com.regnosys.rosetta.generator.java.util.PreferWildcardImportClass;
import com.regnosys.rosetta.generator.java.util.PreferWildcardImportMethod;
import com.rosetta.util.DottedPath;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaType;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ImportingStringConcatenation
extends TargetLanguageStringConcatenation {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private Map<DottedPath, DottedPath> imports = CollectionLiterals.newHashMap();
    private Map<DottedPath, DottedPath> staticImports = CollectionLiterals.newHashMap();
    private JavaScope scope;

    public ImportingStringConcatenation(JavaScope topScope) {
        this.scope = topScope;
    }

    @Override
    protected void append(Object object, int index) {
        if (object instanceof JavaClass) {
            throw new IllegalStateException();
        }
        super.append(object, index);
    }

    @Override
    protected void append(Object object, String indentation, int index) {
        if (object instanceof JavaClass) {
            throw new IllegalStateException();
        }
        super.append(object, indentation, index);
    }

    @Override
    protected Object handle(Object object) {
        if (object instanceof JavaClass) {
            return this.getOrImportIdentifier(object, ((JavaClass)object).getPackageName(), ((JavaClass)object).getSimpleName());
        }
        if (object instanceof PreferWildcardImportClass) {
            JavaClass<?> jc = ((PreferWildcardImportClass)object).getJavaClass();
            return this.getOrWildcardImportIdentifier(jc, jc.getPackageName(), jc.getSimpleName());
        }
        if (object instanceof Method) {
            return this.getOrStaticImportIdentifier(object, DottedPath.splitOnDots((String)((Method)object).getDeclaringClass().getCanonicalName()), ((Method)object).getName());
        }
        if (object instanceof PreferWildcardImportMethod) {
            Method m = ((PreferWildcardImportMethod)object).getMethod();
            return this.getOrStaticWildcardImportIdentifier(m, DottedPath.splitOnDots((String)m.getDeclaringClass().getCanonicalName()), m.getName());
        }
        return super.handle(object);
    }

    @Override
    protected Object normalize(Object object) {
        Object n = super.normalize(object);
        JavaType t = JavaType.from((Object)n);
        if (t == null) {
            return n;
        }
        if (t instanceof JavaClass) {
            if (t instanceof JavaParameterizedType) {
                return new JavaTypeRepresentation(t);
            }
            return t;
        }
        return new JavaTypeRepresentation(t);
    }

    public GeneratedIdentifier getOrImportIdentifier(Object object, DottedPath packageName, String simpleName) {
        DottedPath canonicalName = packageName.child(simpleName);
        Supplier<GeneratedIdentifier> _function = () -> {
            boolean _tripleNotEquals;
            Functions.Function1 _function_1 = it -> {
                String _desiredName = it.getDesiredName();
                return Objects.equals(_desiredName, simpleName);
            };
            GeneratedIdentifier _findFirst = (GeneratedIdentifier)IterableExtensions.findFirst(this.scope.getIdentifiers(), (Functions.Function1)_function_1);
            boolean bl = _tripleNotEquals = _findFirst != null;
            if (_tripleNotEquals) {
                return this.scope.createIdentifier(object, canonicalName.withDots());
            }
            this.addImportIfNotAlreadyImported(packageName, canonicalName);
            return this.scope.createIdentifier(object, simpleName);
        };
        return this.scope.getIdentifier(object).orElseGet(_function);
    }

    public GeneratedIdentifier getOrWildcardImportIdentifier(Object object, DottedPath packageName, String simpleName) {
        DottedPath canonicalName = packageName.child(simpleName);
        Function<GeneratedIdentifier, GeneratedIdentifier> _function = it -> {
            boolean _containsKey = this.imports.containsKey(canonicalName);
            if (_containsKey) {
                this.addWildcardImport(packageName);
            }
            return it;
        };
        Supplier<GeneratedIdentifier> _function_1 = () -> {
            boolean _tripleNotEquals;
            Functions.Function1 _function_2 = it -> {
                String _desiredName = it.getDesiredName();
                return Objects.equals(_desiredName, simpleName);
            };
            GeneratedIdentifier _findFirst = (GeneratedIdentifier)IterableExtensions.findFirst(this.scope.getIdentifiers(), (Functions.Function1)_function_2);
            boolean bl = _tripleNotEquals = _findFirst != null;
            if (_tripleNotEquals) {
                return this.scope.createIdentifier(object, canonicalName.withDots());
            }
            this.addWildcardImport(packageName);
            return this.scope.createIdentifier(object, simpleName);
        };
        return this.scope.getIdentifier(object).map(_function).orElseGet(_function_1);
    }

    public GeneratedIdentifier getOrStaticImportIdentifier(Object object, DottedPath canonicalClassName, String staticMemberName) {
        DottedPath canonicalStaticMemberName = canonicalClassName.child(staticMemberName);
        Supplier<GeneratedIdentifier> _function = () -> {
            boolean _tripleNotEquals;
            Functions.Function1 _function_1 = it -> {
                String _desiredName = it.getDesiredName();
                return Objects.equals(_desiredName, staticMemberName);
            };
            GeneratedIdentifier _findFirst = (GeneratedIdentifier)IterableExtensions.findFirst(this.scope.getIdentifiers(), (Functions.Function1)_function_1);
            boolean bl = _tripleNotEquals = _findFirst != null;
            if (_tripleNotEquals) {
                return this.scope.createIdentifier(object, canonicalStaticMemberName.withDots());
            }
            this.addStaticImportIfNotAlreadyImported(canonicalClassName, canonicalStaticMemberName);
            return this.scope.createIdentifier(object, staticMemberName);
        };
        return this.scope.getIdentifier(object).orElseGet(_function);
    }

    public GeneratedIdentifier getOrStaticWildcardImportIdentifier(Object object, DottedPath canonicalClassName, String staticMemberName) {
        DottedPath canonicalStaticMemberName = canonicalClassName.child(staticMemberName);
        Function<GeneratedIdentifier, GeneratedIdentifier> _function = it -> {
            boolean _containsKey = this.staticImports.containsKey(canonicalStaticMemberName);
            if (_containsKey) {
                this.addStaticWildcardImport(canonicalClassName);
            }
            return it;
        };
        Supplier<GeneratedIdentifier> _function_1 = () -> {
            boolean _tripleNotEquals;
            Functions.Function1 _function_2 = it -> {
                String _desiredName = it.getDesiredName();
                return Objects.equals(_desiredName, staticMemberName);
            };
            GeneratedIdentifier _findFirst = (GeneratedIdentifier)IterableExtensions.findFirst(this.scope.getIdentifiers(), (Functions.Function1)_function_2);
            boolean bl = _tripleNotEquals = _findFirst != null;
            if (_tripleNotEquals) {
                return this.scope.createIdentifier(object, canonicalStaticMemberName.withDots());
            }
            this.addStaticWildcardImport(canonicalClassName);
            return this.scope.createIdentifier(object, staticMemberName);
        };
        return this.scope.getIdentifier(object).map(_function).orElseGet(_function_1);
    }

    public void addImportIfNotAlreadyImported(DottedPath packageName, DottedPath canonicalName) {
        boolean _not;
        boolean _containsKey = this.imports.containsKey(packageName.child("*"));
        boolean bl = _not = !_containsKey;
        if (_not) {
            this.imports.put(canonicalName, packageName);
        }
    }

    public void addWildcardImport(DottedPath packageName) {
        boolean _tripleEquals;
        DottedPath wildcard = packageName.child("*");
        DottedPath _put = this.imports.put(wildcard, packageName);
        boolean bl = _tripleEquals = _put == null;
        if (_tripleEquals) {
            Predicate<Map.Entry> _function = it -> !Objects.equals(it.getKey(), wildcard) && Objects.equals(it.getValue(), packageName);
            this.imports.entrySet().removeIf(_function);
        }
    }

    public void addStaticImportIfNotAlreadyImported(DottedPath canonicalClassName, DottedPath canonicalStaticMemberName) {
        boolean _not;
        boolean _containsKey = this.staticImports.containsKey(canonicalClassName.child("*"));
        boolean bl = _not = !_containsKey;
        if (_not) {
            this.staticImports.put(canonicalStaticMemberName, canonicalClassName);
        }
    }

    public void addStaticWildcardImport(DottedPath canonicalClassName) {
        boolean _tripleEquals;
        DottedPath wildcard = canonicalClassName.child("*");
        DottedPath _put = this.staticImports.put(wildcard, canonicalClassName);
        boolean bl = _tripleEquals = _put == null;
        if (_tripleEquals) {
            Predicate<Map.Entry> _function = it -> !Objects.equals(it.getKey(), wildcard) && Objects.equals(it.getValue(), canonicalClassName);
            this.staticImports.entrySet().removeIf(_function);
        }
    }

    public List<DottedPath> getImports() {
        return IterableExtensions.sort(this.imports.keySet());
    }

    public List<DottedPath> getStaticImports() {
        return IterableExtensions.sort(this.staticImports.keySet());
    }
}

