/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.rules;

import com.regnosys.rosetta.rules.RuleResult;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class RulePathMap {
    private final List<RulePathMap> parents;
    private Map<List<String>, RuleResult> map = new LinkedHashMap<List<String>, RuleResult>();

    public RulePathMap(List<RulePathMap> parentsInDescendingPriority) {
        this.parents = parentsInDescendingPriority;
    }

    public void add(List<String> path, RuleResult ruleResult) {
        this.map.put(path, ruleResult);
    }

    public RuleResult get(List<String> path) {
        RuleResult result = this.map.get(path);
        if (result != null) {
            return result;
        }
        for (RulePathMap parent : this.parents) {
            result = parent.get(path);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public Map<List<String>, RuleResult> getAsMap() {
        LinkedHashMap<List<String>, RuleResult> result = new LinkedHashMap<List<String>, RuleResult>();
        this.addToMapIfNotPresent(result);
        return result;
    }

    public void addToMapIfNotPresent(Map<List<String>, RuleResult> mapToAddTo) {
        this.map.forEach(mapToAddTo::putIfAbsent);
        for (RulePathMap parent : this.parents) {
            parent.addToMapIfNotPresent(mapToAddTo);
        }
    }

    public Map<List<String>, RuleResult> getInheritedRules() {
        Map<List<String>, RuleResult> result = this.getParentRules();
        result.keySet().removeAll(this.map.keySet());
        return result;
    }

    public Map<List<String>, RuleResult> getParentRules() {
        LinkedHashMap<List<String>, RuleResult> result = new LinkedHashMap<List<String>, RuleResult>();
        for (RulePathMap parent : this.parents) {
            parent.addToMapIfNotPresent(result);
        }
        return result;
    }

    public Map<List<String>, RuleResult> getOwnRules() {
        return this.map;
    }
}

