/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.google.common.collect.Streams;
import com.regnosys.rosetta.types.RMetaAttribute;
import com.regnosys.rosetta.types.RType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.Validate;

public class RMetaAnnotatedType {
    private final RType rType;
    private final List<RMetaAttribute> metaAttributes;

    protected RMetaAnnotatedType(RType rType, List<RMetaAttribute> metaAttributes) {
        this.rType = rType;
        this.metaAttributes = (List)Validate.noNullElements(metaAttributes);
    }

    public static RMetaAnnotatedType withNoMeta(RType rType) {
        return new RMetaAnnotatedType(rType, List.of());
    }

    public static RMetaAnnotatedType withMeta(RType rType, List<RMetaAttribute> metaAttributes) {
        return new RMetaAnnotatedType(rType, metaAttributes);
    }

    public RMetaAnnotatedType addMeta(List<RMetaAttribute> metaAttributes) {
        List<RMetaAttribute> metas = Streams.concat((Stream[])new Stream[]{this.metaAttributes.stream(), metaAttributes.stream()}).collect(Collectors.toList());
        return new RMetaAnnotatedType(this.rType, metas);
    }

    public RType getRType() {
        return this.rType;
    }

    public boolean hasMeta() {
        return !this.metaAttributes.isEmpty();
    }

    public List<RMetaAttribute> getMetaAttributes() {
        return this.metaAttributes;
    }

    public boolean hasMetaAttribute(String name) {
        return this.metaAttributes.stream().anyMatch(m -> m.getName().equals(name));
    }

    public int hashCode() {
        return Objects.hash(this.rType, this.metaAttributes);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RMetaAnnotatedType other = (RMetaAnnotatedType)obj;
        return Objects.equals(this.rType, other.rType) && Objects.equals(this.metaAttributes, other.metaAttributes);
    }

    public String toString() {
        if (this.metaAttributes.isEmpty()) {
            return this.rType.toString();
        }
        return this.rType.toString() + " with " + this.metaAttributes.stream().map(RMetaAttribute::getName).collect(Collectors.joining(", "));
    }
}

