/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaCardinality;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.RosettaRule;
import com.regnosys.rosetta.rosetta.simple.Annotation;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.ChoiceOption;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.rules.RuleComputationCache;
import com.regnosys.rosetta.rules.RulePathMap;
import com.regnosys.rosetta.rules.RuleReferenceService;
import com.regnosys.rosetta.rules.RuleResult;
import com.regnosys.rosetta.types.RAttribute;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RFunction;
import com.regnosys.rosetta.types.RMetaAnnotatedType;
import com.regnosys.rosetta.types.RObjectFactory;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.TypeSystem;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class AttributeValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RObjectFactory rObjectFactory;
    @Inject
    private RosettaEcoreUtil ecoreUtil;
    @Inject
    private TypeSystem typeSystem;
    @Inject
    private RuleReferenceService ruleService;

    @Check
    public void checkAttributeNameStartsWithLowerCase(Attribute attribute) {
        if (!(attribute instanceof ChoiceOption) && !(attribute.eContainer() instanceof Annotation) && Character.isUpperCase(attribute.getName().charAt(0))) {
            this.warning("Attribute name should start with a lower case", attribute, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkAttribute(Attribute attr) {
        RAttribute attribute = this.rObjectFactory.buildRAttribute(attr);
        RType attrType = attribute.getRMetaAnnotatedType().getRType();
        if (attrType instanceof RChoiceType) {
            attrType = ((RChoiceType)attrType).asRDataType();
        }
        if (attrType instanceof RDataType) {
            RDataType attrDataType = (RDataType)attrType;
            if (this.ecoreUtil.hasReferenceAnnotation(attr) && !attrDataType.hasMetaAttribute("key") && !attrDataType.getAllSuperTypes().stream().anyMatch(st -> st.hasMetaAttribute("key"))) {
                this.warning(attrDataType.getName() + " must be annotated with [metadata key] as reference annotation is used", attr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
            }
        }
    }

    @Check
    public void checkAttributeOverride(Attribute attr) {
        if (attr.isOverride()) {
            EObject container = attr.eContainer();
            if (!(container instanceof Data)) {
                this.error("You can only override the attribute of a type", attr, (EStructuralFeature)SimplePackage.Literals.ATTRIBUTE__OVERRIDE);
            } else {
                RAttribute attribute = this.rObjectFactory.buildRAttribute(attr);
                RAttribute parentAttribute = attribute.getParentAttribute();
                if (parentAttribute != null) {
                    this.checkDeprecatedAnnotation(parentAttribute.getEObject(), attr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, -1);
                    RMetaAnnotatedType overriddenType = attribute.getRMetaAnnotatedType();
                    RMetaAnnotatedType parentAttrType = parentAttribute.getRMetaAnnotatedType();
                    if (!this.typeSystem.isSubtypeOf(overriddenType, parentAttrType)) {
                        this.error("The overridden type should be a subtype of the parent type " + String.valueOf(parentAttrType), attr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
                    }
                    if (!parentAttribute.getCardinality().includes(attribute.getCardinality())) {
                        this.error("Cardinality may not be broader than the cardinality of the parent attribute " + String.valueOf(parentAttribute.getCardinality()), attr, (EStructuralFeature)SimplePackage.Literals.ATTRIBUTE__CARD);
                    }
                    if (!overriddenType.equals(parentAttrType) || !attribute.getCardinality().equals(parentAttribute.getCardinality())) {
                        RuleComputationCache map = new RuleComputationCache();
                        RulePathMap ruleMap = this.ruleService.computeRulePathMap(attribute, map);
                        Map<List<String>, RuleResult> inheritedRules = ruleMap.getInheritedRules();
                        inheritedRules.forEach((path, ruleResult) -> {
                            RAttribute target;
                            RosettaRule rule = ruleResult.getRule();
                            if (rule != null && (target = this.ruleService.getTargetAttribute(attribute, (List<String>)path)) != null) {
                                RFunction ruleFunc = this.rObjectFactory.buildRFunction(rule);
                                RMetaAnnotatedType ruleType = ruleFunc.getOutput().getRMetaAnnotatedType();
                                if (!this.typeSystem.isSubtypeOf(ruleType, target.getRMetaAnnotatedType())) {
                                    this.error("The overridden type is incompatible with the inherited rule reference `" + rule.getName() + "`" + this.toPathMessage((List<String>)path) + ". Either change the type or override the rule reference", attr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
                                }
                                if (!target.isMulti() && ruleFunc.getOutput().isMulti()) {
                                    this.error("Cardinality is incompatible with the inherited rule reference `" + rule.getName() + "`" + this.toPathMessage((List<String>)path) + ". Either change the cardinality or override the rule reference", attr, (EStructuralFeature)SimplePackage.Literals.ATTRIBUTE__CARD);
                                }
                            }
                        });
                    }
                } else {
                    this.error("Attribute " + attr.getName() + " does not exist in supertype", attr, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
                }
            }
        }
    }

    private String toPathMessage(List<String> path) {
        if (path.isEmpty()) {
            return "";
        }
        return " for " + String.join((CharSequence)" -> ", path);
    }

    @Check
    public void checkCardinality(RosettaCardinality card) {
        if (!card.isUnbounded() && card.getInf() > card.getSup()) {
            this.error("The upper bound must be greater than the lower bound", card, null);
        }
    }
}

