/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.simple.Attribute;
import com.regnosys.rosetta.rosetta.simple.Choice;
import com.regnosys.rosetta.rosetta.simple.Data;
import com.regnosys.rosetta.rosetta.simple.SimplePackage;
import com.regnosys.rosetta.validation.AbstractDeclarativeRosettaValidator;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class TypeValidator
extends AbstractDeclarativeRosettaValidator {
    @Inject
    private RosettaEcoreUtil ecoreUtil;

    @Check
    public void checkTypeNameIsCapitalized(Data data) {
        if (Character.isLowerCase(data.getName().charAt(0))) {
            this.warning("Type name should start with a capital", (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME, "RosettaIssueCodes.invalidCase", new String[0]);
        }
    }

    @Check
    public void checkDoNotExtendChoice(Data data) {
        if (data.getSuperType() instanceof Choice) {
            this.warning("Extending a choice type is deprecated", data, (EStructuralFeature)SimplePackage.Literals.DATA__SUPER_TYPE);
        }
    }

    @Check
    public void checkCyclicExtensions(Data data) {
        Data p = data.getSuperType();
        if (p != null) {
            ArrayList<Data> path = new ArrayList<Data>();
            path.add(data);
            HashSet<Data> visited = new HashSet<Data>();
            visited.add(data);
            if (this.hasCyclicExtension(p, path, visited)) {
                String pathString = path.stream().map(e -> e.getName()).collect(Collectors.joining(" extends "));
                this.error("Cyclic extension: " + pathString, data, (EStructuralFeature)SimplePackage.Literals.DATA__SUPER_TYPE);
            }
        }
    }

    private boolean hasCyclicExtension(Data current, List<Data> path, Set<Data> visited) {
        path.add(current);
        if (visited.add(current) && current.getSuperType() != null ? this.hasCyclicExtension(current.getSuperType(), path, visited) : path.get(0).equals(path.get(path.size() - 1))) {
            return true;
        }
        path.remove(path.size() - 1);
        return false;
    }

    @Check
    public void checkAttributeNamesAreUnique(Data data) {
        HashSet<String> usedNames = new HashSet<String>();
        if (data.getSuperType() != null) {
            this.ecoreUtil.getAllAttributes(data.getSuperType()).forEach(attr -> usedNames.add(attr.getName()));
        }
        HashSet<String> usedOverrides = new HashSet<String>();
        for (Attribute attr2 : data.getAttributes()) {
            if (!attr2.isOverride()) {
                if (usedNames.add(attr2.getName())) continue;
                this.warning("Duplicate attribute '" + attr2.getName() + "'. To override the type, cardinality or annotations of this attribute, use the keyword `override`.", attr2, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
                continue;
            }
            if (usedOverrides.add(attr2.getName())) continue;
            this.error("Duplicate attribute override for '" + attr2.getName() + "'.", attr2, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_NAMED__NAME);
        }
    }

    @Check
    public void checkAttributeOverridesShouldComeFirst(Data data) {
        boolean newAttrEncountered = false;
        for (Attribute attr : data.getAttributes()) {
            if (!attr.isOverride()) {
                newAttrEncountered = true;
                continue;
            }
            if (!newAttrEncountered) continue;
            this.error("Attribute overrides should come before any new attributes.", attr, null);
        }
    }
}

