/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.validation.expression;

import com.regnosys.rosetta.RosettaEcoreUtil;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import com.regnosys.rosetta.rosetta.RosettaPackage;
import com.regnosys.rosetta.rosetta.expression.ConstructorKeyValuePair;
import com.regnosys.rosetta.rosetta.expression.ExpressionPackage;
import com.regnosys.rosetta.rosetta.expression.RosettaConstructorExpression;
import com.regnosys.rosetta.rosetta.expression.RosettaExpression;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RRecordType;
import com.regnosys.rosetta.utils.ConstructorManagementService;
import com.regnosys.rosetta.validation.expression.AbstractExpressionValidator;
import jakarta.inject.Inject;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;

public class ConstructorValidator
extends AbstractExpressionValidator {
    @Inject
    private RosettaEcoreUtil ecoreUtil;
    @Inject
    private ConstructorManagementService constructorService;

    @Check
    public void checkConstructorExpression(RosettaConstructorExpression ele) {
        RType rType = this.typeProvider.getRMetaAnnotatedType(ele).getRType();
        RType baseRType = this.typeSystem.stripFromTypeAliases(rType);
        if (baseRType instanceof RChoiceType) {
            baseRType = ((RChoiceType)baseRType).asRDataType();
        }
        if (!(baseRType instanceof RDataType || baseRType instanceof RRecordType || baseRType.equals(this.builtins.NOTHING))) {
            this.error("Cannot construct an instance of type `" + String.valueOf(rType) + "`", ele, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL);
        }
        HashSet<RosettaFeature> seenFeatures = new HashSet<RosettaFeature>();
        for (ConstructorKeyValuePair pair : ele.getValues()) {
            RosettaFeature feature = pair.getKey();
            if (!this.ecoreUtil.isResolved(feature)) continue;
            RosettaExpression expr = pair.getValue();
            if (!seenFeatures.add(feature)) {
                this.error("Duplicate attribute `" + feature.getName() + "`", pair, (EStructuralFeature)ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__KEY);
            }
            this.subtypeCheck(this.typeProvider.getRTypeOfFeature(feature, pair), expr, (EObject)pair, (EStructuralFeature)ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__VALUE, (String actual) -> "Cannot assign `" + actual + "` to attribute `" + feature.getName() + "`");
            if (this.cardinalityProvider.isFeatureMulti(feature)) continue;
            this.isSingleCheck(expr, (EObject)pair, (EStructuralFeature)ExpressionPackage.Literals.CONSTRUCTOR_KEY_VALUE_PAIR__VALUE, "Cannot assign a list to a single value");
        }
        ConstructorManagementService.RosettaFeatureGroup featureGroup = this.constructorService.groupConstructorFeatures(ele);
        List<RosettaFeature> absentRequiredAttributes = featureGroup.getAbsentRequiredAttributes();
        if (ele.isImplicitEmpty()) {
            List<RosettaFeature> optionalAbsentAttributes;
            if (!absentRequiredAttributes.isEmpty()) {
                String absent = absentRequiredAttributes.stream().map(a -> a.getName()).collect(Collectors.joining("`, `", "`", "`"));
                this.error("Missing attributes " + absent, ele, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL, "RosettaIssueCodes.missingAttributes", new String[0]);
            }
            if ((optionalAbsentAttributes = featureGroup.getAbsentOptionalAttributes()).isEmpty()) {
                this.error("There are no optional attributes left", ele, (EStructuralFeature)ExpressionPackage.Literals.ROSETTA_CONSTRUCTOR_EXPRESSION__IMPLICIT_EMPTY);
            }
        } else {
            List<RosettaFeature> allAbsentAttributes = featureGroup.getAbsentAttributes();
            if (!allAbsentAttributes.isEmpty()) {
                String absent = allAbsentAttributes.stream().map(a -> a.getName()).collect(Collectors.joining("`, `", "`", "`"));
                String message = "Missing attributes " + absent;
                if (absentRequiredAttributes.isEmpty()) {
                    message = message + ". Perhaps you forgot a `...` at the end of the constructor?";
                }
                this.error(message, ele, (EStructuralFeature)RosettaPackage.Literals.ROSETTA_TYPED__TYPE_CALL, "RosettaIssueCodes.missingAttributes", new String[0]);
            }
        }
    }
}

