package iso20022.auth030.esma;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.esma.AssetClassProductType5Code;
import iso20022.auth030.esma.AssetClassSubProductType42Code;
import iso20022.auth030.esma.FertilizerCommoditySulphur2;
import iso20022.auth030.esma.FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder;
import iso20022.auth030.esma.FertilizerCommoditySulphur2.FertilizerCommoditySulphur2BuilderImpl;
import iso20022.auth030.esma.FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Impl;
import iso20022.auth030.esma.meta.FertilizerCommoditySulphur2Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Defines commodity sub-product attributes of a fertilizer derivative of type sulphur.
 * @version ${project.version}
 */
@RosettaDataType(value="FertilizerCommoditySulphur2", builder=FertilizerCommoditySulphur2.FertilizerCommoditySulphur2BuilderImpl.class, version="${project.version}")
@RuneDataType(value="FertilizerCommoditySulphur2", model="iso20022", builder=FertilizerCommoditySulphur2.FertilizerCommoditySulphur2BuilderImpl.class, version="${project.version}")
public interface FertilizerCommoditySulphur2 extends RosettaModelObject {

	FertilizerCommoditySulphur2Meta metaData = new FertilizerCommoditySulphur2Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Base product for the underlying asset class as specified in the classification of commodities derivatives table.
	 */
	AssetClassProductType5Code getBasePdct();
	/**
	 * Sub-product for the underlying asset class.
	 */
	AssetClassSubProductType42Code getSubPdct();

	/*********************** Build Methods  ***********************/
	FertilizerCommoditySulphur2 build();
	
	FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder toBuilder();
	
	static FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder builder() {
		return new FertilizerCommoditySulphur2.FertilizerCommoditySulphur2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends FertilizerCommoditySulphur2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends FertilizerCommoditySulphur2> getType() {
		return FertilizerCommoditySulphur2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType5Code.class, getBasePdct(), this);
		processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType42Code.class, getSubPdct(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface FertilizerCommoditySulphur2Builder extends FertilizerCommoditySulphur2, RosettaModelObjectBuilder {
		FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder setBasePdct(AssetClassProductType5Code basePdct);
		FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder setSubPdct(AssetClassSubProductType42Code subPdct);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("basePdct"), AssetClassProductType5Code.class, getBasePdct(), this);
			processor.processBasic(path.newSubPath("subPdct"), AssetClassSubProductType42Code.class, getSubPdct(), this);
		}
		

		FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder prune();
	}

	/*********************** Immutable Implementation of FertilizerCommoditySulphur2  ***********************/
	class FertilizerCommoditySulphur2Impl implements FertilizerCommoditySulphur2 {
		private final AssetClassProductType5Code basePdct;
		private final AssetClassSubProductType42Code subPdct;
		
		protected FertilizerCommoditySulphur2Impl(FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder builder) {
			this.basePdct = builder.getBasePdct();
			this.subPdct = builder.getSubPdct();
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType5Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType42Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		public FertilizerCommoditySulphur2 build() {
			return this;
		}
		
		@Override
		public FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder toBuilder() {
			FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder builder) {
			ofNullable(getBasePdct()).ifPresent(builder::setBasePdct);
			ofNullable(getSubPdct()).ifPresent(builder::setSubPdct);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FertilizerCommoditySulphur2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FertilizerCommoditySulphur2 {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}

	/*********************** Builder Implementation of FertilizerCommoditySulphur2  ***********************/
	class FertilizerCommoditySulphur2BuilderImpl implements FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder {
	
		protected AssetClassProductType5Code basePdct;
		protected AssetClassSubProductType42Code subPdct;
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public AssetClassProductType5Code getBasePdct() {
			return basePdct;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public AssetClassSubProductType42Code getSubPdct() {
			return subPdct;
		}
		
		@Override
		@RosettaAttribute("basePdct")
		@RuneAttribute("basePdct")
		public FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder setBasePdct(AssetClassProductType5Code _basePdct) {
			this.basePdct = _basePdct == null ? null : _basePdct;
			return this;
		}
		
		@Override
		@RosettaAttribute("subPdct")
		@RuneAttribute("subPdct")
		public FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder setSubPdct(AssetClassSubProductType42Code _subPdct) {
			this.subPdct = _subPdct == null ? null : _subPdct;
			return this;
		}
		
		@Override
		public FertilizerCommoditySulphur2 build() {
			return new FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Impl(this);
		}
		
		@Override
		public FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getBasePdct()!=null) return true;
			if (getSubPdct()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder o = (FertilizerCommoditySulphur2.FertilizerCommoditySulphur2Builder) other;
			
			
			merger.mergeBasic(getBasePdct(), o.getBasePdct(), this::setBasePdct);
			merger.mergeBasic(getSubPdct(), o.getSubPdct(), this::setSubPdct);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			FertilizerCommoditySulphur2 _that = getType().cast(o);
		
			if (!Objects.equals(basePdct, _that.getBasePdct())) return false;
			if (!Objects.equals(subPdct, _that.getSubPdct())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (basePdct != null ? basePdct.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (subPdct != null ? subPdct.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "FertilizerCommoditySulphur2Builder {" +
				"basePdct=" + this.basePdct + ", " +
				"subPdct=" + this.subPdct +
			'}';
		}
	}
}
